/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public final class UndoMemento {
    private List fEdits = new ArrayList(5);

    UndoMemento() {
    }

    void add(SimpleTextEdit edit) {
        this.fEdits.add(edit);
    }

    void execute(TextBuffer buffer, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.fEdits.size());
        int i = this.fEdits.size() - 1;
        while (i >= 0) {
            ((TextEdit)this.fEdits.get(i)).perform(buffer);
            pm.worked(1);
            --i;
        }
    }

    void executed(IProgressMonitor pm) {
        pm.beginTask("", this.fEdits.size());
        int i = this.fEdits.size() - 1;
        while (i >= 0) {
            ((TextEdit)this.fEdits.get(i)).performed();
            pm.worked(1);
            --i;
        }
    }

    IStatus checkEdits(int bufferLength) {
        return new Status(0, JavaPlugin.getPluginId(), 0, TextManipulationMessages.getString("UndoMemento.is_valid"), null);
    }
}

