/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.internal.corext.Assert;

public final class TextRange {
    private int fOffset;
    private int fLength;
    private static final int UNDEFINED_VALUE = -1;
    private static final int DELETED_VALUE = -2;
    public static final TextRange UNDEFINED = new TextRange(null, -1);
    public static final TextRange DELETED = new TextRange(null, -2);

    public TextRange(int offset) {
        this(offset, 0);
    }

    public TextRange(int offset, int length) {
        this.fOffset = offset;
        Assert.isTrue(this.fOffset >= 0);
        this.fLength = length;
        Assert.isTrue(this.fLength >= 0);
    }

    private TextRange(TextRange dummy, int value) {
        this.fOffset = value;
        this.fLength = value;
    }

    public static TextRange createFromStartAndLength(int start, int length) {
        return new TextRange(start, length);
    }

    public static TextRange createFromStartAndInclusiveEnd(int start, int end) {
        return new TextRange(start, end - start + 1);
    }

    public static TextRange createFromStartAndExclusiveEnd(int start, int end) {
        return new TextRange(start, end - start);
    }

    public TextRange(ISourceRange range) {
        this(range.getOffset(), range.getLength());
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getInclusiveEnd() {
        return this.fOffset + this.fLength - 1;
    }

    public int getExclusiveEnd() {
        return this.fOffset + this.fLength;
    }

    public TextRange copy() {
        if (this.isUndefined()) {
            return this;
        }
        if (this.isDeleted()) {
            return new TextRange(null, -2);
        }
        return new TextRange(this.fOffset, this.fLength);
    }

    public boolean isUndefined() {
        return UNDEFINED == this;
    }

    public boolean isDeleted() {
        return this.fOffset == -2 && this.fLength == -2;
    }

    public boolean isValid() {
        return this.fOffset >= 0 && this.fLength >= 0;
    }

    public String toString() {
        if (this.isDeleted()) {
            return "[deleted]";
        }
        if (this.isUndefined()) {
            return "[undefined]";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(this.fOffset);
        buffer.append(",");
        buffer.append(this.fLength);
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange other = (TextRange)obj;
        return this.fOffset == other.fOffset && this.fLength == other.fLength;
    }

    public int hashCode() {
        return this.fOffset * this.fLength;
    }

    boolean isInsertionPoint() {
        return this.fLength == 0;
    }

    boolean equals(TextRange range) {
        return this.fOffset == range.fOffset && this.fLength == range.fLength;
    }

    boolean isEqualInsertionPoint(TextRange range) {
        return this.fLength == 0 && range.fLength == 0 && this.fOffset == range.fOffset;
    }

    boolean liesBehind(TextRange range) {
        return this.fOffset >= range.fOffset + range.fLength;
    }

    boolean isInsertionPointAt(int o) {
        return this.fOffset == o && this.fLength == 0;
    }

    boolean covers(TextRange other) {
        if (this.fLength == 0) {
            return false;
        }
        if (other.fLength == 0) {
            int otherOffset = other.fOffset;
            return this.fOffset < otherOffset && otherOffset < this.fOffset + this.fLength;
        }
        int otherOffset = other.fOffset;
        return this.fOffset <= otherOffset && otherOffset + other.fLength <= this.fOffset + this.fLength;
    }

    void markAsDeleted() {
        this.fOffset = -2;
        this.fLength = -2;
    }

    void addToOffset(int delta) {
        if (this.isUndefined() || this.isDeleted()) {
            return;
        }
        this.fOffset += delta;
        Assert.isTrue(this.fOffset >= 0);
    }

    void addToLength(int delta) {
        if (this.isUndefined() || this.isDeleted()) {
            return;
        }
        this.fLength += delta;
        Assert.isTrue(this.fLength >= 0);
    }
}

