/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jdt.internal.corext.textmanipulation.Updater;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.DocumentEvent;

public abstract class TextEdit {
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private TextEdit fParent;
    private List fChildren;
    private int fLifeCycle = 0;
    private int fActiveState = 2;
    protected static final int UNCONNECTED = 0;
    protected static final int ADDED = 1;
    protected static final int CONNECTED = 2;
    static final int INACTIVE = 0;
    static final int ACTIVE = 1;
    static final int SAME_AS_PARENT = 2;

    protected TextEdit() {
    }

    public TextEdit getParent() {
        return this.fParent;
    }

    public int size() {
        if (this.fChildren == null) {
            return 0;
        }
        return this.fChildren.size();
    }

    public void add(TextEdit edit) {
        this.internalAdd(edit);
    }

    public void addAll(TextEdit[] edits) {
        int i = 0;
        while (i < edits.length) {
            this.internalAdd(edits[i]);
            ++i;
        }
    }

    public TextEdit remove(int index) {
        if (this.fChildren == null) {
            return null;
        }
        TextEdit result = (TextEdit)this.fChildren.remove(index);
        result.setParent(null);
        if (this.fChildren.isEmpty()) {
            this.fChildren = null;
        }
        return result;
    }

    public TextEdit[] removeAll() {
        if (this.fChildren == null) {
            return new TextEdit[0];
        }
        int size = this.fChildren.size();
        TextEdit[] result = new TextEdit[size];
        int i = 0;
        while (i < size) {
            result[i] = (TextEdit)this.fChildren.get(i);
            result[i].setParent(null);
            ++i;
        }
        this.fChildren = null;
        return result;
    }

    public boolean isActive() {
        switch (this.fActiveState) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                TextEdit parent = this.getParent();
                if (parent == null) {
                    return false;
                }
                return parent.isActive();
            }
        }
        return false;
    }

    public void setActive(boolean active) {
        this.fActiveState = active ? 1 : 0;
    }

    public void clearActive() {
        this.fActiveState = 2;
    }

    public Iterator iterator() {
        if (this.fChildren == null) {
            return EMPTY_ITERATOR;
        }
        return this.fChildren.iterator();
    }

    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    public abstract TextRange getTextRange();

    public void connect(TextBuffer buffer) throws CoreException {
    }

    public final void connect(TextBufferEditor editor) throws CoreException {
    }

    public abstract void perform(TextBuffer var1) throws CoreException;

    public void performed() {
    }

    final TextEdit copy(TextEditCopier copier) {
        TextEdit result = this.copy0(copier);
        copier.addCopy(this, result);
        result.fActiveState = this.fActiveState;
        if (this.fChildren != null) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                TextEdit element = (TextEdit)iter.next();
                result.add(element.copy(copier));
            }
        }
        this.executePostProcessCopy(copier);
        return result;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String toString() {
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return "{" + name + "} " + this.getTextRange().toString();
    }

    public static TextRange getTextRange(List edits) {
        int size = 0;
        if (edits == null || (size = edits.size()) == 0) {
            return TextRange.UNDEFINED;
        }
        int offset = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        int deleted = 0;
        int undefined = 0;
        int i = 0;
        while (i < size) {
            TextRange range = ((TextEdit)edits.get(i)).getTextRange();
            if (range.isDeleted()) {
                ++deleted;
            } else if (range.isUndefined()) {
                ++undefined;
            } else {
                offset = Math.min(offset, range.getOffset());
                end = Math.max(end, range.getExclusiveEnd());
            }
            ++i;
        }
        if (size == deleted) {
            return TextRange.DELETED;
        }
        if (size == undefined) {
            return TextRange.UNDEFINED;
        }
        return TextRange.createFromStartAndExclusiveEnd(offset, end);
    }

    protected final TextEdit copy0() {
        return null;
    }

    protected abstract TextEdit copy0(TextEditCopier var1);

    protected void postProcessCopy(TextEditCopier copier) {
    }

    protected TextRange getChildrenTextRange() {
        int size;
        int n = size = this.fChildren != null ? this.fChildren.size() : 0;
        if (size == 0) {
            return TextRange.UNDEFINED;
        }
        return TextEdit.getTextRange(this.fChildren);
    }

    protected void adjustOffset(int delta) {
        this.getTextRange().addToOffset(delta);
    }

    protected void adjustLength(int delta) {
        this.getTextRange().addToLength(delta);
    }

    void executePostProcessCopy(TextEditCopier copier) {
        this.postProcessCopy(copier);
        if (this.fChildren != null) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((TextEdit)iter.next()).executePostProcessCopy(copier);
            }
        }
    }

    void setParent(TextEdit parent) {
        if (parent != null) {
            Assert.isTrue(this.fParent == null);
        }
        this.fParent = parent;
    }

    List getChildren() {
        return this.fChildren;
    }

    void setChildren(List children) {
        this.fChildren = children;
    }

    void setLifeCycle(int state) {
        this.fLifeCycle = state;
    }

    boolean isUnconnected() {
        return this.fLifeCycle == 0;
    }

    boolean isAdded() {
        return this.fLifeCycle == 1;
    }

    boolean isConnected() {
        return this.fLifeCycle == 2;
    }

    void internalAdd(TextEdit edit) {
        Assert.isTrue(this.isUnconnected());
        edit.setParent(this);
        if (this.fChildren == null) {
            this.fChildren = new ArrayList(2);
        }
        this.fChildren.add(edit);
    }

    void setLifeCycleDeep(int state) {
        this.setLifeCycle(state);
        if (this.fChildren != null) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                ((TextEdit)iter.next()).setLifeCycleDeep(state);
            }
        }
    }

    void checkRange(DocumentEvent event) {
        TextRange range = this.getTextRange();
        int eventOffset = event.getOffset();
        int eventLength = event.getLength();
        int eventEnd = eventOffset + eventLength - 1;
        Assert.isTrue(range.getOffset() <= eventOffset && eventEnd <= range.getInclusiveEnd());
    }

    IStatus checkEdit(int bufferLength) {
        TextRange range = this.getTextRange();
        if (range.getExclusiveEnd() > bufferLength) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("TextEdit.offset_greater"));
        }
        boolean isInsertionPoint = range.isInsertionPoint();
        TextRange cRange = this.getChildrenTextRange();
        if (!(cRange.isUndefined() || cRange.getOffset() >= range.getOffset() && cRange.getExclusiveEnd() <= range.getExclusiveEnd())) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("TextEdit.range_outside"));
        }
        TextRange last = null;
        if (this.fChildren != null) {
            Iterator iter = this.fChildren.iterator();
            while (iter.hasNext()) {
                TextEdit element = (TextEdit)iter.next();
                TextRange eRange = element.getTextRange();
                if (!(isInsertionPoint && eRange.isInsertionPoint() || last == null || last.getInclusiveEnd() < eRange.getOffset())) {
                    return TextEdit.createErrorStatus(TextManipulationMessages.getString("TextEdit.overlapping"));
                }
                IStatus s = element.checkEdit(bufferLength);
                if (!s.isOK()) {
                    return s;
                }
                last = eRange;
            }
        }
        return TextEdit.createOKStatus();
    }

    protected static IStatus createErrorStatus(String message) {
        return new Status(4, JavaPlugin.getPluginId(), 4, message, null);
    }

    protected static IStatus createOKStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, TextManipulationMessages.getString("TextEdit.is_valid"), null);
    }

    void executeConnect(TextBuffer buffer) throws CoreException {
        Assert.isTrue(this.isUnconnected());
        this.fLifeCycle = 1;
        List children = this.getChildren();
        if (children != null) {
            int i = children.size() - 1;
            while (i >= 0) {
                ((TextEdit)children.get(i)).executeConnect(buffer);
                --i;
            }
        }
        this.connect(buffer);
        this.fLifeCycle = 2;
        this.sortChildren();
    }

    void execute(TextBuffer buffer, Updater updater, IProgressMonitor pm) throws CoreException {
        List children = this.getChildren();
        pm.beginTask("", children != null ? children.size() + 1 : 1);
        if (children != null) {
            int i = children.size() - 1;
            while (i >= 0) {
                ((TextEdit)children.get(i)).execute(buffer, updater, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                --i;
            }
        }
        if (this.isActive()) {
            try {
                updater.setActiveNode(this);
                this.perform(buffer);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                updater.setActiveNode(null);
                throw throwable;
            }
            Object var5_7 = null;
            updater.setActiveNode(null);
        }
        pm.worked(1);
    }

    void updateTextRange(int delta, List executedEdits) {
        Iterator iter = executedEdits.iterator();
        while (iter.hasNext()) {
            ((TextEdit)iter.next()).predecessorExecuted(delta);
        }
        this.adjustLength(delta);
        this.updateParents(delta);
    }

    void childExecuted(int delta) {
        this.adjustLength(delta);
    }

    void predecessorExecuted(int delta) {
        this.adjustOffset(delta);
    }

    void markAsDeleted(List children) {
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TextEdit element = (TextEdit)iter.next();
                element.getTextRange().markAsDeleted();
                this.markAsDeleted(element.getChildren());
            }
        }
    }

    void updateParents(int delta) {
        TextEdit edit = this.getParent();
        while (edit != null) {
            edit.childExecuted(delta);
            edit = edit.getParent();
        }
    }

    void sortChildren() {
        if (this.fChildren != null) {
            Collections.sort(this.fChildren, new Sorter());
        }
    }

    private static class Sorter
    implements Comparator {
        Sorter() {
        }

        public int compare(Object arg1, Object arg2) {
            int l2;
            int o2;
            TextRange r1 = ((TextEdit)arg1).getTextRange();
            TextRange r2 = ((TextEdit)arg2).getTextRange();
            int o1 = r1.getOffset();
            if (o1 < (o2 = r2.getOffset())) {
                return -1;
            }
            if (o1 > o2) {
                return 1;
            }
            int l1 = r1.getLength();
            if (l1 < (l2 = r2.getLength())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

