/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.jdt.internal.corext.textmanipulation.Updater;

public class TextBufferEditor {
    private TextBuffer fBuffer;
    private MultiTextEdit fRoot;
    private UndoMemento fUndoMemento;
    private IStatus fCheckStatus;

    public TextBufferEditor(TextBuffer buffer) {
        Assert.isNotNull(buffer);
        this.fBuffer = buffer;
        this.fCheckStatus = null;
    }

    public TextBuffer getTextBuffer() {
        return this.fBuffer;
    }

    public void add(TextEdit edit) throws CoreException {
        Assert.isTrue(this.fUndoMemento == null);
        if (this.fRoot == null) {
            this.fRoot = new MultiTextEdit();
            this.fRoot.setActive(true);
        }
        edit.executeConnect(this.fBuffer);
        this.fRoot.setLifeCycle(0);
        this.fRoot.add(edit);
        this.fCheckStatus = null;
    }

    public void add(UndoMemento undo) throws CoreException {
        Assert.isTrue(this.fRoot == null);
        this.fUndoMemento = undo;
        this.fCheckStatus = null;
    }

    public IStatus canPerformEdits() {
        if (this.fCheckStatus != null) {
            return this.fCheckStatus;
        }
        if (this.fRoot != null) {
            this.fRoot.sortChildren();
            this.fRoot.setLifeCycle(2);
            this.fCheckStatus = this.fRoot.checkEdit(this.fBuffer.getLength());
        } else {
            this.fCheckStatus = this.fUndoMemento != null ? this.fUndoMemento.checkEdits(this.fBuffer.getLength()) : TextEdit.createOKStatus();
        }
        return this.fCheckStatus;
    }

    public void clear() {
        this.fRoot = null;
        this.fUndoMemento = null;
        this.fCheckStatus = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UndoMemento performEdits(IProgressMonitor pm) throws CoreException {
        UndoMemento undoMemento;
        block7: {
            UndoMemento undoMemento2;
            block6: {
                IStatus s = this.canPerformEdits();
                if (!s.isOK()) {
                    throw new CoreException(s);
                }
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                try {
                    if (this.fRoot != null) {
                        UndoMemento undoMemento3 = this.executeDo(pm);
                        Object var3_6 = null;
                        this.clear();
                        return undoMemento3;
                    }
                    if (this.fUndoMemento != null) {
                        undoMemento2 = this.executeUndo(pm);
                        break block6;
                    }
                    undoMemento = new UndoMemento();
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    this.clear();
                    throw throwable;
                }
            }
            Object var3_7 = null;
            this.clear();
            return undoMemento2;
        }
        Object var3_8 = null;
        this.clear();
        return undoMemento;
    }

    private UndoMemento executeDo(IProgressMonitor pm) throws CoreException {
        Updater updater = null;
        try {
            pm.beginTask("", 5);
            updater = Updater.createDoUpdater();
            this.fBuffer.registerUpdater(updater);
            this.fRoot.execute(this.fBuffer, updater, (IProgressMonitor)new SubProgressMonitor(pm, 4));
            List executed = updater.getProcessedEdits();
            SubProgressMonitor sm = new SubProgressMonitor(pm, 1);
            sm.beginTask("", executed.size());
            int i = executed.size() - 1;
            while (i >= 0) {
                ((TextEdit)executed.get(i)).performed();
                sm.worked(1);
                --i;
            }
            UndoMemento undoMemento = updater.undo;
            Object var6_7 = null;
            if (updater != null) {
                this.fBuffer.unregisterUpdater(updater);
            }
            return undoMemento;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_8 = null;
                if (updater == null) break block4;
                this.fBuffer.unregisterUpdater(updater);
            }
            throw throwable;
        }
    }

    private UndoMemento executeUndo(IProgressMonitor pm) throws CoreException {
        Updater updater = null;
        try {
            pm.beginTask("", 5);
            updater = Updater.createUndoUpdater();
            this.fBuffer.registerUpdater(updater);
            this.fUndoMemento.execute(this.fBuffer, (IProgressMonitor)new SubProgressMonitor(pm, 4));
            this.fUndoMemento.executed((IProgressMonitor)new SubProgressMonitor(pm, 1));
            UndoMemento undoMemento = updater.undo;
            Object var3_4 = null;
            if (updater != null) {
                this.fBuffer.unregisterUpdater(updater);
            }
            return undoMemento;
        }
        catch (Throwable throwable) {
            block3: {
                Object var3_5 = null;
                if (updater == null) break block3;
                this.fBuffer.unregisterUpdater(updater);
            }
            throw throwable;
        }
    }
}

