/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public class SimpleTextEdit
extends TextEdit {
    private TextRange fRange;
    private String fText;
    static /* synthetic */ Class class$0;

    public static SimpleTextEdit createReplace(int offset, int length, String text) {
        return new SimpleTextEdit(offset, length, text);
    }

    public static SimpleTextEdit createInsert(int offset, String text) {
        return new SimpleTextEdit(offset, 0, text);
    }

    public static SimpleTextEdit createDelete(int offset, int length) {
        return new SimpleTextEdit(offset, length, "");
    }

    public SimpleTextEdit(int offset, int length, String text) {
        this(new TextRange(offset, length), text);
    }

    protected SimpleTextEdit() {
        this(TextRange.UNDEFINED, "");
    }

    protected SimpleTextEdit(TextRange range, String text) {
        Assert.isNotNull(range);
        Assert.isNotNull(text);
        this.fRange = range;
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    protected final void setText(String text) {
        Assert.isTrue(text != null && !this.isConnected());
        this.fText = text;
    }

    protected final void setTextRange(TextRange range) {
        Assert.isTrue(range != null && !this.isConnected());
        this.fRange = range;
    }

    public final TextRange getTextRange() {
        return this.fRange;
    }

    public void perform(TextBuffer buffer) throws CoreException {
        buffer.replace(this.fRange, this.fText);
    }

    public String toString() {
        return String.valueOf(super.toString()) + " <<" + this.fText;
    }

    protected TextEdit copy0(TextEditCopier copier) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.isTrue(clazz == this.getClass(), "Subclasses must reimplement copy0");
        return new SimpleTextEdit(this.getTextRange().copy(), this.getText());
    }

    void updateTextRange(int delta, List executedEdits) {
        this.markAsDeleted(this.getChildren());
        super.updateTextRange(delta, executedEdits);
    }
}

