/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.AbstractTransferEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.MoveSourceEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jface.text.DocumentEvent;

public final class MoveTargetEdit
extends AbstractTransferEdit {
    private MoveSourceEdit fSource;

    public MoveTargetEdit(int offset) {
        super(new TextRange(offset, 0));
    }

    public MoveTargetEdit(int offset, MoveSourceEdit source) {
        this(offset);
        this.setSourceEdit(source);
    }

    private MoveTargetEdit(TextRange range) {
        super(range);
    }

    public void setSourceEdit(MoveSourceEdit edit) {
        if (this.fSource != edit) {
            this.fSource = edit;
            this.fSource.setTargetEdit(this);
        }
    }

    public void perform(TextBuffer buffer) throws CoreException {
        block4: {
            if (++this.fSource.fCounter != 2) break block4;
            try {
                String source = this.getSourceContent();
                if (!this.getTextRange().isDeleted()) {
                    this.fMode = 1;
                    buffer.replace(this.getTextRange(), source);
                }
                if (!this.fSource.getTextRange().isDeleted()) {
                    this.fMode = 2;
                    buffer.replace(this.fSource.getTextRange(), "");
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fMode = 0;
                this.fSource.clearContent();
                throw throwable;
            }
            Object var3_5 = null;
            this.fMode = 0;
            this.fSource.clearContent();
        }
    }

    protected String getSourceContent() {
        return this.fSource.getContent();
    }

    public TextEdit copy0(TextEditCopier copier) {
        return new MoveTargetEdit(this.getTextRange().copy());
    }

    protected void postProcessCopy(TextEditCopier copier) {
        if (this.fSource != null) {
            ((MoveTargetEdit)copier.getCopy(this)).setSourceEdit((MoveSourceEdit)copier.getCopy(this.fSource));
        }
    }

    void updateTextRange(int delta, List executedEdits) {
        if (this.fMode == 1) {
            this.predecessorExecuted(this.getSuccessorIterator(), delta);
            this.adjustLength(delta);
            this.updateParents(delta);
            this.markAsDeleted(this.getChildren());
            List sourceChildren = this.fSource.getChildren();
            this.fSource.setChildren(null);
            int moveDelta = this.getTextRange().getOffset() - this.fSource.getTextRange().getOffset();
            this.move(sourceChildren, moveDelta);
            this.setChildren(sourceChildren);
        } else if (this.fMode == 2) {
            this.predecessorExecuted(this.fSource.getSuccessorIterator(), delta);
            this.fSource.adjustLength(delta);
            this.fSource.updateParents(delta);
        } else {
            Assert.isTrue(false);
        }
    }

    void checkRange(DocumentEvent event) {
        if (this.fMode == 2) {
            this.fSource.checkRange(event);
        } else {
            super.checkRange(event);
        }
    }

    IStatus checkEdit(int bufferLength) {
        IStatus s = super.checkEdit(bufferLength);
        if (!s.isOK()) {
            return s;
        }
        if (this.fSource == null) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("MoveTargetEdit.no_source"));
        }
        if (this.fSource.getTargetEdit() != this) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("MoveTargetEdit.different_target"));
        }
        if (this.getTextRange().getLength() != 0) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("MoveTargetEdit.length"));
        }
        return TextEdit.createOKStatus();
    }

    MoveSourceEdit getSourceEdit() {
        return this.fSource;
    }
}

