/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.AbstractTransferEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.MoveTargetEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jface.text.DocumentEvent;

public final class MoveSourceEdit
extends AbstractTransferEdit {
    private String fContent;
    int fCounter;
    private MoveTargetEdit fTarget;

    public MoveSourceEdit(int offset, int length) {
        super(new TextRange(offset, length));
    }

    public MoveSourceEdit(int offset, int length, MoveTargetEdit target) {
        this(offset, length);
        this.setTargetEdit(target);
    }

    private MoveSourceEdit(TextRange range) {
        super(range);
    }

    public void setTargetEdit(MoveTargetEdit edit) {
        if (this.fTarget != edit) {
            this.fTarget = edit;
            this.fTarget.setSourceEdit(this);
        }
    }

    public void perform(TextBuffer buffer) throws CoreException {
        block4: {
            TextRange range = this.getTextRange();
            this.fContent = buffer.getContent(range.getOffset(), range.getLength());
            if (++this.fCounter != 2) break block4;
            try {
                if (!this.getTextRange().isDeleted()) {
                    this.fMode = 2;
                    buffer.replace(range, "");
                }
                if (!this.fTarget.getTextRange().isDeleted()) {
                    this.fMode = 1;
                    buffer.replace(this.fTarget.getTextRange(), this.fContent);
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fMode = 0;
                this.clearContent();
                throw throwable;
            }
            Object var3_5 = null;
            this.fMode = 0;
            this.clearContent();
        }
    }

    public TextEdit copy0(TextEditCopier copier) {
        return new MoveSourceEdit(this.getTextRange().copy());
    }

    protected void postProcessCopy(TextEditCopier copier) {
        if (this.fTarget != null) {
            ((MoveSourceEdit)copier.getCopy(this)).setTargetEdit((MoveTargetEdit)copier.getCopy(this.fTarget));
        }
    }

    String getContent() {
        return this.fContent;
    }

    void clearContent() {
        this.fContent = null;
    }

    void updateTextRange(int delta, List executedEdits) {
        if (this.fMode == 2) {
            this.predecessorExecuted(this.getSuccessorIterator(), delta);
            this.adjustLength(delta);
            this.updateParents(delta);
        } else if (this.fMode == 1) {
            this.predecessorExecuted(this.fTarget.getSuccessorIterator(), delta);
            this.fTarget.adjustLength(delta);
            this.fTarget.updateParents(delta);
            this.markAsDeleted(this.fTarget.getChildren());
            List children = this.getChildren();
            this.setChildren(null);
            int moveDelta = this.fTarget.getTextRange().getOffset() - this.getTextRange().getOffset();
            this.move(children, moveDelta);
            this.fTarget.setChildren(children);
        } else {
            Assert.isTrue(false);
        }
    }

    void checkRange(DocumentEvent event) {
        if (this.fMode == 1) {
            this.fTarget.checkRange(event);
        } else {
            super.checkRange(event);
        }
    }

    IStatus checkEdit(int bufferLength) {
        IStatus s = super.checkEdit(bufferLength);
        if (!s.isOK()) {
            return s;
        }
        if (this.fTarget == null) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("MoveSourceEdit.no_target"));
        }
        if (this.fTarget.getSourceEdit() != this) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("MoveSourceEdit.different_source"));
        }
        return TextEdit.createOKStatus();
    }

    MoveTargetEdit getTargetEdit() {
        return this.fTarget;
    }
}

