/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public class GroupDescription {
    private String fDescription;
    private List fEdits;

    public GroupDescription(String description) {
        Assert.isNotNull(description);
        this.fDescription = description;
        this.fEdits = new ArrayList(3);
    }

    public GroupDescription(String description, TextEdit[] edits) {
        Assert.isNotNull(description);
        Assert.isNotNull(edits);
        this.fDescription = description;
        this.fEdits = new ArrayList<TextEdit>(Arrays.asList(edits));
    }

    public void addTextEdit(TextEdit edit) {
        this.fEdits.add(edit);
    }

    public TextEdit[] getTextEdits() {
        return this.fEdits.toArray(new TextEdit[this.fEdits.size()]);
    }

    public TextRange getTextRange() {
        int size = this.fEdits.size();
        if (size == 0) {
            return TextRange.UNDEFINED;
        }
        if (size == 1) {
            return ((TextEdit)this.fEdits.get(0)).getTextRange();
        }
        return TextEdit.getTextRange(this.fEdits);
    }

    public Object getModifiedElement() {
        int size = this.fEdits.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return ((TextEdit)this.fEdits.get(0)).getModifiedElement();
            }
        }
        return null;
    }

    public String getName() {
        return this.fDescription;
    }
}

