/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.AbstractTransferEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.CopySourceEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public class CopyTargetEdit
extends AbstractTransferEdit {
    private CopySourceEdit fSource;
    static /* synthetic */ Class class$0;

    public CopyTargetEdit(int offset) {
        this(new TextRange(offset, 0));
    }

    public CopyTargetEdit(int offset, CopySourceEdit source) {
        this(new TextRange(offset, 0));
        this.setSourceEdit(source);
    }

    private CopyTargetEdit(TextRange range) {
        super(range);
    }

    public void setSourceEdit(CopySourceEdit edit) {
        if (this.fSource != edit) {
            this.fSource = edit;
            this.fSource.setTargetEdit(this);
        }
    }

    protected TextEdit copy0(TextEditCopier copier) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.internal.corext.textmanipulation.CopyTargetEdit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.isTrue(clazz == this.getClass(), "Subclasses must reimplement copy0");
        return new CopyTargetEdit(this.getTextRange().copy());
    }

    protected void postProcessCopy(TextEditCopier copier) {
        if (this.fSource != null) {
            ((CopyTargetEdit)copier.getCopy(this)).setSourceEdit((CopySourceEdit)copier.getCopy(this.fSource));
        }
    }

    public void perform(TextBuffer buffer) throws CoreException {
        block2: {
            if (++this.fSource.fCounter != 2 || this.getTextRange().isDeleted()) break block2;
            try {
                buffer.replace(this.getTextRange(), this.getSourceContent());
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fSource.clearContent();
                throw throwable;
            }
            Object var2_4 = null;
            this.fSource.clearContent();
        }
    }

    protected String getSourceContent() {
        return this.fSource.getContent();
    }

    IStatus checkEdit(int bufferLength) {
        IStatus s = super.checkEdit(bufferLength);
        if (!s.isOK()) {
            return s;
        }
        if (this.fSource == null) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("CopyTargetEdit.no_source"));
        }
        if (this.fSource.getTargetEdit() != this) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("CopyTargetEdit.different_target"));
        }
        if (this.getTextRange().getLength() != 0) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("CopyTargetEdit.length"));
        }
        return TextEdit.createOKStatus();
    }

    CopySourceEdit getSourceEdit() {
        return this.fSource;
    }
}

