/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.textmanipulation.AbstractTransferEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.CopyTargetEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.jface.text.DocumentEvent;

public class CopySourceEdit
extends AbstractTransferEdit {
    private String fContent;
    private CopyTargetEdit fTarget;
    int fCounter;

    public CopySourceEdit(int offset, int length) {
        this(new TextRange(offset, length));
    }

    public CopySourceEdit(int offset, int length, CopyTargetEdit target) {
        this(offset, length);
        this.setTargetEdit(target);
    }

    private CopySourceEdit(TextRange range) {
        super(range);
    }

    public void setTargetEdit(CopyTargetEdit edit) {
        if (this.fTarget != edit) {
            this.fTarget = edit;
            this.fTarget.setSourceEdit(this);
        }
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new CopySourceEdit(this.getTextRange().copy());
    }

    protected void postProcessCopy(TextEditCopier copier) {
        if (this.fTarget != null) {
            ((CopySourceEdit)copier.getCopy(this)).setTargetEdit((CopyTargetEdit)copier.getCopy(this.fTarget));
        }
    }

    public void perform(TextBuffer buffer) throws CoreException {
        block2: {
            this.fContent = this.computeContent(buffer);
            TextRange targetRange = this.fTarget.getTextRange();
            if (++this.fCounter != 2 || targetRange.isDeleted()) break block2;
            try {
                buffer.replace(targetRange, this.fContent);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.clearContent();
                throw throwable;
            }
            Object var3_5 = null;
            this.clearContent();
        }
    }

    protected String computeContent(TextBuffer buffer) {
        TextRange range = this.getTextRange();
        return buffer.getContent(range.getOffset(), range.getLength());
    }

    void updateTextRange(int delta, List executedEdits) {
        boolean doIt = true;
        Iterator iter = executedEdits.iterator();
        while (iter.hasNext() && doIt) {
            TextEdit edit = (TextEdit)iter.next();
            if (edit == this.fTarget) {
                doIt = false;
            }
            if (!doIt) continue;
            edit.adjustOffset(delta);
        }
        this.fTarget.adjustLength(delta);
        this.fTarget.updateParents(delta);
    }

    String getContent() {
        return this.fContent;
    }

    void clearContent() {
        this.fContent = null;
    }

    void checkRange(DocumentEvent event) {
        this.fTarget.checkRange(event);
    }

    IStatus checkEdit(int bufferLength) {
        IStatus s = super.checkEdit(bufferLength);
        if (!s.isOK()) {
            return s;
        }
        if (this.fTarget == null) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("CopySourceEdit.no_target"));
        }
        if (this.fTarget.getSourceEdit() != this) {
            return TextEdit.createErrorStatus(TextManipulationMessages.getString("CopySourceEdit.different_source"));
        }
        return TextEdit.createOKStatus();
    }

    CopyTargetEdit getTargetEdit() {
        return this.fTarget;
    }
}

