/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

public final class AutoOrganizingTextEdit
extends TextEdit {
    private List fElements;

    public AutoOrganizingTextEdit() {
        this.fElements = new ArrayList(2);
    }

    private AutoOrganizingTextEdit(List elements) {
        this.fElements = elements;
    }

    public void add(TextEdit edit) {
        Assert.isTrue(this.isUnconnected());
        this.fElements.add(edit);
    }

    public boolean hasChildren() {
        if (this.fElements != null && this.isUnconnected()) {
            return !this.fElements.isEmpty();
        }
        return super.hasChildren();
    }

    protected TextEdit copy0(TextEditCopier copier) {
        ArrayList<TextEdit> newElements = new ArrayList<TextEdit>(this.fElements.size());
        Iterator iter = this.fElements.iterator();
        while (iter.hasNext()) {
            newElements.add(((TextEdit)iter.next()).copy(copier));
        }
        return new AutoOrganizingTextEdit(newElements);
    }

    public final TextRange getTextRange() {
        TextRange result = this.getChildrenTextRange();
        if (result == null || result.isUndefined()) {
            return new TextRange(0, 0);
        }
        return result;
    }

    public void perform(TextBuffer buffer) throws CoreException {
    }

    public Iterator iterator() {
        if (this.fElements != null && this.isUnconnected()) {
            return this.fElements.iterator();
        }
        return super.iterator();
    }

    protected void adjustOffset(int delta) {
    }

    protected void adjustLength(int delta) {
    }

    void executePostProcessCopy(TextEditCopier copier) {
        if (this.fElements != null && this.isUnconnected()) {
            this.postProcessCopy(copier);
            Iterator iter = this.fElements.iterator();
            while (iter.hasNext()) {
                ((TextEdit)iter.next()).executePostProcessCopy(copier);
            }
        } else {
            super.executePostProcessCopy(copier);
        }
    }

    void executeConnect(TextBuffer buffer) throws CoreException {
        Assert.isTrue(this.isUnconnected());
        this.setLifeCycle(1);
        int size = this.fElements.size();
        int i = size - 1;
        while (i >= 0) {
            ((TextEdit)this.fElements.get(i)).executeConnect(buffer);
            --i;
        }
        this.setLifeCycle(0);
        i = 0;
        while (i < size) {
            TextEdit edit = (TextEdit)this.fElements.get(i);
            edit.setLifeCycleDeep(0);
            AutoOrganizingTextEdit.insert(this, edit);
            ++i;
        }
        this.fElements = null;
        this.connect(buffer);
        AutoOrganizingTextEdit.sortAndConnect(this);
    }

    private static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        ArrayList children = parent.getChildren();
        if (children == null) {
            parent.internalAdd(edit);
            return;
        }
        children = new ArrayList(children);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            child = (TextEdit)iter.next();
            if (!child.getTextRange().covers(edit.getTextRange())) continue;
            AutoOrganizingTextEdit.insert(child, edit);
            return;
        }
        int i = children.size() - 1;
        while (i >= 0) {
            child = (TextEdit)children.get(i);
            if (edit.getTextRange().covers(child.getTextRange())) {
                parent.remove(i);
                edit.internalAdd(child);
                parent.internalAdd(edit);
                int r = i - 1;
                while (r >= 0) {
                    TextEdit child2 = (TextEdit)children.get(r);
                    if (edit.getTextRange().covers(child2.getTextRange())) {
                        parent.remove(r);
                        edit.internalAdd(child2);
                    }
                    --r;
                }
                return;
            }
            --i;
        }
        parent.internalAdd(edit);
    }

    private static void sortAndConnect(TextEdit edit) {
        List children = edit.getChildren();
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                AutoOrganizingTextEdit.sortAndConnect((TextEdit)iter.next());
            }
        }
        edit.sortChildren();
        edit.setLifeCycle(2);
    }
}

