/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.textmanipulation;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRange;

abstract class AbstractTransferEdit
extends TextEdit {
    private TextRange fRange;
    int fMode;
    static final int UNDEFINED = 0;
    static final int INSERT = 1;
    static final int DELETE = 2;

    protected AbstractTransferEdit(TextRange range) {
        Assert.isNotNull(range);
        this.fRange = range;
    }

    public TextRange getTextRange() {
        return this.fRange;
    }

    protected final void setTextRange(TextRange range) {
        Assert.isTrue(range != null && !this.isConnected());
        this.fRange = range;
    }

    void predecessorExecuted(Iterator iter, int delta) {
        while (iter.hasNext()) {
            TextEdit edit = (TextEdit)iter.next();
            edit.predecessorExecuted(delta);
            List children = edit.getChildren();
            if (children == null) continue;
            this.predecessorExecuted(children.iterator(), delta);
        }
    }

    Iterator getSuccessorIterator() {
        TextEdit parent = this.getParent();
        if (parent == null) {
            return ((AbstractList)new ArrayList(0)).iterator();
        }
        Iterator result = parent.getChildren().iterator();
        while (result.next() != this) {
        }
        return result;
    }

    void move(List children, int delta) {
        if (children != null) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                TextEdit element = (TextEdit)iter.next();
                element.adjustOffset(delta);
                this.move(element.getChildren(), delta);
            }
        }
    }
}

