/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.internal.corext.template.ITemplateEditor;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.textmanipulation.RangeMarker;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;

public class JavaFormatter
implements ITemplateEditor {
    private static final String MARKER = "/*${cursor}*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private final IDocumentPartitioner fPartitioner = JavaPlugin.getDefault().getJavaTextTools().createDocumentPartitioner();
    private boolean fUseCodeFormatter;

    public JavaFormatter(String lineDelimiter, int initialIndentLevel, boolean useCodeFormatter) {
        this.fLineDelimiter = lineDelimiter;
        this.fUseCodeFormatter = useCodeFormatter;
        this.fInitialIndentLevel = initialIndentLevel;
    }

    public void edit(TemplateBuffer buffer, TemplateContext context) throws CoreException {
        if (this.fUseCodeFormatter) {
            this.format(buffer);
        } else {
            this.indentate(buffer);
        }
        JavaFormatter.trimBegin(buffer);
    }

    private static int getCaretOffset(TemplatePosition[] variables) {
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (variable.getName().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInsideCommentOrString(String string, int offset) {
        boolean bl;
        Document document = new Document(string);
        document.setDocumentPartitioner(this.fPartitioner);
        this.fPartitioner.connect((IDocument)document);
        try {
            try {
                ITypedRegion partition = document.getPartition(offset);
                String partitionType = partition.getType();
                bl = partitionType != null && (partitionType.equals("__java_multiline_comment") || partitionType.equals("__java_singleline_comment") || partitionType.equals("__java_string") || partitionType.equals("__java_character") || partitionType.equals("__java_javadoc"));
                Object var6_7 = null;
            }
            catch (BadLocationException badLocationException) {
                Object var6_8 = null;
                this.fPartitioner.disconnect();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.fPartitioner.disconnect();
            throw throwable;
        }
        this.fPartitioner.disconnect();
        return bl;
    }

    private void format(TemplateBuffer templateBuffer) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] variables = templateBuffer.getVariables();
        int caretOffset = JavaFormatter.getCaretOffset(variables);
        if (caretOffset > 0 && Character.isWhitespace(string.charAt(caretOffset - 1)) && caretOffset < string.length() && Character.isWhitespace(string.charAt(caretOffset)) && !this.isInsideCommentOrString(string, caretOffset)) {
            List positions = JavaFormatter.variablesToPositions(variables);
            SimpleTextEdit insert = SimpleTextEdit.createInsert(caretOffset, MARKER);
            string = JavaFormatter.edit(string, positions, insert);
            JavaFormatter.positionsToVariables(positions, variables);
            templateBuffer.setContent(string, variables);
            this.plainFormat(templateBuffer);
            string = templateBuffer.getString();
            variables = templateBuffer.getVariables();
            caretOffset = JavaFormatter.getCaretOffset(variables);
            positions = JavaFormatter.variablesToPositions(variables);
            SimpleTextEdit delete = SimpleTextEdit.createDelete(caretOffset, MARKER.length());
            string = JavaFormatter.edit(string, positions, delete);
            JavaFormatter.positionsToVariables(positions, variables);
            templateBuffer.setContent(string, variables);
        } else {
            this.plainFormat(templateBuffer);
        }
    }

    private void plainFormat(TemplateBuffer templateBuffer) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] variables = templateBuffer.getVariables();
        int[] offsets = JavaFormatter.variablesToOffsets(variables);
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter(null);
        string = formatter.format(string, this.fInitialIndentLevel, offsets, this.fLineDelimiter);
        JavaFormatter.offsetsToVariables(offsets, variables);
        templateBuffer.setContent(string, variables);
    }

    private void indentate(TemplateBuffer templateBuffer) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] variables = templateBuffer.getVariables();
        List positions = JavaFormatter.variablesToPositions(variables);
        ArrayList<SimpleTextEdit> edits = new ArrayList<SimpleTextEdit>(5);
        TextBuffer textBuffer = TextBuffer.create(string);
        int lineCount = textBuffer.getNumberOfLines();
        int i = 0;
        while (i < lineCount) {
            TextRegion region = textBuffer.getLineInformation(i);
            edits.add(SimpleTextEdit.createInsert(region.getOffset(), CodeFormatterUtil.createIndentString(this.fInitialIndentLevel)));
            String lineDelimiter = textBuffer.getLineDelimiter(i);
            if (lineDelimiter != null) {
                edits.add(SimpleTextEdit.createReplace(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter));
            }
            ++i;
        }
        string = JavaFormatter.edit(string, positions, edits);
        JavaFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static void trimBegin(TemplateBuffer templateBuffer) throws CoreException {
        String string = templateBuffer.getString();
        TemplatePosition[] variables = templateBuffer.getVariables();
        List positions = JavaFormatter.variablesToPositions(variables);
        int i = 0;
        while (i != string.length() && Character.isWhitespace(string.charAt(i))) {
            ++i;
        }
        string = JavaFormatter.edit(string, positions, SimpleTextEdit.createDelete(0, i));
        JavaFormatter.positionsToVariables(positions, variables);
        templateBuffer.setContent(string, variables);
    }

    private static String edit(String string, List positions, TextEdit edit) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(string);
        TextBufferEditor editor = new TextBufferEditor(textBuffer);
        JavaFormatter.addEdits(editor, positions);
        editor.add(edit);
        editor.performEdits(null);
        return textBuffer.getContent();
    }

    private static String edit(String string, List positions, List edits) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(string);
        TextBufferEditor editor = new TextBufferEditor(textBuffer);
        JavaFormatter.addEdits(editor, positions);
        JavaFormatter.addEdits(editor, edits);
        editor.performEdits(null);
        return textBuffer.getContent();
    }

    private static int[] variablesToOffsets(TemplatePosition[] variables) {
        Vector<Integer> vector = new Vector<Integer>();
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                vector.add(new Integer(offsets[j]));
                ++j;
            }
            ++i;
        }
        int[] offsets = new int[vector.size()];
        int i2 = 0;
        while (i2 != offsets.length) {
            offsets[i2] = (Integer)vector.get(i2);
            ++i2;
        }
        Arrays.sort(offsets);
        return offsets;
    }

    private static void offsetsToVariables(int[] allOffsets, TemplatePosition[] variables) {
        int[] currentIndices = new int[variables.length];
        int i = 0;
        while (i != currentIndices.length) {
            currentIndices[i] = 0;
            ++i;
        }
        int[][] offsets = new int[variables.length][];
        int i2 = 0;
        while (i2 != variables.length) {
            offsets[i2] = variables[i2].getOffsets();
            ++i2;
        }
        i2 = 0;
        while (i2 != allOffsets.length) {
            int min = Integer.MAX_VALUE;
            int minVariableIndex = -1;
            int j = 0;
            while (j != variables.length) {
                int offset;
                int currentIndex = currentIndices[j];
                if (currentIndex != offsets[j].length && (offset = offsets[j][currentIndex]) < min) {
                    min = offset;
                    minVariableIndex = j;
                }
                ++j;
            }
            offsets[minVariableIndex][currentIndices[minVariableIndex]] = allOffsets[i2];
            int n = minVariableIndex;
            currentIndices[n] = currentIndices[n] + 1;
            ++i2;
        }
        i2 = 0;
        while (i2 != variables.length) {
            variables[i2].setOffsets(offsets[i2]);
            ++i2;
        }
    }

    private static List variablesToPositions(TemplatePosition[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplatePosition[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getTextRange().getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    private static void addEdits(TextBufferEditor editor, List edits) throws CoreException {
        Iterator iter = edits.iterator();
        while (iter.hasNext()) {
            editor.add((TextEdit)iter.next());
        }
    }
}

