/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateTranslator;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitCompletion;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.JavaFormatter;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;

public class JavaContext
extends CompilationUnitContext {
    private static final String PLATFORM_LINE_DELIMITER = System.getProperty("line.separator");
    private CompilationUnitCompletion fCompletion;

    public JavaContext(ContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            return Strings.computeIndent(lineContent, CodeFormatterUtil.getTabWidth());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws CoreException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template.getPattern());
        this.getContextType().edit(buffer, this);
        String lineDelimiter = null;
        try {
            lineDelimiter = this.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelimiter == null) {
            lineDelimiter = PLATFORM_LINE_DELIMITER;
        }
        IPreferenceStore prefs = JavaPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.eclipse.jdt.ui.template.format");
        JavaFormatter formatter = new JavaFormatter(lineDelimiter, this.getIndentation(), useCodeFormatter);
        formatter.edit(buffer, this);
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        String key = this.getKey();
        if (this.fForceEvaluation) {
            return true;
        }
        return template.matches(key, this.getContextType().getName()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        try {
            IDocument document = this.getDocument();
            if (this.getCompletionLength() == 0) {
                int start = this.getCompletionOffset();
                while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                    --start;
                }
                if (start != 0 && Character.isUnicodeIdentifierStart(document.getChar(start - 1))) {
                    --start;
                }
                return start;
            }
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private CompilationUnitCompletion guessVariableNames() {
        ICompilationUnit unit = this.getCompilationUnit();
        int start = this.getStart();
        if (unit == null) {
            return null;
        }
        try {
            CompilationUnitCompletion collector = new CompilationUnitCompletion(unit);
            unit.codeComplete(start, (ICompletionRequestor)collector);
            return collector;
        }
        catch (JavaModelException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
            return null;
        }
    }

    private static void handleException(Shell shell, Exception e) {
        String title = JavaTemplateMessages.getString("JavaContext.error.title");
        if (e instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, null);
        } else if (e instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)e, shell, title, null);
        } else {
            JavaPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        }
    }

    private CompilationUnitCompletion getCompletion() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        if (this.fCompletion == null) {
            this.fCompletion = new CompilationUnitCompletion(compilationUnit);
            if (compilationUnit != null) {
                try {
                    compilationUnit.codeComplete(this.getStart(), (ICompletionRequestor)this.fCompletion);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return this.fCompletion;
    }

    public String guessArray() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localArrays = completion.findLocalArrays();
        if (localArrays.length > 0) {
            return localArrays[localArrays.length - 1].name;
        }
        return null;
    }

    public String guessArrayType() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localArrays = completion.findLocalArrays();
        if (localArrays.length > 0) {
            CompilationUnitCompletion.LocalVariable localArray = localArrays[localArrays.length - 1];
            String arrayTypeName = localArray.typeName;
            String typeName = JavaContext.getScalarType(arrayTypeName);
            int dimension = JavaContext.getArrayDimension(arrayTypeName) - 1;
            Assert.isTrue(dimension >= 0);
            String qualifiedName = JavaContext.createQualifiedTypeName(localArray.typePackageName, typeName);
            String innerTypeName = completion.simplifyTypeName(qualifiedName);
            return innerTypeName == null ? JavaContext.createArray(typeName, dimension) : JavaContext.createArray(innerTypeName, dimension);
        }
        return null;
    }

    private static String createArray(String type, int dimension) {
        StringBuffer buffer = new StringBuffer(type);
        int i = 0;
        while (i < dimension) {
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }

    private static String getScalarType(String type) {
        return type.substring(0, type.indexOf(91));
    }

    private static int getArrayDimension(String type) {
        int dimension = 0;
        int index = type.indexOf(91);
        while (index != -1) {
            ++dimension;
            index = type.indexOf(91, index + 1);
        }
        return dimension;
    }

    private static String createQualifiedTypeName(String packageName, String className) {
        StringBuffer buffer = new StringBuffer();
        if (packageName.length() != 0) {
            buffer.append(packageName);
            buffer.append('.');
        }
        buffer.append(className);
        return buffer.toString();
    }

    public String guessArrayElement() {
        CompilationUnitCompletion completion = this.getCompletion();
        CompilationUnitCompletion.LocalVariable[] localArrays = completion.findLocalArrays();
        if (localArrays.length > 0) {
            String typeName;
            String baseTypeName;
            int idx = localArrays.length - 1;
            CompilationUnitCompletion.LocalVariable var = localArrays[idx];
            IJavaProject project = this.getCompilationUnit().getJavaProject();
            String[] proposals = NamingConventions.suggestLocalVariableNames((IJavaProject)project, (String)var.typePackageName, (String)(baseTypeName = (typeName = var.typeName).substring(0, typeName.lastIndexOf(91))), (int)0, (String[])completion.getLocalVariableNames());
            if (proposals.length > 0) {
                return proposals[0];
            }
        }
        return null;
    }

    public String getIndex() {
        CompilationUnitCompletion completion = this.getCompletion();
        String[] proposals = new String[]{"i", "j", "k"};
        int i = 0;
        while (i != proposals.length) {
            String proposal = proposals[i];
            if (!completion.existsLocalName(proposal)) {
                return proposal;
            }
            ++i;
        }
        return null;
    }

    public String guessCollection() {
        CompilationUnitCompletion completion = this.getCompletion();
        try {
            CompilationUnitCompletion.LocalVariable[] localCollections = completion.findLocalCollections();
            if (localCollections.length > 0) {
                return localCollections[localCollections.length - 1].name;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public String getIterator() {
        CompilationUnitCompletion completion = this.getCompletion();
        String[] proposals = new String[]{"iter"};
        int i = 0;
        while (i != proposals.length) {
            String proposal = proposals[i];
            if (!completion.existsLocalName(proposal)) {
                return proposal;
            }
            ++i;
        }
        return null;
    }

    public void addIteratorImport() {
        try {
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            ImportsStructure structure = new ImportsStructure(this.getCompilationUnit(), settings.importOrder, settings.importThreshold, true);
            structure.addImport("java.util.Iterator");
            structure.create(false, null);
        }
        catch (CoreException e) {
            JavaContext.handleException(null, (Exception)((Object)e));
        }
    }

    public static String evaluateTemplate(Template template, ICompilationUnit compilationUnit, int position) throws CoreException {
        ContextType contextType = ContextTypeRegistry.getInstance().getContextType("java");
        if (contextType == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, JavaTemplateMessages.getString("JavaContext.error.message"), null));
        }
        Document document = new Document();
        if (compilationUnit != null && compilationUnit.exists()) {
            document.set(compilationUnit.getSource());
        }
        JavaContext context = new JavaContext(contextType, (IDocument)document, position, 0, compilationUnit);
        context.setForceEvaluation(true);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        return buffer.getString();
    }
}

