/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplateMessages;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;
import org.eclipse.jface.text.IDocument;

public abstract class CompilationUnitContextType
extends ContextType {
    public CompilationUnitContextType(String name) {
        super(name);
    }

    public abstract CompilationUnitContext createContext(IDocument var1, int var2, int var3, ICompilationUnit var4);

    protected String validateVariables(TemplatePosition[] variables) {
        int i = 0;
        while (i < variables.length) {
            TemplatePosition position = variables[i];
            if (position.getName().equals("cursor") && position.getOffsets().length > 1) {
                return TemplateMessages.getString("ContextType.error.multiple.cursor.variables");
            }
            ++i;
        }
        return null;
    }

    protected static class ReturnType
    extends TemplateVariable {
        public ReturnType() {
            super("return_type", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.return.type"));
        }

        public String evaluate(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(9);
            if (element == null) {
                return null;
            }
            try {
                return Signature.toString((String)((IMethod)element).getReturnType());
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }

        public boolean isResolved(TemplateContext context) {
            return this.evaluate(context) != null;
        }
    }

    protected static class File
    extends TemplateVariable {
        public File() {
            super("file", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.file"));
        }

        public String evaluate(TemplateContext context) {
            ICompilationUnit unit = ((CompilationUnitContext)context).getCompilationUnit();
            return unit == null ? null : unit.getElementName();
        }

        public boolean isResolved(TemplateContext context) {
            return this.evaluate(context) != null;
        }
    }

    protected static class EnclosingJavaElement
    extends TemplateVariable {
        protected final int fElementType;

        public EnclosingJavaElement(String name, String description, int elementType) {
            super(name, description);
            this.fElementType = elementType;
        }

        public String evaluate(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(this.fElementType);
            return element == null ? null : element.getElementName();
        }

        public boolean isResolved(TemplateContext context) {
            return this.evaluate(context) != null;
        }
    }

    protected static class Method
    extends EnclosingJavaElement {
        public Method() {
            super("enclosing_method", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.method"), 9);
        }
    }

    protected static class Type
    extends EnclosingJavaElement {
        public Type() {
            super("enclosing_type", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.type"), 7);
        }
    }

    protected static class Package
    extends EnclosingJavaElement {
        public Package() {
            super("enclosing_package", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.package"), 4);
        }
    }

    protected static class Project
    extends EnclosingJavaElement {
        public Project() {
            super("enclosing_project", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.project"), 2);
        }
    }

    protected static class Arguments
    extends TemplateVariable {
        public Arguments() {
            super("enclosing_method_arguments", JavaTemplateMessages.getString("CompilationUnitContextType.variable.description.enclosing.method.arguments"));
        }

        public String evaluate(TemplateContext context) {
            IJavaElement element = ((CompilationUnitContext)context).findEnclosingElement(9);
            if (element == null) {
                return null;
            }
            IMethod method = (IMethod)element;
            try {
                String[] arguments = method.getParameterNames();
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < arguments.length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(arguments[i]);
                    ++i;
                }
                return buffer.toString();
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
    }
}

