/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jdt.core.CompletionRequestorAdapter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;

class CompilationUnitCompletion
extends CompletionRequestorAdapter {
    private ICompilationUnit fUnit;
    private List fLocalVariables = new ArrayList();
    private Map fTypes = new HashMap();
    private boolean fError;

    public CompilationUnitCompletion(ICompilationUnit unit) {
        this.reset(unit);
    }

    public void reset(ICompilationUnit unit) {
        this.fUnit = unit;
        this.fLocalVariables.clear();
        this.fTypes.clear();
        this.fError = false;
    }

    public void acceptError(IProblem error) {
        this.fError = true;
    }

    public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
        this.fLocalVariables.add(new LocalVariable(new String(name), new String(typePackageName), new String(typeName)));
    }

    public boolean hasErrors() {
        return this.fError;
    }

    boolean existsLocalName(String name) {
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!localVariable.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    String[] getLocalVariableNames() {
        String[] res = new String[this.fLocalVariables.size()];
        int i = 0;
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            res[i++] = localVariable.name;
        }
        return res;
    }

    LocalVariable[] findLocalArrays() {
        Vector<LocalVariable> vector = new Vector<LocalVariable>();
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!CompilationUnitCompletion.isArray(localVariable.typeName)) continue;
            vector.add(localVariable);
        }
        return vector.toArray(new LocalVariable[vector.size()]);
    }

    LocalVariable[] findLocalCollections() throws JavaModelException {
        Vector<LocalVariable> vector = new Vector<LocalVariable>();
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            String typeName = this.qualify(localVariable.typeName);
            if (typeName == null || !this.isSubclassOf(typeName, "java.util.Collection")) continue;
            vector.add(localVariable);
        }
        return vector.toArray(new LocalVariable[vector.size()]);
    }

    String simplifyTypeName(String qualifiedName) {
        return (String)this.fTypes.get(qualifiedName);
    }

    private LocalVariable[] findLocalIntegers() {
        Vector<LocalVariable> vector = new Vector<LocalVariable>();
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            if (!localVariable.typeName.equals("int")) continue;
            vector.add(localVariable);
        }
        return vector.toArray(new LocalVariable[vector.size()]);
    }

    private LocalVariable[] findLocalIterator() throws JavaModelException {
        Vector<LocalVariable> vector = new Vector<LocalVariable>();
        Iterator iterator = this.fLocalVariables.iterator();
        while (iterator.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iterator.next();
            String typeName = this.qualify(localVariable.typeName);
            if (typeName == null || !this.isSubclassOf(typeName, "java.util.Iterator")) continue;
            vector.add(localVariable);
        }
        return vector.toArray(new LocalVariable[vector.size()]);
    }

    private static boolean isArray(String type) {
        return type.endsWith("[]");
    }

    private String qualify(String typeName) throws JavaModelException {
        if (this.fUnit == null) {
            return null;
        }
        IType[] types = this.fUnit.getTypes();
        if (types.length == 0) {
            return null;
        }
        String[][] resolvedTypeNames = types[0].resolveType(typeName);
        if (resolvedTypeNames == null) {
            return null;
        }
        return String.valueOf(resolvedTypeNames[0][0]) + '.' + resolvedTypeNames[0][1];
    }

    private boolean isSubclassOf(String typeName0, String typeName1) throws JavaModelException {
        if (typeName0.equals(typeName1)) {
            return true;
        }
        if (this.fUnit == null) {
            return false;
        }
        IJavaProject project = this.fUnit.getJavaProject();
        IType type0 = project.findType(typeName0);
        IType type1 = project.findType(typeName1);
        ITypeHierarchy hierarchy = type0.newSupertypeHierarchy(null);
        IType[] superTypes = hierarchy.getAllSupertypes(type0);
        int i = 0;
        while (i < superTypes.length) {
            if (superTypes[i].equals(type1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        String qualifiedName = CompilationUnitCompletion.createQualifiedTypeName(packageName, className);
        this.fTypes.put(qualifiedName, String.valueOf(completionName));
    }

    public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
        String qualifiedName = CompilationUnitCompletion.createQualifiedTypeName(packageName, interfaceName);
        this.fTypes.put(qualifiedName, String.valueOf(completionName));
    }

    private static String createQualifiedTypeName(char[] packageName, char[] className) {
        StringBuffer buffer = new StringBuffer();
        if (packageName.length != 0) {
            buffer.append(packageName);
            buffer.append('.');
        }
        buffer.append(className);
        return buffer.toString();
    }

    static class LocalVariable {
        String name;
        String typePackageName;
        String typeName;

        LocalVariable(String name, String typePackageName, String typeName) {
            this.name = name;
            this.typePackageName = typePackageName;
            this.typeName = typeName;
        }
    }
}

