/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.template.java.GlobalVariables;
import org.eclipse.jdt.internal.corext.template.java.JavaTemplateMessages;

public class CodeTemplateContextType
extends ContextType {
    public static final String CATCHBLOCK_CONTEXTTYPE = "catchblock_context";
    public static final String METHODBODY_CONTEXTTYPE = "methodbody_context";
    public static final String CONSTRUCTORBODY_CONTEXTTYPE = "constructorbody_context";
    public static final String NEWTYPE_CONTEXTTYPE = "newtype_context";
    public static final String TYPECOMMENT_CONTEXTTYPE = "typecomment_context";
    public static final String METHODCOMMENT_CONTEXTTYPE = "methodcomment_context";
    public static final String CONSTRUCTORCOMMENT_CONTEXTTYPE = "constructorcomment_context";
    public static final String OVERRIDECOMMENT_CONTEXTTYPE = "overridecomment_context";
    public static final String EXCEPTION_TYPE = "exception_type";
    public static final String EXCEPTION_VAR = "exception_var";
    public static final String ENCLOSING_METHOD = "enclosing_method";
    public static final String ENCLOSING_TYPE = "enclosing_type";
    public static final String BODY_STATEMENT = "body_statement";
    public static final String RETURN_TYPE = "return_type";
    public static final String SEE_TAG = "see_to_overridden";
    public static final String TAGS = "tags";
    public static final String TYPENAME = "type_name";
    public static final String FILENAME = "file_name";
    public static final String PACKAGENAME = "package_name";
    public static final String PROJECTNAME = "project_name";
    public static final String PACKAGE_DECLARATION = "package_declaration";
    public static final String TYPE_DECLARATION = "type_declaration";
    public static final String TYPE_COMMENT = "typecomment";
    private IScanner fScanner;

    public CodeTemplateContextType(String contextName) {
        super(contextName);
        this.addVariable(new GlobalVariables.Dollar());
        this.addVariable(new GlobalVariables.Date());
        this.addVariable(new GlobalVariables.Year());
        this.addVariable(new GlobalVariables.Time());
        this.addVariable(new GlobalVariables.User());
        this.addVariable(new Todo());
        if (CATCHBLOCK_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(EXCEPTION_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.exceptiontype")));
            this.addVariable(new CodeTemplateVariable(EXCEPTION_VAR, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.exceptionvar")));
        } else if (METHODBODY_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addVariable(new CodeTemplateVariable(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addVariable(new CodeTemplateVariable(BODY_STATEMENT, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.bodystatement")));
        } else if (CONSTRUCTORBODY_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addVariable(new CodeTemplateVariable(BODY_STATEMENT, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.bodystatement")));
        } else if (NEWTYPE_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(TYPENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typename")));
            this.addVariable(new CodeTemplateVariable(PACKAGE_DECLARATION, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.packdeclaration")));
            this.addVariable(new CodeTemplateVariable(TYPE_DECLARATION, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typedeclaration")));
            this.addVariable(new CodeTemplateVariable(TYPE_COMMENT, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typecomment")));
            this.addCompilationUnitVariables();
        } else if (TYPECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(TYPENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.typename")));
            this.addVariable(new CodeTemplateVariable(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addVariable(new TagsTemplateVariable());
            this.addCompilationUnitVariables();
        } else if (METHODCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addVariable(new CodeTemplateVariable(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addVariable(new CodeTemplateVariable(RETURN_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.returntype")));
            this.addVariable(new TagsTemplateVariable());
            this.addCompilationUnitVariables();
        } else if (OVERRIDECOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addVariable(new CodeTemplateVariable(ENCLOSING_METHOD, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingmethod")));
            this.addVariable(new CodeTemplateVariable(SEE_TAG, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.seetag")));
            this.addVariable(new TagsTemplateVariable());
            this.addCompilationUnitVariables();
        } else if (CONSTRUCTORCOMMENT_CONTEXTTYPE.equals(contextName)) {
            this.addVariable(new CodeTemplateVariable(ENCLOSING_TYPE, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.enclosingtype")));
            this.addVariable(new TagsTemplateVariable());
            this.addCompilationUnitVariables();
        }
    }

    private void addCompilationUnitVariables() {
        this.addVariable(new CodeTemplateVariable(FILENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.filename")));
        this.addVariable(new CodeTemplateVariable(PACKAGENAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.packagename")));
        this.addVariable(new CodeTemplateVariable(PROJECTNAME, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.projectname")));
    }

    protected String validateVariables(TemplatePosition[] variables) {
        ArrayList<String> required = new ArrayList<String>(5);
        String contextName = this.getName();
        if (NEWTYPE_CONTEXTTYPE.equals(contextName)) {
            required.add(PACKAGE_DECLARATION);
            required.add(TYPE_DECLARATION);
        }
        int i = 0;
        while (i < variables.length) {
            String var = variables[i].getName();
            if (this.getVariable(var) == null) {
                return JavaTemplateMessages.getFormattedString("CodeTemplateContextType.validate.unknownvariable", var);
            }
            ((AbstractCollection)required).remove(var);
            ++i;
        }
        if (!required.isEmpty()) {
            String missing = (String)required.get(0);
            return JavaTemplateMessages.getFormattedString("CodeTemplateContextType.validate.missingvariable", missing);
        }
        return super.validateVariables(variables);
    }

    public TemplateContext createContext() {
        return null;
    }

    public static void registerContextTypes(ContextTypeRegistry registry) {
        registry.add(new CodeTemplateContextType(CATCHBLOCK_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(METHODBODY_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(CONSTRUCTORBODY_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(NEWTYPE_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(TYPECOMMENT_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(METHODCOMMENT_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(CONSTRUCTORCOMMENT_CONTEXTTYPE));
        registry.add(new CodeTemplateContextType(OVERRIDECOMMENT_CONTEXTTYPE));
    }

    public String validate(String pattern) throws CoreException {
        String message = super.validate(pattern);
        if (message != null) {
            return message;
        }
        String contextName = this.getName();
        if ((METHODCOMMENT_CONTEXTTYPE.equals(contextName) || CONSTRUCTORCOMMENT_CONTEXTTYPE.equals(contextName) || TYPECOMMENT_CONTEXTTYPE.equals(contextName) || OVERRIDECOMMENT_CONTEXTTYPE.equals(contextName)) && !this.isValidComment(pattern)) {
            return JavaTemplateMessages.getString("CodeTemplateContextType.validate.invalidcomment");
        }
        return null;
    }

    private IScanner getScanner() {
        if (this.fScanner == null) {
            this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        }
        return this.fScanner;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = this.getScanner();
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (next == 1001 || next == 1003 || next == 1002) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static class CodeTemplateVariable
    extends TemplateVariable {
        public CodeTemplateVariable(String name, String description) {
            super(name, description);
        }

        public String evaluate(TemplateContext context) {
            return context.getVariable(this.getName());
        }
    }

    public static class TagsTemplateVariable
    extends TemplateVariable {
        public TagsTemplateVariable() {
            super(CodeTemplateContextType.TAGS, JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.tags"));
        }

        public String evaluate(TemplateContext context) {
            return "@";
        }
    }

    protected static class Todo
    extends TemplateVariable {
        public Todo() {
            super("todo", JavaTemplateMessages.getString("CodeTemplateContextType.variable.description.todo"));
        }

        public String evaluate(TemplateContext context) {
            String todoTaskTag = StubUtility.getTodoTaskTag(((CodeTemplateContext)context).getJavaProject());
            if (todoTaskTag == null) {
                return "XXX";
            }
            return todoTaskTag;
        }
    }
}

