/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.template.ContextTypeRegistry;
import org.eclipse.jdt.internal.corext.template.Template;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplateTranslator;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContextType;

public class CodeTemplateContext
extends TemplateContext {
    private String fLineDelimiter;
    private int fInitialIndentLevel;
    private IJavaProject fProject;

    public CodeTemplateContext(String contextTypeName, IJavaProject project, String lineDelim, int initialIndentLevel) {
        super(ContextTypeRegistry.getInstance().getContextType(contextTypeName));
        this.fLineDelimiter = lineDelim;
        this.fInitialIndentLevel = initialIndentLevel;
        this.fProject = project;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public TemplateBuffer evaluate(Template template) throws CoreException {
        Iterator iterator = this.getContextType().variableIterator();
        while (iterator.hasNext()) {
            TemplateVariable var = (TemplateVariable)iterator.next();
            if (!(var instanceof CodeTemplateContextType.CodeTemplateVariable)) continue;
            Assert.isNotNull(this.getVariable(var.getName()), "Variable " + var.getName() + "not defined");
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template.getPattern());
        if (buffer == null) {
            return null;
        }
        this.getContextType().edit(buffer, this);
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public void setCompilationUnitVariables(ICompilationUnit cu) {
        this.setVariable("file_name", cu.getElementName());
        this.setVariable("package_name", cu.getParent().getElementName());
        this.setVariable("project_name", cu.getJavaProject().getElementName());
    }
}

