/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template;

import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.template.ContextType;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public abstract class DocumentTemplateContext
extends TemplateContext {
    private final IDocument fDocument;
    private final int fCompletionOffset;
    private final int fCompletionLength;

    protected DocumentTemplateContext(ContextType type, IDocument document, int completionOffset, int completionLength) {
        super(type);
        Assert.isNotNull(document);
        Assert.isTrue(completionOffset >= 0 && completionOffset <= document.getLength());
        Assert.isTrue(completionLength >= 0);
        this.fDocument = document;
        this.fCompletionOffset = completionOffset;
        this.fCompletionLength = completionLength;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public int getCompletionOffset() {
        return this.fCompletionOffset;
    }

    public int getCompletionLength() {
        return this.fCompletionLength;
    }

    public String getKey() {
        int offset = this.getStart();
        int length = this.getEnd() - offset;
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getStart() {
        return this.fCompletionOffset;
    }

    public int getEnd() {
        return this.fCompletionOffset + this.fCompletionLength;
    }
}

