/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.template.ITemplateEditor;
import org.eclipse.jdt.internal.corext.template.TemplateBuffer;
import org.eclipse.jdt.internal.corext.template.TemplateContext;
import org.eclipse.jdt.internal.corext.template.TemplatePosition;
import org.eclipse.jdt.internal.corext.template.TemplateTranslator;
import org.eclipse.jdt.internal.corext.template.TemplateVariable;
import org.eclipse.jdt.internal.corext.textmanipulation.RangeMarker;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;

public abstract class ContextType
implements ITemplateEditor {
    private final String fName;
    private final Map fVariables = new HashMap();

    public ContextType(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void addVariable(TemplateVariable variable) {
        this.fVariables.put(variable.getName(), variable);
    }

    public void removeVariable(TemplateVariable variable) {
        this.fVariables.remove(variable.getName());
    }

    public void removeAllVariables() {
        this.fVariables.clear();
    }

    public Iterator variableIterator() {
        return this.fVariables.values().iterator();
    }

    protected TemplateVariable getVariable(String name) {
        return (TemplateVariable)this.fVariables.get(name);
    }

    public String validate(String pattern) throws CoreException {
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(pattern);
        if (buffer != null) {
            return this.validateVariables(buffer.getVariables());
        }
        return translator.getErrorMessage();
    }

    protected String validateVariables(TemplatePosition[] variables) {
        return null;
    }

    public void edit(TemplateBuffer templateBuffer, TemplateContext context) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(templateBuffer.getString());
        TemplatePosition[] variables = templateBuffer.getVariables();
        List positions = ContextType.variablesToPositions(variables);
        ArrayList<SimpleTextEdit> edits = new ArrayList<SimpleTextEdit>(5);
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (!variable.isResolved()) {
                String value;
                String name = variable.getName();
                int[] offsets = variable.getOffsets();
                int length = variable.getLength();
                TemplateVariable evaluator = (TemplateVariable)this.fVariables.get(name);
                String string = value = evaluator == null ? null : evaluator.evaluate(context);
                if (value != null) {
                    variable.setLength(value.length());
                    variable.setResolved(evaluator.isResolved(context));
                    int k = 0;
                    while (k != offsets.length) {
                        edits.add(SimpleTextEdit.createReplace(offsets[k], length, value));
                        ++k;
                    }
                }
            }
            ++i;
        }
        TextBufferEditor editor = new TextBufferEditor(textBuffer);
        ContextType.addEdits(editor, positions);
        ContextType.addEdits(editor, edits);
        editor.performEdits(null);
        ContextType.positionsToVariables(positions, variables);
        templateBuffer.setContent(textBuffer.getContent(), variables);
    }

    private static void addEdits(TextBufferEditor editor, List edits) throws CoreException {
        Iterator iter = edits.iterator();
        while (iter.hasNext()) {
            editor.add((TextEdit)iter.next());
        }
    }

    private static List variablesToPositions(TemplatePosition[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List positions, TemplatePosition[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getTextRange().getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }
}

