/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.search.internal.core.text.TextSearchScope;

public class QualifiedNameFinder {
    public static QualifiedNameSearchResult process(String pattern, String newValue, String filePatterns, IProject root, IProgressMonitor monitor) throws JavaModelException {
        if (filePatterns == null || filePatterns.length() == 0) {
            monitor.beginTask("", 1);
            monitor.worked(1);
            return new QualifiedNameSearchResult();
        }
        Assert.isNotNull(pattern);
        Assert.isNotNull(newValue);
        Assert.isNotNull(root);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ResultCollector collector = new ResultCollector(newValue, monitor);
        TextSearchEngine engine = new TextSearchEngine();
        engine.search(ResourcesPlugin.getWorkspace(), pattern, "", (ISearchScope)QualifiedNameFinder.createScope(filePatterns, root), (ITextSearchResultCollector)collector);
        return collector.getResult();
    }

    private static TextSearchScope createScope(String filePatterns, IProject root) throws JavaModelException {
        String[] patterns = QualifiedNameFinder.splitFilePatterns(filePatterns);
        TextSearchScope result = new TextSearchScope("");
        result.add((IResource)root);
        QualifiedNameFinder.addReferencingProjects(result, root);
        int i = 0;
        while (i < patterns.length) {
            result.addExtension(patterns[i]);
            ++i;
        }
        return result;
    }

    private static String[] splitFilePatterns(String filePatterns) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(filePatterns, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken().trim());
        }
        return result.toArray(new String[result.size()]);
    }

    private static void addReferencingProjects(TextSearchScope scope, IProject root) {
        IProject[] projects = root.getReferencingProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!scope.encloses((IResource)project)) {
                scope.add((IResource)project);
                QualifiedNameFinder.addReferencingProjects(scope, project);
            }
            ++i;
        }
    }

    private static class ResultCollector
    implements ITextSearchResultCollector {
        private String fNewValue;
        private IProgressMonitor fProgressMonitor;
        private QualifiedNameSearchResult fResult;

        public ResultCollector(String newValue, IProgressMonitor monitor) {
            this.fNewValue = newValue;
            this.fProgressMonitor = monitor;
            this.fResult = new QualifiedNameSearchResult();
        }

        public void aboutToStart() throws CoreException {
        }

        public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) throws CoreException {
            if (proxy.getType() != 1) {
                return;
            }
            IFile file = (IFile)proxy.requestResource();
            IJavaElement element = JavaCore.create((IFile)file);
            if (element != null && element.exists()) {
                return;
            }
            TextChange change = this.fResult.getChange(file);
            change.addTextEdit(RefactoringCoreMessages.getString("QualifiedNameFinder.update_name"), SimpleTextEdit.createReplace(start, length, this.fNewValue));
        }

        public void done() throws CoreException {
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public QualifiedNameSearchResult getResult() {
            return this.fResult;
        }
    }
}

