/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class JavaElementUtil {
    private JavaElementUtil() {
    }

    public static String createMethodSignature(IMethod method) {
        try {
            return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (!method.isConstructor() ? 1 : 0) != 0);
        }
        catch (JavaModelException javaModelException) {
            return method.getElementName();
        }
    }

    public static String createFieldSignature(IField field) {
        return String.valueOf(JavaModelUtil.getFullyQualifiedName(field.getDeclaringType())) + "." + field.getElementName();
    }

    public static String createInitializerSignature(IInitializer initializer) {
        String label = String.valueOf(RefactoringCoreMessages.getString("JavaElementUtil.initializer_in")) + JavaModelUtil.getFullyQualifiedName(initializer.getDeclaringType());
        try {
            if (JdtFlags.isStatic((IMember)initializer)) {
                return "static " + label;
            }
            return label;
        }
        catch (JavaModelException javaModelException) {
            return label;
        }
    }

    public static String createSignature(IMember member) {
        switch (member.getElementType()) {
            case 8: {
                return JavaElementUtil.createFieldSignature((IField)member);
            }
            case 7: {
                return JavaModelUtil.getFullyQualifiedName((IType)member);
            }
            case 10: {
                return RefactoringCoreMessages.getString("JavaElementUtil.initializer");
            }
            case 9: {
                return JavaElementUtil.createMethodSignature((IMethod)member);
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public static IJavaElement[] getElementsOfType(IJavaElement[] elements, int type) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            if (element.getElementType() == type) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IType getMainType(ICompilationUnit cu) throws JavaModelException {
        IType[] types = cu.getTypes();
        int i = 0;
        while (i < types.length) {
            if (JavaElementUtil.isMainType(types[i])) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isMainType(IType type) throws JavaModelException {
        if (!type.exists()) {
            return false;
        }
        if (type.isBinary()) {
            return false;
        }
        if (type.getCompilationUnit() == null) {
            return false;
        }
        if (type.getDeclaringType() != null) {
            return false;
        }
        return JavaElementUtil.isPrimaryType(type) || JavaElementUtil.isCuOnlyType(type);
    }

    private static boolean isPrimaryType(IType type) {
        return type.getElementName().equals(Signature.getQualifier((String)type.getCompilationUnit().getElementName()));
    }

    private static boolean isCuOnlyType(IType type) throws JavaModelException {
        return type.getCompilationUnit().getTypes().length == 1;
    }

    public static IMethod[] getAllConstructors(IType type) throws JavaModelException {
        if (type.isInterface()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod iMethod = methods[i];
            if (iMethod.isConstructor()) {
                result.add(iMethod);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IJavaProject[] getReferencingProjects(IPackageFragmentRoot root) throws JavaModelException {
        IClasspathEntry cpe = root.getRawClasspathEntry();
        IJavaProject myProject = root.getJavaProject();
        IJavaProject[] allJavaProjects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>(allJavaProjects.length);
        int i = 0;
        while (i < allJavaProjects.length) {
            IPackageFragmentRoot[] roots;
            IJavaProject project = allJavaProjects[i];
            if (!project.equals(myProject) && (roots = project.findPackageFragmentRoots(cpe)).length > 0) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IJavaProject[result.size()]);
    }

    public static IMember[] merge(IMember[] a1, IMember[] a2) {
        HashSet<IMember> result = new HashSet<IMember>(a1.length + a2.length);
        result.addAll(Arrays.asList(a1));
        result.addAll(Arrays.asList(a2));
        return result.toArray(new IMember[result.size()]);
    }

    public static boolean isDefaultPackage(Object element) {
        return element instanceof IPackageFragment && ((IPackageFragment)element).isDefaultPackage();
    }
}

