/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public final class DebugUtils {
    private DebugUtils() {
    }

    public static void dumpCharCharArray(String msg, char[][] o) {
        DebugUtils.dump("DUMPING char[][]:" + msg);
        int i = 0;
        while (i < o.length) {
            DebugUtils.dump(new String(o[i]));
            ++i;
        }
    }

    public static void dumpArray(String msg, Object[] refs) {
        System.out.println("DUMPING array: " + msg);
        if (refs == null) {
            System.out.println("null");
            return;
        }
        int i = 0;
        while (i < refs.length) {
            System.out.println(refs[i].toString());
            ++i;
        }
    }

    public static void dumpCollectionCollection(String msg, Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            DebugUtils.dumpCollection("", (List)iter.next());
        }
    }

    public static void dumpCollection(String msg, Collection c) {
        System.out.println("DUMPING collection: " + msg);
        if (c == null) {
            System.out.println("null");
            return;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next().toString());
        }
    }

    public static void dumpIMethod(IMethod method) {
        try {
            if (method == null) {
                System.out.println("DUMPING method: null");
                return;
            }
            System.out.println("DUMPING method:" + method.getElementName() + "\n " + method.getSignature() + "\n declared in " + JavaModelUtil.getFullyQualifiedName(method.getDeclaringType()) + "\nreturnType:" + method.getReturnType());
            DebugUtils.dumpArray("paramTypes:", method.getParameterTypes());
            DebugUtils.dumpArray("exceptions:", method.getExceptionTypes());
        }
        catch (JavaModelException e) {
            System.out.println("JavaModelException: " + e.getMessage());
        }
    }

    public static void dumpIMethodList(String msg, List l) {
        System.out.println("DUMPING IMethodList: " + msg);
        if (l == null) {
            System.out.println("null");
            return;
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            DebugUtils.dumpIMethod((IMethod)iter.next());
        }
    }

    public static void dumpIType(String msg, IType type) {
        System.out.println("DUMPING IType:" + msg);
        System.out.println("exists:" + type.exists());
        try {
            System.out.println("correspondingResource:" + type.getCorrespondingResource());
            System.out.println("underResource:" + type.getUnderlyingResource());
            System.out.println("source:\n" + type.getSource());
            System.out.println("cu:" + type.getCompilationUnit().getSource());
        }
        catch (JavaModelException e) {
            System.out.println("JavaModelException: " + e.getMessage());
        }
    }

    public static void dumpIResource(String msg, IResource res) {
        System.out.println("DUMPING IResource:" + msg);
        System.out.println("name:" + res.getFullPath().toString());
        System.out.println("exists" + res.exists());
    }

    public static void dump(Object o) {
        if (o == null) {
            DebugUtils.dump("null");
        } else {
            DebugUtils.dump(o.toString());
        }
    }

    public static void dump(String msg) {
        System.out.println("DUMP:" + msg);
    }

    public static void dumpImports(ICompilationUnit cu) throws JavaModelException {
        IImportDeclaration[] imports = cu.getImports();
        if (imports == null) {
            return;
        }
        DebugUtils.dump("Compilation Unit: " + cu.getElementName());
        int k = 0;
        while (k < imports.length) {
            DebugUtils.dump("import " + imports[k].getElementName() + " on demand: " + imports[k].isOnDemand());
            ++k;
        }
    }

    public static void dumpImports(IPackageFragment pack) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        if (cus == null) {
            return;
        }
        int j = 0;
        while (j < cus.length) {
            DebugUtils.dumpImports(cus[j]);
            ++j;
        }
    }

    public static void dumpImports(IJavaProject project) throws JavaModelException {
        IPackageFragment[] packages = project.getPackageFragments();
        if (packages == null) {
            return;
        }
        int i = 0;
        while (i < packages.length) {
            DebugUtils.dumpImports(packages[i]);
            ++i;
        }
    }
}

