/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.util;

import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.dom.CompilationUnitBuffer;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class CommentAnalyzer {
    private CommentAnalyzer() {
    }

    public static RefactoringStatus perform(Selection selection, CompilationUnitBuffer source, int start, int length) {
        RefactoringStatus result = new RefactoringStatus();
        if (length <= 0) {
            return result;
        }
        new CommentAnalyzer().check(result, selection, source, start, start + length - 1);
        return result;
    }

    private void check(RefactoringStatus result, Selection selection, CompilationUnitBuffer source, int start, int end) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.getCharacters());
        scanner.resetTo(start, end);
        int token = 0;
        try {
            block5: while (token != 158) {
                token = scanner.getNextToken();
                switch (token) {
                    case 1001: 
                    case 1002: 
                    case 1003: {
                        if (this.checkStart(scanner, selection.getOffset())) {
                            result.addFatalError(RefactoringCoreMessages.getString("CommentAnalyzer.starts_inside_comment"));
                            break;
                        }
                        if (this.checkEnd(scanner, selection.getInclusiveEnd())) {
                            result.addFatalError(RefactoringCoreMessages.getString("CommentAnalyzer.ends_inside_comment"));
                            break;
                        }
                    }
                    default: {
                        continue block5;
                    }
                }
                break;
            }
        }
        catch (InvalidInputException invalidInputException) {
            result.addFatalError(RefactoringCoreMessages.getString("CommentAnalyzer.internal_error"));
        }
    }

    private boolean checkStart(IScanner scanner, int position) {
        return scanner.getCurrentTokenStartPosition() < position && position <= scanner.getCurrentTokenEndPosition();
    }

    private boolean checkEnd(IScanner scanner, int position) {
        return scanner.getCurrentTokenStartPosition() <= position && position < scanner.getCurrentTokenEndPosition();
    }
}

