/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ASTNodeCodeBlock;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeBlock;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeBlockEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.CompositeCodeBlock;
import org.eclipse.jdt.internal.corext.codemanipulation.DeleteNodeEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.TryCatchBlock;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jface.text.ITextSelection;

public class SurroundWithTryCatchRefactoring
extends Refactoring {
    private Selection fSelection;
    private CodeGenerationSettings fSettings;
    private ISurroundWithTryCatchQuery fQuery;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fSaveChanges;
    private ICompilationUnit fCUnit;
    private AST fTargetAST;

    public SurroundWithTryCatchRefactoring(ICompilationUnit cu, ITextSelection selection, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        this.fCUnit = cu;
        this.fSelection = Selection.createFromStartLength(selection.getOffset(), selection.getLength());
        this.fSettings = settings;
        this.fQuery = query;
    }

    public SurroundWithTryCatchRefactoring(ICompilationUnit cu, int offset, int length, CodeGenerationSettings settings, ISurroundWithTryCatchQuery query) {
        this.fCUnit = cu;
        this.fSelection = Selection.createFromStartLength(offset, length);
        this.fSettings = settings;
        this.fQuery = query;
    }

    public void setSaveChanges(boolean saveChanges) {
        this.fSaveChanges = saveChanges;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        return exceptions == null || exceptions.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("SurroundWithTryCatchRefactoring.name");
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit rootNode, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection, this.fQuery);
        rootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit})));
        if (result.hasFatalError()) {
            return result;
        }
        CompilationUnit rootNode = AST.parseCompilationUnit((ICompilationUnit)this.fCUnit, (boolean)true);
        return this.checkActivationBasics(rootNode, pm);
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompilationUnitChange compilationUnitChange;
        block6: {
            TextBuffer buffer = null;
            try {
                try {
                    this.fTargetAST = new AST();
                    CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
                    result.setSave(this.fSaveChanges);
                    buffer = TextBuffer.acquire(this.getFile());
                    this.addEdits(result, buffer);
                    compilationUnitChange = result;
                    Object var4_7 = null;
                    if (buffer == null) break block6;
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                if (buffer != null) {
                    TextBuffer.release(buffer);
                }
                this.fTargetAST = null;
                throw throwable;
            }
            TextBuffer.release(buffer);
        }
        this.fTargetAST = null;
        return compilationUnitChange;
    }

    private void addEdits(TextChange change, TextBuffer buffer) throws CoreException {
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        VariableDeclaration[] locals = this.fAnalyzer.getAffectedLocals();
        int tabWidth = CodeFormatterUtil.getTabWidth();
        this.addImportEdit(change, exceptions);
        int selectionStart = this.fSelection.getOffset();
        TextBuffer.Block block = buffer.getBlockContent(selectionStart, this.fSelection.getLength(), tabWidth);
        TextBufferEditor editor = new TextBufferEditor(TextBuffer.create(block.content));
        int delta = selectionStart + block.offsetDelta;
        ArrayList<VariableDeclarationStatement> handleDeclarationStatements = new ArrayList<VariableDeclarationStatement>(3);
        ASTNodeCodeBlock newLocals = new ASTNodeCodeBlock();
        int i = 0;
        while (i < locals.length) {
            VariableDeclaration local = locals[i];
            if (local instanceof SingleVariableDeclaration) {
                editor.add(this.handleLocal((SingleVariableDeclaration)local, newLocals, delta));
            } else if (local.getParent() instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement ds = (VariableDeclarationStatement)local.getParent();
                if (!handleDeclarationStatements.contains(ds)) {
                    editor.add(this.handleLocal(ds, buffer, newLocals, delta));
                    handleDeclarationStatements.add(ds);
                }
            } else {
                Assert.isTrue(false, "Operation doesn't work for expressions. So should never happen");
            }
            ++i;
        }
        CodeScopeBuilder.Scope root = CodeScopeBuilder.perform(this.fAnalyzer.getEnclosingBodyDeclaration(), this.fSelection);
        CodeScopeBuilder.Scope scope = root.findScope(this.fSelection.getOffset(), this.fSelection.getLength());
        scope.setCursor(this.fSelection.getOffset());
        editor.performEdits(null);
        CompositeCodeBlock codeBlock = new CompositeCodeBlock();
        codeBlock.add(newLocals);
        codeBlock.add(new TryCatchBlock(exceptions, this.fCUnit.getJavaProject(), scope, new CodeBlock(editor.getTextBuffer())));
        change.addTextEdit("", CodeBlockEdit.createReplace(selectionStart, this.fSelection.getLength(), codeBlock));
    }

    private void addImportEdit(TextChange change, ITypeBinding[] exceptions) throws JavaModelException {
        ImportEdit edit = new ImportEdit(this.fCUnit, this.fSettings);
        int i = 0;
        while (i < exceptions.length) {
            edit.addImport(Bindings.getFullyQualifiedImportName(exceptions[i]));
            ++i;
        }
        if (!edit.isEmpty()) {
            change.addTextEdit("", edit);
        }
    }

    private TextEdit handleLocal(SingleVariableDeclaration node, ASTNodeCodeBlock newLocals, int delta) {
        SingleVariableDeclaration copy = (SingleVariableDeclaration)ASTNode.copySubtree((AST)this.fTargetAST, (ASTNode)node);
        copy.setInitializer(null);
        newLocals.add((ASTNode)copy);
        int start = node.getStartPosition();
        if (node.getInitializer() != null) {
            int end = node.getName().getStartPosition();
            return SimpleTextEdit.createDelete(start - delta, end - start);
        }
        int length = node.getLength();
        return new DeleteNodeEdit(start - delta, length, true, ASTNodes.getDelimiterToken((ASTNode)node));
    }

    private TextEdit handleLocal(VariableDeclarationStatement node, TextBuffer buffer, ASTNodeCodeBlock newLocals, int delta) throws CoreException {
        List fragments = node.fragments();
        this.createNewDeclaration(node, newLocals);
        if (this.allFragmentsUninitialized(fragments)) {
            return new DeleteNodeEdit(node.getStartPosition() - delta, node.getLength(), true, ASTNodes.getDelimiterToken((ASTNode)node));
        }
        int size = fragments.size();
        ASTNodeCodeBlock block = new ASTNodeCodeBlock();
        int i = 0;
        while (i < size) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
            if (fragment.getInitializer() != null) {
                Assignment ass = this.fTargetAST.newAssignment();
                ass.setLeftHandSide((Expression)ASTNode.copySubtree((AST)this.fTargetAST, (ASTNode)fragment.getName()));
                ass.setOperator(Assignment.Operator.ASSIGN);
                ass.setRightHandSide((Expression)ASTNode.copySubtree((AST)this.fTargetAST, (ASTNode)fragment.getInitializer()));
                block.add((ASTNode)this.fTargetAST.newExpressionStatement((Expression)ass));
            }
            ++i;
        }
        return CodeBlockEdit.createReplace(node.getStartPosition() - delta, node.getLength(), block);
    }

    private void createNewDeclaration(VariableDeclarationStatement node, ASTNodeCodeBlock newLocals) {
        VariableDeclarationStatement copy = (VariableDeclarationStatement)ASTNode.copySubtree((AST)this.fTargetAST, (ASTNode)node);
        Iterator iter = copy.fragments().iterator();
        while (iter.hasNext()) {
            ((VariableDeclarationFragment)iter.next()).setInitializer(null);
        }
        newLocals.add((ASTNode)copy);
    }

    private boolean allFragmentsUninitialized(List fragments) {
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            if (fragment.getInitializer() == null) continue;
            return false;
        }
        return true;
    }

    private IFile getFile() throws JavaModelException {
        if (this.fCUnit.isWorkingCopy()) {
            return (IFile)this.fCUnit.getOriginalElement().getResource();
        }
        return (IFile)this.fCUnit.getResource();
    }
}

