/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Binding2JavaModel;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

class VisibilityChecker {
    static /* synthetic */ Class class$0;

    private VisibilityChecker() {
    }

    static boolean isVisibleFrom(IMember member, ASTNode accessingNode, ICompilationUnit nodeCu) throws JavaModelException {
        if (member.getDeclaringType() != null && !VisibilityChecker.isVisibleFrom((IMember)member.getDeclaringType(), accessingNode, nodeCu)) {
            return false;
        }
        if (JdtFlags.isPublic(member)) {
            return true;
        }
        boolean samePackage = VisibilityChecker.isInSamePackage(member, nodeCu);
        if (JdtFlags.isProtected(member)) {
            return samePackage || VisibilityChecker.isInSubtype(member, accessingNode, nodeCu.getJavaProject());
        }
        if (JdtFlags.isPackageVisible(member)) {
            return samePackage;
        }
        return VisibilityChecker.isInSameType(member, accessingNode, nodeCu.getJavaProject());
    }

    private static boolean isInSamePackage(IMember member, ICompilationUnit nodeCu) {
        return VisibilityChecker.getPackage(member).equals(VisibilityChecker.getPackage(nodeCu));
    }

    private static IPackageFragment getPackage(IMember member) {
        return (IPackageFragment)member.getAncestor(4);
    }

    private static IPackageFragment getPackage(ICompilationUnit cu) {
        return (IPackageFragment)cu.getAncestor(4);
    }

    private static boolean isInSameType(IMember member, ASTNode node, IJavaProject project) throws JavaModelException {
        IType memberType = member.getDeclaringType();
        IType nodeType = VisibilityChecker.getDeclaringType(node, project);
        if (memberType == null || nodeType == null) {
            return false;
        }
        do {
            if (!memberType.equals(nodeType)) continue;
            return true;
        } while ((memberType = memberType.getDeclaringType()) != null);
        return false;
    }

    private static IType getDeclaringType(ASTNode node, IJavaProject project) throws JavaModelException {
        ITypeBinding tb = VisibilityChecker.getDeclaringTypeBinding(node);
        if (tb == null) {
            return null;
        }
        return Binding2JavaModel.find(tb, project);
    }

    private static ITypeBinding getDeclaringTypeBinding(ASTNode node) {
        TypeDeclaration td;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((td = (TypeDeclaration)ASTNodes.getParent(node, clazz)) == null) {
            return null;
        }
        return td.resolveBinding();
    }

    private static boolean isInSubtype(IMember member, ASTNode node, IJavaProject project) throws JavaModelException {
        IType memberType = member.getDeclaringType();
        ITypeBinding tb = VisibilityChecker.getDeclaringTypeBinding(node);
        while (tb != null) {
            if (memberType.equals(Binding2JavaModel.find(tb, project))) {
                return true;
            }
            tb = tb.getSuperclass();
        }
        return false;
    }
}

