/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Binding2JavaModel;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.UpdateTypeReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.VisibilityChecker;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class UseSupertypeWherePossibleUtil {
    private final TextChangeManager fManager;
    private final Set fExtractedMemberSet;
    private final String fSuperTypeName;
    private final IType fInputClass;
    private final IType fSuperTypeToUse;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private final ASTNodeMappingManager fASTMappingManager;
    private final Set fBadVarSet;
    private final Map fReferenceNodeCache;
    private final Map fRippleMethodCache;
    private final Set fSuperTypeSet;
    private final boolean fUpdateInstanceOf;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private UseSupertypeWherePossibleUtil(TextChangeManager manager, IMember[] extractedMembers, String superTypeName, IType inputClass, CodeGenerationSettings codeGenerationSettings, ASTNodeMappingManager astManager, IType supertypeToUse, boolean updateInstanceOf) throws JavaModelException {
        this.fManager = manager;
        this.fExtractedMemberSet = UseSupertypeWherePossibleUtil.toWorkingCopyMembersSet(new HashSet<IMember>(Arrays.asList(extractedMembers)));
        this.fSuperTypeName = superTypeName;
        this.fInputClass = (IType)WorkingCopyUtil.getWorkingCopyIfExists((IMember)inputClass);
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fASTMappingManager = astManager;
        this.fBadVarSet = new HashSet(0);
        this.fReferenceNodeCache = new HashMap();
        this.fRippleMethodCache = new HashMap();
        this.fSuperTypeToUse = (IType)WorkingCopyUtil.getWorkingCopyIfExists((IMember)supertypeToUse);
        this.fSuperTypeSet = UseSupertypeWherePossibleUtil.createSuperTypeSet(this.fSuperTypeToUse, this.fInputClass.getJavaProject());
        this.fUpdateInstanceOf = updateInstanceOf;
    }

    static Set updateReferences(TextChangeManager manager, IMember[] extractedMembers, String superTypeName, IType inputClass, CodeGenerationSettings codeGenerationSettings, ASTNodeMappingManager astManager, IProgressMonitor pm, IType supertypeToUse, boolean updateInstanceOf) throws CoreException {
        UseSupertypeWherePossibleUtil inst = new UseSupertypeWherePossibleUtil(manager, extractedMembers, superTypeName, inputClass, codeGenerationSettings, astManager, supertypeToUse, updateInstanceOf);
        pm.beginTask("", 4);
        SearchResultGroup[] referenceGroups = UseSupertypeWherePossibleUtil.getMemberReferences((IMember)inputClass, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        Set replacedNodes = inst.addReferenceUpdatesAndImports(manager, (IProgressMonitor)new SubProgressMonitor(pm, 3), referenceGroups);
        pm.done();
        return replacedNodes;
    }

    static Set updateReferences(TextChangeManager manager, IMember[] extractedMembers, String superTypeName, IType inputClass, CodeGenerationSettings codeGenerationSettings, ASTNodeMappingManager astManager, IProgressMonitor pm) throws CoreException {
        return UseSupertypeWherePossibleUtil.updateReferences(manager, extractedMembers, superTypeName, inputClass, codeGenerationSettings, astManager, pm, null, true);
    }

    private static Set createSuperTypeSet(IType type, IJavaProject project) throws JavaModelException {
        if (type == null) {
            HashSet<IType> result = new HashSet<IType>(1);
            result.add(project.findType("java.lang.Object"));
            return result;
        }
        return UseSupertypeWherePossibleUtil.toWorkingCopyMembersSet(new HashSet<IType>(Arrays.asList(JavaModelUtil.getAllSuperTypes(type, (IProgressMonitor)new NullProgressMonitor()))));
    }

    private static Set toWorkingCopyMembersSet(Set members) throws JavaModelException {
        HashSet<IMember> result = new HashSet<IMember>(members.size());
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            result.add(WorkingCopyUtil.getWorkingCopyIfExists((IMember)iter.next()));
        }
        return result;
    }

    private static SearchResultGroup[] getMemberReferences(IMember member, IProgressMonitor pm) throws JavaModelException {
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)member, (int)2);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)member);
        return RefactoringSearchEngine.search(pm, scope, pattern);
    }

    private Set addReferenceUpdatesAndImports(TextChangeManager manager, IProgressMonitor pm, SearchResultGroup[] resultGroups) throws CoreException {
        Set nodeSet = this.getNodesToUpdate(resultGroups, pm);
        HashSet<ICompilationUnit> updatedCus = new HashSet<ICompilationUnit>(0);
        Iterator iter = nodeSet.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            ICompilationUnit cu = this.getCompilationUnit(node);
            manager.get(cu).addTextEdit(RefactoringCoreMessages.getString("UseSupertypeWherePossibleUtil.update_reference"), this.createTypeUpdateEdit(new SourceRange(node)));
            updatedCus.add(cu);
        }
        iter = updatedCus.iterator();
        while (iter.hasNext()) {
            ICompilationUnit cu = (ICompilationUnit)iter.next();
            if (!this.needsImport(cu)) continue;
            this.addSupertypeImport(manager, cu);
        }
        return nodeSet;
    }

    private boolean needsImport(ICompilationUnit cu) {
        IPackageFragment superTypePackage = this.getSuperTypePackage();
        if (superTypePackage.getElementName().equals("java.lang")) {
            return false;
        }
        return !superTypePackage.equals(cu.getParent());
    }

    private IPackageFragment getSuperTypePackage() {
        if (this.fSuperTypeToUse != null) {
            return this.fSuperTypeToUse.getPackageFragment();
        }
        return this.getInputClassPackage();
    }

    private Set getNodesToUpdate(SearchResultGroup[] resultGroups, IProgressMonitor pm) throws JavaModelException {
        HashSet<ASTNode> nodeSet = new HashSet<ASTNode>();
        int i = 0;
        while (i < resultGroups.length) {
            nodeSet.addAll(Arrays.asList(this.getAstNodes(resultGroups[i])));
            ++i;
        }
        this.retainUpdatableNodes(nodeSet, pm);
        return nodeSet;
    }

    private void retainUpdatableNodes(Set nodeSet, IProgressMonitor pm) throws JavaModelException {
        Collection nodesToRemove = this.computeNodesToRemove(nodeSet, pm);
        Iterator iter = nodesToRemove.iterator();
        while (iter.hasNext()) {
            nodeSet.remove(iter.next());
        }
    }

    private Collection computeNodesToRemove(Set nodeSet, IProgressMonitor pm) throws JavaModelException {
        boolean reiterate;
        pm.beginTask("", 1);
        SubProgressMonitor subPm1 = new SubProgressMonitor(pm, 1);
        subPm1.beginTask("", nodeSet.size());
        HashSet<ASTNode> nodesToRemove = new HashSet<ASTNode>(0);
        Iterator iter = nodeSet.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            if (!this.hasDirectProblems(node, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm1, 1))) continue;
            nodesToRemove.add(node);
        }
        subPm1.done();
        if (nodesToRemove.isEmpty()) {
            return nodesToRemove;
        }
        SubProgressMonitor subPm2 = new SubProgressMonitor(pm, 1);
        subPm2.beginTask("", nodeSet.size() - nodesToRemove.size());
        do {
            reiterate = false;
            Iterator iter2 = nodeSet.iterator();
            while (iter2.hasNext()) {
                ASTNode node = (ASTNode)iter2.next();
                if (nodesToRemove.contains(node) || !this.hasIndirectProblems(node, nodesToRemove, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm2, 1))) continue;
                reiterate = true;
                nodesToRemove.add(node);
            }
        } while (reiterate);
        subPm2.done();
        pm.done();
        return nodesToRemove;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasIndirectProblems(ASTNode node, Collection nodesToRemove, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        block38: {
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        try {
                                            ASTNode parentNode = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(node);
                                            if (parentNode instanceof VariableDeclarationStatement) {
                                                VariableDeclarationStatement vds = (VariableDeclarationStatement)parentNode;
                                                if (vds.getType() != node) {
                                                    Object var10_9 = null;
                                                    break block31;
                                                }
                                                VariableDeclarationFragment[] vdfs = UseSupertypeWherePossibleUtil.getVariableDeclarationFragments(vds);
                                                pm.beginTask("", vdfs.length);
                                                int i = 0;
                                                while (i < vdfs.length) {
                                                    if (this.hasIndirectProblems((VariableDeclaration)vdfs[i], nodesToRemove, (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                        Object var10_10 = null;
                                                        pm.done();
                                                        return true;
                                                    }
                                                    ++i;
                                                }
                                            } else if (parentNode instanceof FieldDeclaration) {
                                                FieldDeclaration fd = (FieldDeclaration)parentNode;
                                                if (fd.getType() != node) {
                                                    break block32;
                                                }
                                                VariableDeclarationFragment[] vdfs = UseSupertypeWherePossibleUtil.getVariableDeclarationFragments(fd);
                                                pm.beginTask("", vdfs.length);
                                                int i = 0;
                                                while (i < vdfs.length) {
                                                    if (this.hasIndirectProblems((VariableDeclaration)vdfs[i], nodesToRemove, (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                        Object var10_12 = null;
                                                        pm.done();
                                                        return true;
                                                    }
                                                    ++i;
                                                }
                                            } else if (parentNode instanceof VariableDeclaration) {
                                                pm.beginTask("", 1);
                                                if (UseSupertypeWherePossibleUtil.isMethodParameter(parentNode)) {
                                                    MethodDeclaration methodDeclaration = (MethodDeclaration)parentNode.getParent();
                                                    int parameterIndex = methodDeclaration.parameters().indexOf(parentNode);
                                                    IMethod[] methods = this.getAllRippleMethods(methodDeclaration, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                                    if (methods == null) {
                                                        SingleVariableDeclaration svd = this.getParameterDeclarationNode(parameterIndex, methodDeclaration);
                                                        nodesToRemove.add(svd.getType());
                                                        this.addToBadVarSet((VariableDeclaration)svd);
                                                        break block33;
                                                    }
                                                    if (this.isAnyParameterDeclarationExcluded(methods, parameterIndex, nodesToRemove)) {
                                                        int i = 0;
                                                        while (true) {
                                                            if (i >= methods.length) break;
                                                            SingleVariableDeclaration svd = this.getParameterDeclarationNode(parameterIndex, methods[i]);
                                                            if (svd != null) {
                                                                nodesToRemove.add(svd.getType());
                                                                this.addToBadVarSet((VariableDeclaration)svd);
                                                            }
                                                            ++i;
                                                        }
                                                        Object var10_14 = null;
                                                        pm.done();
                                                        return true;
                                                    }
                                                }
                                                if (this.hasIndirectProblems((VariableDeclaration)parentNode, nodesToRemove, (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                    break block34;
                                                }
                                            } else if (parentNode instanceof CastExpression) {
                                                pm.beginTask("", 1);
                                                if (!this.isReferenceUpdatable(parentNode, nodesToRemove)) {
                                                    break block35;
                                                }
                                            } else if (parentNode instanceof MethodDeclaration) {
                                                pm.beginTask("", 3);
                                                MethodDeclaration methodDeclaration = (MethodDeclaration)parentNode;
                                                if (methodDeclaration.getReturnType() == node) {
                                                    IMethod[] methods = this.getAllRippleMethods(methodDeclaration, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                                    if (methods == null) {
                                                        nodesToRemove.add(methodDeclaration.getReturnType());
                                                        break block36;
                                                    }
                                                    if (this.isAnyMethodReturnTypeNodeExcluded(methods, nodesToRemove)) {
                                                        nodesToRemove.addAll(this.getAllReturnTypeNodes(methods));
                                                        break block37;
                                                    }
                                                    ASTNode[] referenceNodes = this.getReferenceNodes((IMember[])methods, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                                    int i = 0;
                                                    while (i < referenceNodes.length) {
                                                        if (!this.isReferenceUpdatable(referenceNodes[i], nodesToRemove)) {
                                                            nodesToRemove.addAll(this.getAllReturnTypeNodes(methods));
                                                            Object var10_19 = null;
                                                            pm.done();
                                                            return true;
                                                        }
                                                        ++i;
                                                    }
                                                }
                                            } else if (parentNode instanceof ArrayType) {
                                                bl = this.hasIndirectProblems(parentNode, nodesToRemove, pm);
                                                break block38;
                                            }
                                            Object var10_21 = null;
                                            pm.done();
                                            return false;
                                        }
                                        catch (Throwable throwable) {
                                            Object var10_22 = null;
                                            pm.done();
                                            throw throwable;
                                        }
                                    }
                                    pm.done();
                                    return false;
                                }
                                Object var10_11 = null;
                                pm.done();
                                return false;
                            }
                            Object var10_13 = null;
                            pm.done();
                            return true;
                        }
                        Object var10_15 = null;
                        pm.done();
                        return true;
                    }
                    Object var10_16 = null;
                    pm.done();
                    return true;
                }
                Object var10_17 = null;
                pm.done();
                return true;
            }
            Object var10_18 = null;
            pm.done();
            return true;
        }
        Object var10_20 = null;
        pm.done();
        return bl;
    }

    private static boolean isMethodParameter(ASTNode node) {
        return node instanceof VariableDeclaration && node.getParent() instanceof MethodDeclaration && ((MethodDeclaration)node.getParent()).parameters().indexOf(node) != -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod[] getAllRippleMethods(MethodDeclaration methodDeclaration, IProgressMonitor pm) throws JavaModelException {
        IMethod[] iMethodArray;
        block6: {
            block5: {
                IMethod[] iMethodArray2;
                block4: {
                    try {
                        pm.beginTask("", 2);
                        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
                        if (methodBinding == null) {
                            iMethodArray2 = new IMethod[]{};
                            Object var5_6 = null;
                            break block4;
                        }
                        IMethod method = Binding2JavaModel.find(methodBinding, this.getCompilationUnit((ASTNode)methodDeclaration).getJavaProject());
                        if (method == null) {
                            break block5;
                        }
                        method = (IMethod)WorkingCopyUtil.getWorkingCopyIfExists((IMember)method);
                        iMethodArray = this.getAllRippleMethods(pm, UseSupertypeWherePossibleUtil.getTopMethod(method, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return iMethodArray2;
            }
            Object var5_7 = null;
            pm.done();
            return null;
        }
        Object var5_8 = null;
        pm.done();
        return iMethodArray;
    }

    private IMethod[] getAllRippleMethods(IProgressMonitor pm, IMethod topMethod) throws JavaModelException {
        if (this.fRippleMethodCache.containsKey(topMethod)) {
            return (IMethod[])this.fRippleMethodCache.get(topMethod);
        }
        IMethod[] methods = RippleMethodFinder.getRelatedMethods(topMethod, (IProgressMonitor)new SubProgressMonitor(pm, 1), (IWorkingCopy[])new ICompilationUnit[0]);
        this.fRippleMethodCache.put(topMethod, UseSupertypeWherePossibleUtil.getWorkingCopyMethods(methods));
        return methods;
    }

    private static IMethod[] getWorkingCopyMethods(IMethod[] methods) throws JavaModelException {
        IMethod[] result = new IMethod[methods.length];
        int i = 0;
        while (i < methods.length) {
            result[i] = (IMethod)WorkingCopyUtil.getWorkingCopyIfExists((IMember)methods[i]);
            ++i;
        }
        return result;
    }

    private boolean isAnyParameterDeclarationExcluded(IMethod[] methods, int parameterIndex, Collection nodesToRemove) throws JavaModelException {
        int i = 0;
        while (i < methods.length) {
            SingleVariableDeclaration paramDecl = this.getParameterDeclarationNode(parameterIndex, methods[i]);
            if (paramDecl == null) {
                return true;
            }
            if (this.fBadVarSet.contains(paramDecl)) {
                return true;
            }
            if (nodesToRemove.contains(paramDecl.getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SingleVariableDeclaration getParameterDeclarationNode(int parameterIndex, IMethod method) throws JavaModelException {
        return this.getParameterDeclarationNode(parameterIndex, this.getMethodDeclarationNode(method));
    }

    private SingleVariableDeclaration getParameterDeclarationNode(int parameterIndex, MethodDeclaration md) {
        if (md == null) {
            return null;
        }
        return (SingleVariableDeclaration)md.parameters().get(parameterIndex);
    }

    private Collection getAllReturnTypeNodes(IMethod[] methods) throws JavaModelException {
        ArrayList<Type> result = new ArrayList<Type>(methods.length);
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration methodDeclarationNode = this.getMethodDeclarationNode(methods[i]);
            if (methodDeclarationNode != null) {
                result.add(methodDeclarationNode.getReturnType());
            }
            ++i;
        }
        return result;
    }

    private boolean isAnyMethodReturnTypeNodeExcluded(IMethod[] methods, Collection nodesToRemove) throws JavaModelException {
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration methodDeclarationNode = this.getMethodDeclarationNode(methods[i]);
            if (methodDeclarationNode == null || nodesToRemove.contains(methodDeclarationNode.getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static IMethod getTopMethod(IMethod method, IProgressMonitor pm) throws JavaModelException {
        IMethod oldTop;
        Assert.isNotNull(method);
        pm.beginTask("", 3);
        IMethod top = method;
        do {
            oldTop = top;
        } while ((top = MethodChecks.overridesAnotherMethod(top, (IProgressMonitor)new SubProgressMonitor(pm, 1))) != null);
        pm.done();
        return (IMethod)WorkingCopyUtil.getWorkingCopyIfExists((IMember)oldTop);
    }

    private boolean hasIndirectProblems(VariableDeclaration varDeclaration, Collection nodesToRemove, IProgressMonitor pm) throws JavaModelException {
        ASTNode[] references = this.getVariableReferenceNodes(varDeclaration, pm);
        int i = 0;
        while (i < references.length) {
            if (!this.isReferenceUpdatable(references[i], nodesToRemove)) {
                this.addToBadVarSet(varDeclaration);
                return true;
            }
            ++i;
        }
        return false;
    }

    private ASTNode[] getVariableReferenceNodes(VariableDeclaration varDeclaration, IProgressMonitor pm) throws JavaModelException {
        IVariableBinding vb = varDeclaration.resolveBinding();
        if (vb == null) {
            return new ASTNode[0];
        }
        if (vb.isField()) {
            return this.getFieldReferenceNodes(varDeclaration, pm);
        }
        return TempOccurrenceFinder.findTempOccurrenceNodes(varDeclaration, true, false);
    }

    private ASTNode[] getFieldReferenceNodes(VariableDeclaration varDeclaration, IProgressMonitor pm) throws JavaModelException {
        Assert.isTrue(varDeclaration.resolveBinding().isField());
        IField field = Binding2JavaModel.find(varDeclaration.resolveBinding(), this.getCompilationUnit((ASTNode)varDeclaration).getJavaProject());
        if (field == null) {
            return new ASTNode[0];
        }
        field = (IField)WorkingCopyUtil.getWorkingCopyIfExists((IMember)field);
        return this.getReferenceNodes((IMember)field, pm);
    }

    private ASTNode[] getReferenceNodes(IMember member, IProgressMonitor pm) throws JavaModelException {
        ASTNode[] cached = this.getReferencesFromCache(member);
        if (cached != null) {
            return cached;
        }
        ASTNode[] nodes = ASTNodeSearchUtil.findReferenceNodes((IJavaElement)member, this.fASTMappingManager, pm);
        this.putToCache(member, nodes);
        return nodes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ASTNode[] getReferenceNodes(IMember[] members, IProgressMonitor pm) throws JavaModelException {
        ASTNode[] aSTNodeArray;
        block6: {
            ASTNode[] aSTNodeArray2;
            block5: {
                ASTNode[] aSTNodeArray3;
                block4: {
                    try {
                        if (members == null || members.length == 0) {
                            aSTNodeArray3 = new ASTNode[]{};
                            Object var4_6 = null;
                            break block4;
                        }
                        if (members.length == 1) {
                            aSTNodeArray2 = this.getReferenceNodes(members[0], pm);
                            break block5;
                        }
                        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)members[0]);
                        aSTNodeArray = ASTNodeSearchUtil.findReferenceNodes((IJavaElement[])members, this.fASTMappingManager, pm, scope);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_9 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return aSTNodeArray3;
            }
            Object var4_7 = null;
            pm.done();
            return aSTNodeArray2;
        }
        Object var4_8 = null;
        pm.done();
        return aSTNodeArray;
    }

    private ASTNode[] getReferencesFromCache(IMember member) {
        return (ASTNode[])this.fReferenceNodeCache.get(member);
    }

    private void putToCache(IMember member, ASTNode[] nodes) {
        this.fReferenceNodeCache.put(member, nodes);
    }

    private boolean isReferenceUpdatable(ASTNode node, Collection nodesToRemove) throws JavaModelException {
        ASTNode parent = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(node);
        if (node instanceof SimpleName && parent instanceof ArrayInitializer) {
            ArrayInitializer initializer = (ArrayInitializer)parent;
            if (initializer.getParent() instanceof VariableDeclarationFragment) {
                return this.isReferenceUpdatable((ASTNode)initializer, nodesToRemove);
            }
            if (initializer.getParent() instanceof ArrayCreation) {
                ArrayCreation arrayCreation = (ArrayCreation)initializer.getParent();
                return !nodesToRemove.contains(arrayCreation.getType().getComponentType());
            }
        }
        if (parent instanceof VariableDeclarationFragment) {
            IVariableBinding vb;
            VariableDeclarationFragment r1 = (VariableDeclarationFragment)parent;
            if (node == r1.getInitializer() && ((vb = r1.resolveBinding()) == null || this.fBadVarSet.contains(UseSupertypeWherePossibleUtil.getCompilationUnitNode(node).findDeclaringNode((IBinding)vb)))) {
                return false;
            }
        } else if (parent instanceof Assignment) {
            Assignment assmnt = (Assignment)parent;
            if (node == assmnt.getRightHandSide()) {
                return this.isLHSUpdatable(assmnt.getLeftHandSide(), nodesToRemove);
            }
        } else {
            if (UseSupertypeWherePossibleUtil.isInvocation(parent)) {
                return this.isReferenceInInvocationUpdatable(node, nodesToRemove);
            }
            if (parent instanceof ReturnStatement) {
                MethodDeclaration md;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (nodesToRemove.contains((md = (MethodDeclaration)ASTNodes.getParent(parent, clazz)).getReturnType())) {
                    return false;
                }
            } else if (parent instanceof ArrayAccess) {
                return this.isReferenceUpdatable(parent, nodesToRemove);
            }
        }
        return true;
    }

    private boolean isLHSUpdatable(Expression lhs, Collection nodesToRemove) throws JavaModelException {
        if (lhs instanceof Name) {
            IBinding binding = ((Name)lhs).resolveBinding();
            return !this.isBindingForExcludedElement(lhs, binding, nodesToRemove);
        }
        if (lhs instanceof MethodInvocation) {
            IMethodBinding binding = ((MethodInvocation)lhs).resolveMethodBinding();
            return !this.isBindingForExcludedElement(lhs, (IBinding)binding, nodesToRemove);
        }
        if (lhs instanceof SuperMethodInvocation) {
            IMethodBinding binding = ((SuperMethodInvocation)lhs).resolveMethodBinding();
            return !this.isBindingForExcludedElement(lhs, (IBinding)binding, nodesToRemove);
        }
        if (lhs instanceof FieldAccess) {
            IBinding binding = ((FieldAccess)lhs).getName().resolveBinding();
            return !this.isBindingForExcludedElement(lhs, binding, nodesToRemove);
        }
        if (lhs instanceof SuperFieldAccess) {
            IBinding binding = ((SuperFieldAccess)lhs).getName().resolveBinding();
            return !this.isBindingForExcludedElement(lhs, binding, nodesToRemove);
        }
        if (lhs instanceof ArrayCreation) {
            ArrayCreation arrayCreation = (ArrayCreation)lhs;
            if (nodesToRemove.contains(arrayCreation.getType().getComponentType())) {
                return false;
            }
        } else {
            if (lhs instanceof Assignment) {
                Assignment assignment = (Assignment)lhs;
                return this.isLHSUpdatable(assignment.getLeftHandSide(), nodesToRemove);
            }
            if (lhs instanceof ParenthesizedExpression) {
                ParenthesizedExpression expression = (ParenthesizedExpression)lhs;
                return this.isLHSUpdatable(expression.getExpression(), nodesToRemove);
            }
            if (lhs instanceof ConditionalExpression) {
                ConditionalExpression expression = (ConditionalExpression)lhs;
                return this.isLHSUpdatable(expression.getThenExpression(), nodesToRemove) && this.isLHSUpdatable(expression.getElseExpression(), nodesToRemove);
            }
            if (lhs instanceof ArrayAccess) {
                ArrayAccess arrayAccess = (ArrayAccess)lhs;
                return this.isLHSUpdatable(arrayAccess.getArray(), nodesToRemove);
            }
        }
        return true;
    }

    private boolean isBindingForExcludedElement(Expression lhs, IBinding binding, Collection nodesToRemove) throws JavaModelException {
        if (binding == null) {
            return true;
        }
        IJavaProject scope = this.getCompilationUnit((ASTNode)lhs).getJavaProject();
        if (binding instanceof IVariableBinding) {
            IVariableBinding vb = (IVariableBinding)binding;
            if (!vb.isField()) {
                return this.fBadVarSet.contains(UseSupertypeWherePossibleUtil.getCompilationUnitNode((ASTNode)lhs).findDeclaringNode(binding));
            }
            IField field = Binding2JavaModel.find(vb, scope);
            if (field == null) {
                return true;
            }
            VariableDeclarationFragment fragment = this.getFieldDeclarationFragmentNode(field);
            return this.fBadVarSet.contains(fragment);
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding mb = (IMethodBinding)binding;
            IMethod method = Binding2JavaModel.find(mb, scope);
            if (method == null) {
                return true;
            }
            MethodDeclaration declaration = this.getMethodDeclarationNode(method);
            if (declaration == null) {
                return true;
            }
            return nodesToRemove.contains(UseSupertypeWherePossibleUtil.getElementType(declaration.getReturnType()));
        }
        return this.fBadVarSet.contains(UseSupertypeWherePossibleUtil.getCompilationUnitNode((ASTNode)lhs).findDeclaringNode(binding));
    }

    private static Type getElementType(Type type) {
        if (type.isArrayType()) {
            return ((ArrayType)type).getElementType();
        }
        return type;
    }

    private boolean isReferenceInInvocationUpdatable(ASTNode node, Collection nodesToRemove) throws JavaModelException {
        ASTNode parent = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(node);
        Assert.isTrue(UseSupertypeWherePossibleUtil.isInvocation(parent));
        int argumentIndex = UseSupertypeWherePossibleUtil.getArgumentIndexInInvocation(node);
        if (argumentIndex == -1) {
            return this.isReferenceUpdatable(parent, nodesToRemove);
        }
        IMethodBinding bin = UseSupertypeWherePossibleUtil.resolveMethodBindingInInvocation(node);
        if (bin == null) {
            return false;
        }
        IMethod method = Binding2JavaModel.find(bin, this.fInputClass.getJavaProject());
        if (method == null) {
            return false;
        }
        if ((method = (IMethod)WorkingCopyUtil.getWorkingCopyIfExists((IMember)method)).getCompilationUnit() == null) {
            if (this.fSuperTypeToUse == null) {
                return false;
            }
            IType type = JavaModelUtil.findType(this.fInputClass.getJavaProject(), Signature.toString((String)method.getParameterTypes()[argumentIndex]));
            if (type == null) {
                return false;
            }
            return this.isTypeOkToUseAsSuperType(type);
        }
        MethodDeclaration methodDeclarationNode = this.getMethodDeclarationNode(method);
        if (method == null) {
            return false;
        }
        SingleVariableDeclaration parDecl = (SingleVariableDeclaration)methodDeclarationNode.parameters().get(argumentIndex);
        return !this.fBadVarSet.contains(parDecl);
    }

    private static int getArgumentIndexInInvocation(ASTNode node) {
        ASTNode parent = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(node);
        Assert.isTrue(UseSupertypeWherePossibleUtil.isInvocation(parent));
        if (parent instanceof MethodInvocation) {
            return ((MethodInvocation)parent).arguments().indexOf(node);
        }
        if (parent instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)parent).arguments().indexOf(node);
        }
        if (parent instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)parent).arguments().indexOf(node);
        }
        if (parent instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)parent).arguments().indexOf(node);
        }
        return ((SuperConstructorInvocation)parent).arguments().indexOf(node);
    }

    private static IMethodBinding resolveMethodBindingInInvocation(ASTNode node) {
        ASTNode parent = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(node);
        Assert.isTrue(UseSupertypeWherePossibleUtil.isInvocation(parent));
        if (parent instanceof MethodInvocation) {
            return ((MethodInvocation)parent).resolveMethodBinding();
        }
        if (parent instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)parent).resolveMethodBinding();
        }
        if (parent instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)parent).resolveConstructorBinding();
        }
        if (parent instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)parent).resolveConstructorBinding();
        }
        return ((SuperConstructorInvocation)parent).resolveConstructorBinding();
    }

    private static boolean isInvocation(ASTNode node) {
        return node instanceof MethodInvocation || node instanceof ConstructorInvocation || node instanceof SuperConstructorInvocation || node instanceof SuperMethodInvocation || node instanceof ClassInstanceCreation;
    }

    private static CompilationUnit getCompilationUnitNode(ASTNode node) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CompilationUnit)ASTNodes.getParent(node, clazz);
    }

    private static ASTNode getUnparenthesizedParent(ASTNode node) {
        ASTNode parent = node.getParent();
        while (parent instanceof ParenthesizedExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasDirectProblems(ASTNode node, IProgressMonitor pm) throws JavaModelException {
        block59: {
            block60: {
                block58: {
                    block57: {
                        block56: {
                            block55: {
                                block54: {
                                    block53: {
                                        block52: {
                                            block51: {
                                                block50: {
                                                    block49: {
                                                        boolean bl;
                                                        block48: {
                                                            block47: {
                                                                block46: {
                                                                    boolean bl2;
                                                                    block45: {
                                                                        block43: {
                                                                            block44: {
                                                                                block42: {
                                                                                    block41: {
                                                                                        block40: {
                                                                                            block39: {
                                                                                                block38: {
                                                                                                    block37: {
                                                                                                        block36: {
                                                                                                            block35: {
                                                                                                                block34: {
                                                                                                                    pm.beginTask("", 1);
                                                                                                                    try {
                                                                                                                        VariableDeclarationStatement vds;
                                                                                                                        FieldDeclaration fd;
                                                                                                                        ASTNode parentNode = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(node);
                                                                                                                        if (parentNode instanceof TypeLiteral) {
                                                                                                                            Object var9_4 = null;
                                                                                                                            break block34;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof MethodInvocation) {
                                                                                                                            break block35;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof FieldAccess) {
                                                                                                                            break block36;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof ThisExpression) {
                                                                                                                            break block37;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof SuperMethodInvocation) {
                                                                                                                            break block38;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof ImportDeclaration) {
                                                                                                                            break block39;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof QualifiedName) {
                                                                                                                            QualifiedName qn = (QualifiedName)parentNode;
                                                                                                                            IBinding binding = qn.resolveBinding();
                                                                                                                            if (!(binding instanceof IVariableBinding)) {
                                                                                                                                break block40;
                                                                                                                            }
                                                                                                                            IVariableBinding vb = (IVariableBinding)binding;
                                                                                                                            if (!vb.isField()) {
                                                                                                                                break block41;
                                                                                                                            }
                                                                                                                            IField field = Binding2JavaModel.find(vb, this.getCompilationUnit((ASTNode)qn).getJavaProject());
                                                                                                                            if (field != null) {
                                                                                                                                field = (IField)WorkingCopyUtil.getWorkingCopyIfExists((IMember)field);
                                                                                                                            }
                                                                                                                            if (!this.fExtractedMemberSet.contains(field)) {
                                                                                                                                break block42;
                                                                                                                            }
                                                                                                                            IBinding b1 = qn.getQualifier().resolveBinding();
                                                                                                                            if (b1 instanceof ITypeBinding) break block43;
                                                                                                                            break block44;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof InstanceofExpression) {
                                                                                                                            bl2 = !this.fUpdateInstanceOf;
                                                                                                                            break block45;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof ClassInstanceCreation && node == ((ClassInstanceCreation)parentNode).getName()) {
                                                                                                                            break block46;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof ArrayType && parentNode.getParent() instanceof ArrayCreation && parentNode == ((ArrayCreation)parentNode.getParent()).getType()) {
                                                                                                                            break block47;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof ArrayType) {
                                                                                                                            bl = this.hasDirectProblems(parentNode, pm);
                                                                                                                            break block48;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof MethodDeclaration) {
                                                                                                                            MethodDeclaration md = (MethodDeclaration)parentNode;
                                                                                                                            if (md.thrownExceptions().contains(node)) {
                                                                                                                                break block49;
                                                                                                                            }
                                                                                                                            if (node == md.getReturnType()) {
                                                                                                                                ICompilationUnit cu = this.getCompilationUnit(node);
                                                                                                                                IMethodBinding binding = md.resolveBinding();
                                                                                                                                if (binding == null) {
                                                                                                                                    break block50;
                                                                                                                                }
                                                                                                                                IMethod method = Binding2JavaModel.find(binding, cu.getJavaProject());
                                                                                                                                if (method != null && this.anyReferenceHasDirectProblems((IMember)(method = (IMethod)WorkingCopyUtil.getWorkingCopyIfExists((IMember)method)), (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                                                                                                    break block51;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (parentNode instanceof SingleVariableDeclaration && parentNode.getParent() instanceof CatchClause) {
                                                                                                                            break block52;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof TypeDeclaration) {
                                                                                                                            if (node == ((TypeDeclaration)parentNode).getSuperclass()) {
                                                                                                                                break block53;
                                                                                                                            }
                                                                                                                            if (((TypeDeclaration)parentNode).superInterfaces().contains(node)) {
                                                                                                                                break block54;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (parentNode instanceof FieldDeclaration && (fd = (FieldDeclaration)parentNode).getType() == node && !this.canReplaceTypeInFieldDeclaration(fd, (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                                                                                            this.addAllToBadVarSet((VariableDeclaration[])UseSupertypeWherePossibleUtil.getVariableDeclarationFragments(fd));
                                                                                                                            break block55;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof VariableDeclarationStatement && (vds = (VariableDeclarationStatement)parentNode).getType() == node && !this.canReplaceTypeInVariableDeclarationStatement(vds, (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                                                                                            this.addAllToBadVarSet((VariableDeclaration[])UseSupertypeWherePossibleUtil.getVariableDeclarationFragments(vds));
                                                                                                                            break block56;
                                                                                                                        }
                                                                                                                        if (parentNode instanceof SingleVariableDeclaration && this.anyVariableReferenceHasDirectProblems((VariableDeclaration)((SingleVariableDeclaration)parentNode), (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                                                                                                                            if (!UseSupertypeWherePossibleUtil.isMethodParameter(parentNode)) {
                                                                                                                                this.addToBadVarSet((VariableDeclaration)((SingleVariableDeclaration)parentNode));
                                                                                                                                break block57;
                                                                                                                            }
                                                                                                                            MethodDeclaration methodDeclaration = (MethodDeclaration)parentNode.getParent();
                                                                                                                            int parameterIndex = methodDeclaration.parameters().indexOf(parentNode);
                                                                                                                            IMethod[] methods = this.getAllRippleMethods(methodDeclaration, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                                                                                                                            if (methods == null) {
                                                                                                                                SingleVariableDeclaration svd = this.getParameterDeclarationNode(parameterIndex, methodDeclaration);
                                                                                                                                this.addToBadVarSet((VariableDeclaration)svd);
                                                                                                                                break block58;
                                                                                                                            } else {
                                                                                                                                int i = 0;
                                                                                                                                while (true) {
                                                                                                                                    if (i >= methods.length) break;
                                                                                                                                    SingleVariableDeclaration svd = this.getParameterDeclarationNode(parameterIndex, methods[i]);
                                                                                                                                    if (svd != null) {
                                                                                                                                        this.addToBadVarSet((VariableDeclaration)svd);
                                                                                                                                    }
                                                                                                                                    ++i;
                                                                                                                                }
                                                                                                                                Object var9_29 = null;
                                                                                                                                pm.done();
                                                                                                                                return true;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (!(parentNode instanceof CastExpression) || !this.isNotUpdatableReference(parentNode, (IProgressMonitor)new SubProgressMonitor(pm, 1))) break block59;
                                                                                                                        break block60;
                                                                                                                    }
                                                                                                                    catch (Throwable throwable) {
                                                                                                                        Object var9_32 = null;
                                                                                                                        pm.done();
                                                                                                                        throw throwable;
                                                                                                                    }
                                                                                                                }
                                                                                                                pm.done();
                                                                                                                return true;
                                                                                                            }
                                                                                                            Object var9_5 = null;
                                                                                                            pm.done();
                                                                                                            return true;
                                                                                                        }
                                                                                                        Object var9_6 = null;
                                                                                                        pm.done();
                                                                                                        return true;
                                                                                                    }
                                                                                                    Object var9_7 = null;
                                                                                                    pm.done();
                                                                                                    return true;
                                                                                                }
                                                                                                Object var9_8 = null;
                                                                                                pm.done();
                                                                                                return true;
                                                                                            }
                                                                                            Object var9_9 = null;
                                                                                            pm.done();
                                                                                            return true;
                                                                                        }
                                                                                        Object var9_10 = null;
                                                                                        pm.done();
                                                                                        return true;
                                                                                    }
                                                                                    Object var9_11 = null;
                                                                                    pm.done();
                                                                                    return true;
                                                                                }
                                                                                Object var9_12 = null;
                                                                                pm.done();
                                                                                return true;
                                                                            }
                                                                            Object var9_13 = null;
                                                                            pm.done();
                                                                            return true;
                                                                        }
                                                                        Object var9_14 = null;
                                                                        pm.done();
                                                                        return false;
                                                                    }
                                                                    Object var9_15 = null;
                                                                    pm.done();
                                                                    return bl2;
                                                                }
                                                                Object var9_16 = null;
                                                                pm.done();
                                                                return true;
                                                            }
                                                            Object var9_17 = null;
                                                            pm.done();
                                                            return true;
                                                        }
                                                        Object var9_18 = null;
                                                        pm.done();
                                                        return bl;
                                                    }
                                                    Object var9_19 = null;
                                                    pm.done();
                                                    return true;
                                                }
                                                Object var9_20 = null;
                                                pm.done();
                                                return true;
                                            }
                                            Object var9_21 = null;
                                            pm.done();
                                            return true;
                                        }
                                        Object var9_22 = null;
                                        pm.done();
                                        return true;
                                    }
                                    Object var9_23 = null;
                                    pm.done();
                                    return true;
                                }
                                Object var9_24 = null;
                                pm.done();
                                return true;
                            }
                            Object var9_25 = null;
                            pm.done();
                            return true;
                        }
                        Object var9_26 = null;
                        pm.done();
                        return true;
                    }
                    Object var9_27 = null;
                    pm.done();
                    return true;
                }
                Object var9_28 = null;
                pm.done();
                return true;
            }
            Object var9_30 = null;
            pm.done();
            return true;
        }
        Object var9_31 = null;
        pm.done();
        return false;
    }

    private ASTNode[] getAstNodes(SearchResultGroup searchResultGroup) {
        HashSet<ASTNode> nodeSet = new HashSet<ASTNode>();
        ICompilationUnit cu = searchResultGroup.getCompilationUnit();
        if (cu == null) {
            return new ASTNode[0];
        }
        ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        ASTNode[] nodes = ASTNodeSearchUtil.getAstNodes(searchResultGroup.getSearchResults(), this.getAST(wc));
        int i = 0;
        while (i < nodes.length) {
            nodeSet.add(nodes[i]);
            ++i;
        }
        return nodeSet.toArray(new ASTNode[nodeSet.size()]);
    }

    private void addSupertypeImport(TextChangeManager manager, ICompilationUnit cu) throws CoreException {
        ImportEdit importEdit = new ImportEdit(cu, this.fCodeGenerationSettings);
        importEdit.addImport(this.getFullyQualifiedSupertypeName());
        String[] keys = new String[]{this.getFullyQualifiedSupertypeName()};
        String editName = RefactoringCoreMessages.getFormattedString("UseSupertypeWherePossibleUtil.adding_import", keys);
        manager.get(cu).addTextEdit(editName, importEdit);
    }

    private String getFullyQualifiedSupertypeName() {
        if (this.fSuperTypeToUse != null) {
            return JavaModelUtil.getFullyQualifiedName(this.fSuperTypeToUse);
        }
        return String.valueOf(this.getInputClassPackage().getElementName()) + "." + this.fSuperTypeName;
    }

    private IPackageFragment getInputClassPackage() {
        return this.fInputClass.getPackageFragment();
    }

    private TextEdit createTypeUpdateEdit(ISourceRange sourceRange) {
        return new UpdateTypeReferenceEdit(sourceRange.getOffset(), sourceRange.getLength(), this.fSuperTypeName, this.fInputClass.getElementName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canReplaceTypeInDeclarationFragments(VariableDeclarationFragment[] fragments, IProgressMonitor pm) throws JavaModelException {
        block5: {
            pm.beginTask("", fragments.length);
            try {
                int i = 0;
                while (true) {
                    if (i >= fragments.length) {
                        break block5;
                    }
                    if (this.anyVariableReferenceHasDirectProblems((VariableDeclaration)fragments[i], (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                        Object var4_4 = null;
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return false;
        }
        Object var4_5 = null;
        pm.done();
        return true;
    }

    private boolean canReplaceTypeInFieldDeclaration(FieldDeclaration fd, IProgressMonitor pm) throws JavaModelException {
        return this.canReplaceTypeInDeclarationFragments(UseSupertypeWherePossibleUtil.getVariableDeclarationFragments(fd), pm);
    }

    private boolean canReplaceTypeInVariableDeclarationStatement(VariableDeclarationStatement vds, IProgressMonitor pm) throws JavaModelException {
        return this.canReplaceTypeInDeclarationFragments(UseSupertypeWherePossibleUtil.getVariableDeclarationFragments(vds), pm);
    }

    private void addToBadVarSet(VariableDeclaration variableDeclaration) {
        this.fBadVarSet.add(variableDeclaration);
    }

    private void addAllToBadVarSet(VariableDeclaration[] variableDeclarations) {
        int i = 0;
        while (i < variableDeclarations.length) {
            this.addToBadVarSet(variableDeclarations[i]);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean anyVariableReferenceHasDirectProblems(VariableDeclaration varDeclaration, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        block4: {
            block3: {
                pm.beginTask("", 2);
                try {
                    if (UseSupertypeWherePossibleUtil.isInterfaceMethodParameterDeclaration(varDeclaration)) {
                        Object var3_3 = null;
                        break block3;
                    }
                    bl = this.anyReferenceNodeHasDirectProblems(this.getVariableReferenceNodes(varDeclaration, (IProgressMonitor)new SubProgressMonitor(pm, 1)), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return true;
        }
        Object var3_4 = null;
        pm.done();
        return bl;
    }

    private static boolean isInterfaceMethodParameterDeclaration(VariableDeclaration varDeclaration) {
        if (!(varDeclaration.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        if (!(varDeclaration.getParent().getParent() instanceof TypeDeclaration)) {
            return false;
        }
        return ((TypeDeclaration)varDeclaration.getParent().getParent()).isInterface();
    }

    private boolean anyReferenceHasDirectProblems(IMember member, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        pm.beginTask("", 2);
        try {
            bl = this.anyReferenceNodeHasDirectProblems(this.getReferenceNodes(member, (IProgressMonitor)new SubProgressMonitor(pm, 1)), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean anyReferenceNodeHasDirectProblems(ASTNode[] referenceNodes, IProgressMonitor pm) throws JavaModelException {
        block5: {
            pm.beginTask("", referenceNodes.length);
            try {
                int i = 0;
                while (true) {
                    if (i >= referenceNodes.length) {
                        break block5;
                    }
                    if (this.isNotUpdatableReference(referenceNodes[i], (IProgressMonitor)new SubProgressMonitor(pm, 1))) {
                        Object var4_4 = null;
                        break;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
            return true;
        }
        Object var4_5 = null;
        pm.done();
        return false;
    }

    private boolean isNotUpdatableReference(ASTNode parentNode, IProgressMonitor pm) throws JavaModelException {
        VariableDeclaration vd;
        Assignment assign;
        IBinding binding;
        ASTNode unparenthesizedParent = UseSupertypeWherePossibleUtil.getUnparenthesizedParent(parentNode);
        if (unparenthesizedParent instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)unparenthesizedParent;
            if (parentNode.equals((Object)arrayAccess.getArray())) {
                return this.isNotUpdatableReference((ASTNode)arrayAccess, pm);
            }
            if (ASTNodes.isParent(parentNode, (ASTNode)arrayAccess.getArray())) {
                return this.isNotUpdatableReference((ASTNode)arrayAccess, pm);
            }
        }
        if (unparenthesizedParent instanceof FieldAccess) {
            if (this.fSuperTypeToUse == null) {
                return true;
            }
            binding = ((FieldAccess)unparenthesizedParent).getName().resolveBinding();
            if (binding instanceof IVariableBinding) {
                return !this.isVariableBindingOk((IVariableBinding)binding);
            }
            return true;
        }
        if (unparenthesizedParent instanceof SuperFieldAccess) {
            if (this.fSuperTypeToUse == null) {
                return true;
            }
            binding = ((SuperFieldAccess)unparenthesizedParent).getName().resolveBinding();
            if (binding instanceof IVariableBinding) {
                return !this.isVariableBindingOk((IVariableBinding)binding);
            }
            return true;
        }
        if (unparenthesizedParent instanceof QualifiedName) {
            binding = ((QualifiedName)unparenthesizedParent).resolveBinding();
            if (binding instanceof IVariableBinding) {
                return !this.isVariableBindingOk((IVariableBinding)binding);
            }
            return true;
        }
        if (unparenthesizedParent instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)unparenthesizedParent;
            if (parentNode == mi.getExpression() && !this.isMethodInvocationOk(mi, pm)) {
                return true;
            }
            if (mi.getExpression() != null && ASTNodes.isParent(parentNode, (ASTNode)mi.getExpression()) && !this.isMethodInvocationOk(mi, pm)) {
                return true;
            }
            int argumentIndex = mi.arguments().indexOf(parentNode);
            if (argumentIndex != -1) {
                IMethodBinding bin = mi.resolveMethodBinding();
                if (bin == null) {
                    return true;
                }
                IMethod method = Binding2JavaModel.find(bin, this.fInputClass.getJavaProject());
                if (method == null) {
                    return true;
                }
                IType paramType = UseSupertypeWherePossibleUtil.getMethodParameterType(method, argumentIndex);
                if (!this.isTypeOkToUseAsSuperType(paramType)) {
                    return true;
                }
            }
        }
        if (unparenthesizedParent instanceof Assignment && parentNode == (assign = (Assignment)unparenthesizedParent).getRightHandSide()) {
            IType type = this.findType(assign.getLeftHandSide().resolveTypeBinding());
            if (type == null) {
                return true;
            }
            if (!this.isTypeOkToUseAsSuperType(type)) {
                return true;
            }
        }
        if (unparenthesizedParent instanceof VariableDeclaration && parentNode == (vd = (VariableDeclaration)unparenthesizedParent).getInitializer()) {
            IType type = this.findType(vd.getName().resolveTypeBinding());
            if (type == null) {
                return true;
            }
            if (!this.isTypeOkToUseAsSuperType(type)) {
                return true;
            }
        }
        return false;
    }

    private boolean isTypeOkToUseAsSuperType(IType type) throws JavaModelException {
        if ((type = (IType)WorkingCopyUtil.getWorkingCopyIfExists((IMember)type)).equals(this.fInputClass)) {
            return true;
        }
        if (this.fSuperTypeToUse != null && this.fSuperTypeToUse.equals(type)) {
            return true;
        }
        return this.fSuperTypeSet.contains(type);
    }

    private static IType getMethodParameterType(IMethod method, int parameterIndex) throws JavaModelException {
        Assert.isTrue(parameterIndex >= 0);
        if (method.getNumberOfParameters() < parameterIndex) {
            return null;
        }
        String fqn = JavaModelUtil.getResolvedTypeName(method.getParameterTypes()[parameterIndex], method.getDeclaringType());
        if (fqn == null) {
            return null;
        }
        return JavaModelUtil.findType(method.getJavaProject(), fqn);
    }

    private boolean isVariableBindingOk(IVariableBinding vb) throws JavaModelException {
        if (!vb.isField()) {
            return false;
        }
        IField field = Binding2JavaModel.find(vb, this.fInputClass.getJavaProject());
        if (field == null) {
            return false;
        }
        field = (IField)WorkingCopyUtil.getWorkingCopyIfExists((IMember)field);
        return this.fExtractedMemberSet.contains(field);
    }

    private boolean isMethodInvocationOk(MethodInvocation mi, IProgressMonitor pm) throws JavaModelException {
        IBinding miBinding = mi.getName().resolveBinding();
        if (miBinding == null || miBinding.getKind() != 4) {
            return false;
        }
        IMethod method = this.fSuperTypeToUse != null ? Binding2JavaModel.findIncludingSupertypes((IMethodBinding)miBinding, this.fSuperTypeToUse, pm) : Binding2JavaModel.find((IMethodBinding)miBinding, this.fInputClass);
        if (method == null) {
            return false;
        }
        if (!this.fExtractedMemberSet.contains(method = (IMethod)WorkingCopyUtil.getWorkingCopyIfExists((IMember)method))) {
            return false;
        }
        return VisibilityChecker.isVisibleFrom((IMember)method, (ASTNode)mi, this.fASTMappingManager.getCompilationUnit((ASTNode)mi));
    }

    private CompilationUnit getAST(ICompilationUnit cu) {
        return this.fASTMappingManager.getAST(cu);
    }

    private ICompilationUnit getCompilationUnit(ASTNode node) {
        return this.fASTMappingManager.getCompilationUnit(node);
    }

    private static VariableDeclarationFragment[] getVariableDeclarationFragments(VariableDeclarationStatement vds) {
        return vds.fragments().toArray(new VariableDeclarationFragment[vds.fragments().size()]);
    }

    private static VariableDeclarationFragment[] getVariableDeclarationFragments(FieldDeclaration fd) {
        return fd.fragments().toArray(new VariableDeclarationFragment[fd.fragments().size()]);
    }

    private IType findType(ITypeBinding tb) throws JavaModelException {
        if (tb == null) {
            return null;
        }
        IType result = Binding2JavaModel.find(tb, this.fInputClass.getJavaProject());
        if (result == null) {
            return result;
        }
        return (IType)WorkingCopyUtil.getWorkingCopyIfExists((IMember)result);
    }

    private VariableDeclarationFragment getFieldDeclarationFragmentNode(IField field) throws JavaModelException {
        return ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, this.fASTMappingManager);
    }

    private MethodDeclaration getMethodDeclarationNode(IMethod iMethod) throws JavaModelException {
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, this.fASTMappingManager);
    }
}

