/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSupertypeWherePossibleUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class UseSupertypeWherePossibleRefactoring
extends Refactoring {
    private final ASTNodeMappingManager fASTMappingManager;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private IType fInputType;
    private TextChangeManager fChangeManager;
    private IType fSuperTypeToUse;
    private IType[] fSuperTypes;
    private boolean fUseSupertypeInInstanceOf;

    public UseSupertypeWherePossibleRefactoring(IType clazz, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(clazz);
        Assert.isNotNull(codeGenerationSettings);
        this.fInputType = clazz;
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fASTMappingManager = new ASTNodeMappingManager();
        this.fUseSupertypeInInstanceOf = false;
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public void setUseSupertypeInInstanceOf(boolean use) {
        this.fUseSupertypeInInstanceOf = use;
    }

    public boolean getUseSupertypeInInstanceOf() {
        return this.fUseSupertypeInInstanceOf;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fInputType);
        if (result.hasFatalError()) {
            return result;
        }
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fInputType);
        if (orig == null || !orig.exists()) {
            String[] keys = new String[]{this.fInputType.getCompilationUnit().getElementName()};
            String message = RefactoringCoreMessages.getFormattedString("UseSupertypeWherePossibleRefactoring.deleted", keys);
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fInputType = orig;
        this.fSuperTypes = this.getSuperTypes(pm);
        if (Checks.isException(this.fInputType, pm)) {
            String message = RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.unavailable_on_Throwable");
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        return Checks.checkIfCuBroken((IMember)this.fInputType);
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    private IType[] getSuperTypes(IProgressMonitor pm) throws JavaModelException {
        return JavaModelUtil.getAllSuperTypes(this.fInputType, pm);
    }

    public IType[] getSuperTypes() throws JavaModelException {
        return this.fSuperTypes;
    }

    public void setSuperTypeToUse(IType superType) {
        Assert.isNotNull(superType);
        this.fSuperTypeToUse = superType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            try {
                RefactoringStatus result = new RefactoringStatus();
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                result.merge(this.validateModifiesFiles());
                refactoringStatus = result;
                Object var3_6 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            pm.beginTask("", 1);
            CompositeChange builder = new CompositeChange(RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.name"));
            builder.addAll(this.fChangeManager.getAllChanges());
            compositeChange = builder;
            Object var3_4 = null;
            this.clearIntermediateState();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.clearIntermediateState();
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.name");
    }

    private void clearIntermediateState() {
        this.fASTMappingManager.clear();
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 1);
            pm.setTaskName(RefactoringCoreMessages.getString("UseSupertypeWherePossibleRefactoring.analyzing..."));
            TextChangeManager manager = new TextChangeManager();
            this.updateReferences(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void updateReferences(TextChangeManager manager, IProgressMonitor pm) throws JavaModelException, CoreException {
        pm.beginTask("", 2);
        try {
            IMember[] members = UseSupertypeWherePossibleRefactoring.getAllDeclaredAndInheritedMembers(this.fSuperTypeToUse, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            String superTypeName = this.fSuperTypeToUse.getElementName();
            UseSupertypeWherePossibleUtil.updateReferences(manager, members, superTypeName, this.fInputType, this.fCodeGenerationSettings, this.fASTMappingManager, (IProgressMonitor)new SubProgressMonitor(pm, 1), this.fSuperTypeToUse, this.fUseSupertypeInInstanceOf);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            pm.done();
            throw throwable;
        }
        Object var5_7 = null;
        pm.done();
    }

    private static IMember[] getAllDeclaredAndInheritedMembers(IType type, IProgressMonitor pm) throws JavaModelException {
        HashSet result = new HashSet();
        IType[] allClasses = type.newSupertypeHierarchy(pm).getAllSupertypes(type);
        int i = 0;
        while (i < allClasses.length) {
            result.addAll(UseSupertypeWherePossibleRefactoring.getMembers(allClasses[i]));
            ++i;
        }
        result.addAll(UseSupertypeWherePossibleRefactoring.getMembers(type));
        result.addAll(UseSupertypeWherePossibleRefactoring.getMembers(UseSupertypeWherePossibleRefactoring.getObject(type.getJavaProject())));
        return result.toArray(new IMember[result.size()]);
    }

    private static List getMembers(IType type) throws JavaModelException {
        IJavaElement[] allChildren = type.getChildren();
        ArrayList<IMember> result = new ArrayList<IMember>(allChildren.length);
        int i = 0;
        while (i < allChildren.length) {
            if (allChildren[i] instanceof IMember && !(allChildren[i] instanceof IInitializer)) {
                IMember member = (IMember)allChildren[i];
                if (!(allChildren[i] instanceof IMethod) || !((IMethod)member).isConstructor()) {
                    result.add(member);
                }
            }
            ++i;
        }
        return result;
    }

    private static IType getObject(IJavaProject jProject) throws JavaModelException {
        return jProject.findType("java.lang.Object");
    }
}

