/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;

class TypeReferenceFinder {
    TypeReferenceFinder() {
    }

    public static ISourceRange[] findTypeReferenceRanges(SearchResult[] searchResults, ICompilationUnit cu) throws JavaModelException {
        Assert.isNotNull(searchResults);
        if (searchResults.length == 0) {
            return new ISourceRange[0];
        }
        TypeReferenceFinderVisitor visitor = new TypeReferenceFinderVisitor(searchResults);
        AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)false).accept((ASTVisitor)visitor);
        return visitor.getFoundRanges();
    }

    private static class TypeReferenceFinderVisitor
    extends ASTVisitor {
        private Collection fFoundRanges;
        private SearchResult[] fSearchResults;

        TypeReferenceFinderVisitor(SearchResult[] searchResults) {
            this.fSearchResults = searchResults;
            this.fFoundRanges = new ArrayList(0);
        }

        ISourceRange[] getFoundRanges() {
            return this.fFoundRanges.toArray(new ISourceRange[this.fFoundRanges.size()]);
        }

        private static boolean areReportedForSameNode(ASTNode node, SearchResult searchResult) {
            if (node.getStartPosition() != searchResult.getStart()) {
                return false;
            }
            return ASTNodes.getExclusiveEnd(node) >= searchResult.getEnd();
        }

        private boolean isReported(ASTNode node) {
            int i = 0;
            while (i < this.fSearchResults.length) {
                if (TypeReferenceFinderVisitor.areReportedForSameNode(node, this.fSearchResults[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean visit(SimpleName node) {
            if (!this.isReported((ASTNode)node)) {
                return true;
            }
            this.fFoundRanges.add(new SourceRange((ASTNode)node));
            return false;
        }
    }
}

