/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Binding2JavaModel;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTRewriteManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportEditManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

public class PullUpRefactoring
extends Refactoring {
    private IMember[] fMembersToPullUp;
    private IMethod[] fMethodsToDeclareAbstract;
    private IMethod[] fMethodsToDelete;
    private TextChangeManager fChangeManager;
    private IType fTargetType;
    private boolean fCreateMethodStubs;
    private final ASTNodeMappingManager fAstManager;
    private final ASTRewriteManager fRewriteManager;
    private final ImportEditManager fImportEditManager;
    private final CodeGenerationSettings fPreferenceSettings;
    private IType fCachedDeclaringType;
    private IType[] fTypesReferencedInPulledUpMembers;
    private ITypeHierarchy fCachedTargetClassHierarchy;
    private Set fCachedSkippedSuperclasses;
    static /* synthetic */ Class class$0;

    public PullUpRefactoring(IMember[] elements, CodeGenerationSettings preferenceSettings) {
        Assert.isTrue(elements.length > 0);
        Assert.isNotNull(preferenceSettings);
        this.fMembersToPullUp = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])elements);
        this.fMethodsToDelete = new IMethod[0];
        this.fMethodsToDeclareAbstract = new IMethod[0];
        this.fPreferenceSettings = preferenceSettings;
        this.fAstManager = new ASTNodeMappingManager();
        this.fRewriteManager = new ASTRewriteManager(this.fAstManager);
        this.fImportEditManager = new ImportEditManager(preferenceSettings);
        this.fCreateMethodStubs = true;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("PullUpRefactoring.Pull_Up");
    }

    public void setMethodsToDelete(IMethod[] methodsToDelete) {
        Assert.isNotNull(methodsToDelete);
        this.fMethodsToDelete = PullUpRefactoring.getOriginals(methodsToDelete);
    }

    public void setMethodsToDeclareAbstract(IMethod[] methods) {
        Assert.isNotNull(methods);
        this.fMethodsToDeclareAbstract = PullUpRefactoring.getOriginals(methods);
    }

    public void setMembersToPullUp(IMember[] elements) {
        Assert.isNotNull(elements);
        this.fMembersToPullUp = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])elements);
        this.fMembersToPullUp = WorkingCopyUtil.getOriginals(this.fMembersToPullUp);
    }

    private IMember[] getMembersToDelete(IProgressMonitor pm) throws JavaModelException {
        IMember[] iMemberArray;
        try {
            IMember[] typesToDelete = WorkingCopyUtil.getOriginals(PullUpRefactoring.getMembersOfType(this.fMembersToPullUp, 7));
            IMember[] matchingElements = this.getMatchingElements(pm, false);
            IMember[] matchingFields = WorkingCopyUtil.getOriginals(PullUpRefactoring.getMembersOfType(matchingElements, 8));
            iMemberArray = PullUpRefactoring.merge(matchingFields, typesToDelete, (IMember[])this.fMethodsToDelete);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMemberArray;
    }

    public void setCreateMethodStubs(boolean create) {
        this.fCreateMethodStubs = create;
    }

    public boolean getCreateMethodStubs() {
        return this.fCreateMethodStubs;
    }

    public IMember[] getMembersToPullUp() {
        return this.fMembersToPullUp;
    }

    public IType getDeclaringType() {
        if (this.fCachedDeclaringType != null) {
            return this.fCachedDeclaringType;
        }
        this.fCachedDeclaringType = (IType)WorkingCopyUtil.getOriginal((IMember)this.fMembersToPullUp[0].getDeclaringType());
        return this.fCachedDeclaringType;
    }

    public IMember[] getPullableMembersOfDeclaringType() {
        try {
            ArrayList list = new ArrayList(3);
            this.addAllPullable((IMember[])this.getDeclaringType().getFields(), list);
            this.addAllPullable((IMember[])this.getDeclaringType().getMethods(), list);
            this.addAllPullable((IMember[])this.getDeclaringType().getTypes(), list);
            return list.toArray(new IMember[list.size()]);
        }
        catch (JavaModelException javaModelException) {
            return new IMember[0];
        }
    }

    private void addAllPullable(IMember[] members, List list) throws JavaModelException {
        int i = 0;
        while (i < members.length) {
            if (PullUpRefactoring.isPullable(members[i])) {
                list.add(members[i]);
            }
            ++i;
        }
    }

    private static boolean isPullable(IMember member) throws JavaModelException {
        return PullUpRefactoring.checkElement(member).isOK();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITypeHierarchy getTypeHierarchyOfTargetClass(IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy iTypeHierarchy;
        block4: {
            ITypeHierarchy iTypeHierarchy2;
            block3: {
                try {
                    if (this.fCachedTargetClassHierarchy != null) {
                        iTypeHierarchy2 = this.fCachedTargetClassHierarchy;
                        Object var2_4 = null;
                        break block3;
                    }
                    iTypeHierarchy = this.fCachedTargetClassHierarchy = this.getTargetClass().newTypeHierarchy(pm);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var2_6 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return iTypeHierarchy2;
        }
        Object var2_5 = null;
        pm.done();
        return iTypeHierarchy;
    }

    public IType[] getPossibleTargetClasses(IProgressMonitor pm) throws JavaModelException {
        IType[] superClasses = this.getDeclaringType().newSupertypeHierarchy(pm).getAllSuperclasses(this.getDeclaringType());
        ArrayList<IType> superClassList = new ArrayList<IType>(superClasses.length);
        int i = 0;
        while (i < superClasses.length) {
            if (this.isPossibleTargetClass(superClasses[i])) {
                superClassList.add(superClasses[i]);
            }
            ++i;
        }
        Collections.reverse(superClassList);
        return superClassList.toArray(new IType[superClassList.size()]);
    }

    private boolean isPossibleTargetClass(IType clazz) {
        return clazz != null && clazz.exists() && !clazz.isReadOnly() && !clazz.isBinary() && !"java.lang.Object".equals(clazz.getFullyQualifiedName());
    }

    public IType getTargetClass() {
        return this.fTargetType;
    }

    public void setTargetClass(IType targetType) {
        Assert.isNotNull(targetType);
        if (!targetType.equals(this.fTargetType)) {
            this.fCachedTargetClassHierarchy = null;
        }
        this.fTargetType = targetType;
    }

    public IMember[] getMatchingElements(IProgressMonitor pm, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        IMember[] iMemberArray;
        try {
            HashSet result = new HashSet();
            IType targetClass = this.getTargetClass();
            Map matching = this.getMatchingMemberMatching(pm, includeMethodsToDeclareAbstract);
            Iterator iter = matching.keySet().iterator();
            while (iter.hasNext()) {
                IMember key = (IMember)iter.next();
                if (key.getDeclaringType().equals(targetClass)) {
                    iter.remove();
                    continue;
                }
                result.addAll((Set)matching.get(key));
            }
            iMemberArray = result.toArray(new IMember[result.size()]);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMemberArray;
    }

    public IMember[] getAdditionalRequiredMembersToPullUp(IProgressMonitor pm) throws JavaModelException {
        IMember current;
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.calculating_required"), members.length);
        ArrayList<IMember> queue = new ArrayList<IMember>(members.length);
        queue.addAll(Arrays.asList(members));
        if (queue.isEmpty()) {
            return new IMember[0];
        }
        int i = 0;
        do {
            current = (IMember)queue.get(i);
            this.addAllRequiredPullableMembers(queue, current, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (queue.size() != ++i) continue;
            current = null;
        } while (current != null);
        queue.removeAll(Arrays.asList(members));
        return queue.toArray(new IMember[queue.size()]);
    }

    private void addAllRequiredPullableMembers(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        this.addAllRequiredPullableMethods(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addAllRequiredPullableFields(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addAllRequiredPullableTypes(queue, member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }

    private void addAllRequiredPullableTypes(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        IType[] requiredTypes = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{member}, pm);
        boolean isStatic = JdtFlags.isStatic(member);
        int i = 0;
        while (i < requiredTypes.length) {
            IType requiredType = requiredTypes[i];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredType)) && this.isRequiredPullableMember(queue, (IMember)requiredType)) {
                queue.add(requiredType);
            }
            ++i;
        }
    }

    private void addAllRequiredPullableFields(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        IField[] requiredFields = ReferenceFinderUtil.getFieldsReferencedIn(new IJavaElement[]{member}, pm);
        boolean isStatic = JdtFlags.isStatic(member);
        int i = 0;
        while (i < requiredFields.length) {
            IField requiredField = requiredFields[i];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredField)) && this.isRequiredPullableMember(queue, (IMember)requiredField)) {
                queue.add(requiredField);
            }
            ++i;
        }
    }

    private void addAllRequiredPullableMethods(List queue, IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        IMethod[] requiredMethods = ReferenceFinderUtil.getMethodsReferencedIn(new IJavaElement[]{member}, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        SubProgressMonitor sPm = new SubProgressMonitor(pm, 1);
        sPm.beginTask("", requiredMethods.length);
        boolean isStatic = JdtFlags.isStatic(member);
        int i = 0;
        while (i < requiredMethods.length) {
            IMethod requiredMethod = requiredMethods[i];
            if ((!isStatic || JdtFlags.isStatic((IMember)requiredMethod)) && this.isRequiredPullableMember(queue, (IMember)requiredMethod) && !this.isVirtualAccessibleFromTargetClass(requiredMethod, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sPm, 1))) {
                queue.add(requiredMethod);
            }
            ++i;
        }
        sPm.done();
    }

    private boolean isVirtualAccessibleFromTargetClass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        try {
            bl = MethodChecks.isVirtual(method) && this.isDeclaredInTargetClassOrItsSuperclass(method, pm);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDeclaredInTargetClassOrItsSuperclass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        boolean bl;
        block4: {
            block3: {
                try {
                    boolean isConstructor = false;
                    String[] paramTypes = method.getParameterTypes();
                    String name = method.getElementName();
                    IType targetClass = this.getTargetClass();
                    ITypeHierarchy hierarchy = this.getTypeHierarchyOfTargetClass(pm);
                    IMethod first = JavaModelUtil.findMethod(name, paramTypes, isConstructor, targetClass);
                    if (first != null && MethodChecks.isVirtual(first)) {
                        Object var10_9 = null;
                        break block3;
                    }
                    IMethod found = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, targetClass, name, paramTypes, isConstructor);
                    bl = found != null && MethodChecks.isVirtual(found);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return true;
        }
        Object var10_10 = null;
        pm.done();
        return bl;
    }

    private boolean isRequiredPullableMember(List queue, IMember member) throws JavaModelException {
        if (member.getDeclaringType() == null) {
            return false;
        }
        return member.getDeclaringType().equals(this.getDeclaringType()) && !queue.contains(member) && PullUpRefactoring.isPullable(member);
    }

    private static void addToMapping(Map mapping, IMember key, IMember matchingMember) {
        Set<IMember> matchingSet;
        if (mapping.containsKey(key)) {
            matchingSet = (Set)mapping.get(key);
        } else {
            matchingSet = new HashSet();
            mapping.put(key, matchingSet);
        }
        Assert.isTrue(!matchingSet.contains(matchingMember));
        matchingSet.add(matchingMember);
    }

    private Map getMatchingMembersMappingFromTypeAndAllSubtypes(ITypeHierarchy hierarchy, IType type, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        HashMap result = new HashMap();
        result.putAll(this.getMatchingMembersMapping(hierarchy, type));
        IType[] subTypes = hierarchy.getAllSubtypes(type);
        int i = 0;
        while (i < subTypes.length) {
            PullUpRefactoring.mergeSets(result, this.getMatchingMembersMapping(hierarchy, subTypes[i]));
            ++i;
        }
        if (includeMethodsToDeclareAbstract) {
            return result;
        }
        i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            if (result.containsKey(this.fMethodsToDeclareAbstract[i])) {
                result.remove(this.fMethodsToDeclareAbstract[i]);
            }
            ++i;
        }
        return result;
    }

    private static void mergeSets(Map result, Map map) {
        PullUpRefactoring.mergeSetsForCommonKeys(result, map);
        PullUpRefactoring.putAllThatDoNotExistInResultYet(result, map);
    }

    private static void mergeSetsForCommonKeys(Map result, Map map) {
        Iterator iter = result.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (!map.containsKey(key)) continue;
            Set resultSet = (Set)result.get(key);
            Set mapSet = (Set)map.get(key);
            resultSet.addAll(mapSet);
        }
    }

    private static void putAllThatDoNotExistInResultYet(Map result, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            IMember key = (IMember)iter.next();
            if (result.containsKey(key)) continue;
            Set mapSet = (Set)map.get(key);
            HashSet resultSet = new HashSet(mapSet);
            result.put(key, resultSet);
        }
    }

    private Map getMatchingMembersMapping(ITypeHierarchy hierarchy, IType analyzedType) throws JavaModelException {
        HashMap result = new HashMap();
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        int i = 0;
        while (i < members.length) {
            IMethod found;
            IMember member = members[i];
            if (member instanceof IMethod) {
                IMethod method = (IMethod)member;
                found = MemberCheckUtil.findMethod(method, analyzedType.getMethods());
                if (found != null) {
                    PullUpRefactoring.addToMapping(result, (IMember)method, (IMember)found);
                }
            } else if (member instanceof IField) {
                IField field = (IField)member;
                found = analyzedType.getField(field.getElementName());
                if (found.exists()) {
                    PullUpRefactoring.addToMapping(result, (IMember)field, (IMember)found);
                }
            } else if (member instanceof IType) {
                IType type = (IType)member;
                found = type.getField(type.getElementName());
                if (found.exists()) {
                    PullUpRefactoring.addToMapping(result, (IMember)type, (IMember)found);
                }
            } else {
                Assert.isTrue(false);
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus precheck = this.precheckAllElements();
        if (precheck.hasFatalError()) {
            return precheck;
        }
        if (!this.haveCommonDeclaringType()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.same_declaring_type"));
        }
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block8: {
            RefactoringStatus refactoringStatus2;
            block7: {
                RefactoringStatus refactoringStatus3;
                block6: {
                    RefactoringStatus refactoringStatus4;
                    block5: {
                        try {
                            pm.beginTask("", 3);
                            RefactoringStatus result = new RefactoringStatus();
                            result.merge(this.checkAllElements());
                            if (result.hasFatalError()) {
                                refactoringStatus4 = result;
                                Object var3_7 = null;
                                break block5;
                            }
                            this.fMembersToPullUp = WorkingCopyUtil.getOriginals(this.fMembersToPullUp);
                            result.merge(this.checkDeclaringType((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                            if (result.hasFatalError()) {
                                refactoringStatus3 = result;
                                break block6;
                            }
                            result.merge(this.checkIfMembersExist());
                            if (result.hasFatalError()) {
                                refactoringStatus2 = result;
                                break block7;
                            }
                            result.merge(this.checkMultiDeclarationOfFields());
                            refactoringStatus = result;
                            break block8;
                        }
                        catch (Throwable throwable) {
                            Object var3_11 = null;
                            pm.done();
                            throw throwable;
                        }
                    }
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_8 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_9 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_10 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkIfMembersExist() {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IMember orig = this.fMembersToPullUp[i];
            if (orig == null || !orig.exists()) {
                String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.does_not_exist", orig.getElementName());
                result.addFatalError(message);
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkMultiDeclarationOfFields() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IField field;
            IMember member = this.fMembersToPullUp[i];
            if (member.getElementType() == 8 && this.isPartOfMultiDeclaration(field = (IField)member)) {
                Context context = JavaSourceContext.create(member);
                String[] keys = new String[]{PullUpRefactoring.createFieldLabel(field)};
                String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.multi_declaration", keys);
                result.addFatalError(msg, context);
            }
            ++i;
        }
        return result;
    }

    private boolean isPartOfMultiDeclaration(IField iField) throws JavaModelException {
        FieldDeclaration fieldDeclaration;
        Selection selection = Selection.createFromStartLength(iField.getNameRange().getOffset(), iField.getNameRange().getLength());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, true);
        this.fAstManager.getAST(iField.getCompilationUnit()).accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        if (selected == null) {
            selected = analyzer.getLastCoveringNode();
        }
        if (selected == null) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((fieldDeclaration = (FieldDeclaration)ASTNodes.getParent(selected, clazz)) == null) {
            return false;
        }
        return fieldDeclaration.fragments().size() != 1;
    }

    private static IMethod[] getOriginals(IMethod[] methods) {
        IMethod[] result = new IMethod[methods.length];
        int i = 0;
        while (i < methods.length) {
            result[i] = (IMethod)WorkingCopyUtil.getOriginal((IMember)methods[i]);
            ++i;
        }
        return result;
    }

    private static IMember[] merge(IMember[] a1, IMember[] a2, IMember[] a3) {
        return JavaElementUtil.merge(JavaElementUtil.merge(a1, a2), a3);
    }

    private static IMember[] getMembersOfType(IMember[] members, int type) {
        List<IJavaElement> list = Arrays.asList(JavaElementUtil.getElementsOfType((IJavaElement[])members, type));
        return list.toArray(new IMember[list.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block9: {
            RefactoringStatus refactoringStatus2;
            block8: {
                try {
                    try {
                        pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.preview"), 7);
                        this.clearManagers();
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(this.checkFinalFields((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        result.merge(this.checkAccesses((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        result.merge(this.checkMembersInDestinationType());
                        pm.worked(1);
                        result.merge(this.checkMembersInSubclasses((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        result.merge(this.checkIfSkippingOverElements((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        if (this.shouldMakeTargetClassAbstract()) {
                            result.merge(this.checkCallsToTargetClassConstructors((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        } else {
                            pm.worked(1);
                        }
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            Object var3_7 = null;
                            break block8;
                        }
                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        result.merge(this.validateModifiesFiles());
                        refactoringStatus = result;
                        break block9;
                    }
                    catch (JavaModelException e) {
                        throw e;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkMembersInDestinationType() throws JavaModelException {
        IMember[] membersToBeCreatedInTargetClass = this.getMembersToBeCreatedInTargetClass();
        ArrayList<IMember> newMembersInDesitnationType = new ArrayList<IMember>(membersToBeCreatedInTargetClass.length);
        newMembersInDesitnationType.addAll(Arrays.asList(membersToBeCreatedInTargetClass));
        newMembersInDesitnationType.removeAll(Arrays.asList(this.fMethodsToDelete));
        IMember[] members = newMembersInDesitnationType.toArray(new IMember[newMembersInDesitnationType.size()]);
        return MemberCheckUtil.checkMembersInDestinationType(members, this.getTargetClass());
    }

    private void clearManagers() {
        this.fAstManager.clear();
        this.fImportEditManager.clear();
        this.fRewriteManager.clear();
    }

    private RefactoringStatus checkCallsToTargetClassConstructors(IProgressMonitor pm) throws JavaModelException {
        ASTNode[] refNodes = ConstructorReferenceFinder.getConstructorReferenceNodes(this.getTargetClass(), this.fAstManager, pm);
        RefactoringStatus result = new RefactoringStatus();
        String[] keys = new String[]{PullUpRefactoring.createTypeLabel(this.getTargetClass())};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.gets_instantiated", keys);
        int i = 0;
        while (i < refNodes.length) {
            ASTNode node = refNodes[i];
            if (node instanceof ClassInstanceCreation) {
                Context context = JavaSourceContext.create(this.fAstManager.getCompilationUnit(node), node);
                result.addError(msg, context);
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkIfSkippingOverElements(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            Set skippedSuperclassSet = this.getSkippedSuperclasses((IProgressMonitor)new SubProgressMonitor(pm, 1));
            IType[] skippedSuperclasses = skippedSuperclassSet.toArray(new IType[skippedSuperclassSet.size()]);
            RefactoringStatus result = new RefactoringStatus();
            int i = 0;
            while (i < this.fMembersToPullUp.length) {
                IMember element = this.fMembersToPullUp[i];
                int j = 0;
                while (j < skippedSuperclasses.length) {
                    result.merge(this.checkIfDeclaredIn(element, skippedSuperclasses[j]));
                    ++j;
                }
                ++i;
            }
            refactoringStatus = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkIfDeclaredIn(IMember element, IType type) throws JavaModelException {
        if (element instanceof IMethod) {
            return this.checkIfMethodDeclaredIn((IMethod)element, type);
        }
        if (element instanceof IField) {
            return this.checkIfFieldDeclaredIn((IField)element, type);
        }
        if (element instanceof IType) {
            return this.checkIfTypeDeclaredIn((IType)element, type);
        }
        Assert.isTrue(false);
        return null;
    }

    private RefactoringStatus checkIfTypeDeclaredIn(IType iType, IType type) {
        IType typeInType = type.getType(iType.getElementName());
        if (!typeInType.exists()) {
            return null;
        }
        String[] keys = new String[]{PullUpRefactoring.createTypeLabel(typeInType), PullUpRefactoring.createTypeLabel(type)};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.Type_declared_in_class", keys);
        Context context = JavaSourceContext.create((IMember)typeInType);
        return RefactoringStatus.createWarningStatus(msg, context);
    }

    private RefactoringStatus checkIfFieldDeclaredIn(IField iField, IType type) {
        IField fieldInType = type.getField(iField.getElementName());
        if (!fieldInType.exists()) {
            return null;
        }
        String[] keys = new String[]{PullUpRefactoring.createFieldLabel(fieldInType), PullUpRefactoring.createTypeLabel(type)};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.Field_declared_in_class", keys);
        Context context = JavaSourceContext.create((IMember)fieldInType);
        return RefactoringStatus.createWarningStatus(msg, context);
    }

    private RefactoringStatus checkIfMethodDeclaredIn(IMethod iMethod, IType type) throws JavaModelException {
        IMethod methodInType = JavaModelUtil.findMethod(iMethod.getElementName(), iMethod.getParameterTypes(), iMethod.isConstructor(), type);
        if (methodInType == null || !methodInType.exists()) {
            return null;
        }
        String[] keys = new String[]{PullUpRefactoring.createMethodLabel(methodInType), PullUpRefactoring.createTypeLabel(type)};
        String msg = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.methodis_declared_in_class", keys);
        Context context = JavaSourceContext.create((IMember)methodInType);
        return RefactoringStatus.createWarningStatus(msg, context);
    }

    private static String createTypeLabel(IType type) {
        return JavaModelUtil.getFullyQualifiedName(type);
    }

    private static String createFieldLabel(IField field) {
        return field.getElementName();
    }

    private static String createMethodLabel(IMethod method) {
        return JavaElementUtil.createMethodSignature(method);
    }

    private RefactoringStatus precheckAllElements() throws JavaModelException {
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            RefactoringStatus status = PullUpRefactoring.precheckElement(this.fMembersToPullUp[i]);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkAllElements() throws JavaModelException {
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            RefactoringStatus status = PullUpRefactoring.checkElement(this.fMembersToPullUp[i]);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return new RefactoringStatus();
    }

    private static RefactoringStatus precheckElement(IMember member) throws JavaModelException {
        if (member.getElementType() != 9 && member.getElementType() != 8 && member.getElementType() != 7) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.only_fields_and_methods"));
        }
        if (!member.exists()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.elements_do_not_exist"));
        }
        if (member.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_binary_elements"));
        }
        if (member.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_read_only_elements"));
        }
        if (!member.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_unknown_structure"));
        }
        return new RefactoringStatus();
    }

    private static RefactoringStatus checkElement(IMember member) throws JavaModelException {
        RefactoringStatus precheck = PullUpRefactoring.precheckElement(member);
        if (precheck.hasFatalError()) {
            return precheck;
        }
        if (member instanceof IType && !JdtFlags.isStatic(member)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.only_static_types"));
        }
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            if (method.isConstructor()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_constructors"));
            }
            if (JdtFlags.isNative((IMember)method)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_native_methods"));
            }
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkDeclaringType(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        IType declaringType = this.getDeclaringType();
        if (declaringType.isInterface()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_interface_members"));
        }
        if (JavaModelUtil.getFullyQualifiedName(declaringType).equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_java.lang.Object"));
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_binary_types"));
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.no_read_only_types"));
        }
        return this.checkSuperclassesOfDeclaringClass(pm);
    }

    private RefactoringStatus checkSuperclassesOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        if (this.getPossibleTargetClasses(pm).length == 0) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("PullUpRefactoring.not_this_type"));
        }
        return new RefactoringStatus();
    }

    private boolean haveCommonDeclaringType() {
        IType declaringType = this.fMembersToPullUp[0].getDeclaringType();
        if (declaringType == null) {
            return false;
        }
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            if (!declaringType.equals(this.fMembersToPullUp[i].getDeclaringType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkFinalFields(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", this.fMembersToPullUp.length);
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IMember member = this.fMembersToPullUp[i];
            if (member.getElementType() == 8 && !JdtFlags.isStatic(member) && JdtFlags.isFinal(member)) {
                Context context = JavaSourceContext.create(member);
                result.addWarning(RefactoringCoreMessages.getString("PullUpRefactoring.final_fields"), context);
            }
            pm.worked(1);
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccesses(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.checking_referenced_elements"), 3);
        result.merge(this.checkAccessedTypes((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFields((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedTypes(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = this.getTypeReferencedInPulledUpMembers(pm);
        IType targetClass = this.getTargetClass();
        int i = 0;
        while (i < accessedTypes.length) {
            IType iType = accessedTypes[i];
            if (iType.exists() && !this.canBeAccessedFrom((IMember)iType, targetClass)) {
                String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.type_not_accessible", new String[]{PullUpRefactoring.createTypeLabel(iType), PullUpRefactoring.createTypeLabel(targetClass)});
                result.addError(message, JavaSourceContext.create((IMember)iType));
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedFields(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToPullUp);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembersToPullUp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IType targetClass = this.getTargetClass();
        int i = 0;
        while (i < accessedFields.length) {
            IField field = accessedFields[i];
            if (field.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(field) || deletedList.contains(field) || this.canBeAccessedFrom((IMember)field, targetClass);
                if (!isAccessible) {
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.field_not_accessible", new String[]{PullUpRefactoring.createFieldLabel(field), PullUpRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaSourceContext.create((IMember)field));
                } else if (this.isDeclaredInSkippedSuperclass((IMember)field, (IProgressMonitor)new NullProgressMonitor())) {
                    String[] keys = new String[]{PullUpRefactoring.createFieldLabel(field), PullUpRefactoring.createTypeLabel(targetClass)};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.field_cannot_be_accessed", keys);
                    result.addError(message, JavaSourceContext.create((IMember)field));
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethods(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        RefactoringStatus result = new RefactoringStatus();
        List<IMember> pulledUpList = Arrays.asList(this.fMembersToPullUp);
        List<IMethod> declaredAbstractList = Arrays.asList(this.fMethodsToDeclareAbstract);
        List<IMember> deletedList = Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembersToPullUp, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        IType targetClass = this.getTargetClass();
        int i = 0;
        while (i < accessedMethods.length) {
            IMethod method = accessedMethods[i];
            if (method.exists()) {
                boolean isAccessible;
                boolean bl = isAccessible = pulledUpList.contains(method) || deletedList.contains(method) || declaredAbstractList.contains(method) || this.canBeAccessedFrom((IMember)method, targetClass);
                if (!isAccessible) {
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.method_not_accessible", new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(targetClass)});
                    result.addError(message, JavaSourceContext.create((IMember)method));
                } else if (this.isDeclaredInSkippedSuperclass((IMember)method, (IProgressMonitor)new NullProgressMonitor())) {
                    String[] keys = new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(targetClass)};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.method_cannot_be_accessed", keys);
                    result.addError(message, JavaSourceContext.create((IMember)method));
                }
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private boolean isDeclaredInSkippedSuperclass(IMember member, IProgressMonitor pm) throws JavaModelException {
        return this.getSkippedSuperclasses(pm).contains(member.getDeclaringType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set getSkippedSuperclasses(IProgressMonitor pm) throws JavaModelException {
        Set set;
        block6: {
            Set set2;
            block5: {
                pm.beginTask("", 1);
                try {
                    if (this.fCachedSkippedSuperclasses != null) {
                        set2 = this.fCachedSkippedSuperclasses;
                        Object var4_4 = null;
                        break block5;
                    }
                    ITypeHierarchy hierarchy = this.getTypeHierarchyOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    this.fCachedSkippedSuperclasses = new HashSet(2);
                    IType current = hierarchy.getSuperclass(this.getDeclaringType());
                    while (true) {
                        if (current == null || current.equals(this.getTargetClass())) {
                            set = this.fCachedSkippedSuperclasses;
                            break block6;
                        }
                        this.fCachedSkippedSuperclasses.add(current);
                        current = hierarchy.getSuperclass(current);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return set2;
        }
        Object var4_5 = null;
        pm.done();
        return set;
    }

    private boolean canBeAccessedFrom(IMember member, IType newHome) throws JavaModelException {
        Assert.isTrue(!(member instanceof IInitializer));
        if (!member.exists()) {
            return false;
        }
        if (newHome.equals(member.getDeclaringType())) {
            return true;
        }
        if (newHome.equals(member)) {
            return true;
        }
        if (JdtFlags.isPrivate(member)) {
            return false;
        }
        if (member.getDeclaringType() == null) {
            if (!(member instanceof IType)) {
                return false;
            }
            if (JdtFlags.isPublic(member)) {
                return true;
            }
            if (!JdtFlags.isPackageVisible(member)) {
                return false;
            }
            return ((IType)member).getPackageFragment().equals(newHome.getPackageFragment());
        }
        IType enclosingType = member.getDeclaringType();
        if (!this.canBeAccessedFrom((IMember)enclosingType, newHome)) {
            return false;
        }
        if (enclosingType.equals(this.getDeclaringType())) {
            return false;
        }
        if (JdtFlags.isPublic(member)) {
            return true;
        }
        return enclosingType.getPackageFragment().equals(newHome.getPackageFragment());
    }

    private RefactoringStatus checkMembersInSubclasses(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 3);
        Set notDeletedMembers = this.getNotDeletedMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkAccessModifiers(result, notDeletedMembers);
        this.checkMethodReturnTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), result, notDeletedMembers);
        this.checkFieldTypes((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
        pm.done();
        return result;
    }

    private void checkMethodReturnTypes(IProgressMonitor pm, RefactoringStatus result, Set notDeletedMembers) throws JavaModelException {
        Map mapping = this.getMatchingMemberMatching(pm, true);
        IMember[] members = this.getMembersToBeCreatedInTargetClass();
        int i = 0;
        while (i < members.length) {
            if (members[i].getElementType() == 9) {
                IMethod method = (IMethod)members[i];
                String returnType = PullUpRefactoring.getReturnTypeName(method);
                Assert.isTrue(mapping.containsKey(method));
                Iterator iter = ((Set)mapping.get(method)).iterator();
                while (iter.hasNext()) {
                    IMethod matchingMethod = (IMethod)iter.next();
                    if (method.equals(matchingMethod) || !notDeletedMembers.contains(matchingMethod) || returnType.equals(PullUpRefactoring.getReturnTypeName(matchingMethod))) continue;
                    String[] keys = new String[]{PullUpRefactoring.createMethodLabel(matchingMethod), PullUpRefactoring.createTypeLabel(matchingMethod.getDeclaringType())};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.different_method_return_type", keys);
                    Context context = JavaSourceContext.create(matchingMethod.getCompilationUnit(), matchingMethod.getNameRange());
                    result.addError(message, context);
                }
            }
            ++i;
        }
    }

    private void checkFieldTypes(IProgressMonitor pm, RefactoringStatus result) throws JavaModelException {
        Map mapping = this.getMatchingMemberMatching(pm, true);
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            if (this.fMembersToPullUp[i].getElementType() == 8) {
                IField field = (IField)this.fMembersToPullUp[i];
                String type = PullUpRefactoring.getTypeName(field);
                Assert.isTrue(mapping.containsKey(field));
                Iterator iter = ((Set)mapping.get(field)).iterator();
                while (iter.hasNext()) {
                    IField matchingField = (IField)iter.next();
                    if (field.equals(matchingField) || type.equals(PullUpRefactoring.getTypeName(matchingField))) continue;
                    String[] keys = new String[]{PullUpRefactoring.createFieldLabel(matchingField), PullUpRefactoring.createTypeLabel(matchingField.getDeclaringType())};
                    String message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.different_field_type", keys);
                    Context context = JavaSourceContext.create(matchingField.getCompilationUnit(), matchingField.getSourceRange());
                    result.addError(message, context);
                }
            }
            ++i;
        }
    }

    private Map getMatchingMemberMatching(IProgressMonitor pm, boolean includeMethodsToDeclareAbstract) throws JavaModelException {
        return this.getMatchingMembersMappingFromTypeAndAllSubtypes(this.getTypeHierarchyOfTargetClass(pm), this.getTargetClass(), includeMethodsToDeclareAbstract);
    }

    private void checkAccessModifiers(RefactoringStatus result, Set notDeletedMembers) throws JavaModelException {
        List<IMethod> toDeclareAbstract = Arrays.asList(this.fMethodsToDeclareAbstract);
        Iterator iter = notDeletedMembers.iterator();
        while (iter.hasNext()) {
            IMember member = (IMember)iter.next();
            if (member.getElementType() != 9 || toDeclareAbstract.contains(member)) continue;
            this.checkMethodAccessModifiers(result, (IMethod)member);
        }
    }

    private void checkMethodAccessModifiers(RefactoringStatus result, IMethod method) throws JavaModelException {
        String message;
        String[] keys;
        Context errorContext = JavaSourceContext.create((IMember)method);
        if (JdtFlags.isStatic((IMember)method)) {
            keys = new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(method.getDeclaringType())};
            message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.static_method", keys);
            result.addError(message, errorContext);
        }
        if (PullUpRefactoring.isVisibilityLowerThanProtected((IMember)method)) {
            keys = new String[]{PullUpRefactoring.createMethodLabel(method), PullUpRefactoring.createTypeLabel(method.getDeclaringType())};
            message = RefactoringCoreMessages.getFormattedString("PullUpRefactoring.lower_visibility", keys);
            result.addError(message, errorContext);
        }
    }

    private static String getReturnTypeName(IMethod method) throws JavaModelException {
        return Signature.toString((String)Signature.getReturnType((String)method.getSignature()).toString());
    }

    private static String getTypeName(IField field) throws JavaModelException {
        return Signature.toString((String)field.getTypeSignature());
    }

    private Set getNotDeletedMembers(IProgressMonitor pm) throws JavaModelException {
        HashSet<IMember> matchingSet = new HashSet<IMember>();
        pm.beginTask("", 2);
        matchingSet.addAll(Arrays.asList(this.getMatchingElements((IProgressMonitor)new SubProgressMonitor(pm, 1), true)));
        matchingSet.removeAll(Arrays.asList(this.getMembersToDelete((IProgressMonitor)new SubProgressMonitor(pm, 1))));
        pm.done();
        return matchingSet;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private static boolean isVisibilityLowerThanProtected(IMember member) throws JavaModelException {
        return !JdtFlags.isPublic(member) && !JdtFlags.isProtected(member);
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("PullUpRefactoring.Pull_Up"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearManagers();
            throw throwable;
        }
        pm.done();
        this.clearManagers();
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("PullUpRefactoring.preview"), 4);
            this.copyMembersToTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.needsAddingImportsToTargetCu()) {
                this.addImportsToTargetCu((IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else {
                pm.worked(1);
            }
            this.deleteMembers((IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.shouldMakeTargetClassAbstract()) {
                this.makeTargetClassAbstract();
            }
            if (this.shouldAddMethodStubsToConcreteSubclassesOfTargetClass()) {
                this.addMethodStubsToNonAbstractSubclassesOfTargetClass((IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else {
                pm.worked(1);
            }
            this.createAbstractMethodsInTargetClass();
            this.increaseVisibilityOfMethodsDeclaredAbstract();
            TextChangeManager manager = new TextChangeManager();
            this.fillWithRewriteEdits(manager);
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void increaseVisibilityOfMethodsDeclaredAbstract() throws JavaModelException {
        ASTRewrite rewrite = this.fRewriteManager.getRewrite(this.getDeclaringCu());
        AST ast = PullUpRefactoring.getAST(rewrite);
        int i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            IMethod method = this.fMethodsToDeclareAbstract[i];
            if (PullUpRefactoring.needsToChangeVisibility((IMember)method)) {
                MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(method);
                MethodDeclaration newMethod = ast.newMethodDeclaration();
                newMethod.setExtraDimensions(methodDeclaration.getExtraDimensions());
                newMethod.setConstructor(methodDeclaration.isConstructor());
                newMethod.setModifiers(this.getModifiersWithUpdatedVisibility((IMember)method, methodDeclaration.getModifiers()));
                rewrite.markAsModified((ASTNode)methodDeclaration, (ASTNode)newMethod);
            }
            ++i;
        }
    }

    private void createAbstractMethodsInTargetClass() throws JavaModelException {
        TypeDeclaration targetClass = this.getTypeDeclarationNode(this.getTargetClass());
        ASTRewrite rewrite = this.getRewriteFor((ASTNode)targetClass);
        int i = 0;
        while (i < this.fMethodsToDeclareAbstract.length) {
            IMethod method = this.fMethodsToDeclareAbstract[i];
            this.createAbstractMethodInTargetClass(method, rewrite, targetClass);
            ++i;
        }
    }

    private void createAbstractMethodInTargetClass(IMethod method, ASTRewrite rewrite, TypeDeclaration targetClass) throws JavaModelException {
        MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(method);
        AST ast = PullUpRefactoring.getAST(rewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        newMethod.setBody(null);
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(methodDeclaration.getExtraDimensions());
        newMethod.setJavadoc(null);
        newMethod.setModifiers(this.createModifiersForAbstractDeclaration(method));
        newMethod.setName(PullUpRefactoring.createCopyOfSimpleName(methodDeclaration.getName(), ast));
        this.copyReturnType(rewrite, methodDeclaration, newMethod);
        this.copyParameters(rewrite, methodDeclaration, newMethod);
        this.copyThrownExceptions(methodDeclaration, newMethod);
        targetClass.bodyDeclarations().add(newMethod);
        rewrite.markAsInserted((ASTNode)newMethod);
    }

    private int createModifiersForAbstractDeclaration(IMethod method) throws JavaModelException {
        MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(method);
        int modifiers = 0x400 | ASTNodes.clearFlag(256, ASTNodes.clearFlag(16, methodDeclaration.getModifiers()));
        return this.getModifiersWithUpdatedVisibility((IMember)method, modifiers);
    }

    private int getModifiersWithUpdatedVisibility(IMember member, int modifiers) throws JavaModelException {
        if (PullUpRefactoring.needsToChangeVisibility(member)) {
            return ASTNodes.clearAccessModifiers(modifiers) | 4;
        }
        return modifiers;
    }

    private void addMethodStubsToNonAbstractSubclassesOfTargetClass(IProgressMonitor pm) throws CoreException {
        IType[] concreteSubclasses = this.getNonAbstractSubclassesOfTargetClass(pm);
        IType declaringType = this.getDeclaringType();
        IMethod[] methods = this.getAbstractMethodsAddedToTargetClass();
        IType[] typesToImport = this.getTypesReferencedInDeclarations(methods);
        int i = 0;
        while (i < concreteSubclasses.length) {
            IType clazz = concreteSubclasses[i];
            if (!clazz.equals(declaringType)) {
                boolean anyStubAdded = false;
                int j = 0;
                while (j < methods.length) {
                    IMethod method = methods[j];
                    if (JavaModelUtil.findMethod(method.getElementName(), method.getParameterTypes(), method.isConstructor(), clazz) == null) {
                        this.addStub(clazz, method);
                        anyStubAdded = true;
                    }
                    ++j;
                }
                if (anyStubAdded) {
                    this.addImports(typesToImport, WorkingCopyUtil.getWorkingCopyIfExists(clazz.getCompilationUnit()));
                }
            }
            ++i;
        }
    }

    private void addStub(IType type, IMethod method) throws CoreException {
        TypeDeclaration typeDeclaration = this.getTypeDeclarationNode(type);
        MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(method);
        ASTRewrite rewrite = this.getRewriteFor((ASTNode)typeDeclaration);
        AST ast = PullUpRefactoring.getAST(rewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        newMethod.setBody(this.getMethodStubBody(methodDeclaration, ast));
        newMethod.setConstructor(false);
        newMethod.setExtraDimensions(methodDeclaration.getExtraDimensions());
        newMethod.setModifiers(this.createModifiersForMethodStubs(method));
        newMethod.setName(PullUpRefactoring.createCopyOfSimpleName(methodDeclaration.getName(), ast));
        this.copyReturnType(rewrite, methodDeclaration, newMethod);
        this.copyParameters(rewrite, methodDeclaration, newMethod);
        this.copyThrownExceptions(methodDeclaration, newMethod);
        newMethod.setJavadoc(this.createJavadocForStub(method, typeDeclaration.getName().getIdentifier(), newMethod, rewrite));
        typeDeclaration.bodyDeclarations().add(newMethod);
        rewrite.markAsInserted((ASTNode)newMethod);
    }

    private Block getMethodStubBody(MethodDeclaration method, AST ast) {
        Block body = ast.newBlock();
        Type returnType = method.getReturnType();
        ITypeBinding typeBinding = returnType.resolveBinding();
        if (typeBinding == null) {
            return body;
        }
        Type returnTypeInOurAST = ASTResolving.getTypeFromTypeBinding(ast, typeBinding);
        Expression expression = ASTResolving.getInitExpression(returnTypeInOurAST, method.getExtraDimensions());
        if (expression != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        return body;
    }

    private Javadoc createJavadocForStub(IMethod method, String enclosingTypeName, MethodDeclaration newMethodNode, ASTRewrite rewrite) throws CoreException {
        if (!this.fPreferenceSettings.createComments) {
            return null;
        }
        MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(method);
        IMethodBinding binding = methodDeclaration.resolveBinding();
        if (binding == null) {
            return null;
        }
        ITypeBinding[] params = binding.getParameterTypes();
        String fullTypeName = JavaModelUtil.getFullyQualifiedName(this.getTargetClass());
        String[] fullParamNames = new String[params.length];
        int i = 0;
        while (i < fullParamNames.length) {
            fullParamNames[i] = Bindings.getFullyQualifiedName(params[i]);
            ++i;
        }
        ICompilationUnit cu = this.fAstManager.getCompilationUnit(rewrite.getRootNode());
        String comment = StubUtility.getMethodComment(cu, enclosingTypeName, newMethodNode, true, false, fullTypeName, fullParamNames, String.valueOf('\n'));
        return (Javadoc)rewrite.createPlaceholder(comment, 7);
    }

    private int createModifiersForMethodStubs(IMethod method) throws JavaModelException {
        MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(method);
        int modifiers = ASTNodes.clearFlag(256, ASTNodes.clearFlag(1024, methodDeclaration.getModifiers()));
        return this.getModifiersWithUpdatedVisibility((IMember)method, modifiers);
    }

    private IType[] getNonAbstractSubclassesOfTargetClass(IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy hierarchy = this.getTypeHierarchyOfTargetClass(pm);
        Set nonAbstractSubclasses = PullUpRefactoring.getNonAbstractSubclasses(hierarchy, this.getTargetClass());
        return nonAbstractSubclasses.toArray(new IType[nonAbstractSubclasses.size()]);
    }

    private static Set getNonAbstractSubclasses(ITypeHierarchy hierarchy, IType clazz) throws JavaModelException {
        IType[] subclasses = hierarchy.getSubclasses(clazz);
        HashSet<IType> result = new HashSet<IType>();
        int i = 0;
        while (i < subclasses.length) {
            IType subclass = subclasses[i];
            if (JdtFlags.isAbstract((IMember)subclass)) {
                result.addAll(PullUpRefactoring.getNonAbstractSubclasses(hierarchy, subclass));
            } else {
                result.add(subclass);
            }
            ++i;
        }
        return result;
    }

    private boolean shouldAddMethodStubsToConcreteSubclassesOfTargetClass() throws JavaModelException {
        return this.fCreateMethodStubs && this.getAbstractMethodsAddedToTargetClass().length > 0;
    }

    private void makeTargetClassAbstract() throws JavaModelException {
        TypeDeclaration targetClass = this.getTypeDeclarationNode(this.getTargetClass());
        TypeDeclaration modifiedNode = targetClass.getAST().newTypeDeclaration();
        modifiedNode.setInterface(targetClass.isInterface());
        modifiedNode.setModifiers(targetClass.getModifiers() | 0x400);
        ASTRewrite rewrite = this.getRewriteFor((ASTNode)this.getTypeDeclarationNode(this.getTargetClass()));
        rewrite.markAsModified((ASTNode)targetClass, (ASTNode)modifiedNode);
    }

    private ASTRewrite getRewriteFor(ASTNode node) {
        return this.fRewriteManager.getRewrite(ASTNodeMappingManager.getCompilationUnitNode(node));
    }

    private boolean shouldMakeTargetClassAbstract() throws JavaModelException {
        if (JdtFlags.isAbstract((IMember)this.getTargetClass())) {
            return false;
        }
        return this.getAbstractMethodsAddedToTargetClass().length > 0;
    }

    private IMember[] getMembersToBeCreatedInTargetClass() {
        ArrayList<Object> result = new ArrayList<Object>(this.fMembersToPullUp.length + this.fMethodsToDeclareAbstract.length);
        result.addAll(Arrays.asList(this.fMembersToPullUp));
        result.addAll(Arrays.asList(this.fMethodsToDeclareAbstract));
        return result.toArray(new IMember[result.size()]);
    }

    private IMethod[] getAbstractMethodsAddedToTargetClass() throws JavaModelException {
        IMethod[] toDeclareAbstract = this.fMethodsToDeclareAbstract;
        IMethod[] abstractPulledUp = this.getAbstractMethodsToPullUp();
        ArrayList<IMethod> result = new ArrayList<IMethod>(toDeclareAbstract.length + abstractPulledUp.length);
        result.addAll(Arrays.asList(toDeclareAbstract));
        result.addAll(Arrays.asList(abstractPulledUp));
        return result.toArray(new IMethod[result.size()]);
    }

    private IMethod[] getAbstractMethodsToPullUp() throws JavaModelException {
        ArrayList<IMember> result = new ArrayList<IMember>(this.fMembersToPullUp.length);
        int i = 0;
        while (i < this.fMembersToPullUp.length) {
            IMember member = this.fMembersToPullUp[i];
            if (member instanceof IMethod && JdtFlags.isAbstract(member)) {
                result.add(member);
            }
            ++i;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    private IType getSuperclassOfDeclaringClass(IProgressMonitor pm) throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        return declaringType.newSupertypeHierarchy(pm).getSuperclass(declaringType);
    }

    private void copyMembersToTargetClass(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fMembersToPullUp.length);
        int i = this.fMembersToPullUp.length - 1;
        while (i >= 0) {
            if (this.fMembersToPullUp[i] instanceof IField) {
                this.copyFieldToTargetClass((IField)this.fMembersToPullUp[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else if (this.fMembersToPullUp[i] instanceof IMethod) {
                this.copyMethodToTargetClass((IMethod)this.fMembersToPullUp[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
            } else if (this.fMembersToPullUp[i] instanceof IType) {
                this.copyTypeToTargetClass((IType)this.fMembersToPullUp[i], new SubProgressMonitor(pm, 1));
            } else {
                Assert.isTrue(false);
            }
            --i;
        }
        pm.done();
    }

    private void copyTypeToTargetClass(IType type, SubProgressMonitor monitor) throws JavaModelException {
        ASTRewrite rewrite = this.fRewriteManager.getRewrite(this.getTargetCu());
        TypeDeclaration targetClass = this.getTypeDeclarationNode(this.getTargetClass());
        BodyDeclaration newType = this.createNewTypeDeclarationNode(type, rewrite);
        rewrite.markAsInserted((ASTNode)newType);
        targetClass.bodyDeclarations().add(newType);
    }

    private BodyDeclaration createNewTypeDeclarationNode(IType type, ASTRewrite rewrite) throws JavaModelException {
        TypeDeclaration oldType = this.getTypeDeclarationNode(type);
        return this.createPlaceholderForBodyDeclaration((BodyDeclaration)oldType, rewrite, true);
    }

    private void copyMethodToTargetClass(IMethod method, IProgressMonitor pm) throws JavaModelException {
        ASTRewrite targetRewrite = this.fRewriteManager.getRewrite(this.getTargetCu());
        TypeDeclaration targetClass = this.getTypeDeclarationNode(this.getTargetClass());
        MethodDeclaration newMethod = this.createNewMethodDeclarationNode(method, targetRewrite, pm);
        targetRewrite.markAsInserted((ASTNode)newMethod);
        targetClass.bodyDeclarations().add(newMethod);
    }

    private MethodDeclaration createNewMethodDeclarationNode(IMethod method, ASTRewrite targetRewrite, IProgressMonitor pm) throws JavaModelException {
        MethodDeclaration oldMethod = this.getMethodDeclarationNode(method);
        AST ast = PullUpRefactoring.getAST(targetRewrite);
        MethodDeclaration newMethod = ast.newMethodDeclaration();
        this.copyBodyOfPulledUpMethod(targetRewrite, method, oldMethod, newMethod, pm);
        newMethod.setConstructor(oldMethod.isConstructor());
        newMethod.setExtraDimensions(oldMethod.getExtraDimensions());
        PullUpRefactoring.copyJavadocNode(ast, (BodyDeclaration)oldMethod, (BodyDeclaration)newMethod);
        newMethod.setModifiers(this.getNewModifiers((IMember)method));
        newMethod.setName(PullUpRefactoring.createCopyOfSimpleName(oldMethod.getName(), ast));
        this.copyReturnType(targetRewrite, oldMethod, newMethod);
        this.copyParameters(targetRewrite, oldMethod, newMethod);
        this.copyThrownExceptions(oldMethod, newMethod);
        return newMethod;
    }

    private void copyBodyOfPulledUpMethod(ASTRewrite targetRewrite, IMethod method, MethodDeclaration oldMethod, MethodDeclaration newMethod, IProgressMonitor pm) throws JavaModelException {
        if (oldMethod.getBody() == null) {
            newMethod.setBody(null);
            return;
        }
        Block oldBody = oldMethod.getBody();
        ISourceRange[] superRefOffsert = SourceRange.reverseSortByOffset(PullUpRefactoring.findSuperReferenceRanges(method, this.getSuperclassOfDeclaringClass(pm)));
        String oldBodySource = this.getBufferText((ASTNode)oldBody);
        StringBuffer newBodyCodeBuff = new StringBuffer(oldBodySource);
        int i = 0;
        while (i < superRefOffsert.length) {
            ISourceRange range = superRefOffsert[i];
            int start = range.getOffset() - oldBody.getStartPosition();
            int end = start + range.getLength();
            newBodyCodeBuff.replace(start, end, "this");
            ++i;
        }
        String newBodySource = newBodyCodeBuff.toString();
        String[] lines = Strings.convertIntoLines(newBodySource);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        newBodySource = Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)method));
        Block newBody = (Block)targetRewrite.createPlaceholder(newBodySource, 2);
        newMethod.setBody(newBody);
    }

    private static ISourceRange[] findSuperReferenceRanges(IMethod method, IType superType) throws JavaModelException {
        Assert.isNotNull(method);
        if (JdtFlags.isStatic((IMember)method)) {
            return new ISourceRange[0];
        }
        SuperReferenceFinderVisitor visitor = new SuperReferenceFinderVisitor(method, superType);
        AST.parseCompilationUnit((ICompilationUnit)method.getCompilationUnit(), (boolean)true).accept((ASTVisitor)visitor);
        return visitor.getSuperReferenceRanges();
    }

    private void copyThrownExceptions(MethodDeclaration oldMethod, MethodDeclaration newMethod) {
        AST ast = newMethod.getAST();
        int i = 0;
        int n = oldMethod.thrownExceptions().size();
        while (i < n) {
            Name oldExceptionName = (Name)oldMethod.thrownExceptions().get(i);
            newMethod.thrownExceptions().add(i, PullUpRefactoring.createCopyOfName(oldExceptionName, ast));
            ++i;
        }
    }

    private static Name createCopyOfName(Name name, AST ast) {
        if (name.isSimpleName()) {
            return PullUpRefactoring.createCopyOfSimpleName((SimpleName)name, ast);
        }
        return ast.newName(ASTNodes.getIdentifiers((QualifiedName)name));
    }

    private static SimpleName createCopyOfSimpleName(SimpleName simpleName, AST ast) {
        return ast.newSimpleName(simpleName.getIdentifier());
    }

    private void copyParameters(ASTRewrite targetRewrite, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        int i = 0;
        int n = oldMethod.parameters().size();
        while (i < n) {
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)oldMethod.parameters().get(i);
            SingleVariableDeclaration newParam = this.createPlaceholderForSingleVariableDeclaration(oldParam, targetRewrite);
            newMethod.parameters().add(i, newParam);
            ++i;
        }
    }

    private void copyReturnType(ASTRewrite targetRewrite, MethodDeclaration oldMethod, MethodDeclaration newMethod) throws JavaModelException {
        Type newReturnType = this.createPlaceholderForType(oldMethod.getReturnType(), targetRewrite);
        newMethod.setReturnType(newReturnType);
    }

    private static void copyJavadocNode(AST ast, BodyDeclaration oldDeclaration, BodyDeclaration newDeclaration) {
        if (oldDeclaration.getJavadoc() == null) {
            return;
        }
        Javadoc newJavadoc = ast.newJavadoc();
        newJavadoc.setComment(oldDeclaration.getJavadoc().getComment());
        newDeclaration.setJavadoc(newJavadoc);
    }

    private void copyFieldToTargetClass(IField field, IProgressMonitor pm) throws JavaModelException {
        ASTRewrite rewrite = this.fRewriteManager.getRewrite(this.getTargetCu());
        TypeDeclaration targetClass = this.getTypeDeclarationNode(this.getTargetClass());
        FieldDeclaration newField = this.createNewFieldDeclarationNode(field, rewrite);
        rewrite.markAsInserted((ASTNode)newField);
        targetClass.bodyDeclarations().add(newField);
    }

    private FieldDeclaration createNewFieldDeclarationNode(IField field, ASTRewrite rewrite) throws JavaModelException {
        AST ast = PullUpRefactoring.getAST(rewrite);
        VariableDeclarationFragment oldFieldFragment = this.getFieldDeclarationFragmentNode(field);
        VariableDeclarationFragment newFragment = ast.newVariableDeclarationFragment();
        newFragment.setExtraDimensions(oldFieldFragment.getExtraDimensions());
        if (oldFieldFragment.getInitializer() != null) {
            Expression newInitializer = this.createPlaceholderForExpression(oldFieldFragment.getInitializer(), rewrite);
            newFragment.setInitializer(newInitializer);
        }
        newFragment.setName(PullUpRefactoring.createCopyOfSimpleName(oldFieldFragment.getName(), ast));
        FieldDeclaration newField = ast.newFieldDeclaration(newFragment);
        FieldDeclaration oldField = this.getFieldDeclarationNode(field);
        PullUpRefactoring.copyJavadocNode(ast, (BodyDeclaration)oldField, (BodyDeclaration)newField);
        newField.setModifiers(this.getNewModifiers((IMember)field));
        Type newType = this.createPlaceholderForType(oldField.getType(), rewrite);
        newField.setType(newType);
        return newField;
    }

    private static boolean needsToChangeVisibility(IMember method) throws JavaModelException {
        return !JdtFlags.isPublic(method) && !JdtFlags.isProtected(method);
    }

    private int getNewModifiers(IMember member) throws JavaModelException {
        return this.getModifiersWithUpdatedVisibility(member, this.getModifiers(member));
    }

    private int getModifiers(IMember member) throws JavaModelException {
        if (member instanceof IField) {
            return this.getFieldDeclarationNode((IField)member).getModifiers();
        }
        if (member instanceof IMethod) {
            return this.getMethodDeclarationNode((IMethod)member).getModifiers();
        }
        if (member instanceof IType) {
            return this.getTypeDeclarationNode((IType)member).getModifiers();
        }
        Assert.isTrue(false);
        return 0;
    }

    private void addImportsToTargetCu(IProgressMonitor pm) throws CoreException {
        this.addImports(this.getTypesThatNeedToBeImportedInTargetCu(pm), this.getTargetWorkingCopy());
    }

    private void addImports(IType[] typesToImport, ICompilationUnit cu) throws JavaModelException {
        int i = 0;
        while (i < typesToImport.length) {
            this.fImportEditManager.addImportTo(typesToImport[i], cu);
            ++i;
        }
    }

    private void deleteMembers(IProgressMonitor pm) throws JavaModelException {
        IMember[] membersToDelete = this.getMembersToDelete(pm);
        int i = 0;
        while (i < membersToDelete.length) {
            if (membersToDelete[i] instanceof IField) {
                this.deleteField((IField)membersToDelete[i]);
            } else if (membersToDelete[i] instanceof IMethod) {
                this.deleteMethod((IMethod)membersToDelete[i]);
            } else if (membersToDelete[i] instanceof IType) {
                this.deleteType((IType)membersToDelete[i]);
            } else {
                Assert.isTrue(false);
            }
            ++i;
        }
    }

    private void deleteType(IType type) throws JavaModelException {
        TypeDeclaration td = this.getTypeDeclarationNode(type);
        this.fRewriteManager.getRewrite(this.getWorkingCopy((IMember)type)).markAsRemoved((ASTNode)td);
    }

    private void deleteField(IField field) throws JavaModelException {
        FieldDeclaration fd = this.getFieldDeclarationNode(field);
        this.fRewriteManager.getRewrite(this.getWorkingCopy((IMember)field)).markAsRemoved((ASTNode)fd);
    }

    private void deleteMethod(IMethod method) throws JavaModelException {
        MethodDeclaration md = this.getMethodDeclarationNode(method);
        this.fRewriteManager.getRewrite(this.getWorkingCopy((IMember)method)).markAsRemoved((ASTNode)md);
    }

    private void fillWithRewriteEdits(TextChangeManager manager) throws JavaModelException, CoreException {
        CompilationUnit[] cuNodes = this.fRewriteManager.getAllCompilationUnitNodes();
        int i = 0;
        while (i < cuNodes.length) {
            CompilationUnit cuNode = cuNodes[i];
            ASTRewrite rewrite = this.fRewriteManager.getRewrite(cuNode);
            TextBuffer textBuffer = TextBuffer.create(this.fAstManager.getCompilationUnit((ASTNode)cuNode).getBuffer().getContents());
            MultiTextEdit resultingEdits = new MultiTextEdit();
            rewrite.rewriteNode(textBuffer, resultingEdits, null);
            ICompilationUnit cu = this.fAstManager.getCompilationUnit((ASTNode)cuNode);
            TextChange textChange = manager.get(cu);
            if (this.fImportEditManager.hasImportEditFor(cu)) {
                resultingEdits.add(this.fImportEditManager.getImportEdit(cu));
            }
            textChange.addTextEdit(RefactoringCoreMessages.getString("PullUpRefactoring.pull_up_class_members"), resultingEdits);
            rewrite.removeModifications();
            ++i;
        }
    }

    private ICompilationUnit getWorkingCopy(IMember member) {
        return WorkingCopyUtil.getWorkingCopyIfExists(member.getCompilationUnit());
    }

    private boolean needsAddingImportsToTargetCu() throws JavaModelException {
        return !this.getTargetCu().equals(this.getDeclaringCu());
    }

    private ICompilationUnit getDeclaringCu() {
        return this.getDeclaringType().getCompilationUnit();
    }

    private ICompilationUnit getTargetWorkingCopy() {
        return WorkingCopyUtil.getWorkingCopyIfExists(this.getTargetCu());
    }

    private ICompilationUnit getTargetCu() {
        return this.getTargetClass().getCompilationUnit();
    }

    private IType[] getTypesThatNeedToBeImportedInTargetCu(IProgressMonitor pm) throws JavaModelException {
        IType[] typesInPulledUpMembers = this.getTypeReferencedInPulledUpMembers(pm);
        IType[] typesInMethodsDeclaredAbstract = this.getTypesReferencedInDeclarations(this.fMethodsToDeclareAbstract);
        ArrayList<IType> result = new ArrayList<IType>(typesInMethodsDeclaredAbstract.length + typesInPulledUpMembers.length);
        result.addAll(Arrays.asList(typesInMethodsDeclaredAbstract));
        result.addAll(Arrays.asList(typesInPulledUpMembers));
        return result.toArray(new IType[result.size()]);
    }

    private IType[] getTypeReferencedInPulledUpMembers(IProgressMonitor pm) throws JavaModelException {
        if (this.fTypesReferencedInPulledUpMembers == null) {
            this.fTypesReferencedInPulledUpMembers = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembersToPullUp, pm);
        }
        return this.fTypesReferencedInPulledUpMembers;
    }

    private IType[] getTypesReferencedInDeclarations(IMethod[] methods) throws JavaModelException {
        ITypeBinding[] referencedTypesBindings = ReferenceFinderUtil.getTypesReferencedInDeclarations(methods, this.fAstManager);
        ArrayList<IType> types = new ArrayList<IType>(referencedTypesBindings.length);
        IJavaProject proj = this.getDeclaringType().getJavaProject();
        int i = 0;
        while (i < referencedTypesBindings.length) {
            ITypeBinding typeBinding = referencedTypesBindings[i];
            if (typeBinding != null) {
                IType type;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if ((type = Binding2JavaModel.find(typeBinding, proj)) != null) {
                    types.add(type);
                }
            }
            ++i;
        }
        return types.toArray(new IType[types.size()]);
    }

    private static AST getAST(ASTRewrite rewrite) {
        return rewrite.getRootNode().getAST();
    }

    private String getBufferText(ASTNode node) throws JavaModelException {
        return this.fAstManager.getCompilationUnit(node).getBuffer().getText(node.getStartPosition(), node.getLength());
    }

    private String getNewText(ASTNode astNode, ASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        String bufferText = this.getBufferText(astNode);
        if (removeIndentation) {
            return this.getUnindentedText(bufferText, rewrite);
        }
        return bufferText;
    }

    private String getUnindentedText(String bufferText, ASTRewrite rewrite) throws JavaModelException {
        String[] lines = Strings.convertIntoLines(bufferText);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)this.fAstManager.getCompilationUnit(rewrite.getRootNode())));
    }

    private FieldDeclaration getFieldDeclarationNode(IField field) throws JavaModelException {
        return ASTNodeSearchUtil.getFieldDeclarationNode(field, this.fAstManager);
    }

    private VariableDeclarationFragment getFieldDeclarationFragmentNode(IField field) throws JavaModelException {
        return ASTNodeSearchUtil.getFieldDeclarationFragmentNode(field, this.fAstManager);
    }

    private TypeDeclaration getTypeDeclarationNode(IType type) throws JavaModelException {
        return ASTNodeSearchUtil.getTypeDeclarationNode(type, this.fAstManager);
    }

    private MethodDeclaration getMethodDeclarationNode(IMethod method) throws JavaModelException {
        return ASTNodeSearchUtil.getMethodDeclarationNode(method, this.fAstManager);
    }

    private Expression createPlaceholderForExpression(Expression expression, ASTRewrite rewrite) throws JavaModelException {
        return (Expression)rewrite.createPlaceholder(this.getBufferText((ASTNode)expression), 3);
    }

    private SingleVariableDeclaration createPlaceholderForSingleVariableDeclaration(SingleVariableDeclaration declaration, ASTRewrite rewrite) throws JavaModelException {
        return (SingleVariableDeclaration)rewrite.createPlaceholder(this.getBufferText((ASTNode)declaration), 5);
    }

    private Type createPlaceholderForType(Type type, ASTRewrite rewrite) throws JavaModelException {
        return (Type)rewrite.createPlaceholder(this.getBufferText((ASTNode)type), 6);
    }

    private BodyDeclaration createPlaceholderForBodyDeclaration(BodyDeclaration bodyDeclaration, ASTRewrite rewrite, boolean removeIndentation) throws JavaModelException {
        String newBufferText = this.getNewText((ASTNode)bodyDeclaration, rewrite, removeIndentation);
        return (BodyDeclaration)rewrite.createPlaceholder(newBufferText, 1);
    }

    private static class SuperReferenceFinderVisitor
    extends ASTVisitor {
        private Collection fFoundRanges = new ArrayList(0);
        private int fMethodSourceStart;
        private int fMethodSourceEnd;
        private String fMethodSource;
        private String fSuperTypeName;

        SuperReferenceFinderVisitor(IMethod method, IType superType) throws JavaModelException {
            this.fMethodSourceStart = method.getSourceRange().getOffset();
            this.fMethodSourceEnd = method.getSourceRange().getOffset() + method.getSourceRange().getLength();
            this.fMethodSource = method.getSource();
            this.fSuperTypeName = JavaModelUtil.getFullyQualifiedName(superType);
        }

        ISourceRange[] getSuperReferenceRanges() {
            return this.fFoundRanges.toArray(new ISourceRange[this.fFoundRanges.size()]);
        }

        private boolean withinMethod(ASTNode node) {
            return node.getStartPosition() >= this.fMethodSourceStart && node.getStartPosition() <= this.fMethodSourceEnd;
        }

        private ISourceRange getSuperRange(String scanSource) {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(scanSource.toCharArray());
            try {
                int token = scanner.getNextToken();
                while (token != 158) {
                    switch (token) {
                        case 33: {
                            int start = scanner.getCurrentTokenEndPosition() + 1 - scanner.getCurrentTokenSource().length;
                            int end = scanner.getCurrentTokenEndPosition() + 1;
                            return new SourceRange(start, end - start);
                        }
                    }
                    token = scanner.getNextToken();
                }
            }
            catch (InvalidInputException invalidInputException) {
                return new SourceRange(0, 0);
            }
            return new SourceRange(0, 0);
        }

        private String getSource(int start, int end) {
            return this.fMethodSource.substring(start - this.fMethodSourceStart, end - this.fMethodSourceStart);
        }

        private String getScanSource(SuperMethodInvocation node) {
            return this.getSource(SuperReferenceFinderVisitor.getScanSourceOffset(node), node.getName().getStartPosition());
        }

        private String getScanSource(SuperFieldAccess node) {
            return this.getSource(SuperReferenceFinderVisitor.getScanSourceOffset(node), node.getName().getStartPosition());
        }

        private static int getScanSourceOffset(SuperMethodInvocation node) {
            if (node.getQualifier() == null) {
                return node.getStartPosition();
            }
            return node.getQualifier().getStartPosition() + node.getQualifier().getLength();
        }

        private static int getScanSourceOffset(SuperFieldAccess node) {
            if (node.getQualifier() == null) {
                return node.getStartPosition();
            }
            return node.getQualifier().getStartPosition() + node.getQualifier().getLength();
        }

        public boolean visit(SuperFieldAccess node) {
            if (!this.withinMethod((ASTNode)node)) {
                return true;
            }
            ISourceRange superRange = this.getSuperRange(this.getScanSource(node));
            this.fFoundRanges.add(new SourceRange(superRange.getOffset() + SuperReferenceFinderVisitor.getScanSourceOffset(node), superRange.getLength()));
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            ITypeBinding declaringType;
            if (!this.withinMethod((ASTNode)node)) {
                return true;
            }
            IBinding nameBinding = node.getName().resolveBinding();
            if (nameBinding != null && nameBinding.getKind() == 4 && (declaringType = ((IMethodBinding)nameBinding).getDeclaringClass()) != null && !this.fSuperTypeName.equals(Bindings.getFullyQualifiedName(declaringType))) {
                return true;
            }
            ISourceRange superRange = this.getSuperRange(this.getScanSource(node));
            this.fFoundRanges.add(new SourceRange(superRange.getOffset() + SuperReferenceFinderVisitor.getScanSourceOffset(node), superRange.getLength()));
            return true;
        }

        public boolean visit(TypeDeclarationStatement node) {
            return !this.withinMethod((ASTNode)node);
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return !this.withinMethod((ASTNode)node);
        }
    }
}

