/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

class ParameterOffsetFinder {
    private ParameterOffsetFinder() {
    }

    static int[] findOffsets(IMethod method, String parameterName, boolean includeReferences) throws JavaModelException {
        ParameterOffsetFinderVisitor visitor = new ParameterOffsetFinderVisitor(includeReferences, method, parameterName);
        AST.parseCompilationUnit((ICompilationUnit)method.getCompilationUnit(), (boolean)true).accept((ASTVisitor)visitor);
        return visitor.getOffsets();
    }

    private static class ParameterOffsetFinderVisitor
    extends ASTVisitor {
        private boolean fIncludeReferences;
        private Set fOffsetsFound;
        private int fMethodSourceStart;
        private int fMethodSourceEnd;
        private Set fParamBindings;
        private String fParameterName;

        ParameterOffsetFinderVisitor(boolean includeReferences, IMethod method, String parameterName) throws JavaModelException {
            this.fIncludeReferences = includeReferences;
            this.fOffsetsFound = new HashSet();
            this.fParamBindings = new HashSet();
            this.fMethodSourceStart = ParameterOffsetFinderVisitor.computeMethodSourceStart(method);
            this.fMethodSourceEnd = method.getSourceRange().getOffset() + method.getSourceRange().getLength();
            this.fParameterName = parameterName;
        }

        private static int computeMethodSourceStart(IMethod method) throws JavaModelException {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(method.getSource().toCharArray());
            scanner.resetTo(0, method.getSourceRange().getLength());
            try {
                scanner.getNextToken();
                return method.getSourceRange().getOffset() + scanner.getCurrentTokenStartPosition();
            }
            catch (InvalidInputException invalidInputException) {
                return method.getSourceRange().getOffset();
            }
        }

        private void addOffset(int offset) {
            this.fOffsetsFound.add(new Integer(offset));
        }

        private boolean withinMethod(ASTNode node) {
            return node.getStartPosition() >= this.fMethodSourceStart && node.getStartPosition() <= this.fMethodSourceEnd;
        }

        int[] getOffsets() {
            int[] result = new int[this.fOffsetsFound.size()];
            Integer[] integerResult = this.fOffsetsFound.toArray(new Integer[this.fOffsetsFound.size()]);
            int i = 0;
            while (i < integerResult.length) {
                result[i] = integerResult[i];
                ++i;
            }
            return result;
        }

        private boolean isParameterMatch(SimpleName simpleName) {
            if (!this.withinMethod((ASTNode)simpleName)) {
                return false;
            }
            if (!simpleName.getIdentifier().equals(this.fParameterName)) {
                return false;
            }
            IBinding binding = simpleName.resolveBinding();
            return this.fParamBindings.contains(binding);
        }

        public boolean visit(SimpleName simpleName) {
            if (!this.fIncludeReferences) {
                return true;
            }
            if (this.isParameterMatch(simpleName)) {
                this.addOffset(simpleName.getStartPosition());
            }
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            if (methodDeclaration.getStartPosition() != this.fMethodSourceStart) {
                return true;
            }
            List params = methodDeclaration.parameters();
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)iter.next();
                IBinding binding = param.getName().resolveBinding();
                if (binding == null) continue;
                this.fParamBindings.add(binding);
            }
            return true;
        }
    }
}

