/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.MemberEdit;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteSourceReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceReferenceUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.FieldReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportEditManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberMoveUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.MethodInvocationFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public class MoveStaticMembersRefactoring
extends Refactoring {
    private IMember[] fMembers;
    private IType fDestinationType;
    private String fDestinationTypeName;
    private TextChangeManager fChangeManager;
    private final ImportEditManager fImportManager;

    public MoveStaticMembersRefactoring(IMember[] elements, CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(elements);
        Assert.isNotNull(preferenceSettings);
        this.fMembers = (IMember[])SourceReferenceUtil.sortByOffset((ISourceReference[])elements);
        this.fImportManager = new ImportEditManager(preferenceSettings);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveMembersRefactoring.Move_Members");
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public void setDestinationTypeFullyQualifiedName(String fullyQualifiedTypeName) throws JavaModelException {
        Assert.isNotNull(fullyQualifiedTypeName);
        this.fDestinationType = this.resolveType(fullyQualifiedTypeName);
        this.fDestinationTypeName = fullyQualifiedTypeName;
    }

    public IMember[] getMovedMembers() {
        return this.fMembers;
    }

    private IType resolveType(String fullyQualifiedTypeName) throws JavaModelException {
        return this.getDeclaringType().getJavaProject().findType(fullyQualifiedTypeName);
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAllElements());
        if (result.hasFatalError()) {
            return result;
        }
        if (!this.haveCommonDeclaringType()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.same_type"));
        }
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block5: {
            RefactoringStatus refactoringStatus2;
            block4: {
                RefactoringStatus preAct = this.checkPreactivation();
                if (preAct.hasFatalError()) {
                    return preAct;
                }
                try {
                    pm.beginTask("", 1);
                    RefactoringStatus result = new RefactoringStatus();
                    result.merge(preAct);
                    result.merge(this.checkDeclaringType());
                    pm.worked(1);
                    if (result.hasFatalError()) {
                        refactoringStatus2 = result;
                        Object var4_6 = null;
                        break block4;
                    }
                    this.fMembers = MoveStaticMembersRefactoring.getOriginals(this.fMembers);
                    refactoringStatus = new RefactoringStatus();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var4_7 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block15: {
            RefactoringStatus refactoringStatus2;
            block14: {
                RefactoringStatus refactoringStatus3;
                block13: {
                    RefactoringStatus refactoringStatus4;
                    block12: {
                        RefactoringStatus refactoringStatus5;
                        block11: {
                            RefactoringStatus refactoringStatus6;
                            block10: {
                                try {
                                    try {
                                        pm.beginTask(RefactoringCoreMessages.getString("MoveMembersRefactoring.Checking_preconditions"), 5);
                                        RefactoringStatus result = new RefactoringStatus();
                                        result.merge(this.checkDestinationType());
                                        if (result.hasFatalError()) {
                                            refactoringStatus6 = result;
                                            Object var3_11 = null;
                                            break block10;
                                        }
                                        result.merge(MemberCheckUtil.checkMembersInDestinationType(this.fMembers, this.fDestinationType));
                                        if (result.hasFatalError()) {
                                            refactoringStatus5 = result;
                                            break block11;
                                        }
                                        result.merge(this.checkAccessedMembersAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                        if (result.hasFatalError()) {
                                            refactoringStatus4 = result;
                                            break block12;
                                        }
                                        result.merge(this.checkMovedMembersAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                        if (result.hasFatalError()) {
                                            refactoringStatus3 = result;
                                            break block13;
                                        }
                                        result.merge(this.checkNativeMovedMethods((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                        if (result.hasFatalError()) {
                                            refactoringStatus2 = result;
                                            break block14;
                                        }
                                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                        result.merge(this.validateModifiesFiles());
                                        refactoringStatus = result;
                                        break block15;
                                    }
                                    catch (JavaModelException e) {
                                        throw e;
                                    }
                                    catch (CoreException e) {
                                        throw new JavaModelException(e);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var3_17 = null;
                                    pm.done();
                                    throw throwable;
                                }
                            }
                            pm.done();
                            return refactoringStatus6;
                        }
                        Object var3_12 = null;
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var3_13 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_14 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_15 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_16 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkDestinationType() throws JavaModelException {
        if (this.fDestinationType == null) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.not_found", this.fDestinationTypeName);
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (this.fDestinationType.equals(this.getDeclaringType())) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.same", JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (!this.fDestinationType.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.not_exist", JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (this.fDestinationType.isBinary()) {
            String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.dest_binary", JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (this.fDestinationType.isInterface() && !this.getDeclaringType().isInterface()) {
            String message = RefactoringCoreMessages.getString("MoveMembersRefactoring.interface_fields");
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        if (!this.fDestinationType.isInterface() && this.getDeclaringType().isInterface()) {
            String message = RefactoringCoreMessages.getString("MoveMembersRefactoring.interface_members");
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        RefactoringStatus result = new RefactoringStatus();
        if (!MoveStaticMembersRefactoring.canDeclareStaticMembers(this.fDestinationType)) {
            String message = RefactoringCoreMessages.getString("MoveMembersRefactoring.static_declaration");
            result.addError(message);
        }
        return result;
    }

    private RefactoringStatus checkNativeMovedMethods(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fMembers.length);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembers.length) {
            if (this.fMembers[i].getElementType() == 9 && JdtFlags.isNative(this.fMembers[i])) {
                String message = RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.native", JavaElementUtil.createMethodSignature((IMethod)this.fMembers[i]));
                result.addWarning(message, JavaSourceContext.create(this.fMembers[i]));
                pm.worked(1);
            }
            ++i;
        }
        pm.done();
        return result;
    }

    private RefactoringStatus checkMovedMembersAvailability(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fMembers.length);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fMembers.length) {
            if (!MoveStaticMembersRefactoring.isVisibleFrom(this.fMembers[i], this.fMembers[i].getDeclaringType(), this.fDestinationType)) {
                String message = MoveStaticMembersRefactoring.createNonAccessibleMemberMessage(this.fMembers[i], this.fMembers[i].getDeclaringType(), true);
                result.addWarning(message, JavaSourceContext.create(this.fMembers[i]));
            }
            pm.worked(1);
            ++i;
        }
        pm.done();
        return result;
    }

    private static String createNonAccessibleMemberMessage(IMember member, IType type, boolean moved) throws JavaModelException {
        switch (member.getElementType()) {
            case 8: {
                String message = moved ? RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.moved_field", new String[]{JavaElementUtil.createFieldSignature((IField)member), MoveStaticMembersRefactoring.createAccessModifierString(member), JavaModelUtil.getFullyQualifiedName(type)}) : RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.accessed_field", new String[]{JavaElementUtil.createFieldSignature((IField)member), MoveStaticMembersRefactoring.createAccessModifierString(member), JavaModelUtil.getFullyQualifiedName(type)});
                return message;
            }
            case 9: {
                String message = moved ? RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.moved_method", new String[]{JavaElementUtil.createMethodSignature((IMethod)member), MoveStaticMembersRefactoring.createAccessModifierString(member), JavaModelUtil.getFullyQualifiedName(type)}) : RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.accessed_method", new String[]{JavaElementUtil.createMethodSignature((IMethod)member), MoveStaticMembersRefactoring.createAccessModifierString(member), JavaModelUtil.getFullyQualifiedName(type)});
                return message;
            }
            case 7: {
                String message = moved ? RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.moved_type", new String[]{JavaModelUtil.getFullyQualifiedName((IType)member), MoveStaticMembersRefactoring.createAccessModifierString(member), JavaModelUtil.getFullyQualifiedName(type)}) : RefactoringCoreMessages.getFormattedString("MoveMembersRefactoring.accessed_type", new String[]{JavaModelUtil.getFullyQualifiedName((IType)member), MoveStaticMembersRefactoring.createAccessModifierString(member), JavaModelUtil.getFullyQualifiedName(type)});
                return message;
            }
        }
        Assert.isTrue(false);
        return null;
    }

    private static String createAccessModifierString(IMember member) throws JavaModelException {
        if (JdtFlags.isPublic(member)) {
            return RefactoringCoreMessages.getString("MoveMembersRefactoring.public");
        }
        if (JdtFlags.isProtected(member)) {
            return RefactoringCoreMessages.getString("MoveMembersRefactoring.protected");
        }
        if (JdtFlags.isPrivate(member)) {
            return RefactoringCoreMessages.getString("MoveMembersRefactoring.private");
        }
        return RefactoringCoreMessages.getString("MoveMembersRefactoring.package-visible");
    }

    private RefactoringStatus checkAccessedMembersAvailability(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        RefactoringStatus result = new RefactoringStatus();
        result.merge(this.checkAccessedMethodsAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedFieldsAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.merge(this.checkAccessedTypesAvailability((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result;
    }

    private RefactoringStatus checkAccessedMethodsAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IMethod[] accessedMethods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])this.fMembers, pm);
        List<IMember> movedElementList = Arrays.asList(this.fMembers);
        int i = 0;
        while (i < accessedMethods.length) {
            if (!movedElementList.contains(accessedMethods[i]) && JdtFlags.isStatic((IMember)accessedMethods[i]) && !MoveStaticMembersRefactoring.isVisibleFrom((IMember)accessedMethods[i], this.fDestinationType, accessedMethods[i].getDeclaringType())) {
                String msg = MoveStaticMembersRefactoring.createNonAccessibleMemberMessage((IMember)accessedMethods[i], this.fDestinationType, false);
                result.addWarning(msg, JavaSourceContext.create((IMember)accessedMethods[i]));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkAccessedTypesAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] accessedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembers, pm);
        List<IMember> movedElementList = Arrays.asList(this.fMembers);
        int i = 0;
        while (i < accessedTypes.length) {
            if (!movedElementList.contains(accessedTypes[i]) && JdtFlags.isStatic((IMember)accessedTypes[i]) && !MoveStaticMembersRefactoring.isVisibleFrom((IMember)accessedTypes[i], this.fDestinationType, accessedTypes[i].getDeclaringType())) {
                String msg = MoveStaticMembersRefactoring.createNonAccessibleMemberMessage((IMember)accessedTypes[i], this.fDestinationType, false);
                result.addWarning(msg, JavaSourceContext.create((IMember)accessedTypes[i]));
            }
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkAccessedFieldsAvailability(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        IField[] accessedFields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])this.fMembers, pm);
        List<IMember> movedElementList = Arrays.asList(this.fMembers);
        int i = 0;
        while (i < accessedFields.length) {
            if (!movedElementList.contains(accessedFields[i]) && JdtFlags.isStatic((IMember)accessedFields[i]) && !MoveStaticMembersRefactoring.isVisibleFrom((IMember)accessedFields[i], this.fDestinationType, accessedFields[i].getDeclaringType())) {
                String msg = MoveStaticMembersRefactoring.createNonAccessibleMemberMessage((IMember)accessedFields[i], this.fDestinationType, false);
                result.addWarning(msg, JavaSourceContext.create((IMember)accessedFields[i]));
            }
            ++i;
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private static boolean isVisibleFrom(IMember member, IType accessingType, IType newMemberDeclaringType) throws JavaModelException {
        if (JdtFlags.isPrivate(member)) {
            return newMemberDeclaringType.equals(accessingType);
        }
        if (JdtFlags.isPublic(member)) {
            if (JdtFlags.isPublic((IMember)newMemberDeclaringType)) {
                return true;
            }
            return accessingType.getPackageFragment().equals(newMemberDeclaringType.getPackageFragment());
        }
        if (JdtFlags.isProtected(member)) {
            if (JdtFlags.isPublic((IMember)newMemberDeclaringType)) {
                return true;
            }
            return accessingType.getPackageFragment().equals(newMemberDeclaringType.getPackageFragment());
        }
        return accessingType.getPackageFragment().equals(newMemberDeclaringType.getPackageFragment());
    }

    private static boolean canDeclareStaticMembers(IType type) throws JavaModelException {
        return JdtFlags.isStatic((IMember)type) || type.getDeclaringType() == null;
    }

    private RefactoringStatus checkAllElements() throws JavaModelException {
        int i = 0;
        while (i < this.fMembers.length) {
            IMember member = this.fMembers[i];
            if (member.getElementType() != 9 && member.getElementType() != 8) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.fields_methods"));
            }
            if (!member.exists()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.exist"));
            }
            if (member.isBinary()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.binary_elements"));
            }
            if (member.isReadOnly()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.read_only_elements"));
            }
            if (!member.isStructureKnown()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.structure"));
            }
            if (member.getElementType() == 9 && member.getDeclaringType().isInterface()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.interface_methods"));
            }
            if (member.getElementType() == 9 && !JdtFlags.isStatic(member)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.static_methods"));
            }
            if (!member.getDeclaringType().isInterface() && !JdtFlags.isStatic(member)) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.static_elements"));
            }
            if (member.getElementType() == 9 && ((IMethod)member).isConstructor()) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.constructors"));
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkDeclaringType() throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        if (JavaModelUtil.getFullyQualifiedName(declaringType).equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.Object"));
        }
        if (declaringType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.binary"));
        }
        if (declaringType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveMembersRefactoring.read_only"));
        }
        return null;
    }

    public IType getDeclaringType() {
        return this.fMembers[0].getDeclaringType();
    }

    private boolean haveCommonDeclaringType() {
        IType declaringType = this.fMembers[0].getDeclaringType();
        int i = 0;
        while (i < this.fMembers.length) {
            if (!declaringType.equals(this.fMembers[i].getDeclaringType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static IMember[] getOriginals(IMember[] members) {
        IMember[] result = new IMember[members.length];
        int i = 0;
        while (i < members.length) {
            result[i] = (IMember)WorkingCopyUtil.getOriginal(members[i]);
            ++i;
        }
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("MoveMembersRefactoring.move_members"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("MoveMembersRefactoring.analyzing"), 6);
            TextChangeManager manager = new TextChangeManager();
            this.addCopyMembersChange((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            if (this.destinationCUNeedsAddedImports()) {
                this.addImportsToDestinationCu((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            if (this.sourceCUNeedsAddedImports()) {
                this.addImportsToSourceCu();
            }
            pm.worked(1);
            this.addDeleteMembersChange((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            this.addModifyReferencesToMovedMembers((IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            this.fImportManager.fill(manager);
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private boolean destinationCUNeedsAddedImports() {
        return !this.getDeclaringType().getCompilationUnit().equals(this.fDestinationType.getCompilationUnit());
    }

    private boolean sourceCUNeedsAddedImports() {
        return !this.getDeclaringType().getCompilationUnit().equals(this.fDestinationType.getCompilationUnit());
    }

    private void addCopyMembersChange(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        pm.beginTask("", this.fMembers.length);
        int i = this.fMembers.length - 1;
        while (i >= 0) {
            this.addCopyMemberChange(manager, this.fMembers[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
            --i;
        }
        pm.done();
    }

    private void addCopyMemberChange(TextChangeManager manager, IMember member, IProgressMonitor pm) throws CoreException {
        String source = MemberMoveUtil.computeNewSource(member, pm, this.fImportManager, this.fMembers);
        String changeName = String.valueOf(RefactoringCoreMessages.getString("MoveMembersRefactoring.Copy")) + member.getElementName();
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fDestinationType.getCompilationUnit());
        manager.get(cu).addTextEdit(changeName, this.createAddMemberEdit(source, member.getElementType()));
    }

    private TextEdit createAddMemberEdit(String source, int memberType) throws JavaModelException {
        IMember sibling = MoveStaticMembersRefactoring.getLastMember(this.fDestinationType, memberType);
        String[] sourceLines = Strings.removeTrailingEmptyLines(Strings.convertIntoLines(source));
        if (sibling != null) {
            return new MemberEdit((IJavaElement)sibling, 1, sourceLines, CodeFormatterUtil.getTabWidth());
        }
        return new MemberEdit((IJavaElement)this.fDestinationType, 3, sourceLines, CodeFormatterUtil.getTabWidth());
    }

    private void addDeleteMembersChange(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        pm.beginTask("", this.fMembers.length);
        int i = 0;
        while (i < this.fMembers.length) {
            String changeName = String.valueOf(RefactoringCoreMessages.getString("MoveMembersRefactoring.delete")) + this.fMembers[i].getElementName();
            DeleteSourceReferenceEdit edit = new DeleteSourceReferenceEdit((ISourceReference)this.fMembers[i], this.fMembers[i].getCompilationUnit());
            ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fMembers[i].getCompilationUnit());
            manager.get(cu).addTextEdit(changeName, edit);
            pm.worked(1);
            ++i;
        }
        pm.done();
    }

    private void addImportsToDestinationCu(IProgressMonitor pm) throws CoreException {
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fDestinationType.getCompilationUnit());
        IType[] referencedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.fMembers, pm);
        int i = 0;
        while (i < referencedTypes.length) {
            this.fImportManager.addImportTo(referencedTypes[i], cu);
            ++i;
        }
    }

    private void addImportsToSourceCu() throws CoreException {
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.getDeclaringType().getCompilationUnit());
        this.fImportManager.addImportTo(this.fDestinationType, cu);
    }

    private void addModifyReferencesToMovedMembers(IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        pm.beginTask("", this.fMembers.length);
        int i = 0;
        while (i < this.fMembers.length) {
            this.addModifyReferencesToMovedMember(this.fMembers[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), manager);
            ++i;
        }
        pm.done();
    }

    private void addModifyReferencesToMovedMember(IMember member, IProgressMonitor pm, TextChangeManager manager) throws CoreException {
        pm.beginTask("", 2);
        SearchResultGroup[] results = MoveStaticMembersRefactoring.findReferencesToMember(member, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        int i = 0;
        while (i < results.length) {
            SearchResultGroup searchResultGroup = results[i];
            ICompilationUnit cu = searchResultGroup.getCompilationUnit();
            if (cu != null) {
                ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
                SearchResultGroup modifiedGroup = searchResultGroup;
                if (ResourceUtil.getResource((IMember)this.getDeclaringType()).equals((Object)ResourceUtil.getResource(wc))) {
                    modifiedGroup = MoveStaticMembersRefactoring.removeReferencesEnclosedIn((IJavaElement[])this.fMembers, searchResultGroup);
                }
                this.modifyReferencesToMovedMember(member, manager, modifiedGroup, wc);
                this.fImportManager.addImportTo(this.fDestinationType, wc);
            }
            ++i;
        }
        pm.done();
    }

    private static SearchResultGroup removeReferencesEnclosedIn(IJavaElement[] elements, SearchResultGroup group) {
        List<IJavaElement> elementList = Arrays.asList(elements);
        ArrayList<SearchResult> searchResultList = new ArrayList<SearchResult>(group.getSearchResults().length);
        SearchResult[] searchResults = group.getSearchResults();
        int i = 0;
        while (i < searchResults.length) {
            if (!elementList.contains(searchResults[i].getEnclosingElement())) {
                searchResultList.add(searchResults[i]);
            }
            ++i;
        }
        SearchResult[] searchResultArray = searchResultList.toArray(new SearchResult[searchResultList.size()]);
        return new SearchResultGroup(group.getResource(), searchResultArray);
    }

    private void modifyReferencesToMovedMember(IMember member, TextChangeManager manager, SearchResultGroup searchResultGroup, ICompilationUnit cu) throws JavaModelException, CoreException {
        ISourceRange[] ranges = MoveStaticMembersRefactoring.findMemberReferences(member.getElementType(), searchResultGroup);
        String text = String.valueOf(this.fDestinationType.getElementName()) + "." + member.getElementName();
        int i = 0;
        while (i < ranges.length) {
            ISourceRange iSourceRange = ranges[i];
            SimpleTextEdit edit = SimpleTextEdit.createReplace(iSourceRange.getOffset(), iSourceRange.getLength(), text);
            manager.get(cu).addTextEdit(RefactoringCoreMessages.getString("MoveMembersRefactoring.convert"), edit);
            ++i;
        }
    }

    private static ISourceRange[] findMemberReferences(int memberType, SearchResultGroup searchResultGroup) throws JavaModelException {
        Assert.isTrue(memberType == 9 || memberType == 8);
        if (memberType == 9) {
            return MethodInvocationFinder.findMessageSendRanges(searchResultGroup);
        }
        return FieldReferenceFinder.findFieldReferenceRanges(searchResultGroup);
    }

    private static SearchResultGroup[] findReferencesToMember(IMember member, IProgressMonitor pm) throws JavaModelException {
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)member, (int)2);
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)member);
        return RefactoringSearchEngine.search(pm, scope, pattern);
    }

    private static IMember getLastMember(IType type, int elementType) throws JavaModelException {
        if (elementType == 9) {
            return MoveStaticMembersRefactoring.getLastMethod(type);
        }
        if (elementType == 8) {
            return MoveStaticMembersRefactoring.getLastField(type);
        }
        Assert.isTrue(false);
        return null;
    }

    private static IMethod getLastMethod(IType type) throws JavaModelException {
        if (type == null) {
            return null;
        }
        IMethod[] methods = type.getMethods();
        if (methods.length == 0) {
            return null;
        }
        return methods[methods.length - 1];
    }

    private static IField getLastField(IType type) throws JavaModelException {
        if (type == null) {
            return null;
        }
        IField[] fields = type.getFields();
        if (fields.length == 0) {
            return null;
        }
        return fields[fields.length - 1];
    }
}

