/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeBlock;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.MemberEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTWithExistingFlattener;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteSourceReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportEditManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.MemberMoveUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;

public class MoveInnerToTopRefactoring
extends Refactoring {
    private static final String THIS_KEYWORD = "this";
    private final ImportEditManager fImportEditManager;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private IType fType;
    private TextChangeManager fChangeManager;
    private String fEnclosingInstanceFieldName;
    private final ASTNodeMappingManager fASTManager;
    private DeleteSourceReferenceEdit fCutTypeEdit;
    private boolean fMarkInstanceFieldAsFinal;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public MoveInnerToTopRefactoring(IType type, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(type);
        Assert.isNotNull(codeGenerationSettings);
        this.fType = type;
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fImportEditManager = new ImportEditManager(codeGenerationSettings);
        this.fASTManager = new ASTNodeMappingManager();
        this.fEnclosingInstanceFieldName = this.getInitialNameForEnclosingInstanceField();
        this.fMarkInstanceFieldAsFinal = true;
    }

    public boolean isInstanceFieldMarkedFinal() {
        return this.fMarkInstanceFieldAsFinal;
    }

    public void setMarkInstanceFieldAsFinal(boolean mark) {
        this.fMarkInstanceFieldAsFinal = mark;
    }

    private String getInitialNameForEnclosingInstanceField() {
        IType enclosingType = this.getEnclosingType();
        if (enclosingType == null) {
            return "";
        }
        String qualifiedTypeName = this.getTypeOfEnclosingInstanceField();
        String packageName = enclosingType.getPackageFragment().getElementName();
        String[] suggestedNames = NamingConventions.suggestFieldNames((IJavaProject)enclosingType.getJavaProject(), (String)packageName, (String)qualifiedTypeName, (int)0, (int)this.getEnclosingInstanceAccessModifiers(), (String[])MoveInnerToTopRefactoring.getFieldNames(this.fType));
        if (suggestedNames.length > 0) {
            return suggestedNames[0];
        }
        String name = enclosingType.getElementName();
        if (name.equals("")) {
            return "";
        }
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    private static String[] getFieldNames(IType type) {
        try {
            IField[] fields = type.getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                result.add(fields[i].getElementName());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public IType getInputType() {
        return this.fType;
    }

    private IType getEnclosingType() {
        return this.fType.getDeclaringType();
    }

    public String getEnclosingInstanceName() {
        return this.fEnclosingInstanceFieldName;
    }

    public RefactoringStatus checkEnclosingInstanceName(String name) {
        RefactoringStatus result = Checks.checkFieldName(name);
        if (!Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.names_start_lowercase"));
        }
        if (this.fType.getField(name).exists()) {
            Object[] keys = new String[]{name, this.fType.getElementName()};
            String msg = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.already_declared", keys);
            result.addError(msg, JavaSourceContext.create((IMember)this.fType.getField(name)));
        }
        return result;
    }

    public void setEnclosingInstanceName(String name) {
        Assert.isNotNull(name);
        this.fEnclosingInstanceFieldName = name;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fType);
        if (result.hasFatalError()) {
            return result;
        }
        if (Checks.isTopLevel(this.fType)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.only_nested_types"));
        }
        return result;
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fType);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.deleted", new String[]{this.getInputTypeCu().getElementName()});
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fType = orig;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 2);
        try {
            try {
                RefactoringStatus result = new RefactoringStatus();
                if (this.isInputTypeStatic()) {
                    result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
                }
                if (this.getInputTypePackage().getCompilationUnit(this.getNameForNewCu()).exists()) {
                    String message = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.compilation_Unit_exists", new String[]{this.getNameForNewCu(), this.getInputTypePackage().getElementName()});
                    result.addFatalError(message);
                }
                result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
                result.merge(Checks.checkCompilationUnitName(this.getNameForNewCu()));
                result.merge(this.checkConstructorParameterNames((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                result.merge(this.checkTypeNameInPackage());
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                result.merge(this.validateModifiesFiles());
                refactoringStatus = result;
                Object var4_7 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkTypeNameInPackage() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.getInputTypePackage(), this.fType.getElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String message = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.type_exists", new String[]{this.fType.getElementName(), this.getInputTypePackage().getElementName()});
        return RefactoringStatus.createErrorStatus(message);
    }

    private RefactoringStatus checkConstructorParameterNames(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        ASTNode[] nodes = this.getConstructorDeclarationNodes(pm);
        int i = 0;
        while (i < nodes.length) {
            ASTNode aSTNode = nodes[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MethodDeclaration constructor = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
            Iterator iter = constructor.parameters().iterator();
            while (iter.hasNext()) {
                SingleVariableDeclaration param = (SingleVariableDeclaration)iter.next();
                if (!this.fEnclosingInstanceFieldName.equals(param.getName().getIdentifier())) continue;
                String msg = RefactoringCoreMessages.getFormattedString("MoveInnerToTopRefactoring.name_used", new String[]{param.getName().getIdentifier(), this.fType.getElementName()});
                result.addError(msg, JavaSourceContext.create(this.getInputTypeCu(), (ASTNode)param));
            }
            ++i;
        }
        return result;
    }

    private boolean isInputTypeStatic() throws JavaModelException {
        return JdtFlags.isStatic((IMember)this.fType);
    }

    private IPackageFragment getInputTypePackage() {
        return this.fType.getPackageFragment();
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.name");
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        try {
            try {
                pm.beginTask(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.creating_preview"), 1);
                CompositeChange builder = new CompositeChange(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.move_to_Top"));
                builder.addAll(this.fChangeManager.getAllChanges());
                builder.add(this.createCompilationUnitForMovedType((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                CompositeChange compositeChange = builder;
                Object var3_6 = null;
                this.fASTManager.clear();
                this.fImportEditManager.clear();
                return compositeChange;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.fASTManager.clear();
            this.fImportEditManager.clear();
            throw throwable;
        }
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 3);
            TextChangeManager manager = new TextChangeManager();
            this.cutType(manager);
            this.updateTypeReferences(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.isInputTypeStatic()) {
                pm.worked(2);
            } else {
                this.addEnclosingInstanceDeclaration(manager);
                this.removeUnusedTypeModifiers(manager);
                this.modifyAccessesToMembersFromEnclosingInstance(manager);
                this.updateConstructorReferences(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (JavaElementUtil.getAllConstructors(this.fType).length == 0) {
                    this.addConstructor(manager);
                    pm.worked(1);
                } else {
                    this.modifyConstructors(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
            }
            this.fImportEditManager.fill(manager);
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void modifyAccessesToMembersFromEnclosingInstance(TextChangeManager manager) throws CoreException {
        TypeDeclaration typeDeclaration = this.getTypeDeclarationNode();
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.getEnclosingType());
        typeDeclaration.accept((ASTVisitor)collector);
        this.modifyAccessToMethodsFromEnclosingInstance(manager, collector.getMethodInvocations());
        this.modifyAccessToFieldsFromEnclosingInstance(manager, collector.getFieldAccesses());
        this.modifyAccessToFieldsFromEnclosingInstance(manager, collector.getSimpleNames());
    }

    private static boolean isStatic(IBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    private void modifyAccessToFieldsFromEnclosingInstance(TextChangeManager manager, SimpleName[] simpleNames) throws CoreException {
        int i = 0;
        while (i < simpleNames.length) {
            SimpleName simpleName = simpleNames[i];
            IBinding vb = simpleName.resolveBinding();
            if (vb != null) {
                String text = MoveInnerToTopRefactoring.isStatic(vb) ? String.valueOf(this.getTypeOfEnclosingInstanceField()) + '.' : String.valueOf(this.createReadAccessForEnclosingInstance()) + '.';
                int offset = simpleName.getStartPosition();
                manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.update_field_access"), SimpleTextEdit.createInsert(offset, text));
            }
            ++i;
        }
    }

    private void modifyAccessToFieldsFromEnclosingInstance(TextChangeManager manager, FieldAccess[] fieldAccesses) throws CoreException {
        int i = 0;
        while (i < fieldAccesses.length) {
            block6: {
                IVariableBinding vb;
                FieldAccess fieldAccess;
                int length;
                block5: {
                    length = 0;
                    fieldAccess = fieldAccesses[i];
                    if (fieldAccess.getExpression() == null) break block5;
                    if (!(fieldAccess.getExpression() instanceof ThisExpression) || ((ThisExpression)fieldAccess.getExpression()).getQualifier() == null) break block6;
                    length = fieldAccess.getName().getStartPosition() - fieldAccess.getStartPosition();
                }
                if ((vb = MoveInnerToTopRefactoring.resolveFieldBinding(fieldAccess)) != null) {
                    String text = MoveInnerToTopRefactoring.isStatic((IBinding)vb) ? String.valueOf(this.getTypeOfEnclosingInstanceField()) + '.' : String.valueOf(this.createReadAccessForEnclosingInstance()) + '.';
                    int offset = fieldAccess.getStartPosition();
                    manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.update_field_access"), SimpleTextEdit.createReplace(offset, length, text));
                }
            }
            ++i;
        }
    }

    private void modifyAccessToMethodsFromEnclosingInstance(TextChangeManager manager, MethodInvocation[] methodInvocations) throws CoreException {
        int i = 0;
        while (i < methodInvocations.length) {
            block6: {
                IMethodBinding mb;
                MethodInvocation methodInvocation;
                int length;
                block5: {
                    length = 0;
                    methodInvocation = methodInvocations[i];
                    if (methodInvocation.getExpression() == null) break block5;
                    if (!(methodInvocation.getExpression() instanceof ThisExpression) || ((ThisExpression)methodInvocation.getExpression()).getQualifier() == null) break block6;
                    length = methodInvocation.getName().getStartPosition() - methodInvocation.getStartPosition();
                }
                if ((mb = MoveInnerToTopRefactoring.resolveMethodBinding(methodInvocation)) != null) {
                    String text = MoveInnerToTopRefactoring.isStatic((IBinding)mb) ? String.valueOf(this.getTypeOfEnclosingInstanceField()) + '.' : String.valueOf(this.createReadAccessForEnclosingInstance()) + '.';
                    int offset = methodInvocation.getStartPosition();
                    manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.update_method_invocation"), SimpleTextEdit.createReplace(offset, length, text));
                }
            }
            ++i;
        }
    }

    private TypeDeclaration getTypeDeclarationNode() throws JavaModelException {
        Selection selection = Selection.createFromStartLength(this.fType.getNameRange().getOffset(), this.fType.getNameRange().getLength());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, true);
        this.fASTManager.getAST(this.getInputTypeCu()).accept((ASTVisitor)analyzer);
        return MoveInnerToTopRefactoring.getInnerMostTypeDeclaration(analyzer.getFirstSelectedNode());
    }

    private void modifyConstructors(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        ASTNode[] constructorNodes = this.getConstructorDeclarationNodes(pm);
        int i = 0;
        while (i < constructorNodes.length) {
            ASTNode aSTNode = constructorNodes[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            MethodDeclaration decl = (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
            Assert.isTrue(decl.isConstructor());
            manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.add_parameter"), this.createAddParameterToConstructorEdit(decl));
            manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.set_enclosing_instance_field"), this.createSetEnclosingInstanceFieldEdit(decl));
            ++i;
        }
    }

    private TextEdit createSetEnclosingInstanceFieldEdit(MethodDeclaration decl) throws CoreException {
        Block body = decl.getBody();
        List statements = body.statements();
        if (statements.isEmpty()) {
            int indentationLevel = 1 + CodeRefactoringUtil.getIndentationLevel((ASTNode)decl, ResourceUtil.getFile(this.getInputTypeCu()));
            String src = this.createEnclosingInstanceInitialization();
            String formattedCode = ToolFactory.createCodeFormatter().format(src, indentationLevel, null, this.getLineSeperator());
            int offset = body.getStartPosition() + 1;
            return SimpleTextEdit.createInsert(offset, String.valueOf(this.getLineSeperator()) + formattedCode);
        }
        Statement first = (Statement)statements.get(0);
        if (first instanceof ConstructorInvocation) {
            ConstructorInvocation ci = (ConstructorInvocation)first;
            int offsetForArg = MoveInnerToTopRefactoring.computeOffsetForFirstArgumentOrParameter(ci.arguments(), this.getCompilationUnit((ASTNode)first), first.getStartPosition());
            String src = ci.arguments().isEmpty() ? this.fEnclosingInstanceFieldName : String.valueOf(this.fEnclosingInstanceFieldName) + ", ";
            return SimpleTextEdit.createInsert(offsetForArg, src);
        }
        int indentationLevel = CodeRefactoringUtil.getIndentationLevel((ASTNode)first, ResourceUtil.getFile(this.getInputTypeCu()));
        String formattedCode = this.format(this.createEnclosingInstanceInitialization(), indentationLevel);
        return SimpleTextEdit.createInsert(ASTNodes.getExclusiveEnd((ASTNode)first), String.valueOf(this.getLineSeperator()) + formattedCode);
    }

    private TextEdit createAddParameterToConstructorEdit(MethodDeclaration decl) throws JavaModelException {
        int scanStart = ASTNodes.getExclusiveEnd((ASTNode)decl.getName());
        int offset = MoveInnerToTopRefactoring.computeOffsetForFirstArgumentOrParameter(decl.parameters(), this.getInputTypeCu(), scanStart);
        String parameterDeclarationSource = this.createDeclarationForEnclosingInstanceConstructorParameter();
        if (decl.parameters().isEmpty()) {
            return SimpleTextEdit.createInsert(offset, parameterDeclarationSource);
        }
        return SimpleTextEdit.createInsert(offset, String.valueOf(parameterDeclarationSource) + ", ");
    }

    private void addConstructor(TextChangeManager manager) throws CoreException {
        String[] constLines = Strings.convertIntoLines(this.format(this.getNewConstructorSource(), 0));
        MemberEdit constEdit = new MemberEdit((IJavaElement)this.fType, 2, constLines, CodeFormatterUtil.getTabWidth());
        manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.add_constructor"), constEdit);
    }

    private String getNewConstructorSource() throws CoreException {
        String lineDelimiter = this.getLineSeperator();
        String constructorBody = CodeGeneration.getMethodBodyContent(this.fType.getCompilationUnit(), this.fType.getElementName(), this.fType.getElementName(), true, this.createEnclosingInstanceInitialization(), lineDelimiter);
        if (constructorBody == null) {
            constructorBody = "";
        }
        return String.valueOf(this.getNewConstructorComment()) + this.fType.getElementName() + '(' + this.createDeclarationForEnclosingInstanceConstructorParameter() + "){" + lineDelimiter + constructorBody + lineDelimiter + '}';
    }

    private String getNewConstructorComment() throws CoreException {
        if (this.fCodeGenerationSettings.createComments) {
            String comment = CodeGeneration.getMethodComment(this.getInputTypeCu(), this.fType.getElementName(), this.fType.getElementName(), new String[]{this.getTypeOfEnclosingInstanceField()}, new String[0], null, null, this.getLineSeperator());
            if (comment == null) {
                return "";
            }
            return comment;
        }
        return "";
    }

    private void addEnclosingInstanceDeclaration(TextChangeManager manager) throws CoreException {
        String[] fieldSource = new String[]{String.valueOf(this.createEnclosingInstanceAccessModifierStrings()) + this.createDeclarationForEnclosingInstance() + ';'};
        MemberEdit memberEdit = new MemberEdit((IJavaElement)this.fType, 2, fieldSource, CodeFormatterUtil.getTabWidth());
        manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.add_enclosing_instance_declaration"), memberEdit);
    }

    private String createEnclosingInstanceAccessModifierStrings() {
        if (this.fMarkInstanceFieldAsFinal) {
            return "private final ";
        }
        return "private ";
    }

    private int getEnclosingInstanceAccessModifiers() {
        if (this.fMarkInstanceFieldAsFinal) {
            return 18;
        }
        return 2;
    }

    private void removeUnusedTypeModifiers(TextChangeManager manager) throws CoreException {
        ISourceRange[] modifiesRanges = this.getRangesOfUnneededModifiers();
        int i = 0;
        while (i < modifiesRanges.length) {
            SimpleTextEdit edit = SimpleTextEdit.createDelete(modifiesRanges[i].getOffset(), modifiesRanges[i].getLength() + 1);
            manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.delete_Unused_Modifier"), edit);
            ++i;
        }
    }

    private void updateTypeReferences(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        ASTNode[] nodes = ASTNodeSearchUtil.findReferenceNodes((IJavaElement)this.fType, this.fASTManager, pm);
        int i = 0;
        while (i < nodes.length) {
            MultiTextEdit multiedit;
            ASTNode node = nodes[i];
            ICompilationUnit cu = this.getCompilationUnit(node);
            ImportDeclaration enclosingImport = MoveInnerToTopRefactoring.getEnclosingImportDeclaration(node);
            if (enclosingImport != null) {
                this.updateReferenceInImport(enclosingImport, node);
            } else {
                TextEdit edit = this.createReferenceUpdateEdit(node);
                if (edit != null) {
                    manager.get(cu).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.update_Type_Reference"), edit);
                    if (!this.getInputTypePackage().equals(cu.getParent())) {
                        this.fImportEditManager.addImportTo(this.getNewFullyQualifiedNameOfInputType(), cu);
                    }
                }
            }
            if (node.getParent() instanceof ClassInstanceCreation && (multiedit = this.createConstructorReferenceUpdateEdit((ClassInstanceCreation)node.getParent())) != null) {
                manager.get(cu).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.update_Constructor_Reference"), multiedit);
            }
            ++i;
        }
    }

    private ICompilationUnit getCompilationUnit(ASTNode node) {
        return this.fASTManager.getCompilationUnit(node);
    }

    private void updateReferenceInImport(ImportDeclaration enclosingImport, ASTNode node) throws JavaModelException {
        IBinding importBinding = enclosingImport.resolveBinding();
        if (!(importBinding instanceof ITypeBinding)) {
            return;
        }
        this.fImportEditManager.removeImportTo(this.getSourceOfImport(enclosingImport, importBinding), this.getCompilationUnit(node));
        this.fImportEditManager.addImportTo(this.getSourceForModifiedImport(node), this.getCompilationUnit(node));
    }

    private String getSourceOfImport(ImportDeclaration enclosingImport, IBinding importBinding) {
        String fullyQualifiedTypeName = Bindings.getFullyQualifiedImportName((ITypeBinding)importBinding);
        if (enclosingImport.isOnDemand()) {
            return String.valueOf(fullyQualifiedTypeName) + ".*";
        }
        return fullyQualifiedTypeName;
    }

    private String getSourceForModifiedImport(ASTNode node) throws JavaModelException {
        ImportDeclaration enclosingImport = MoveInnerToTopRefactoring.getEnclosingImportDeclaration(node);
        ICompilationUnit cu = this.getCompilationUnit(node);
        int start = enclosingImport.getName().getStartPosition();
        int end = ASTNodes.getExclusiveEnd((ASTNode)enclosingImport);
        String rawImportSource = cu.getBuffer().getText(start, end - start);
        String newFullyQualifiedName = new StringBuffer(rawImportSource).replace(0, ASTNodes.getExclusiveEnd(node) - start, this.getNewFullyQualifiedNameOfInputType()).toString();
        return newFullyQualifiedName.substring(0, newFullyQualifiedName.length() - 1);
    }

    private static ImportDeclaration getEnclosingImportDeclaration(ASTNode node) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.ImportDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ImportDeclaration)ASTNodes.getParent(node, clazz);
    }

    private TextEdit createReferenceUpdateEdit(ASTNode node) {
        if (node.getNodeType() == 40) {
            return this.createReferenceUpdateEditForName((Name)((QualifiedName)node));
        }
        if (node.getNodeType() == 43) {
            return this.createReferenceUpdateEditForName(((SimpleType)node).getName());
        }
        return null;
    }

    private TextEdit createReferenceUpdateEditForName(Name name) {
        if (name instanceof SimpleName) {
            return null;
        }
        if (this.isFullyQualifiedName(name)) {
            return SimpleTextEdit.createReplace(name.getStartPosition(), name.getLength(), this.getNewFullyQualifiedNameOfInputType());
        }
        return SimpleTextEdit.createReplace(name.getStartPosition(), name.getLength(), this.fType.getElementName());
    }

    private boolean isFullyQualifiedName(Name name) {
        ASTWithExistingFlattener flattener = new ASTWithExistingFlattener();
        name.accept((ASTVisitor)flattener);
        return flattener.getResult().equals(JavaElementUtil.createSignature((IMember)this.fType));
    }

    private String getNewFullyQualifiedNameOfInputType() {
        return String.valueOf(this.fType.getPackageFragment().getElementName()) + '.' + this.fType.getElementName();
    }

    private void cutType(TextChangeManager manager) throws CoreException {
        this.fCutTypeEdit = new DeleteSourceReferenceEdit((ISourceReference)this.fType, this.getInputTypeCu());
        manager.get(this.getInputTypeCu()).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.cut_type"), this.fCutTypeEdit);
    }

    private ICompilationUnit getInputTypeCu() {
        return WorkingCopyUtil.getWorkingCopyIfExists(this.fType.getCompilationUnit());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IChange createCompilationUnitForMovedType(IProgressMonitor pm) throws CoreException {
        CreateTextFileChange createTextFileChange;
        ICompilationUnit newCuWC = null;
        try {
            newCuWC = WorkingCopyUtil.getNewWorkingCopy(this.getInputTypePackage(), this.getNameForNewCu());
            String source = this.createSourceForNewCu(newCuWC, pm);
            createTextFileChange = new CreateTextFileChange(this.createPathForNewCu(), source, true);
            Object var4_5 = null;
            if (newCuWC == null) return createTextFileChange;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (newCuWC == null) throw throwable;
            newCuWC.destroy();
            throw throwable;
        }
        newCuWC.destroy();
        return createTextFileChange;
    }

    private String createSourceForNewCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        newCu.getBuffer().setContents(CodeGeneration.getCompilationUnitContent(newCu, null, this.createTypeSource((IProgressMonitor)new SubProgressMonitor(pm, 1)).toString(), this.getLineSeperator()));
        this.addImportsToNewCu(newCu, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
        return newCu.getSource();
    }

    private void addImportsToNewCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException, JavaModelException {
        ImportsStructure is = new ImportsStructure(newCu, this.fCodeGenerationSettings.importOrder, this.fCodeGenerationSettings.importThreshold, true);
        IType[] typesReferencedInInputType = ReferenceFinderUtil.getTypesReferencedIn(new IJavaElement[]{this.fType}, pm);
        int i = 0;
        while (i < typesReferencedInInputType.length) {
            is.addImport(JavaModelUtil.getFullyQualifiedName(typesReferencedInInputType[i]));
            ++i;
        }
        is.create(false, pm);
    }

    private String createTypeSource(IProgressMonitor pm) throws CoreException {
        return this.allignSourceBlock(this.computeUnalignedTypeSourceBlock(pm));
    }

    private String computeUnalignedTypeSourceBlock(IProgressMonitor pm) throws CoreException {
        if (!this.isInputTypeStatic()) {
            TextChange textChange = this.fChangeManager.get(this.getInputTypeCu());
            textChange.getPreviewContent();
            return ((DeleteSourceReferenceEdit)textChange.getExecutedTextEdit(this.fCutTypeEdit)).getContent();
        }
        String updatedTypeSource = MemberMoveUtil.computeNewSource((IMember)this.fType, pm, this.fImportEditManager, (IMember[])new IType[]{this.fType});
        StringBuffer updatedTypeSourceBuffer = new StringBuffer(updatedTypeSource);
        ISourceRange[] ranges = this.getRangesOfUnneededModifiers();
        SourceRange.reverseSortByOffset(ranges);
        int typeoffset = this.getTypeDefinitionOffset();
        int i = 0;
        while (i < ranges.length) {
            ISourceRange iSourceRange = ranges[i];
            int offset = iSourceRange.getOffset() - typeoffset;
            updatedTypeSourceBuffer.delete(offset, offset + iSourceRange.getLength() + 1);
            ++i;
        }
        return updatedTypeSourceBuffer.toString();
    }

    private String allignSourceBlock(String typeCodeBlock) throws CoreException {
        CodeBlock cb = new CodeBlock(typeCodeBlock);
        StringBuffer buffer = new StringBuffer();
        cb.fill(buffer, "", this.getLineSeperator());
        return buffer.toString().trim();
    }

    private int getTypeDefinitionOffset() throws JavaModelException {
        return SourceRangeComputer.computeSourceRange((ISourceReference)this.fType, this.fType.getCompilationUnit().getSource()).getOffset();
    }

    private ISourceRange[] getRangesOfUnneededModifiers() throws JavaModelException {
        try {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(this.fType.getCompilationUnit().getBuffer().getCharacters());
            scanner.resetTo(this.fType.getSourceRange().getOffset(), this.fType.getNameRange().getOffset());
            ArrayList<SourceRange> result = new ArrayList<SourceRange>(2);
            int token = scanner.getNextToken();
            while (token != 158) {
                switch (token) {
                    case 94: 
                    case 101: 
                    case 102: {
                        result.add(new SourceRange(scanner.getCurrentTokenStartPosition(), scanner.getCurrentTokenEndPosition() - scanner.getCurrentTokenStartPosition() + 1));
                    }
                }
                token = scanner.getNextToken();
            }
            return result.toArray(new ISourceRange[result.size()]);
        }
        catch (InvalidInputException invalidInputException) {
            return new ISourceRange[0];
        }
    }

    private IPath createPathForNewCu() throws JavaModelException {
        return ResourceUtil.getFile(this.getInputTypeCu()).getFullPath().removeLastSegments(1).append(this.getNameForNewCu());
    }

    private String getNameForNewCu() {
        return String.valueOf(this.fType.getElementName()) + ".java";
    }

    private String getLineSeperator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
        }
        catch (JavaModelException javaModelException) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private void updateConstructorReferences(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        ASTNode[] constructorReferenceNodes = ConstructorReferenceFinder.getConstructorReferenceNodes(this.fType, this.fASTManager, pm);
        int i = 0;
        while (i < constructorReferenceNodes.length) {
            ASTNode refNode = constructorReferenceNodes[i];
            if (refNode instanceof SuperConstructorInvocation) {
                this.updateConstructorReferenceInSuperCall(manager, (SuperConstructorInvocation)refNode);
            }
            ++i;
        }
    }

    private void updateConstructorReferenceInSuperCall(TextChangeManager manager, SuperConstructorInvocation sci) throws CoreException {
        MultiTextEdit textEdit = this.createConstructorReferenceUpdateEdit(sci);
        if (textEdit != null) {
            manager.get(this.getCompilationUnit((ASTNode)sci)).addTextEdit(RefactoringCoreMessages.getString("MoveInnerToTopRefactoring.update_Constructor_Reference"), textEdit);
        }
    }

    private ASTNode[] getConstructorDeclarationNodes(IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        ISearchPattern pattern = MoveInnerToTopRefactoring.createConstructorSearchPattern(this.fType, 0);
        if (pattern == null) {
            return new ASTNode[0];
        }
        return ASTNodeSearchUtil.searchNodes(scope, pattern, this.fASTManager, pm);
    }

    private MultiTextEdit createConstructorReferenceUpdateEdit(SuperConstructorInvocation sci) throws JavaModelException {
        MultiTextEdit multi = new MultiTextEdit();
        TextEdit insertExpression = this.createInsertExpressionAsParamaterEdit(sci);
        if (insertExpression != null) {
            multi.add(insertExpression);
        }
        if (sci.getExpression() != null) {
            multi.add(this.createCutExpressionEdit(sci));
        }
        if (!multi.hasChildren()) {
            return null;
        }
        return multi;
    }

    private MultiTextEdit createConstructorReferenceUpdateEdit(ClassInstanceCreation cic) throws JavaModelException {
        MultiTextEdit multi = new MultiTextEdit();
        TextEdit insertExpression = this.createInsertExpressionAsParamaterEdit(cic);
        if (insertExpression != null) {
            multi.add(insertExpression);
        }
        if (cic.getExpression() != null) {
            multi.add(this.createCutExpressionEdit(cic));
        }
        if (!multi.hasChildren()) {
            return null;
        }
        return multi;
    }

    private TextEdit createInsertExpressionAsParamaterEdit(ClassInstanceCreation cic) throws JavaModelException {
        String text = this.createEnclosingInstanceCreationString(cic);
        if (text == null) {
            return null;
        }
        if (!cic.arguments().isEmpty()) {
            text = String.valueOf(text) + ", ";
        }
        return SimpleTextEdit.createInsert(this.computeOffsetForFirstArgument(cic), text);
    }

    private TextEdit createInsertExpressionAsParamaterEdit(SuperConstructorInvocation sci) throws JavaModelException {
        String text = this.createEnclosingInstanceCreationString(sci);
        if (text == null) {
            return null;
        }
        if (!sci.arguments().isEmpty()) {
            text = String.valueOf(text) + ", ";
        }
        return SimpleTextEdit.createInsert(this.computeOffsetForFirstArgument(sci), text);
    }

    private TextEdit createCutExpressionEdit(ClassInstanceCreation cic) throws JavaModelException {
        return this.createCutExpressionEdit(cic.getExpression(), 32);
    }

    private TextEdit createCutExpressionEdit(SuperConstructorInvocation sci) throws JavaModelException {
        return this.createCutExpressionEdit(sci.getExpression(), 33);
    }

    private TextEdit createCutExpressionEdit(Expression expression, int separatingToken) throws JavaModelException {
        try {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(this.getCompilationUnitSource((ASTNode)expression));
            scanner.resetTo(ASTNodes.getExclusiveEnd((ASTNode)expression), scanner.getSource().length);
            int token = scanner.getNextToken();
            Assert.isTrue(token == 6);
            token = scanner.getNextToken();
            Assert.isTrue(token == separatingToken);
            int cutStart = expression.getStartPosition();
            int cutEnd = scanner.getCurrentTokenStartPosition();
            int cutLength = cutEnd - cutStart;
            return SimpleTextEdit.createDelete(cutStart, cutLength);
        }
        catch (InvalidInputException e) {
            throw new JavaModelException((Throwable)e, 984);
        }
    }

    private char[] getCompilationUnitSource(ASTNode node) throws JavaModelException {
        return this.getCompilationUnit(node).getBuffer().getCharacters();
    }

    private int computeOffsetForFirstArgument(ClassInstanceCreation cic) throws JavaModelException {
        return MoveInnerToTopRefactoring.computeOffsetForFirstArgumentOrParameter(cic.arguments(), this.getCompilationUnit((ASTNode)cic), ASTNodes.getExclusiveEnd((ASTNode)cic.getName()));
    }

    private int computeOffsetForFirstArgument(SuperConstructorInvocation sci) throws JavaModelException {
        int scanStart = sci.getExpression() == null ? sci.getStartPosition() : ASTNodes.getExclusiveEnd((ASTNode)sci.getExpression());
        return MoveInnerToTopRefactoring.computeOffsetForFirstArgumentOrParameter(sci.arguments(), this.getCompilationUnit((ASTNode)sci), scanStart);
    }

    private static int computeOffsetForFirstArgumentOrParameter(List arguments, ICompilationUnit cu, int scanStartPosition) throws JavaModelException {
        try {
            if (!arguments.isEmpty()) {
                return ((ASTNode)arguments.get(0)).getStartPosition();
            }
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(cu.getBuffer().getCharacters());
            scanner.resetTo(scanStartPosition, scanner.getSource().length);
            int token = scanner.getNextToken();
            while (token != 7) {
                token = scanner.getNextToken();
            }
            Assert.isTrue(token == 7);
            return scanner.getCurrentTokenEndPosition() + 1;
        }
        catch (InvalidInputException e) {
            throw new JavaModelException((Throwable)e, 984);
        }
    }

    private String createEnclosingInstanceCreationString(ClassInstanceCreation cic) throws JavaModelException {
        Expression expression = cic.getExpression();
        if (expression != null) {
            return this.getExpressionString(expression);
        }
        if (this.isInputTypeStatic()) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType((ASTNode)cic)) {
            return THIS_KEYWORD;
        }
        if (this.isInsideInputType((ASTNode)cic)) {
            return this.createReadAccessForEnclosingInstance();
        }
        if (this.isInsideTypeNestedInDeclaringType((ASTNode)cic)) {
            return String.valueOf(this.getEnclosingType().getElementName()) + '.' + THIS_KEYWORD;
        }
        return null;
    }

    private String createEnclosingInstanceCreationString(SuperConstructorInvocation sci) throws JavaModelException {
        Expression expression = sci.getExpression();
        if (expression != null) {
            return this.getExpressionString(expression);
        }
        if (this.isInputTypeStatic()) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType((ASTNode)sci)) {
            return THIS_KEYWORD;
        }
        if (this.isInsideInputType((ASTNode)sci)) {
            return this.createReadAccessForEnclosingInstance();
        }
        if (this.isInsideTypeNestedInDeclaringType((ASTNode)sci)) {
            return String.valueOf(this.getEnclosingType().getElementName()) + '.' + THIS_KEYWORD;
        }
        return null;
    }

    private String getExpressionString(Expression expression) throws JavaModelException {
        return this.getCompilationUnit((ASTNode)expression).getBuffer().getText(expression.getStartPosition(), expression.getLength());
    }

    private boolean isInsideSubclassOfDeclaringType(ASTNode node) {
        AnonymousClassDeclaration anon;
        boolean isAnonymous;
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        TypeDeclaration typeDeclar = MoveInnerToTopRefactoring.getInnerMostTypeDeclaration(node);
        Assert.isNotNull(typeDeclar);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        boolean bl = isAnonymous = (anon = (AnonymousClassDeclaration)ASTNodes.getParent(node, clazz)) != null && ASTNodes.isParent((ASTNode)anon, (ASTNode)typeDeclar);
        if (isAnonymous) {
            return this.isSubclassBindingOfEnclosingType(anon.resolveBinding());
        }
        return this.isSubclassBindingOfEnclosingType(typeDeclar.resolveBinding());
    }

    private boolean isSubclassBindingOfEnclosingType(ITypeBinding binding) {
        while (binding != null) {
            if (this.isEnclosingTypeBinding(binding)) {
                return true;
            }
            binding = binding.getSuperclass();
        }
        return false;
    }

    private boolean isInsideTypeNestedInDeclaringType(ASTNode node) {
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        TypeDeclaration typeDeclar = MoveInnerToTopRefactoring.getInnerMostTypeDeclaration(node);
        Assert.isNotNull(typeDeclar);
        ITypeBinding enclosing = typeDeclar.resolveBinding();
        while (enclosing != null) {
            if (this.isEnclosingTypeBinding(enclosing)) {
                return true;
            }
            enclosing = enclosing.getDeclaringClass();
        }
        return false;
    }

    private boolean isInsideInputType(ASTNode node) throws JavaModelException {
        Assert.isTrue(node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation);
        ISourceRange range = this.fType.getSourceRange();
        return node.getStartPosition() >= range.getOffset() && ASTNodes.getExclusiveEnd(node) <= range.getOffset() + range.getLength();
    }

    private static TypeDeclaration getInnerMostTypeDeclaration(ASTNode node) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent(node, clazz);
    }

    private boolean isEnclosingTypeBinding(ITypeBinding binding) {
        return MoveInnerToTopRefactoring.isCorrespondingTypeBinding(binding, this.getEnclosingType());
    }

    private static boolean isCorrespondingTypeBinding(ITypeBinding binding, IType type) {
        if (binding == null) {
            return false;
        }
        return Bindings.getFullyQualifiedName(binding).equals(JavaElementUtil.createSignature((IMember)type));
    }

    private String createReadAccessForEnclosingInstance() {
        return "this." + this.fEnclosingInstanceFieldName;
    }

    private String createEnclosingInstanceInitialization() throws JavaModelException {
        return String.valueOf(this.createReadAccessForEnclosingInstance()) + '=' + this.getNameForEnclosingInstanceConstructorParameter() + ';';
    }

    private String getNameForEnclosingInstanceConstructorParameter() throws JavaModelException {
        IType enclosingType = this.getEnclosingType();
        String[] excludedNames = MoveInnerToTopRefactoring.getParameterNamesOfAllConstructors(this.fType);
        String qualifiedTypeName = this.getTypeOfEnclosingInstanceField();
        String packageName = enclosingType.getPackageFragment().getElementName();
        String[] suggestedNames = NamingConventions.suggestArgumentNames((IJavaProject)enclosingType.getJavaProject(), (String)packageName, (String)qualifiedTypeName, (int)0, (String[])excludedNames);
        if (suggestedNames.length > 0) {
            return suggestedNames[0];
        }
        return this.fEnclosingInstanceFieldName;
    }

    private static String[] getParameterNamesOfAllConstructors(IType type) throws JavaModelException {
        IMethod[] construcotrs = JavaElementUtil.getAllConstructors(type);
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < construcotrs.length) {
            result.addAll(Arrays.asList(construcotrs[i].getParameterNames()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private String createDeclarationForEnclosingInstance() {
        return String.valueOf(this.getTypeOfEnclosingInstanceField()) + ' ' + this.fEnclosingInstanceFieldName;
    }

    private String createDeclarationForEnclosingInstanceConstructorParameter() throws JavaModelException {
        return String.valueOf(this.getTypeOfEnclosingInstanceField()) + ' ' + this.getNameForEnclosingInstanceConstructorParameter();
    }

    private String getTypeOfEnclosingInstanceField() {
        return JavaModelUtil.getTypeQualifiedName(this.getEnclosingType());
    }

    private static ISearchPattern createConstructorSearchPattern(IType type, int limitTo) throws JavaModelException {
        return RefactoringSearchEngine.createSearchPattern((IJavaElement[])JavaElementUtil.getAllConstructors(type), limitTo);
    }

    private static ITypeBinding getDeclaringTypeBinding(MethodInvocation methodInvocation) {
        IMethodBinding binding = MoveInnerToTopRefactoring.resolveMethodBinding(methodInvocation);
        if (binding == null) {
            return null;
        }
        return binding.getDeclaringClass();
    }

    private static ITypeBinding getDeclaringTypeBinding(FieldAccess fieldAccess) {
        IVariableBinding varBinding = MoveInnerToTopRefactoring.resolveFieldBinding(fieldAccess);
        if (varBinding == null) {
            return null;
        }
        return varBinding.getDeclaringClass();
    }

    private static IMethodBinding resolveMethodBinding(MethodInvocation method) {
        IBinding binding = method.getName().resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    private static IVariableBinding resolveFieldBinding(FieldAccess fieldAccess) {
        return MoveInnerToTopRefactoring.resolveFieldBinding(fieldAccess.getName());
    }

    private static IVariableBinding resolveFieldBinding(SimpleName simpleName) {
        IBinding binding = simpleName.resolveBinding();
        if (binding instanceof IVariableBinding) {
            return (IVariableBinding)binding;
        }
        return null;
    }

    private String format(String src, int indentationLevel) {
        return ToolFactory.createCodeFormatter().format(src, indentationLevel, null, this.getLineSeperator());
    }

    private static class MemberAccessNodeCollector
    extends ASTVisitor {
        private final List fMethodAccesses = new ArrayList(0);
        private final List fFieldAccesses = new ArrayList(0);
        private final List fSimpleNames = new ArrayList(0);
        private final IType fType;

        MemberAccessNodeCollector(IType type) {
            this.fType = type;
        }

        MethodInvocation[] getMethodInvocations() {
            return this.fMethodAccesses.toArray(new MethodInvocation[this.fMethodAccesses.size()]);
        }

        FieldAccess[] getFieldAccesses() {
            return this.fFieldAccesses.toArray(new FieldAccess[this.fFieldAccesses.size()]);
        }

        SimpleName[] getSimpleNames() {
            return this.fSimpleNames.toArray(new SimpleName[this.fSimpleNames.size()]);
        }

        public boolean visit(MethodInvocation node) {
            ITypeBinding declaringClassBinding = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaringClassBinding != null && MoveInnerToTopRefactoring.isCorrespondingTypeBinding(declaringClassBinding, this.fType)) {
                this.fMethodAccesses.add(node);
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(FieldAccess node) {
            ITypeBinding declaringClassBinding = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaringClassBinding != null && MoveInnerToTopRefactoring.isCorrespondingTypeBinding(declaringClassBinding, this.fType)) {
                this.fFieldAccesses.add(node);
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(SimpleName node) {
            IVariableBinding vb;
            if (node.getParent() instanceof QualifiedName) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding && (vb = (IVariableBinding)binding).isField() && MoveInnerToTopRefactoring.isCorrespondingTypeBinding(vb.getDeclaringClass(), this.fType)) {
                this.fSimpleNames.add(node);
                return false;
            }
            return super.visit(node);
        }
    }
}

