/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;

class MethodInvocationFinder {
    MethodInvocationFinder() {
    }

    public static ISourceRange[] findMessageSendRanges(SearchResultGroup searchResultGroup) throws JavaModelException {
        ICompilationUnit cu = searchResultGroup.getCompilationUnit();
        if (cu == null) {
            return new ISourceRange[0];
        }
        return MethodInvocationFinder.findMessageSendRanges(searchResultGroup.getSearchResults(), cu);
    }

    public static ISourceRange[] findMessageSendRanges(SearchResult[] searchResults, ICompilationUnit cu) throws JavaModelException {
        if (searchResults.length == 0) {
            return new ISourceRange[0];
        }
        MethodInvocationFinderVisitor visitor = new MethodInvocationFinderVisitor(searchResults);
        AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)false).accept((ASTVisitor)visitor);
        return visitor.getFoundRanges();
    }

    private static class MethodInvocationFinderVisitor
    extends ASTVisitor {
        private Collection fFoundRanges;
        private SearchResult[] fSearchResults;

        MethodInvocationFinderVisitor(SearchResult[] searchResults) {
            this.fSearchResults = searchResults;
            this.fFoundRanges = new ArrayList();
        }

        ISourceRange[] getFoundRanges() {
            return this.fFoundRanges.toArray(new ISourceRange[this.fFoundRanges.size()]);
        }

        private static boolean areReportedForSameNode(MethodInvocation node, SearchResult searchResult) {
            if (node.getStartPosition() > searchResult.getStart()) {
                return false;
            }
            if (ASTNodes.getExclusiveEnd((ASTNode)node) < searchResult.getEnd()) {
                return false;
            }
            return node.getName().getStartPosition() == searchResult.getStart();
        }

        private boolean isReported(MethodInvocation node) {
            int i = 0;
            while (i < this.fSearchResults.length) {
                if (MethodInvocationFinderVisitor.areReportedForSameNode(node, this.fSearchResults[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean visit(MethodInvocation node) {
            if (!this.isReported(node)) {
                return true;
            }
            int start = node.getStartPosition();
            int end = ASTNodes.getExclusiveEnd((ASTNode)node.getName());
            int length = end - start;
            this.fFoundRanges.add(new SourceRange(start, length));
            return true;
        }
    }
}

