/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultCollector;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.structure.FieldReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportEditManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.MethodInvocationFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.TypeReferenceFinder;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class MemberMoveUtil {
    private final ImportEditManager fImportManager;
    private final Set fMovedMembers;

    private MemberMoveUtil(ImportEditManager importManager, IMember[] movedMembers) {
        Assert.isNotNull(importManager);
        this.fImportManager = importManager;
        this.fMovedMembers = new HashSet<IMember>(Arrays.asList(movedMembers));
    }

    public static String computeNewSource(IMember member, IProgressMonitor pm, ImportEditManager manager, IMember[] allMovedMembers) throws JavaModelException {
        MemberMoveUtil inst = new MemberMoveUtil(manager, allMovedMembers);
        return inst.computeNewSource(member, pm);
    }

    private String computeNewSource(IMember member, IProgressMonitor pm) throws JavaModelException {
        String originalSource = SourceRangeComputer.computeSource((ISourceReference)member);
        StringBuffer modifiedSource = new StringBuffer(originalSource);
        Map accessModifications = this.getStaticMemberAccessesInMovedMember(member, pm);
        ISourceRange[] ranges = accessModifications.keySet().toArray(new ISourceRange[accessModifications.keySet().size()]);
        ISourceRange[] sortedRanges = SourceRange.reverseSortByOffset(ranges);
        ISourceRange originalRange = SourceRangeComputer.computeSourceRange((ISourceReference)member, member.getCompilationUnit().getSource());
        int i = 0;
        while (i < sortedRanges.length) {
            int start = sortedRanges[i].getOffset() - originalRange.getOffset();
            int end = start + sortedRanges[i].getLength();
            modifiedSource.replace(start, end, (String)accessModifications.get(sortedRanges[i]));
            ++i;
        }
        return modifiedSource.toString();
    }

    private Map getStaticMemberAccessesInMovedMember(IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        HashMap resultMap = new HashMap();
        resultMap.putAll(this.getFieldAccessModificationsInMovedMember(member, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        resultMap.putAll(this.getMethodSendsInMovedMember(member, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        resultMap.putAll(this.getTypeReferencesInMovedMember(member, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return resultMap;
    }

    private Map getFieldAccessModificationsInMovedMember(IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        HashMap result = new HashMap();
        IField[] fields = ReferenceFinderUtil.getFieldsReferencedIn((IJavaElement[])new IMember[]{member}, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ICompilationUnit cu = MemberMoveUtil.getWorkingCopyForDeclaringTypeCu(member);
        IMember[] interestingFields = this.getMembersThatNeedReferenceConversion((IMember[])fields);
        int i = 0;
        while (i < interestingFields.length) {
            IField field = (IField)interestingFields[i];
            this.fImportManager.addImportTo(field.getDeclaringType(), cu);
            String newSource = String.valueOf(field.getDeclaringType().getElementName()) + "." + field.getElementName();
            SearchResult[] searchResults = MemberMoveUtil.findReferencesInMember(member, (IMember)field, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            ISourceRange[] ranges = FieldReferenceFinder.findFieldReferenceRanges(searchResults, cu);
            MemberMoveUtil.putAllToMap(result, newSource, ranges);
            ++i;
        }
        return result;
    }

    private Map getMethodSendsInMovedMember(IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        HashMap result = new HashMap();
        IMethod[] methods = ReferenceFinderUtil.getMethodsReferencedIn((IJavaElement[])new IMember[]{member}, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ICompilationUnit cu = MemberMoveUtil.getWorkingCopyForDeclaringTypeCu(member);
        IMember[] interestingMethods = this.getMembersThatNeedReferenceConversion((IMember[])methods);
        int i = 0;
        while (i < interestingMethods.length) {
            IMethod method = (IMethod)interestingMethods[i];
            this.fImportManager.addImportTo(method.getDeclaringType(), cu);
            String newSource = String.valueOf(method.getDeclaringType().getElementName()) + "." + method.getElementName();
            SearchResult[] searchResults = MemberMoveUtil.findReferencesInMember(member, (IMember)method, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            ISourceRange[] ranges = MethodInvocationFinder.findMessageSendRanges(searchResults, cu);
            MemberMoveUtil.putAllToMap(result, newSource, ranges);
            ++i;
        }
        return result;
    }

    private Map getTypeReferencesInMovedMember(IMember member, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        HashMap result = new HashMap();
        IType[] types = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])new IMember[]{member}, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ICompilationUnit cu = MemberMoveUtil.getWorkingCopyForDeclaringTypeCu(member);
        IMember[] interestingTypes = this.getMembersThatNeedReferenceConversion((IMember[])types);
        int i = 0;
        while (i < interestingTypes.length) {
            IType type = (IType)interestingTypes[i];
            this.fImportManager.addImportTo(type.getDeclaringType(), cu);
            String newSource = String.valueOf(type.getDeclaringType().getElementName()) + "." + type.getElementName();
            SearchResult[] searchResults = MemberMoveUtil.findReferencesInMember(member, (IMember)type, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            ISourceRange[] ranges = TypeReferenceFinder.findTypeReferenceRanges(searchResults, cu);
            MemberMoveUtil.putAllToMap(result, newSource, ranges);
            ++i;
        }
        return result;
    }

    private static ICompilationUnit getWorkingCopyForDeclaringTypeCu(IMember member) {
        return WorkingCopyUtil.getWorkingCopyIfExists(member.getDeclaringType().getCompilationUnit());
    }

    private IMember[] getMembersThatNeedReferenceConversion(IMember[] members) throws JavaModelException {
        HashSet<IMember> memberSet = new HashSet<IMember>();
        int i = 0;
        while (i < members.length) {
            if (this.willNeedToConvertReferenceTo(members[i])) {
                memberSet.add(members[i]);
            }
            ++i;
        }
        return memberSet.toArray(new IMember[memberSet.size()]);
    }

    private boolean willNeedToConvertReferenceTo(IMember member) throws JavaModelException {
        if (!member.exists()) {
            return false;
        }
        if (this.fMovedMembers.contains(member)) {
            return false;
        }
        return JdtFlags.isStatic(member);
    }

    private static SearchResult[] findReferencesInMember(IMember scopeMember, IMember referenceMember, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{scopeMember});
        SearchResultCollector collector = new SearchResultCollector(pm);
        new SearchEngine().search(ResourcesPlugin.getWorkspace(), (IJavaElement)referenceMember, 2, scope, (IJavaSearchResultCollector)collector);
        List results = collector.getResults();
        SearchResult[] searchResults = results.toArray(new SearchResult[results.size()]);
        return searchResults;
    }

    private static void putAllToMap(Map result, String newSource, ISourceRange[] ranges) {
        int i = 0;
        while (i < ranges.length) {
            result.put(ranges[i], newSource);
            ++i;
        }
    }
}

