/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportEdit;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class ImportEditManager {
    private final Map fImportEdits;
    private final CodeGenerationSettings fPreferenceSettings;

    public ImportEditManager(CodeGenerationSettings preferenceSettings) {
        Assert.isNotNull(preferenceSettings);
        this.fPreferenceSettings = preferenceSettings;
        this.fImportEdits = new HashMap();
    }

    public boolean hasImportEditFor(ICompilationUnit cu) throws JavaModelException {
        return this.fImportEdits.containsKey(cu);
    }

    public ImportEdit getImportEdit(ICompilationUnit cu) throws JavaModelException {
        if (this.hasImportEditFor(cu)) {
            return (ImportEdit)this.fImportEdits.get(cu);
        }
        ImportEdit edit = new ImportEdit(cu, this.fPreferenceSettings);
        this.fImportEdits.put(cu, edit);
        return edit;
    }

    public void addImportTo(String fullyQualifiedName, ICompilationUnit cu) throws JavaModelException {
        this.getImportEdit(cu).addImport(fullyQualifiedName);
    }

    public void addImportTo(IType type, ICompilationUnit cu) throws JavaModelException {
        this.addImportTo(JavaModelUtil.getFullyQualifiedName(type), cu);
    }

    public void removeImportTo(IType type, ICompilationUnit cu) throws JavaModelException {
        this.removeImportTo(JavaModelUtil.getFullyQualifiedName(type), cu);
    }

    public void removeImportTo(String fullyQualifiedName, ICompilationUnit cu) throws JavaModelException {
        this.getImportEdit(cu).removeImport(fullyQualifiedName);
    }

    public void fill(TextChangeManager manager) throws CoreException {
        Iterator iter = this.fImportEdits.keySet().iterator();
        while (iter.hasNext()) {
            ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists((ICompilationUnit)iter.next());
            ImportEdit edit = (ImportEdit)this.fImportEdits.get(cu);
            if (edit == null || edit.isEmpty()) continue;
            manager.get(cu).addTextEdit(RefactoringCoreMessages.getString("ImportEditManager.update_Imports"), edit);
        }
    }

    public void clear() {
        this.fImportEdits.clear();
    }
}

