/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;

class FieldReferenceFinder {
    FieldReferenceFinder() {
    }

    public static ISourceRange[] findFieldReferenceRanges(SearchResultGroup searchResultGroup) throws JavaModelException {
        ICompilationUnit cu = searchResultGroup.getCompilationUnit();
        if (cu == null) {
            return new ISourceRange[0];
        }
        return FieldReferenceFinder.findFieldReferenceRanges(searchResultGroup.getSearchResults(), cu);
    }

    public static ISourceRange[] findFieldReferenceRanges(SearchResult[] searchResults, ICompilationUnit cu) throws JavaModelException {
        Assert.isNotNull(searchResults);
        if (searchResults.length == 0) {
            return new ISourceRange[0];
        }
        FieldReferenceFinderVisitor visitor = new FieldReferenceFinderVisitor(searchResults);
        AST.parseCompilationUnit((ICompilationUnit)cu, (boolean)false).accept((ASTVisitor)visitor);
        return visitor.getFoundRanges();
    }

    private static class FieldReferenceFinderVisitor
    extends ASTVisitor {
        private Collection fFoundRanges = new ArrayList();
        private SearchResult[] fSearchResults;

        FieldReferenceFinderVisitor(SearchResult[] searchResults) {
            this.fSearchResults = searchResults;
        }

        ISourceRange[] getFoundRanges() {
            return this.fFoundRanges.toArray(new ISourceRange[this.fFoundRanges.size()]);
        }

        private static boolean areReportedForSameNode(SimpleName node, SearchResult searchResult) {
            if (node.getStartPosition() != searchResult.getStart()) {
                return false;
            }
            return ASTNodes.getExclusiveEnd((ASTNode)node) == searchResult.getEnd();
        }

        private static boolean areReportedForSameNode(FieldAccess node, SearchResult searchResult) {
            if (node.getStartPosition() > searchResult.getStart()) {
                return false;
            }
            if (ASTNodes.getExclusiveEnd((ASTNode)node) != searchResult.getEnd()) {
                return false;
            }
            return node.getName().getStartPosition() == searchResult.getStart();
        }

        private static boolean areReportedForSameNode(QualifiedName node, SearchResult searchResult) {
            if (node.getStartPosition() > searchResult.getStart()) {
                return false;
            }
            return ASTNodes.getExclusiveEnd((ASTNode)node) == searchResult.getEnd();
        }

        private boolean isReported(FieldAccess node) {
            int i = 0;
            while (i < this.fSearchResults.length) {
                if (FieldReferenceFinderVisitor.areReportedForSameNode(node, this.fSearchResults[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isReported(QualifiedName node) {
            int i = 0;
            while (i < this.fSearchResults.length) {
                if (FieldReferenceFinderVisitor.areReportedForSameNode(node, this.fSearchResults[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isReported(SimpleName node) {
            int i = 0;
            while (i < this.fSearchResults.length) {
                if (FieldReferenceFinderVisitor.areReportedForSameNode(node, this.fSearchResults[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean visit(FieldAccess node) {
            if (!this.isReported(node)) {
                return true;
            }
            this.fFoundRanges.add(new SourceRange((ASTNode)node));
            return false;
        }

        public boolean visit(QualifiedName node) {
            if (!this.isReported(node)) {
                return true;
            }
            this.fFoundRanges.add(new SourceRange((ASTNode)node));
            return false;
        }

        public boolean visit(SimpleName node) {
            if (!this.isReported(node)) {
                return true;
            }
            this.fFoundRanges.add(new SourceRange((ASTNode)node));
            return false;
        }
    }
}

