/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.DeleteSourceReferenceEdit;
import org.eclipse.jdt.internal.corext.refactoring.reorg.SourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.JavaElementCommentFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.UseSupertypeWherePossibleUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;

public class ExtractInterfaceRefactoring
extends Refactoring {
    private static final String INTERFACE_METHOD_MODIFIERS = "public abstract ";
    private final CodeGenerationSettings fCodeGenerationSettings;
    private final ASTNodeMappingManager fASTMappingManager;
    private IType fInputType;
    private String fNewInterfaceName;
    private IMember[] fExtractedMembers;
    private boolean fReplaceOccurrences = false;
    private TextChangeManager fChangeManager;
    private Set fUpdatedTypeReferenceNodes;

    public ExtractInterfaceRefactoring(IType type, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(type);
        Assert.isNotNull(codeGenerationSettings);
        this.fInputType = type;
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fExtractedMembers = new IMember[0];
        this.fASTMappingManager = new ASTNodeMappingManager();
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.name");
    }

    public IType getInputType() {
        return this.fInputType;
    }

    public String getNewInterfaceName() {
        return this.fNewInterfaceName;
    }

    public boolean isReplaceOccurrences() {
        return this.fReplaceOccurrences;
    }

    public void setNewInterfaceName(String newInterfaceName) {
        Assert.isNotNull(newInterfaceName);
        this.fNewInterfaceName = newInterfaceName;
    }

    public void setReplaceOccurrences(boolean replaceOccurrences) {
        this.fReplaceOccurrences = replaceOccurrences;
    }

    public void setExtractedMembers(IMember[] extractedMembers) throws JavaModelException {
        Assert.isTrue(this.areAllExtractableMembersOfClass(extractedMembers));
        this.fExtractedMembers = extractedMembers;
    }

    public IMember[] getExtractableMembers() throws JavaModelException {
        ArrayList<IJavaElement> members = new ArrayList<IJavaElement>();
        IJavaElement[] children = this.fInputType.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IMember && ExtractInterfaceRefactoring.isExtractableMember((IMember)children[i])) {
                members.add(children[i]);
            }
            ++i;
        }
        return members.toArray(new IMember[members.size()]);
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        RefactoringStatus result = Checks.checkAvailability((IJavaElement)this.fInputType);
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fInputType.isLocal()) {
            result.addFatalError(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.no_local_types"));
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fInputType.isAnonymous()) {
            result.addFatalError(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.no_anonymous_types"));
        }
        if (result.hasFatalError()) {
            return result;
        }
        if (!Checks.isTopLevel(this.fInputType)) {
            result.addFatalError(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.no_member_classes"));
        }
        if (result.hasFatalError()) {
            return result;
        }
        return result;
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fInputType);
        if (orig == null || !orig.exists()) {
            String[] keys = new String[]{this.fInputType.getCompilationUnit().getElementName()};
            String message = RefactoringCoreMessages.getFormattedString("ExtractInterfaceRefactoring.deleted", keys);
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        this.fInputType = orig;
        if (Checks.isException(this.fInputType, pm)) {
            String message = RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.no_Throwable");
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        return Checks.checkIfCuBroken((IMember)this.fInputType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block7: {
            RefactoringStatus refactoringStatus2;
            block6: {
                pm.beginTask("", 1);
                try {
                    try {
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(this.checkNewInterfaceName(this.fNewInterfaceName));
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            Object var3_7 = null;
                            break block6;
                        }
                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        result.merge(this.validateModifiesFiles());
                        refactoringStatus = result;
                        break block7;
                    }
                    catch (JavaModelException e) {
                        throw e;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_9 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return refactoringStatus2;
        }
        Object var3_8 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkInterfaceTypeName() throws JavaModelException {
        IType type = Checks.findTypeInPackage(this.getInputClassPackage(), this.fNewInterfaceName);
        if (type == null || !type.exists()) {
            return null;
        }
        String[] keys = new String[]{this.fNewInterfaceName, this.getInputClassPackage().getElementName()};
        String message = RefactoringCoreMessages.getFormattedString("ExtractInterfaceRefactoring.type_exists", keys);
        return RefactoringStatus.createFatalErrorStatus(message);
    }

    public RefactoringStatus checkNewInterfaceName(String newName) {
        try {
            RefactoringStatus result = Checks.checkTypeName(newName);
            if (result.hasFatalError()) {
                return result;
            }
            result.merge(Checks.checkCompilationUnitName(String.valueOf(newName) + ".java"));
            if (result.hasFatalError()) {
                return result;
            }
            if (this.getInputClassPackage().getCompilationUnit(this.getCuNameForNewInterface()).exists()) {
                String[] keys = new String[]{this.getCuNameForNewInterface(), this.getInputClassPackage().getElementName()};
                String message = RefactoringCoreMessages.getFormattedString("ExtractInterfaceRefactoring.compilation_Unit_exists", keys);
                result.addFatalError(message);
                if (result.hasFatalError()) {
                    return result;
                }
            }
            result.merge(this.checkInterfaceTypeName());
            return result;
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.internal_Error"));
        }
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            try {
                pm.beginTask("", 1);
                CompositeChange builder = new CompositeChange(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.name"));
                builder.addAll(this.fChangeManager.getAllChanges());
                builder.add(this.createExtractedInterface((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                compositeChange = builder;
                Object var3_6 = null;
                this.clearIntermediateState();
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.clearIntermediateState();
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private void clearIntermediateState() {
        this.fASTMappingManager.clear();
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 10);
            pm.setTaskName(RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.analyzing..."));
            TextChangeManager manager = new TextChangeManager();
            this.updateTypeDeclaration(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (this.fReplaceOccurrences) {
                this.updateReferences(manager, (IProgressMonitor)new SubProgressMonitor(pm, 9));
            } else {
                pm.worked(1);
            }
            this.deleteExtractedFields(manager);
            if (this.fInputType.isInterface()) {
                this.deleteExtractedMethods(manager);
            }
            textChangeManager = manager;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void deleteExtractedMethods(TextChangeManager manager) throws CoreException {
        IMethod[] methods = this.getExtractedMethods();
        int i = 0;
        while (i < methods.length) {
            ExtractInterfaceRefactoring.deleteExtractedMember(manager, (IMember)methods[i], RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.delete_method"));
            ++i;
        }
    }

    private void deleteExtractedFields(TextChangeManager manager) throws CoreException {
        IField[] fields = this.getExtractedFields();
        int i = 0;
        while (i < fields.length) {
            ExtractInterfaceRefactoring.deleteExtractedMember(manager, (IMember)fields[i], RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.delete_field"));
            ++i;
        }
    }

    private static void deleteExtractedMember(TextChangeManager manager, IMember member, String editName) throws CoreException {
        ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(member.getCompilationUnit());
        manager.get(wc).addTextEdit(editName, new DeleteSourceReferenceEdit((ISourceReference)member, wc));
    }

    private void updateReferences(TextChangeManager manager, IProgressMonitor pm) throws JavaModelException, CoreException {
        this.fUpdatedTypeReferenceNodes = UseSupertypeWherePossibleUtil.updateReferences(manager, this.fExtractedMembers, this.fNewInterfaceName, this.fInputType, this.fCodeGenerationSettings, this.fASTMappingManager, pm);
    }

    private boolean areAllExtractableMembersOfClass(IMember[] extractedMembers) throws JavaModelException {
        int i = 0;
        while (i < extractedMembers.length) {
            if (!extractedMembers[i].getParent().equals(this.fInputType)) {
                return false;
            }
            if (!ExtractInterfaceRefactoring.isExtractableMember(extractedMembers[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isExtractableMember(IMember iMember) throws JavaModelException {
        if (iMember.getElementType() == 9) {
            return ExtractInterfaceRefactoring.isExtractableMethod((IMethod)iMember);
        }
        if (iMember.getElementType() == 8) {
            return ExtractInterfaceRefactoring.isExtractableField((IField)iMember);
        }
        return false;
    }

    private static boolean isExtractableField(IField iField) throws JavaModelException {
        if (!JdtFlags.isPublic((IMember)iField)) {
            return false;
        }
        if (!JdtFlags.isStatic((IMember)iField)) {
            return false;
        }
        return JdtFlags.isFinal((IMember)iField);
    }

    private static boolean isExtractableMethod(IMethod iMethod) throws JavaModelException {
        if (!JdtFlags.isPublic((IMember)iMethod)) {
            return false;
        }
        if (JdtFlags.isStatic((IMember)iMethod)) {
            return false;
        }
        return !iMethod.isConstructor();
    }

    private IChange createExtractedInterface(IProgressMonitor pm) throws CoreException {
        CreateTextFileChange createTextFileChange;
        block3: {
            pm.beginTask("", 1);
            IPath cuPath = ResourceUtil.getFile(this.fInputType.getCompilationUnit()).getFullPath();
            IPath interfaceCuPath = cuPath.removeLastSegments(1).append(this.getCuNameForNewInterface());
            ICompilationUnit newCuWC = null;
            try {
                newCuWC = WorkingCopyUtil.getNewWorkingCopy(this.getInputClassPackage(), this.getCuNameForNewInterface());
                String formattedSource = this.formatSource(this.createExtractedInterfaceCUSource(newCuWC, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                createTextFileChange = new CreateTextFileChange(interfaceCuPath, formattedSource, true);
                Object var6_7 = null;
                if (newCuWC == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (newCuWC != null) {
                    newCuWC.destroy();
                }
                pm.done();
                throw throwable;
            }
            newCuWC.destroy();
        }
        pm.done();
        return createTextFileChange;
    }

    private String formatSource(String source) {
        return ToolFactory.createCodeFormatter().format(source, 0, null, this.getLineSeperator());
    }

    private String getCuNameForNewInterface() {
        return String.valueOf(this.fNewInterfaceName) + ".java";
    }

    private IPackageFragment getInputClassPackage() {
        return this.fInputType.getPackageFragment();
    }

    private String getLineSeperator() {
        try {
            return StubUtility.getLineDelimiterUsed((IJavaElement)this.fInputType);
        }
        catch (JavaModelException javaModelException) {
            return System.getProperty("line.separator", "\n");
        }
    }

    private boolean inputClassHasDirectSuperinterfaces() throws JavaModelException {
        return this.fInputType.getSuperInterfaceNames().length > 0;
    }

    private void updateTypeDeclaration(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        String editName = RefactoringCoreMessages.getString("ExtractInterfaceRefactoring.update_Type_Declaration");
        int offset = this.computeIndexOfSuperinterfaceNameInsertion();
        String text = this.computeTextOfSuperinterfaceNameInsertion();
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fInputType.getCompilationUnit());
        manager.get(cu).addTextEdit(editName, SimpleTextEdit.createInsert(offset, text));
        pm.done();
    }

    private String computeTextOfSuperinterfaceNameInsertion() throws JavaModelException {
        if (this.inputClassHasDirectSuperinterfaces()) {
            return ", " + this.fNewInterfaceName;
        }
        if (this.fInputType.isClass()) {
            return " implements " + this.fNewInterfaceName;
        }
        return " extends " + this.fNewInterfaceName;
    }

    private int computeIndexOfSuperinterfaceNameInsertion() throws JavaModelException {
        TypeDeclaration typeNode = this.getTypeDeclarationNode();
        if (typeNode.superInterfaces().isEmpty()) {
            if (typeNode.getSuperclass() == null) {
                return ASTNodes.getExclusiveEnd((ASTNode)typeNode.getName());
            }
            return ASTNodes.getExclusiveEnd((ASTNode)typeNode.getSuperclass());
        }
        Name lastInterfaceName = (Name)typeNode.superInterfaces().get(typeNode.superInterfaces().size() - 1);
        return ASTNodes.getExclusiveEnd((ASTNode)lastInterfaceName);
    }

    private TypeDeclaration getTypeDeclarationNode() throws JavaModelException {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(this.fInputType.getNameRange().getOffset(), this.fInputType.getNameRange().getLength() + 1), true);
        this.getAST(this.fInputType.getCompilationUnit()).accept((ASTVisitor)analyzer);
        if (analyzer.getFirstSelectedNode() != null && analyzer.getFirstSelectedNode().getParent() instanceof TypeDeclaration) {
            return (TypeDeclaration)analyzer.getFirstSelectedNode().getParent();
        }
        return null;
    }

    private String createExtractedInterfaceCUSource(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        String lineDelimiter = this.getLineSeperator();
        String typeComment = CodeGeneration.getTypeComment(newCu, this.fNewInterfaceName, lineDelimiter);
        String compilationUnitContent = CodeGeneration.getCompilationUnitContent(newCu, typeComment, this.createInterfaceSource(), lineDelimiter);
        if (compilationUnitContent == null) {
            compilationUnitContent = "";
        }
        newCu.getBuffer().setContents(compilationUnitContent);
        this.addImportsToNewCu(newCu, pm);
        return newCu.getSource();
    }

    private void addImportsToNewCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 3);
        ImportsStructure is = new ImportsStructure(newCu, this.fCodeGenerationSettings.importOrder, this.fCodeGenerationSettings.importThreshold, true);
        this.addImportsToTypesReferencedInMethodDeclarations(is, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.addImportsToTypesReferencedInFieldDeclarations(is, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        is.create(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
    }

    private String createInterfaceSource() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.createInterfaceModifierString()).append("interface ").append(this.fNewInterfaceName).append(" {").append(this.getLineSeperator()).append(this.createInterfaceMemberDeclarationsSource()).append("}");
        return buff.toString();
    }

    private String createInterfaceModifierString() throws JavaModelException {
        if (JdtFlags.isPublic((IMember)this.fInputType)) {
            return "public ";
        }
        return "";
    }

    private String createInterfaceMemberDeclarationsSource() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        ExtractInterfaceRefactoring.sortByOffset(this.fExtractedMembers);
        int i = 0;
        while (i < this.fExtractedMembers.length) {
            buff.append(this.createInterfaceMemberDeclarationsSource(this.fExtractedMembers[i]));
            if (i + 1 != this.fExtractedMembers.length) {
                buff.append(this.getLineSeperator());
            }
            ++i;
        }
        return buff.toString();
    }

    private static void sortByOffset(IMember[] members) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                ISourceReference sr1 = (ISourceReference)o1;
                ISourceReference sr2 = (ISourceReference)o2;
                try {
                    return sr1.getSourceRange().getOffset() - sr2.getSourceRange().getOffset();
                }
                catch (JavaModelException javaModelException) {
                    return 0;
                }
            }
        };
        Arrays.sort(members, comparator);
    }

    private String createInterfaceMemberDeclarationsSource(IMember iMember) throws JavaModelException {
        Assert.isTrue(iMember.getElementType() == 8 || iMember.getElementType() == 9);
        if (iMember.getElementType() == 8) {
            return this.createInterfaceFieldDeclarationSource((IField)iMember);
        }
        return this.createInterfaceMethodDeclarationsSource((IMethod)iMember);
    }

    private String createInterfaceFieldDeclarationSource(IField iField) throws JavaModelException {
        FieldDeclaration fieldDeclaration = this.getFieldDeclarationNode(iField);
        if (fieldDeclaration == null) {
            return "";
        }
        StringBuffer fieldSource = new StringBuffer(SourceRangeComputer.computeSource((ISourceReference)iField));
        if (this.fUpdatedTypeReferenceNodes != null) {
            int offset = SourceRangeComputer.computeSourceRange((ISourceReference)iField, iField.getCompilationUnit().getSource()).getOffset();
            this.replaceReferencesInFieldDeclaration(fieldDeclaration, offset, fieldSource);
        }
        return fieldSource.toString();
    }

    private String createInterfaceMethodDeclarationsSource(IMethod iMethod) throws JavaModelException {
        MethodDeclaration methodDeclaration = this.getMethodDeclarationNode(iMethod);
        if (methodDeclaration == null) {
            return "";
        }
        if (this.fInputType.isClass()) {
            int methodDeclarationOffset = methodDeclaration.getReturnType().getStartPosition();
            int length = ExtractInterfaceRefactoring.getMethodDeclarationLength(iMethod, methodDeclaration);
            StringBuffer methodDeclarationSource = new StringBuffer();
            String methodComment = ExtractInterfaceRefactoring.getCommentContent(iMethod);
            if (methodComment != null) {
                methodDeclarationSource.append(methodComment);
            }
            methodDeclarationSource.append(INTERFACE_METHOD_MODIFIERS);
            methodDeclarationSource.append(iMethod.getCompilationUnit().getBuffer().getText(methodDeclarationOffset, length));
            if (methodDeclaration.getBody() != null) {
                methodDeclarationSource.append(";");
            }
            if (this.fUpdatedTypeReferenceNodes != null) {
                this.replaceReferencesInMethodDeclaration(methodDeclaration, methodDeclarationOffset - INTERFACE_METHOD_MODIFIERS.length(), methodDeclarationSource);
            }
            return methodDeclarationSource.toString();
        }
        StringBuffer source = new StringBuffer(SourceRangeComputer.computeSource((ISourceReference)iMethod));
        if (this.fUpdatedTypeReferenceNodes != null) {
            int offset = SourceRangeComputer.computeSourceRange((ISourceReference)iMethod, iMethod.getCompilationUnit().getSource()).getOffset();
            this.replaceReferencesInMethodDeclaration(methodDeclaration, offset, source);
        }
        return source.toString();
    }

    private static String getCommentContent(IMethod iMethod) throws JavaModelException {
        String rawContent = JavaElementCommentFinder.getCommentContent((IMember)iMethod);
        if (rawContent == null) {
            return null;
        }
        String[] lines = Strings.convertIntoLines(rawContent);
        Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed((IJavaElement)iMethod));
    }

    private void replaceReferencesInMethodDeclaration(MethodDeclaration methodDeclaration, int methodDeclarationOffset, StringBuffer methodDeclarationSource) {
        SingleVariableDeclaration[] params = methodDeclaration.parameters().toArray(new SingleVariableDeclaration[methodDeclaration.parameters().size()]);
        int i = params.length - 1;
        while (i >= 0) {
            SingleVariableDeclaration declaration = params[i];
            this.replaceReferencesIfUpdated(methodDeclarationOffset, methodDeclarationSource, (ASTNode)declaration.getType());
            --i;
        }
        this.replaceReferencesIfUpdated(methodDeclarationOffset, methodDeclarationSource, (ASTNode)methodDeclaration.getReturnType());
    }

    private void replaceReferencesInFieldDeclaration(FieldDeclaration fieldDeclaration, int offset, StringBuffer fieldSource) {
        ASTNode[] inputTypeReferences = this.getInputTypeReferencesUsedInside(fieldDeclaration);
        ExtractInterfaceRefactoring.sortBackwardsByStartPosition(inputTypeReferences);
        int i = 0;
        while (i < inputTypeReferences.length) {
            ASTNode node = inputTypeReferences[i];
            this.replaceReferencesIfUpdated(offset, fieldSource, node);
            ++i;
        }
    }

    private static void sortBackwardsByStartPosition(ASTNode[] nodes) {
        Arrays.sort(nodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ASTNode)o1).getStartPosition() - ((ASTNode)o2).getStartPosition();
            }
        });
    }

    private ASTNode[] getInputTypeReferencesUsedInside(FieldDeclaration fieldDeclaration) {
        final HashSet nodes = new HashSet(0);
        ASTVisitor collector = new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (this.isReferenceToInputType(node)) {
                    nodes.add(node);
                }
                return false;
            }

            public boolean visit(SimpleType node) {
                if (this.isReferenceToInputType(node)) {
                    nodes.add(node);
                }
                return false;
            }

            private boolean isReferenceToInputType(SimpleType node) {
                return this.isBindingOfInputType((IBinding)node.resolveBinding());
            }

            private boolean isReferenceToInputType(SimpleName node) {
                return this.isBindingOfInputType(node.resolveBinding());
            }

            private boolean isBindingOfInputType(IBinding iBinding) {
                if (!(iBinding instanceof ITypeBinding)) {
                    return false;
                }
                ITypeBinding tb = (ITypeBinding)iBinding;
                if (tb.isPrimitive()) {
                    return false;
                }
                if (tb.isNullType()) {
                    return false;
                }
                if (!tb.getName().equals(ExtractInterfaceRefactoring.this.getInputType().getElementName())) {
                    return false;
                }
                return JavaModelUtil.getFullyQualifiedName(ExtractInterfaceRefactoring.this.getInputType()).equals(Bindings.getFullyQualifiedImportName(tb));
            }
        };
        fieldDeclaration.accept(collector);
        return nodes.toArray(new ASTNode[nodes.size()]);
    }

    private void replaceReferencesIfUpdated(int methodDeclarationOffset, StringBuffer methodDeclarationSource, ASTNode node) {
        if (this.fUpdatedTypeReferenceNodes.contains(node)) {
            methodDeclarationSource.replace(node.getStartPosition() - methodDeclarationOffset, ASTNodes.getExclusiveEnd(node) - methodDeclarationOffset, this.fNewInterfaceName);
        }
    }

    private static int getMethodDeclarationLength(IMethod iMethod, MethodDeclaration methodDeclaration) throws JavaModelException {
        int preDeclarationSourceLength = methodDeclaration.getReturnType().getStartPosition() - iMethod.getSourceRange().getOffset();
        if (methodDeclaration.getBody() == null) {
            return methodDeclaration.getLength() - preDeclarationSourceLength;
        }
        return iMethod.getSourceRange().getLength() - methodDeclaration.getBody().getLength() - preDeclarationSourceLength;
    }

    private MethodDeclaration getMethodDeclarationNode(IMethod iMethod) throws JavaModelException {
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, this.fASTMappingManager);
    }

    private FieldDeclaration getFieldDeclarationNode(IField iField) throws JavaModelException {
        return ASTNodeSearchUtil.getFieldDeclarationNode(iField, this.fASTMappingManager);
    }

    private IField[] getExtractedFields() {
        ArrayList<IMember> fields = new ArrayList<IMember>();
        int i = 0;
        while (i < this.fExtractedMembers.length) {
            if (this.fExtractedMembers[i] instanceof IField) {
                fields.add(this.fExtractedMembers[i]);
            }
            ++i;
        }
        return fields.toArray(new IField[fields.size()]);
    }

    private IMethod[] getExtractedMethods() {
        ArrayList<IMember> methods = new ArrayList<IMember>();
        int i = 0;
        while (i < this.fExtractedMembers.length) {
            if (this.fExtractedMembers[i] instanceof IMethod) {
                methods.add(this.fExtractedMembers[i]);
            }
            ++i;
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    private void addImportsToTypesReferencedInFieldDeclarations(ImportsStructure is, IProgressMonitor pm) throws JavaModelException {
        IType[] referencedTypes = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])this.getExtractedFields(), pm);
        int i = 0;
        while (i < referencedTypes.length) {
            IType type = referencedTypes[i];
            is.addImport(JavaModelUtil.getFullyQualifiedName(type));
            ++i;
        }
    }

    private void addImportsToTypesReferencedInMethodDeclarations(ImportsStructure is, IProgressMonitor pm) throws JavaModelException {
        ITypeBinding[] typesUsed = this.getTypesUsedInExtractedMethodDeclarations();
        pm.beginTask("", typesUsed.length);
        int i = 0;
        while (i < typesUsed.length) {
            is.addImport(typesUsed[i]);
            pm.worked(1);
            ++i;
        }
        pm.done();
    }

    private ITypeBinding[] getTypesUsedInExtractedMethodDeclarations() throws JavaModelException {
        return ReferenceFinderUtil.getTypesReferencedInDeclarations(this.getExtractedMethods(), this.fASTMappingManager);
    }

    private CompilationUnit getAST(ICompilationUnit cu) {
        return this.fASTMappingManager.getAST(cu);
    }
}

