/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

class ConstructorReferenceFinder {
    private final IType fType;
    private final IMethod[] fConstructors;
    private final ASTNodeMappingManager fASTManager;

    private ConstructorReferenceFinder(IType type, ASTNodeMappingManager astManager) throws JavaModelException {
        this.fConstructors = JavaElementUtil.getAllConstructors(type);
        this.fASTManager = astManager;
        this.fType = type;
    }

    private ConstructorReferenceFinder(IMethod constructor, ASTNodeMappingManager astManager) {
        this.fConstructors = new IMethod[]{constructor};
        this.fASTManager = astManager;
        this.fType = constructor.getDeclaringType();
    }

    public static ASTNode[] getConstructorReferenceNodes(IType type, ASTNodeMappingManager astManager, IProgressMonitor pm) throws JavaModelException {
        return new ConstructorReferenceFinder(type, astManager).getConstructorReferenceNodes(pm, 2);
    }

    public static ASTNode[] getConstructorOccurrenceNodes(IMethod constructor, ASTNodeMappingManager astManager, IProgressMonitor pm) throws JavaModelException {
        Assert.isTrue(constructor.isConstructor());
        return new ConstructorReferenceFinder(constructor, astManager).getConstructorReferenceNodes(pm, 3);
    }

    private ASTNode[] getConstructorReferenceNodes(IProgressMonitor pm, int limitTo) throws JavaModelException {
        IJavaSearchScope scope = this.createSearchScope();
        ISearchPattern pattern = RefactoringSearchEngine.createSearchPattern((IJavaElement[])this.fConstructors, limitTo);
        if (pattern == null) {
            if (this.fConstructors.length != 0) {
                return new ASTNode[0];
            }
            return this.getImplicitConstructorReferenceNodes(pm);
        }
        return this.removeUnrealNodes(ASTNodeSearchUtil.searchNodes(scope, pattern, this.fASTManager, pm));
    }

    private ASTNode[] removeUnrealNodes(ASTNode[] nodes) {
        ArrayList<ASTNode> realNodes = new ArrayList<ASTNode>(nodes.length);
        String typeName = this.fConstructors[0].getDeclaringType().getElementName();
        int i = 0;
        while (i < nodes.length) {
            MethodDeclaration md;
            if (!(nodes[i].getParent() instanceof TypeDeclaration || nodes[i].getParent() instanceof MethodDeclaration && (md = (MethodDeclaration)nodes[i].getParent()).isConstructor() && !md.getName().getIdentifier().equals(typeName))) {
                realNodes.add(nodes[i]);
            }
            ++i;
        }
        return realNodes.toArray(new ASTNode[realNodes.size()]);
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        if (this.fConstructors.length == 0) {
            return RefactoringScopeFactory.create((IJavaElement)this.fType);
        }
        return RefactoringScopeFactory.create((IJavaElement)this.getMostVisibleConstructor());
    }

    private IMethod getMostVisibleConstructor() throws JavaModelException {
        Assert.isTrue(this.fConstructors.length > 0);
        IMethod candidate = this.fConstructors[0];
        int visibility = JdtFlags.getVisibilityCode((IMember)this.fConstructors[0]);
        int i = 1;
        while (i < this.fConstructors.length) {
            IMethod constructor = this.fConstructors[i];
            if (JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((IMember)constructor), visibility)) {
                candidate = constructor;
            }
            ++i;
        }
        return candidate;
    }

    private ASTNode[] getImplicitConstructorReferenceNodes(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 2);
        ArrayList result = new ArrayList();
        result.addAll(this.getImplicitConstructorReferenceNodesFromHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        result.addAll(this.getImplicitConstructorReferencesInClassCreations((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
        return result.toArray(new ASTNode[result.size()]);
    }

    private List getImplicitConstructorReferencesInClassCreations(IProgressMonitor pm) throws JavaModelException {
        ASTNode[] nodes = ASTNodeSearchUtil.findReferenceNodes((IJavaElement)this.fType, this.fASTManager, pm);
        ArrayList<ClassInstanceCreation> result = new ArrayList<ClassInstanceCreation>(2);
        int i = 0;
        while (i < nodes.length) {
            ClassInstanceCreation cic;
            ASTNode node = nodes[i];
            if (node instanceof Name && node.getParent() instanceof ClassInstanceCreation && node.equals((Object)(cic = (ClassInstanceCreation)node.getParent()).getName())) {
                result.add(cic);
            }
            ++i;
        }
        return result;
    }

    private List getImplicitConstructorReferenceNodesFromHierarchy(IProgressMonitor pm) throws JavaModelException {
        ITypeHierarchy hierarchy = this.fType.newTypeHierarchy(pm);
        IType[] subTypes = hierarchy.getAllSubtypes(this.fType);
        ArrayList result = new ArrayList(subTypes.length);
        int i = 0;
        while (i < subTypes.length) {
            if (!subTypes[i].isBinary()) {
                result.addAll(this.getAllSuperConstructorInvocations(subTypes[i]));
            }
            ++i;
        }
        return result;
    }

    private Collection getAllSuperConstructorInvocations(IType type) throws JavaModelException {
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(constructors.length);
        int i = 0;
        while (i < constructors.length) {
            ASTNode superCall = this.getSuperConstructorCall(constructors[i]);
            if (superCall != null) {
                result.add(superCall);
            }
            ++i;
        }
        return result;
    }

    private ASTNode getSuperConstructorCall(IMethod constructor) throws JavaModelException {
        Assert.isTrue(constructor.isConstructor());
        MethodDeclaration constructorNode = ASTNodeSearchUtil.getMethodDeclarationNode(constructor, this.fASTManager);
        Assert.isTrue(constructorNode.isConstructor());
        Block body = constructorNode.getBody();
        Assert.isNotNull(body);
        List statements = body.statements();
        if (!statements.isEmpty() && statements.get(0) instanceof SuperConstructorInvocation) {
            return (SuperConstructorInvocation)statements.get(0);
        }
        return null;
    }
}

