/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.RippleMethodFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTRewriteManager;
import org.eclipse.jdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportEditManager;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class ChangeSignatureRefactoring
extends Refactoring {
    private final List fParameterInfos;
    private final CodeGenerationSettings fCodeGenerationSettings;
    private final ImportEditManager fImportEditManager;
    private final ASTNodeMappingManager fAstManager;
    private final ASTRewriteManager fRewriteManager;
    private TextChangeManager fChangeManager;
    private IMethod fMethod;
    private IMethod[] fRippleMethods;
    private ASTNode[] fOccurrenceNodes;
    private Set fDescriptionGroups;
    private String fReturnTypeName;
    private int fVisibility;
    private static final String CONST_CLASS_DECL = "class A{";
    private static final String CONST_ASSIGN = " i=";
    private static final String CONST_CLOSE = ";}";
    private static final String DEFAULT_NEW_PARAM_TYPE = "int";
    private static final String DEFAULT_NEW_PARAM_VALUE = "0";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ChangeSignatureRefactoring(IMethod method, CodeGenerationSettings codeGenerationSettings) throws JavaModelException {
        Assert.isNotNull(method);
        this.fMethod = method;
        this.fParameterInfos = ChangeSignatureRefactoring.createParameterInfoList(method);
        this.fAstManager = new ASTNodeMappingManager();
        this.fRewriteManager = new ASTRewriteManager(this.fAstManager);
        this.fDescriptionGroups = new HashSet(0);
        this.fCodeGenerationSettings = codeGenerationSettings;
        this.fImportEditManager = new ImportEditManager(this.fCodeGenerationSettings);
        this.fReturnTypeName = this.getInitialReturnTypeName();
        this.fVisibility = this.getInitialMethodVisibility();
    }

    private String getInitialReturnTypeName() throws JavaModelException {
        return Signature.toString((String)Signature.getReturnType((String)this.fMethod.getSignature()));
    }

    private int getInitialMethodVisibility() throws JavaModelException {
        return JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private static List createParameterInfoList(IMethod method) {
        try {
            String[] typeNames = method.getParameterTypes();
            String[] oldNames = method.getParameterNames();
            ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(typeNames.length);
            int i = 0;
            while (i < oldNames.length) {
                result.add(new ParameterInfo(Signature.toString((String)typeNames[i]), oldNames[i], i));
                ++i;
            }
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new ArrayList(0);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("ChangeSignatureRefactoring.modify_Parameters");
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public void setNewReturnTypeName(String newReturnTypeName) {
        Assert.isNotNull(newReturnTypeName);
        this.fReturnTypeName = newReturnTypeName;
    }

    public boolean canChangeReturnType() {
        try {
            return !this.fMethod.isConstructor();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        Assert.isTrue(visibility == 1 || visibility == 4 || visibility == 0 || visibility == 2);
        this.fVisibility = visibility;
    }

    public int[] getAvailableVisibilities() throws JavaModelException {
        if (this.fMethod.getDeclaringType().isInterface()) {
            return new int[]{1};
        }
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public List getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setupNewParameterInfo(ParameterInfo parameter) {
        parameter.setDefaultValue(DEFAULT_NEW_PARAM_VALUE);
        parameter.setNewTypeName(DEFAULT_NEW_PARAM_TYPE);
        parameter.setNewName(this.findUnusedParameterName());
    }

    private String findUnusedParameterName() {
        String candidate;
        Set usedNames = this.getUsedParameterNames();
        int i = 0;
        String prefix = "arg";
        while (usedNames.contains(candidate = String.valueOf(prefix) + i++)) {
        }
        return candidate;
    }

    private Set getUsedParameterNames() {
        HashSet<String> names = new HashSet<String>(2);
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            names.add(((ParameterInfo)iter.next()).getNewName());
        }
        return names;
    }

    public RefactoringStatus checkSignature() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.checkForDuplicateNames(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkParameters(result);
        if (result.hasFatalError()) {
            return result;
        }
        this.checkReturnType(result);
        return result;
    }

    public boolean isSignatureSameAsInitial() throws JavaModelException {
        if (this.fMethod.getNumberOfParameters() == 0 && this.fParameterInfos.isEmpty() && this.isVisibilitySameAsInitial() && this.isReturnTypeSameAsInitial()) {
            return true;
        }
        return this.areNamesSameAsInitial() && this.isOrderSameAsInitial() && this.isVisibilitySameAsInitial() && !this.areAnyParametersDeleted() && this.isReturnTypeSameAsInitial() && this.areParameterTypesSameAsInitial();
    }

    private boolean areParameterTypesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            return false;
        }
        return true;
    }

    private boolean isReturnTypeSameAsInitial() throws JavaModelException {
        return this.fReturnTypeName.equals(this.getInitialReturnTypeName());
    }

    private boolean areAnyParametersDeleted() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) continue;
            return true;
        }
        return false;
    }

    private void checkParameters(RefactoringStatus result) {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isDeleted()) continue;
            this.checkParameterType(result, info);
            if (result.hasFatalError()) {
                return;
            }
            result.merge(Checks.checkTempName(info.getNewName()));
            if (result.hasFatalError()) {
                return;
            }
            if (!info.isAdded()) continue;
            this.checkParameterDefaultValue(result, info);
        }
    }

    private void checkReturnType(RefactoringStatus result) {
        if (!ChangeSignatureRefactoring.isValidTypeName(this.fReturnTypeName, true)) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_return_type", new String[]{this.fReturnTypeName});
            result.addFatalError(msg);
        }
    }

    private void checkParameterDefaultValue(RefactoringStatus result, ParameterInfo info) {
        if (info.getDefaultValue().trim().equals("")) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.default_value", new String[]{info.getNewName()});
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidExpression(info.getDefaultValue())) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_expression", new String[]{info.getDefaultValue()});
            result.addFatalError(msg);
        }
    }

    private void checkParameterType(RefactoringStatus result, ParameterInfo info) {
        if (!info.isTypeNameChanged()) {
            return;
        }
        if (info.getNewTypeName().trim().equals("")) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.parameter_type", new String[]{info.getNewName()});
            result.addFatalError(msg);
            return;
        }
        if (!ChangeSignatureRefactoring.isValidTypeName(info.getNewTypeName(), false)) {
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.invalid_type_name", new String[]{info.getNewTypeName()});
            result.addFatalError(msg);
        }
    }

    private static boolean isValidTypeName(String string, boolean isVoidAllowed) {
        if ("".equals(string.trim())) {
            return false;
        }
        if (!string.trim().equals(string)) {
            return false;
        }
        if (PrimitiveType.toCode((String)string) == PrimitiveType.VOID) {
            return isVoidAllowed;
        }
        if (!Checks.checkTypeName(string).hasFatalError()) {
            return true;
        }
        if (ChangeSignatureRefactoring.isPrimitiveTypeName(string)) {
            return true;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_CLASS_DECL);
        int offset = cuBuff.length();
        cuBuff.append(string).append(CONST_ASSIGN).append("null").append(CONST_CLOSE);
        CompilationUnit cu = AST.parseCompilationUnit((char[])cuBuff.toString().toCharArray());
        Selection selection = Selection.createFromStartLength(offset, string.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        if (!(selected instanceof Type)) {
            return false;
        }
        Type type = (Type)selected;
        if (ChangeSignatureRefactoring.isVoidArrayType(type)) {
            return false;
        }
        return string.equals(cuBuff.substring(type.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)type)));
    }

    private static boolean isVoidArrayType(Type type) {
        if (!type.isArrayType()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)type;
        if (!arrayType.getComponentType().isPrimitiveType()) {
            return false;
        }
        PrimitiveType primitiveType = (PrimitiveType)arrayType.getComponentType();
        return primitiveType.getPrimitiveTypeCode() == PrimitiveType.VOID;
    }

    private static boolean isValidExpression(String string) {
        String trimmed = string.trim();
        if ("".equals(trimmed)) {
            return false;
        }
        StringBuffer cuBuff = new StringBuffer();
        cuBuff.append(CONST_CLASS_DECL).append("Object").append(CONST_ASSIGN);
        int offset = cuBuff.length();
        cuBuff.append(trimmed).append(CONST_CLOSE);
        CompilationUnit cu = AST.parseCompilationUnit((char[])cuBuff.toString().toCharArray());
        Selection selection = Selection.createFromStartLength(offset, trimmed.length());
        SelectionAnalyzer analyzer = new SelectionAnalyzer(selection, false);
        cu.accept((ASTVisitor)analyzer);
        ASTNode selected = analyzer.getFirstSelectedNode();
        return selected instanceof Expression && trimmed.equals(cuBuff.substring(selected.getStartPosition(), ASTNodes.getExclusiveEnd(selected)));
    }

    public RefactoringStatus checkPreconditions(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = this.checkPreactivation();
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(super.checkPreconditions(pm));
        return result;
    }

    public RefactoringStatus checkPreactivation() throws JavaModelException {
        return Checks.checkAvailability((IJavaElement)this.fMethod);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block14: {
            RefactoringStatus refactoringStatus2;
            block13: {
                RefactoringStatus refactoringStatus3;
                block12: {
                    RefactoringStatus refactoringStatus4;
                    block11: {
                        RefactoringStatus refactoringStatus5;
                        block10: {
                            RefactoringStatus refactoringStatus6;
                            block9: {
                                try {
                                    pm.beginTask("", 2);
                                    RefactoringStatus result = Checks.checkIfCuBroken((IMember)this.fMethod);
                                    if (result.hasFatalError()) {
                                        refactoringStatus6 = result;
                                        Object var5_9 = null;
                                        break block9;
                                    }
                                    IMethod orig = (IMethod)WorkingCopyUtil.getOriginal((IMember)this.fMethod);
                                    if (orig == null || !orig.exists()) {
                                        String message = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.method_deleted", this.fMethod.getCompilationUnit().getElementName());
                                        refactoringStatus5 = RefactoringStatus.createFatalErrorStatus(message);
                                        break block10;
                                    }
                                    this.fMethod = orig;
                                    if (MethodChecks.isVirtual(this.fMethod)) {
                                        result.merge(MethodChecks.checkIfComesFromInterface(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                        if (result.hasFatalError()) {
                                            refactoringStatus4 = result;
                                            break block11;
                                        }
                                        result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                        if (result.hasFatalError()) {
                                            refactoringStatus3 = result;
                                            break block12;
                                        }
                                    }
                                    if (this.fMethod.getDeclaringType().isInterface()) {
                                        result.merge(MethodChecks.checkIfOverridesAnother(this.getMethod(), (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                        if (result.hasFatalError()) {
                                            refactoringStatus2 = result;
                                            break block13;
                                        }
                                    }
                                    refactoringStatus = result;
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    Object var5_15 = null;
                                    pm.done();
                                    throw throwable;
                                }
                            }
                            pm.done();
                            return refactoringStatus6;
                        }
                        Object var5_10 = null;
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var5_11 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var5_12 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var5_13 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var5_14 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block16: {
            RefactoringStatus refactoringStatus2;
            block15: {
                RefactoringStatus refactoringStatus3;
                block14: {
                    RefactoringStatus refactoringStatus4;
                    block13: {
                        RefactoringStatus refactoringStatus5;
                        block12: {
                            try {
                                try {
                                    pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 6);
                                    RefactoringStatus result = new RefactoringStatus();
                                    this.clearManagers();
                                    if (this.isSignatureSameAsInitial()) {
                                        refactoringStatus5 = RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.unchanged"));
                                        Object var3_10 = null;
                                        break block12;
                                    }
                                    result.merge(this.checkSignature());
                                    if (result.hasFatalError()) {
                                        refactoringStatus4 = result;
                                        break block13;
                                    }
                                    this.fRippleMethods = RippleMethodFinder.getRelatedMethods(this.fMethod, (IProgressMonitor)new SubProgressMonitor(pm, 1), null);
                                    this.fOccurrenceNodes = this.findOccurrenceNodes((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                    result.merge(this.checkVisibilityChanges());
                                    if (!this.isOrderSameAsInitial()) {
                                        result.merge(this.checkReorderings((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                    } else {
                                        pm.worked(1);
                                    }
                                    if (result.hasFatalError()) {
                                        refactoringStatus3 = result;
                                        break block14;
                                    }
                                    result.merge(this.collectAndCheckImports((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                                    this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                                    result.merge(this.checkIfDeletedParametersUsed());
                                    if (this.mustAnalyzeAst()) {
                                        result.merge(this.analyzeAst());
                                    }
                                    if (result.hasFatalError()) {
                                        refactoringStatus2 = result;
                                        break block15;
                                    }
                                    result.merge(this.validateModifiesFiles());
                                    refactoringStatus = result;
                                    break block16;
                                }
                                catch (JavaModelException e) {
                                    throw e;
                                }
                                catch (CoreException e) {
                                    throw new JavaModelException(e);
                                }
                            }
                            catch (Throwable throwable) {
                                Object var3_15 = null;
                                pm.done();
                                throw throwable;
                            }
                        }
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var3_11 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var3_12 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var3_13 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var3_14 = null;
        pm.done();
        return refactoringStatus;
    }

    private void clearManagers() {
        this.fAstManager.clear();
        this.fImportEditManager.clear();
        this.fRewriteManager.clear();
    }

    private RefactoringStatus collectAndCheckImports(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        List notDeleted = this.getNotDeletedInfos();
        pm.beginTask("", notDeleted.size());
        Iterator iter = notDeleted.iterator();
        while (iter.hasNext()) {
            String typeName;
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isTypeNameChanged() || ChangeSignatureRefactoring.isPrimitiveTypeName(typeName = ChangeSignatureRefactoring.getSimpleParameterTypeName(info)) || this.tryResolvingType(typeName)) continue;
            result.merge(this.tryFinidingInTypeCache(typeName, info, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        pm.done();
        return result;
    }

    private boolean tryResolvingType(String typeName) throws JavaModelException {
        String[][] fqns = this.getMethod().getDeclaringType().resolveType(typeName);
        if (fqns == null || fqns.length != 1) {
            return false;
        }
        String fullName = JavaModelUtil.concatenateName(fqns[0][0], fqns[0][1]);
        this.importToAllCusOfRippleMethods(fullName);
        return true;
    }

    private RefactoringStatus tryFinidingInTypeCache(String typeName, ParameterInfo info, IProgressMonitor pm) throws JavaModelException {
        List typeRefsFound = this.findTypeInfos(typeName, pm);
        if (typeRefsFound.size() == 0) {
            String[] keys = new String[]{info.getNewTypeName()};
            String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.not_unique", keys);
            return RefactoringStatus.createErrorStatus(msg);
        }
        if (typeRefsFound.size() == 1) {
            TypeInfo typeInfo = (TypeInfo)typeRefsFound.get(0);
            String fullName = typeInfo.getFullyQualifiedName();
            this.importToAllCusOfRippleMethods(fullName);
            return new RefactoringStatus();
        }
        Assert.isTrue(typeRefsFound.size() > 1);
        String[] keys = new String[]{info.getNewTypeName(), String.valueOf(typeRefsFound.size())};
        String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.ambiguous", keys);
        return RefactoringStatus.createErrorStatus(msg);
    }

    private List findTypeInfos(String typeName, IProgressMonitor pm) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{this.getMethod().getJavaProject()}, (boolean)true);
        IPackageFragment currPackage = this.getMethod().getDeclaringType().getPackageFragment();
        TypeInfo[] infos = AllTypesCache.getTypesForName(typeName, scope, pm);
        ArrayList<TypeInfo> typeRefsFound = new ArrayList<TypeInfo>();
        int i = 0;
        while (i < infos.length) {
            TypeInfo curr = infos[i];
            IType type = curr.resolveType(scope);
            if (type != null && JavaModelUtil.isVisible((IMember)type, currPackage)) {
                typeRefsFound.add(curr);
            }
            ++i;
        }
        return typeRefsFound;
    }

    private void importToAllCusOfRippleMethods(String fullName) throws JavaModelException {
        int i = 0;
        while (i < this.fRippleMethods.length) {
            ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(this.fRippleMethods[i].getCompilationUnit());
            this.fImportEditManager.addImportTo(fullName, wc);
            ++i;
        }
    }

    private static boolean isPrimitiveTypeName(String typeName) {
        return PrimitiveType.toCode((String)typeName) != null;
    }

    private static String getSimpleParameterTypeName(ParameterInfo info) {
        String typeName = info.getNewTypeName();
        if (typeName.indexOf(91) != -1) {
            typeName = typeName.substring(0, typeName.indexOf(91));
        }
        return typeName.trim();
    }

    private RefactoringStatus checkIfDeletedParametersUsed() {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fOccurrenceNodes.length) {
            ASTNode methodOccurrence = this.fOccurrenceNodes[i];
            if (!ChangeSignatureRefactoring.isReferenceNode(methodOccurrence)) {
                ICompilationUnit cu = this.fAstManager.getCompilationUnit(methodOccurrence);
                MethodDeclaration decl = ChangeSignatureRefactoring.getMethodDeclaration(methodOccurrence);
                if (decl != null) {
                    String typeName = this.getFullTypeName(decl);
                    Iterator iter = this.getDeletedInfos().iterator();
                    while (iter.hasNext()) {
                        ParameterInfo info = (ParameterInfo)iter.next();
                        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)decl.parameters().get(info.getOldIndex());
                        ASTNode[] paramRefs = TempOccurrenceFinder.findTempOccurrenceNodes((VariableDeclaration)paramDecl, true, false);
                        if (paramRefs.length <= 0) continue;
                        Context context = JavaSourceContext.create(cu, paramRefs[0]);
                        Object[] keys = new String[]{paramDecl.getName().getIdentifier(), decl.getName().getIdentifier(), typeName};
                        String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.parameter_used", keys);
                        result.addWarning(msg, context);
                    }
                }
            }
            ++i;
        }
        return result;
    }

    private String getFullTypeName(MethodDeclaration decl) {
        AnonymousClassDeclaration anonymous;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TypeDeclaration typeDecl = (TypeDeclaration)ASTNodes.getParent((ASTNode)decl, clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((anonymous = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)decl, clazz2)) != null && ASTNodes.isParent((ASTNode)typeDecl, (ASTNode)anonymous)) {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.jdt.core.dom.ClassInstanceCreation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassInstanceCreation cic = (ClassInstanceCreation)ASTNodes.getParent((ASTNode)decl, clazz3);
            return RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.anonymous_subclass", new String[]{ASTNodes.getNameIdentifier(cic.getName())});
        }
        return typeDecl.getName().getIdentifier();
    }

    private RefactoringStatus checkVisibilityChanges() throws JavaModelException {
        if (this.isVisibilitySameAsInitial()) {
            return null;
        }
        if (this.fRippleMethods.length == 1) {
            return null;
        }
        Assert.isTrue(this.getInitialMethodVisibility() != 2);
        if (this.fVisibility == 2) {
            return RefactoringStatus.createWarningStatus(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.non-virtual"));
        }
        return null;
    }

    public String getMethodSignaturePreview() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getPreviewOfVisibityString());
        if (!this.getMethod().isConstructor()) {
            buff.append(this.getReturnTypeString()).append(' ');
        }
        buff.append(this.getMethod().getElementName()).append('(').append(this.getMethodParameters()).append(')');
        return buff.toString();
    }

    private String getPreviewOfVisibityString() {
        String visibilityString = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(visibilityString)) {
            return visibilityString;
        }
        return String.valueOf(visibilityString) + ' ';
    }

    private void checkForDuplicateNames(RefactoringStatus result) {
        HashSet<String> found = new HashSet<String>();
        HashSet<String> doubled = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            String newName = info.getNewName();
            if (found.contains(newName) && !doubled.contains(newName)) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.duplicate_name", newName));
                doubled.add(newName);
                continue;
            }
            found.add(newName);
        }
    }

    private ICompilationUnit getCu() {
        return WorkingCopyUtil.getWorkingCopyIfExists(this.fMethod.getCompilationUnit());
    }

    private boolean mustAnalyzeAst() throws JavaModelException {
        if (JdtFlags.isAbstract((IMember)this.getMethod())) {
            return false;
        }
        if (JdtFlags.isNative((IMember)this.getMethod())) {
            return false;
        }
        return !this.getMethod().getDeclaringType().isInterface();
    }

    private RefactoringStatus analyzeAst() throws JavaModelException {
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkCompilation());
            if (result.hasError()) {
                return result;
            }
            return result;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private RefactoringStatus checkCompilation() throws CoreException {
        ICompilationUnit cu = this.getCu();
        CompilationUnit compliationUnitNode = this.fAstManager.getAST(cu);
        TextChange change = this.fChangeManager.get(cu);
        String newCuSource = change.getPreviewContent();
        CompilationUnit newCUNode = AST.parseCompilationUnit((char[])newCuSource.toCharArray(), (String)cu.getElementName(), (IJavaProject)cu.getJavaProject());
        IProblem[] problems = RefactoringAnalyzeUtil.getIntroducedCompileProblems(newCuSource, newCUNode, compliationUnitNode);
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (this.shouldReport(problem)) {
                result.addEntry(RefactoringStatusEntry.create(problem, newCuSource));
            }
            ++i;
        }
        return result;
    }

    private boolean shouldReport(IProblem problem) {
        if (!problem.isError()) {
            return false;
        }
        return problem.getID() != 67109234;
    }

    private static String createGroupDescriptionString(String oldParamName) {
        return "rename." + oldParamName;
    }

    public String getReturnTypeString() {
        return this.fReturnTypeName;
    }

    private String getMethodParameters() throws JavaModelException {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (i != 0) {
                buff.append(", ");
            }
            buff.append(ChangeSignatureRefactoring.createDeclarationString(info));
            ++i;
        }
        return buff.toString();
    }

    private List getDeletedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(1);
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (!info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private List getNotDeletedInfos() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(this.fParameterInfos.size());
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isDeleted()) continue;
            result.add(info);
        }
        return result;
    }

    private boolean areNamesSameAsInitial() {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.getOldName().equals(info.getNewName())) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderSameAsInitial() {
        int i = 0;
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.getOldIndex() != i) {
                return false;
            }
            if (info.isAdded()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private RefactoringStatus checkReorderings(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        try {
            pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.checking_preconditions"), 2);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkNativeMethods());
            result.merge(this.checkParameterNamesInRippleMethods());
            refactoringStatus = result;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkParameterNamesInRippleMethods() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        Set newParameterNames = this.getNewParameterNamesList();
        int i = 0;
        while (i < this.fRippleMethods.length) {
            String[] paramNames = this.fRippleMethods[i].getParameterNames();
            int j = 0;
            while (j < paramNames.length) {
                if (newParameterNames.contains(paramNames[j])) {
                    String[] args = new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), paramNames[j]};
                    String msg = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.already_has", args);
                    Context context = JavaSourceContext.create(this.fRippleMethods[i].getCompilationUnit(), this.fRippleMethods[i].getNameRange());
                    result.addError(msg, context);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private Set getNewParameterNamesList() {
        Set oldNames = this.getOriginalParameterNames();
        Set currentNames = this.getNamesOfNotDeletedParameters();
        currentNames.removeAll(oldNames);
        return currentNames;
    }

    private Set getNamesOfNotDeletedParameters() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            result.add(info.getNewName());
        }
        return result;
    }

    private Set getOriginalParameterNames() {
        HashSet<String> result = new HashSet<String>();
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded()) continue;
            result.add(info.getOldName());
        }
        return result;
    }

    private RefactoringStatus checkNativeMethods() throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fRippleMethods.length) {
            if (JdtFlags.isNative((IMember)this.fRippleMethods[i])) {
                String message = RefactoringCoreMessages.getFormattedString("ChangeSignatureRefactoring.native", new String[]{JavaElementUtil.createMethodSignature(this.fRippleMethods[i]), JavaModelUtil.getFullyQualifiedName(this.fRippleMethods[i].getDeclaringType())});
                result.addError(message, JavaSourceContext.create((IMember)this.fRippleMethods[i]));
            }
            ++i;
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        pm.beginTask("", 1);
        try {
            compositeChange = new CompositeChange(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.restructure_parameters"), this.fChangeManager.getAllChanges());
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            this.clearManagers();
            this.fOccurrenceNodes = new ASTNode[0];
            throw throwable;
        }
        pm.done();
        this.clearManagers();
        this.fOccurrenceNodes = new ASTNode[0];
        return compositeChange;
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.preview"), 2);
        if (!this.areNamesSameAsInitial()) {
            this.addRenamings();
        }
        this.modifyMethodOccurrences((IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (this.isNoArgConstructor()) {
            this.modifyImplicitCallsToNoArgConstructor((IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        TextChangeManager manager = new TextChangeManager();
        this.fillWithRewriteEdits(manager);
        pm.done();
        return manager;
    }

    private void modifyImplicitCallsToNoArgConstructor(IProgressMonitor pm) throws JavaModelException {
        TypeDeclaration[] subclassNodes = this.getSubclassNodes(this.fMethod.getDeclaringType(), pm);
        int i = 0;
        while (i < subclassNodes.length) {
            this.modifyImplicitCallsToNoArgConstructor(subclassNodes[i]);
            ++i;
        }
    }

    private void modifyImplicitCallsToNoArgConstructor(TypeDeclaration subclass) {
        MethodDeclaration[] constructors = this.getAllConstructors(subclass);
        if (constructors.length == 0) {
            this.addNewConstructorToSubclass(subclass);
        } else {
            ASTRewrite rewrite = this.getRewrite((ASTNode)subclass);
            int i = 0;
            while (i < constructors.length) {
                if (this.containsImplicitCallToSuperConstructor(constructors[i])) {
                    SuperConstructorInvocation superCall = this.addExplicitSuperConstructorCall(constructors[i], rewrite);
                    rewrite.markAsInserted((ASTNode)superCall);
                }
                ++i;
            }
        }
    }

    private SuperConstructorInvocation addExplicitSuperConstructorCall(MethodDeclaration constructor, ASTRewrite rewrite) {
        SuperConstructorInvocation superCall = constructor.getAST().newSuperConstructorInvocation();
        this.addArgumentsToNewCuperConstructorCall(superCall, rewrite);
        constructor.getBody().statements().add(0, superCall);
        return superCall;
    }

    private void addArgumentsToNewCuperConstructorCall(SuperConstructorInvocation superCall, ASTRewrite rewrite) {
        int i = 0;
        Iterator iter = this.getNotDeletedInfos().iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            superCall.arguments().add(i, ChangeSignatureRefactoring.createNewExpression(rewrite, info));
            ++i;
        }
    }

    private boolean containsImplicitCallToSuperConstructor(MethodDeclaration constructor) {
        Assert.isTrue(constructor.isConstructor());
        Block body = constructor.getBody();
        if (body == null) {
            return false;
        }
        if (body.statements().size() == 0) {
            return true;
        }
        if (body.statements().get(0) instanceof ConstructorInvocation) {
            return false;
        }
        return !(body.statements().get(0) instanceof SuperConstructorInvocation);
    }

    private void addNewConstructorToSubclass(TypeDeclaration subclass) {
        AST ast = subclass.getAST();
        MethodDeclaration newConstructor = ast.newMethodDeclaration();
        newConstructor.setName(ast.newSimpleName(subclass.getName().getIdentifier()));
        newConstructor.setConstructor(true);
        newConstructor.setBody(ast.newBlock());
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        newConstructor.setModifiers(ChangeSignatureRefactoring.getAccessModifier(subclass));
        newConstructor.setReturnType((Type)ast.newPrimitiveType(PrimitiveType.VOID));
        this.addExplicitSuperConstructorCall(newConstructor, this.getRewrite((ASTNode)subclass));
        subclass.bodyDeclarations().add(0, newConstructor);
        this.getRewrite((ASTNode)subclass).markAsInserted((ASTNode)newConstructor);
    }

    private static int getAccessModifier(TypeDeclaration subclass) {
        int modifiers = subclass.getModifiers();
        if (Modifier.isPublic((int)modifiers)) {
            return 1;
        }
        if (Modifier.isProtected((int)modifiers)) {
            return 4;
        }
        if (Modifier.isPrivate((int)modifiers)) {
            return 2;
        }
        return 0;
    }

    private MethodDeclaration[] getAllConstructors(TypeDeclaration typeDeclaration) {
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(1);
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                result.add(methods[i]);
            }
            ++i;
        }
        return result.toArray(new MethodDeclaration[result.size()]);
    }

    private TypeDeclaration[] getSubclassNodes(IType iType, IProgressMonitor pm) throws JavaModelException {
        IType[] subclasses = this.getSubclasses(iType, pm);
        ArrayList<TypeDeclaration> result = new ArrayList<TypeDeclaration>(subclasses.length);
        int i = 0;
        while (i < subclasses.length) {
            TypeDeclaration td = ASTNodeSearchUtil.getTypeDeclarationNode(subclasses[i], this.fAstManager);
            if (td != null) {
                result.add(td);
            }
            ++i;
        }
        return result.toArray(new TypeDeclaration[result.size()]);
    }

    private IType[] getSubclasses(IType iType, IProgressMonitor pm) throws JavaModelException {
        return iType.newTypeHierarchy(pm).getSubclasses(iType);
    }

    private boolean isNoArgConstructor() throws JavaModelException {
        return this.fMethod.isConstructor() && this.fMethod.getNumberOfParameters() == 0;
    }

    private void fillWithRewriteEdits(TextChangeManager manager) throws JavaModelException, CoreException {
        CompilationUnit[] cuNodes = this.fRewriteManager.getAllCompilationUnitNodes();
        int i = 0;
        while (i < cuNodes.length) {
            CompilationUnit cuNode = cuNodes[i];
            ASTRewrite rewrite = this.fRewriteManager.getRewrite(cuNode);
            TextBuffer textBuffer = TextBuffer.create(this.fAstManager.getCompilationUnit((ASTNode)cuNode).getBuffer().getContents());
            MultiTextEdit resultingEdits = new MultiTextEdit();
            rewrite.rewriteNode(textBuffer, resultingEdits, this.fDescriptionGroups);
            ICompilationUnit cu = this.fAstManager.getCompilationUnit((ASTNode)cuNode);
            TextChange textChange = manager.get(this.fAstManager.getCompilationUnit((ASTNode)cuNode));
            if (this.fImportEditManager.hasImportEditFor(cu)) {
                resultingEdits.add(this.fImportEditManager.getImportEdit(cu));
            }
            textChange.addTextEdit(RefactoringCoreMessages.getString("ChangeSignatureRefactoring.modify_parameters"), resultingEdits);
            rewrite.removeModifications();
            ++i;
        }
    }

    private void modifyMethodOccurrences(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fOccurrenceNodes.length);
        try {
            int i = 0;
            while (i < this.fOccurrenceNodes.length) {
                ASTNode methodOccurrence = this.fOccurrenceNodes[i];
                if (ChangeSignatureRefactoring.isReferenceNode(methodOccurrence)) {
                    this.updateReferenceNode(methodOccurrence);
                } else {
                    this.updateDeclarationNode(methodOccurrence);
                }
                pm.worked(1);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            pm.done();
            throw throwable;
        }
        Object var4_6 = null;
        pm.done();
    }

    private void updateDeclarationNode(ASTNode methodOccurrence) throws JavaModelException {
        MethodDeclaration methodDeclaration = ChangeSignatureRefactoring.getMethodDeclaration(methodOccurrence);
        if (methodDeclaration == null) {
            return;
        }
        if (!methodDeclaration.isConstructor()) {
            this.changeReturnType(methodDeclaration);
        }
        this.changeParameterTypes(methodDeclaration);
        if (this.needsVisibilityUpdate(methodDeclaration)) {
            this.changeVisibility(methodDeclaration);
        }
        this.reshuffleElements(methodOccurrence, methodDeclaration.parameters());
    }

    private void changeParameterTypes(MethodDeclaration methodDeclaration) {
        Iterator iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = (ParameterInfo)iter.next();
            if (info.isAdded() || info.isDeleted() || !info.isTypeNameChanged()) continue;
            SingleVariableDeclaration oldParam = (SingleVariableDeclaration)methodDeclaration.parameters().get(info.getOldIndex());
            this.replaceTypeNode(oldParam.getType(), info.getNewTypeName());
        }
    }

    private void replaceTypeNode(Type typeNode, String newTypeName) {
        Type newParamType = (Type)this.getRewrite((ASTNode)typeNode).createPlaceholder(newTypeName, 6);
        this.getRewrite((ASTNode)typeNode).markAsReplaced((ASTNode)typeNode, (ASTNode)newParamType);
    }

    private ASTRewrite getRewrite(ASTNode node) {
        return this.fRewriteManager.getRewrite(ASTNodeMappingManager.getCompilationUnitNode(node));
    }

    private void changeReturnType(MethodDeclaration methodDeclaration) {
        this.replaceTypeNode(methodDeclaration.getReturnType(), this.fReturnTypeName);
    }

    private void changeVisibility(MethodDeclaration methodDeclaration) throws JavaModelException {
        MethodDeclaration modifierMethodDeclaration = methodDeclaration.getAST().newMethodDeclaration();
        modifierMethodDeclaration.setModifiers(this.getNewModifiers(methodDeclaration));
        modifierMethodDeclaration.setExtraDimensions(methodDeclaration.getExtraDimensions());
        ASTRewrite rewrite = this.getRewrite((ASTNode)methodDeclaration);
        rewrite.markAsModified((ASTNode)methodDeclaration, (ASTNode)modifierMethodDeclaration);
    }

    private void updateReferenceNode(ASTNode methodOccurrence) {
        this.reshuffleElements(methodOccurrence, ChangeSignatureRefactoring.getArguments(methodOccurrence));
    }

    private void reshuffleElements(ASTNode methodOccurrence, List elementList) {
        ParameterInfo info;
        ASTRewrite rewrite = this.getRewrite(methodOccurrence);
        AST ast = methodOccurrence.getAST();
        boolean isReference = ChangeSignatureRefactoring.isReferenceNode(methodOccurrence);
        ASTNode[] nodes = this.getSubNodesOfMethodOccurrenceNode(methodOccurrence);
        this.deleteExcesiveElements(rewrite, nodes);
        List nonDeletedInfos = this.getNotDeletedInfos();
        ASTNode[] newPermutation = new ASTNode[nonDeletedInfos.size()];
        int i = 0;
        while (i < newPermutation.length) {
            info = (ParameterInfo)nonDeletedInfos.get(i);
            newPermutation[i] = info.isAdded() ? this.createNewElementForList(rewrite, ast, info, isReference) : (info.getOldIndex() != i ? (rewrite.isReplaced(nodes[info.getOldIndex()]) ? rewrite.getReplacingNode(nodes[info.getOldIndex()]) : rewrite.createCopy(nodes[info.getOldIndex()])) : nodes[i]);
            ++i;
        }
        i = 0;
        while (i < Math.min(nodes.length, newPermutation.length)) {
            if (nodes[i] != newPermutation[i]) {
                rewrite.markAsReplaced(nodes[i], newPermutation[i]);
            }
            ++i;
        }
        i = nodes.length;
        while (i < newPermutation.length) {
            info = (ParameterInfo)nonDeletedInfos.get(i);
            if (info.isAdded()) {
                ASTNode newElement = this.createNewElementForList(rewrite, ast, info, isReference);
                elementList.add(i, newElement);
                rewrite.markAsInserted(newElement);
            } else {
                elementList.add(i, newPermutation[i]);
                rewrite.markAsInserted(newPermutation[i]);
            }
            ++i;
        }
    }

    private void deleteExcesiveElements(ASTRewrite rewrite, ASTNode[] nodes) {
        int i = this.getNotDeletedInfos().size();
        while (i < nodes.length) {
            rewrite.markAsRemoved(nodes[i]);
            ++i;
        }
    }

    private ASTNode createNewElementForList(ASTRewrite rewrite, AST ast, ParameterInfo info, boolean isReferenceNode) {
        if (isReferenceNode) {
            return ChangeSignatureRefactoring.createNewExpression(rewrite, info);
        }
        return ChangeSignatureRefactoring.createNewSingleVariableDeclaration(rewrite, ast, info);
    }

    private static SingleVariableDeclaration createNewSingleVariableDeclaration(ASTRewrite rewrite, AST ast, ParameterInfo info) {
        SingleVariableDeclaration newP = ast.newSingleVariableDeclaration();
        newP.setName(ast.newSimpleName(info.getNewName()));
        newP.setType((Type)rewrite.createPlaceholder(info.getNewTypeName(), 6));
        return newP;
    }

    private static Expression createNewExpression(ASTRewrite rewrite, ParameterInfo info) {
        return (Expression)rewrite.createPlaceholder(info.getDefaultValue(), 3);
    }

    private int getNewModifiers(MethodDeclaration md) {
        return ASTNodes.clearAccessModifiers(md.getModifiers()) | this.fVisibility;
    }

    private IMethod getMethod(MethodDeclaration methodDeclaration) throws JavaModelException {
        return (IMethod)this.fAstManager.getCompilationUnit((ASTNode)methodDeclaration).getElementAt(methodDeclaration.getName().getStartPosition());
    }

    private boolean needsVisibilityUpdate(MethodDeclaration methodDeclaration) throws JavaModelException {
        return this.needsVisibilityUpdate(this.getMethod(methodDeclaration));
    }

    private boolean needsVisibilityUpdate(IMethod method) throws JavaModelException {
        if (this.isVisibilitySameAsInitial()) {
            return false;
        }
        if (this.isIncreasingVisibility()) {
            return JdtFlags.isHigherVisibility(this.fVisibility, JdtFlags.getVisibilityCode((IMember)method));
        }
        return JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((IMember)method), this.fVisibility);
    }

    private boolean isIncreasingVisibility() throws JavaModelException {
        return JdtFlags.isHigherVisibility(this.fVisibility, JdtFlags.getVisibilityCode((IMember)this.fMethod));
    }

    private boolean isVisibilitySameAsInitial() throws JavaModelException {
        return this.fVisibility == JdtFlags.getVisibilityCode((IMember)this.fMethod);
    }

    private ParameterInfo[] getRenamedParameterNames() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        Iterator iterator = this.getParameterInfos().iterator();
        while (iterator.hasNext()) {
            ParameterInfo info = (ParameterInfo)iterator.next();
            if (info.isAdded() || info.getOldName().equals(info.getNewName())) continue;
            result.add(info);
        }
        return result.toArray(new ParameterInfo[result.size()]);
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fMethod);
    }

    private ASTNode[] findOccurrenceNodes(IProgressMonitor pm) throws JavaModelException {
        if (this.fMethod.isConstructor()) {
            return ConstructorReferenceFinder.getConstructorOccurrenceNodes(this.fMethod, this.fAstManager, pm);
        }
        return ASTNodeSearchUtil.findOccurrenceNodes((IJavaElement[])this.fRippleMethods, this.fAstManager, pm, this.createRefactoringScope());
    }

    private void addRenamings() throws JavaModelException {
        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fMethod, this.fAstManager);
        ParameterInfo[] infos = this.getRenamedParameterNames();
        ICompilationUnit cu = WorkingCopyUtil.getWorkingCopyIfExists(this.fMethod.getCompilationUnit());
        if (cu == null) {
            return;
        }
        int i = 0;
        while (i < infos.length) {
            ParameterInfo info = infos[i];
            SingleVariableDeclaration param = (SingleVariableDeclaration)methodDeclaration.parameters().get(info.getOldIndex());
            ASTNode[] paramOccurrences = TempOccurrenceFinder.findTempOccurrenceNodes((VariableDeclaration)param, true, true);
            int j = 0;
            while (j < paramOccurrences.length) {
                ASTNode occurence = paramOccurrences[j];
                if (occurence instanceof SimpleName) {
                    SimpleName newName = occurence.getAST().newSimpleName(info.getNewName());
                    this.fRewriteManager.getRewrite(cu).markAsReplaced(occurence, (ASTNode)newName, ChangeSignatureRefactoring.createGroupDescriptionString(info.getOldName()));
                }
                ++j;
            }
            ++i;
        }
    }

    private ASTNode[] getSubNodesOfMethodOccurrenceNode(ASTNode occurrenceNode) {
        if (ChangeSignatureRefactoring.isReferenceNode(occurrenceNode)) {
            return ChangeSignatureRefactoring.getArguments(occurrenceNode).toArray(new Expression[ChangeSignatureRefactoring.getArguments(occurrenceNode).size()]);
        }
        return this.getSubNodesOfMethodDeclarationNode(occurrenceNode);
    }

    private SingleVariableDeclaration[] getSubNodesOfMethodDeclarationNode(ASTNode occurrenceNode) {
        Assert.isTrue(!ChangeSignatureRefactoring.isReferenceNode(occurrenceNode));
        MethodDeclaration methodDeclaration = ChangeSignatureRefactoring.getMethodDeclaration(occurrenceNode);
        if (methodDeclaration == null) {
            return new SingleVariableDeclaration[0];
        }
        return methodDeclaration.parameters().toArray(new SingleVariableDeclaration[methodDeclaration.parameters().size()]);
    }

    private static MethodDeclaration getMethodDeclaration(ASTNode node) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent(node, clazz);
    }

    private static String createDeclarationString(ParameterInfo info) {
        return String.valueOf(info.getNewTypeName()) + " " + info.getNewName();
    }

    private static List getArguments(ASTNode node) {
        if (node instanceof SimpleName && node.getParent() instanceof MethodInvocation) {
            return ((MethodInvocation)node.getParent()).arguments();
        }
        if (node instanceof SimpleName && node.getParent() instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node.getParent()).arguments();
        }
        if (node instanceof SimpleName && node.getParent() instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)node.getParent()).arguments();
        }
        if (node instanceof ExpressionStatement && ChangeSignatureRefactoring.isReferenceNode((ASTNode)((ExpressionStatement)node).getExpression())) {
            return ChangeSignatureRefactoring.getArguments((ASTNode)((ExpressionStatement)node).getExpression());
        }
        if (node instanceof MethodInvocation) {
            return ((MethodInvocation)node).arguments();
        }
        if (node instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)node).arguments();
        }
        if (node instanceof ClassInstanceCreation) {
            return ((ClassInstanceCreation)node).arguments();
        }
        if (node instanceof ConstructorInvocation) {
            return ((ConstructorInvocation)node).arguments();
        }
        if (node instanceof SuperConstructorInvocation) {
            return ((SuperConstructorInvocation)node).arguments();
        }
        return null;
    }

    private static boolean isReferenceNode(ASTNode node) {
        if (node instanceof SimpleName && node.getParent() instanceof MethodInvocation) {
            return true;
        }
        if (node instanceof SimpleName && node.getParent() instanceof SuperMethodInvocation) {
            return true;
        }
        if (node instanceof SimpleName && node.getParent() instanceof ClassInstanceCreation) {
            return true;
        }
        if (node instanceof ExpressionStatement && ChangeSignatureRefactoring.isReferenceNode((ASTNode)((ExpressionStatement)node).getExpression())) {
            return true;
        }
        if (node instanceof MethodInvocation) {
            return true;
        }
        if (node instanceof SuperMethodInvocation) {
            return true;
        }
        if (node instanceof ClassInstanceCreation) {
            return true;
        }
        if (node instanceof ConstructorInvocation) {
            return true;
        }
        return node instanceof SuperConstructorInvocation;
    }
}

