/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class ASTRewriteManager {
    private final Map fRewrites;
    private final ASTNodeMappingManager fNodeMapper;

    ASTRewriteManager(ASTNodeMappingManager nodeMapper) {
        Assert.isNotNull(nodeMapper);
        this.fRewrites = new HashMap(2);
        this.fNodeMapper = nodeMapper;
    }

    ASTRewrite getRewrite(ICompilationUnit cu) {
        return this.getRewrite(this.fNodeMapper.getAST(WorkingCopyUtil.getWorkingCopyIfExists(cu)));
    }

    ASTRewrite getRewrite(CompilationUnit cuNode) {
        if (this.fRewrites.containsKey(cuNode)) {
            return (ASTRewrite)this.fRewrites.get(cuNode);
        }
        ASTRewrite cuRewrite = new ASTRewrite((ASTNode)cuNode);
        this.fRewrites.put(cuNode, cuRewrite);
        return cuRewrite;
    }

    CompilationUnit[] getAllCompilationUnitNodes() {
        return this.fRewrites.keySet().toArray(new CompilationUnit[this.fRewrites.keySet().size()]);
    }

    public void clear() {
        this.removeRewriteModifications();
        this.fRewrites.clear();
    }

    private void removeRewriteModifications() {
        Iterator iter = this.fRewrites.values().iterator();
        while (iter.hasNext()) {
            ASTRewrite rewrite = (ASTRewrite)iter.next();
            rewrite.removeModifications();
        }
    }
}

