/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeMappingManager;

class ASTNodeSearchUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private ASTNodeSearchUtil() {
    }

    public static ASTNode[] findReferenceNodes(IJavaElement[] elements, ASTNodeMappingManager astManager, IProgressMonitor pm, IJavaSearchScope scope) throws JavaModelException {
        ISearchPattern pattern = RefactoringSearchEngine.createSearchPattern(elements, 2);
        return ASTNodeSearchUtil.searchNodes(scope, pattern, astManager, pm);
    }

    public static ASTNode[] findOccurrenceNodes(IJavaElement[] elements, ASTNodeMappingManager astManager, IProgressMonitor pm, IJavaSearchScope scope) throws JavaModelException {
        ISearchPattern pattern = RefactoringSearchEngine.createSearchPattern(elements, 3);
        return ASTNodeSearchUtil.searchNodes(scope, pattern, astManager, pm);
    }

    public static ASTNode[] findReferenceNodes(IJavaElement element, ASTNodeMappingManager astManager, IProgressMonitor pm) throws JavaModelException {
        ISearchPattern pattern = SearchEngine.createSearchPattern((IJavaElement)element, (int)2);
        IJavaSearchScope scope = RefactoringScopeFactory.create(element);
        return ASTNodeSearchUtil.searchNodes(scope, pattern, astManager, pm);
    }

    public static ASTNode[] searchNodes(IJavaSearchScope scope, ISearchPattern pattern, ASTNodeMappingManager astManager, IProgressMonitor pm) throws JavaModelException {
        SearchResultGroup[] searchResultGroups = RefactoringSearchEngine.search(pm, scope, pattern);
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        int i = 0;
        while (i < searchResultGroups.length) {
            ICompilationUnit referencedCu = searchResultGroups[i].getCompilationUnit();
            if (referencedCu != null) {
                result.addAll(Arrays.asList(ASTNodeSearchUtil.getAstNodes(searchResultGroups[i].getSearchResults(), astManager.getAST(referencedCu))));
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode[] getAstNodes(SearchResult[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.getAstNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private static ASTNode getAstNode(SearchResult searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = ASTNodeSearchUtil.getAstNode(cuNode, searchResult.getStart(), searchResult.getEnd() - searchResult.getStart());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }

    private static ASTNode getAstNode(CompilationUnit cuNode, int start, int length) {
        MethodDeclaration md;
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(start, length), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode node = analyzer.getFirstSelectedNode();
        if (node == null && analyzer.getLastCoveringNode() instanceof SuperConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        }
        if (node != null && node.getParent() instanceof MethodDeclaration && (md = (MethodDeclaration)node.getParent()).isConstructor() && md.getBody() != null && md.getBody().statements().size() > 0 && md.getBody().statements().get(0) instanceof ConstructorInvocation && ((ASTNode)md.getBody().statements().get(0)).getLength() == length + 1) {
            return (ASTNode)md.getBody().statements().get(0);
        }
        if (node != null && node.getParent() instanceof MethodDeclaration && (md = (MethodDeclaration)node.getParent()).isConstructor() && md.getBody() != null && md.getBody().statements().size() > 0 && md.getBody().statements().get(0) instanceof SuperConstructorInvocation && ((ASTNode)md.getBody().statements().get(0)).getLength() == length + 1) {
            return (ASTNode)md.getBody().statements().get(0);
        }
        if (node != null && node.getParent() instanceof SuperConstructorInvocation && node.getParent().getLength() == length + 1) {
            return node.getParent();
        }
        if (node != null && node.getParent() instanceof ConstructorInvocation && node.getParent().getLength() == length + 1) {
            return node.getParent();
        }
        return node;
    }

    public static MethodDeclaration getMethodDeclarationNode(IMethod iMethod, ASTNodeMappingManager astManager) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getDeclarationNode((IMember)iMethod, astManager);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, ASTNodeMappingManager astManager) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.getDeclarationNode((IMember)iField, astManager);
        if (node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(node, clazz);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, ASTNodeMappingManager astManager) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getDeclarationNode((IMember)iField, astManager);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (FieldDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, ASTNodeMappingManager astManager) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getDeclarationNode((IMember)iType, astManager);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    private static ASTNode getDeclarationNode(IMember iMember, ASTNodeMappingManager astManager) throws JavaModelException {
        Assert.isTrue(!(iMember instanceof IInitializer));
        Selection selection = Selection.createFromStartLength(iMember.getNameRange().getOffset(), iMember.getNameRange().getLength());
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(selection, true);
        astManager.getAST(iMember.getCompilationUnit()).accept((ASTVisitor)selectionAnalyzer);
        ASTNode node = selectionAnalyzer.getFirstSelectedNode();
        if (node == null) {
            node = selectionAnalyzer.getLastCoveringNode();
        }
        return node;
    }
}

