/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

class ASTNodeMappingManager {
    private final Map fCUsToCuNodes = new HashMap();
    private final Map fCuNodesToCus = new HashMap();
    static /* synthetic */ Class class$0;

    public CompilationUnit getAST(ICompilationUnit cu) {
        ICompilationUnit wc = WorkingCopyUtil.getWorkingCopyIfExists(cu);
        if (this.fCUsToCuNodes.containsKey(wc)) {
            return (CompilationUnit)this.fCUsToCuNodes.get(wc);
        }
        CompilationUnit cuNode = AST.parseCompilationUnit((ICompilationUnit)wc, (boolean)true);
        this.fCUsToCuNodes.put(wc, cuNode);
        this.fCuNodesToCus.put(cuNode, wc);
        return cuNode;
    }

    public ICompilationUnit getCompilationUnit(ASTNode node) {
        CompilationUnit cuNode = ASTNodeMappingManager.getCompilationUnitNode(node);
        Assert.isTrue(this.fCuNodesToCus.containsKey(cuNode));
        return (ICompilationUnit)this.fCuNodesToCus.get(cuNode);
    }

    public static CompilationUnit getCompilationUnitNode(ASTNode node) {
        if (node instanceof CompilationUnit) {
            return (CompilationUnit)node;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (CompilationUnit)ASTNodes.getParent(node, clazz);
    }

    public ICompilationUnit[] getAllCompilationUnits() {
        return this.fCUsToCuNodes.keySet().toArray(new ICompilationUnit[this.fCUsToCuNodes.keySet().size()]);
    }

    public void clear() {
        this.fCuNodesToCus.clear();
        this.fCUsToCuNodes.clear();
    }
}

