/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ChangeVisibilityEdit;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.codemanipulation.MemberEdit;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.BindingIdentifier;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.JavaElementMapper;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.sef.AccessAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class SelfEncapsulateFieldRefactoring
extends Refactoring {
    private IField fField;
    private CodeGenerationSettings fSettings;
    private TextChangeManager fChangeManager;
    private CompositeChange fChange;
    private VariableDeclarationFragment fFieldDeclaration;
    private int fVisibility;
    private String fGetterName;
    private String fSetterName;
    private String fArgName;
    private boolean fSetterMustReturnValue;
    private int fInsertionIndex;
    private boolean fEncapsulateDeclaringClass;
    private List fUsedReadNames;
    private List fUsedModifyNames;
    private TextEdit[] fNewMethods;
    private static final String NO_NAME = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SelfEncapsulateFieldRefactoring(IField field, CodeGenerationSettings settings) throws JavaModelException {
        Assert.isNotNull(field);
        Assert.isNotNull(settings);
        this.fField = field;
        this.fSettings = settings;
        this.fChangeManager = new TextChangeManager();
        this.fChange = new CompositeChange(this.getName());
        this.fGetterName = GetterSetterUtil.getGetterName(field, null);
        this.fSetterName = GetterSetterUtil.getSetterName(field, null);
        this.fEncapsulateDeclaringClass = true;
        this.fArgName = NamingConventions.removePrefixAndSuffixForFieldName((IJavaProject)field.getJavaProject(), (String)field.getElementName(), (int)field.getFlags());
        this.checkArgName();
        this.fNewMethods = new TextEdit[2];
    }

    public IField getField() {
        return this.fField;
    }

    public String getGetterName() {
        return this.fGetterName;
    }

    public void setGetterName(String name) {
        this.fGetterName = name;
        Assert.isNotNull(this.fGetterName);
    }

    public String getSetterName() {
        return this.fSetterName;
    }

    public void setSetterName(String name) {
        this.fSetterName = name;
        Assert.isNotNull(this.fSetterName);
    }

    public void setInsertionIndex(int index) {
        this.fInsertionIndex = index;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public void setEncapsulateDeclaringClass(boolean encapsulateDeclaringClass) {
        this.fEncapsulateDeclaringClass = encapsulateDeclaringClass;
    }

    public boolean getEncapsulateDeclaringClass() {
        return this.fEncapsulateDeclaringClass;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        ASTNode node;
        this.fVisibility = this.fField.getFlags() & 7;
        RefactoringStatus result = new RefactoringStatus();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((node = JavaElementMapper.perform((IMember)this.fField, clazz)) == null || !(node instanceof VariableDeclarationFragment)) {
            return this.mappingErrorFound(result, node);
        }
        this.fFieldDeclaration = (VariableDeclarationFragment)node;
        if (this.fFieldDeclaration.resolveBinding() == null) {
            if (!this.processCompilerError(result, node)) {
                result.addFatalError(RefactoringCoreMessages.getString("SelfEncapsulateField.type_not_resolveable"));
            }
            return result;
        }
        result.merge(Checks.validateModifiesFiles(new IFile[]{ResourceUtil.getFile(this.fField.getCompilationUnit())}));
        if (result.hasFatalError()) {
            return result;
        }
        this.computeUsedNames();
        return result;
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.compiler_errors_field", new String[]{this.fField.getElementName(), messages[0].getMessage()}));
        return true;
    }

    private String getMappingErrorMessage() {
        return RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.cannot_analyze_selected_field", new String[]{this.fField.getElementName()});
    }

    public RefactoringStatus checkMethodNames() {
        RefactoringStatus result = new RefactoringStatus();
        IType declaringType = this.fField.getDeclaringType();
        SelfEncapsulateFieldRefactoring.checkName(result, this.fGetterName, this.fUsedReadNames, declaringType);
        SelfEncapsulateFieldRefactoring.checkName(result, this.fSetterName, this.fUsedModifyNames, declaringType);
        return result;
    }

    private static void checkName(RefactoringStatus status, String name, List usedNames, IType type) {
        if (NO_NAME.equals(name)) {
            status.addFatalError(RefactoringCoreMessages.getString("Checks.Choose_name"));
            return;
        }
        status.merge(Checks.checkMethodName(name));
        Iterator iter = usedNames.iterator();
        while (iter.hasNext()) {
            IMethodBinding method = (IMethodBinding)iter.next();
            String selector = method.getName();
            if (!selector.equals(name)) continue;
            status.addFatalError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.method_exists", new String[]{Bindings.asString(method), type.getElementName()}));
        }
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        try {
            RefactoringStatus result = new RefactoringStatus();
            this.fChangeManager.clear();
            pm.beginTask(NO_NAME, 11);
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.checking_preconditions"));
            result.merge(this.checkMethodNames());
            pm.worked(1);
            if (result.hasFatalError()) {
                return result;
            }
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.searching_for_cunits"));
            ICompilationUnit[] affectedCUs = RefactoringSearchEngine.findAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, 5), RefactoringScopeFactory.create((IJavaElement)this.fField), SearchEngine.createSearchPattern((IJavaElement)this.fField, (int)2));
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(affectedCUs)));
            this.checkInHierarchy(result);
            if (result.hasFatalError()) {
                return result;
            }
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.analyzing"));
            SubProgressMonitor sub = new SubProgressMonitor(pm, 5);
            sub.beginTask(NO_NAME, affectedCUs.length);
            BindingIdentifier fieldIdentifier = new BindingIdentifier((IBinding)this.fFieldDeclaration.resolveBinding());
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BindingIdentifier declaringClass = new BindingIdentifier((IBinding)((TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, clazz)).resolveBinding());
            int i = 0;
            while (i < affectedCUs.length) {
                ICompilationUnit unit = affectedCUs[i];
                sub.subTask(unit.getElementName());
                CompilationUnit root = AST.parseCompilationUnit((ICompilationUnit)unit, (boolean)true);
                if (this.isProcessable(result, root, unit)) {
                    TextChange change = this.fChangeManager.get(unit);
                    AccessAnalyzer analyzer = new AccessAnalyzer(this, unit, fieldIdentifier, declaringClass, change);
                    root.accept((ASTVisitor)analyzer);
                    result.merge(analyzer.getStatus());
                    if (!this.fSetterMustReturnValue) {
                        this.fSetterMustReturnValue = analyzer.getSetterMustReturnValue();
                    }
                }
                if (result.hasFatalError()) break;
                sub.worked(1);
                ++i;
            }
            if (result.hasFatalError()) {
                return result;
            }
            sub.done();
            return result;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        try {
            CompositeChange result = new CompositeChange(this.getName());
            this.addGetterSetterChanges();
            TextChange[] changes = this.fChangeManager.getAllChanges();
            pm.beginTask(NO_NAME, changes.length);
            pm.setTaskName(RefactoringCoreMessages.getString("SelfEncapsulateField.create_changes"));
            int i = 0;
            while (i < changes.length) {
                result.add(changes[i]);
                pm.worked(1);
                ++i;
            }
            pm.done();
            return result;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public String getName() {
        return RefactoringCoreMessages.getString("SelfEncapsulateField.name");
    }

    private boolean isProcessable(RefactoringStatus result, CompilationUnit root, ICompilationUnit element) {
        Message[] messages = root.getMessages();
        if (messages.length != 0) {
            result.addError(RefactoringCoreMessages.getFormattedString("SelfEncapsulateField.compiler_errors_update", element.getElementName()), JavaSourceContext.create(element));
        }
        return true;
    }

    private void checkInHierarchy(RefactoringStatus status) throws CoreException {
        TypeDeclaration declaration = (TypeDeclaration)ASTNodes.getParent((ASTNode)this.fFieldDeclaration, 55);
        ITypeBinding type = declaration.resolveBinding();
        if (type != null) {
            ITypeBinding fieldType = this.fFieldDeclaration.resolveBinding().getType();
            status.merge(Checks.checkMethodInHierarchy(type, this.fGetterName, fieldType, new ITypeBinding[0], this.fField.getJavaProject()));
            status.merge(Checks.checkMethodInHierarchy(type, this.fSetterName, this.fFieldDeclaration.getAST().resolveWellKnownType("void"), new ITypeBinding[]{fieldType}, this.fField.getJavaProject()));
        }
    }

    private void computeUsedNames() {
        this.fUsedReadNames = new ArrayList(0);
        this.fUsedModifyNames = new ArrayList(0);
        IVariableBinding binding = this.fFieldDeclaration.resolveBinding();
        ITypeBinding type = binding.getType();
        IMethodBinding[] methods = binding.getDeclaringClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding method = methods[i];
            ITypeBinding[] parameters = methods[i].getParameterTypes();
            if (parameters == null || parameters.length == 0) {
                this.fUsedReadNames.add(method);
            } else if (parameters.length == 1 && parameters[0] == type) {
                this.fUsedModifyNames.add(method);
            }
            ++i;
        }
    }

    private void addGetterSetterChanges() throws CoreException {
        int insertionKind = 1;
        IMethod sibling = null;
        IMethod[] methods = this.fField.getDeclaringType().getMethods();
        if (this.fInsertionIndex < 0) {
            if (methods.length > 0) {
                sibling = methods[0];
                insertionKind = 0;
            } else {
                IField[] fields = this.fField.getDeclaringType().getFields();
                sibling = fields[fields.length - 1];
            }
        } else {
            sibling = methods[this.fInsertionIndex];
        }
        TextChange change = this.fChangeManager.get(this.fField.getCompilationUnit());
        if (!JdtFlags.isPrivate((IMember)this.fField)) {
            change.addTextEdit(RefactoringCoreMessages.getString("SelfEncapsulateField.change_visibility"), new ChangeVisibilityEdit((IMember)this.fField, 2));
        }
        String modifiers = this.createModifiers();
        String type = Signature.toString((String)this.fField.getTypeSignature());
        if (!JdtFlags.isFinal((IMember)this.fField)) {
            change.addTextEdit(RefactoringCoreMessages.getString("SelfEncapsulateField.add_setter"), this.createSetterMethod(insertionKind, (IMember)sibling, modifiers, type));
        }
        change.addTextEdit(RefactoringCoreMessages.getString("SelfEncapsulateField.add_getter"), this.createGetterMethod(insertionKind, (IMember)sibling, modifiers, type));
    }

    private TextEdit createSetterMethod(int insertionKind, IMember sibling, String modifiers, String type) throws JavaModelException {
        String returnType = this.createSetterReturnType();
        String returnStatement = this.fSetterMustReturnValue ? "return " : NO_NAME;
        this.fNewMethods[1] = this.createMemberEdit(sibling, insertionKind, new String[]{String.valueOf(modifiers) + "  " + returnType + " " + this.getSetterName() + "(" + type + " " + this.fArgName + ") {", String.valueOf(returnStatement) + this.createFieldAccess() + " = " + this.fArgName + ";", "}"});
        return this.fNewMethods[1];
    }

    private TextEdit createGetterMethod(int insertionKind, IMember sibling, String modifiers, String type) {
        this.fNewMethods[0] = this.createMemberEdit(sibling, insertionKind, new String[]{String.valueOf(modifiers) + " " + type + " " + this.getGetterName() + "() {", "return " + this.fField.getElementName() + ";", "}"});
        return this.fNewMethods[0];
    }

    private MemberEdit createMemberEdit(IMember sibling, int insertionKind, String[] source) {
        MemberEdit result = new MemberEdit((IJavaElement)sibling, insertionKind, source, this.fSettings.tabWidth);
        result.setUseFormatter(true);
        return result;
    }

    private String createModifiers() throws JavaModelException {
        StringBuffer result = new StringBuffer();
        if (Flags.isPublic((int)this.fVisibility)) {
            result.append("public ");
        } else if (Flags.isProtected((int)this.fVisibility)) {
            result.append("protected ");
        } else if (Flags.isPrivate((int)this.fVisibility)) {
            result.append("private ");
        }
        if (JdtFlags.isStatic((IMember)this.fField)) {
            result.append("static ");
        }
        return result.toString();
    }

    private String createSetterReturnType() throws JavaModelException {
        return this.fSetterMustReturnValue ? Signature.toString((String)this.fField.getTypeSignature()) : "void";
    }

    private String createFieldAccess() throws JavaModelException {
        String fieldName = this.fField.getElementName();
        if (this.fArgName.equals(fieldName)) {
            return String.valueOf(JdtFlags.isStatic((IMember)this.fField) ? String.valueOf(this.fField.getDeclaringType().getElementName()) + "." : "this.") + fieldName;
        }
        return fieldName;
    }

    private void checkArgName() {
        String fieldName = this.fField.getElementName();
        boolean isStatic = true;
        try {
            isStatic = JdtFlags.isStatic((IMember)this.fField);
        }
        catch (JavaModelException javaModelException) {}
        if (isStatic && this.fArgName.equals(fieldName) && fieldName.equals(this.fField.getDeclaringType().getElementName())) {
            this.fArgName = "_" + fieldName;
        }
    }
}

