/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.jdt.internal.corext.textmanipulation.TextEditCopier;

final class EncapsulateWriteAccess
extends MultiTextEdit {
    public EncapsulateWriteAccess(String getter, String setter, Assignment assignment) {
        int offset = EncapsulateWriteAccess.getOffset(assignment);
        int length = EncapsulateWriteAccess.getLength(assignment, offset);
        int bracket = EncapsulateWriteAccess.getBracketOffset(assignment);
        if (assignment.getOperator() == Assignment.Operator.ASSIGN) {
            this.add(SimpleTextEdit.createReplace(offset, length, String.valueOf(setter) + "("));
            this.add(SimpleTextEdit.createInsert(bracket, ")"));
        } else {
            boolean needsParentheses = ASTNodes.needsParentheses(assignment.getRightHandSide());
            this.add(SimpleTextEdit.createInsert(offset, String.valueOf(setter) + "("));
            this.add(SimpleTextEdit.createReplace(offset, length, String.valueOf(EncapsulateWriteAccess.getGetter(getter, assignment)) + "() " + EncapsulateWriteAccess.getOperator(assignment) + " " + (needsParentheses ? "(" : "")));
            this.add(SimpleTextEdit.createInsert(bracket, ")" + (needsParentheses ? ")" : "")));
        }
    }

    private EncapsulateWriteAccess() {
    }

    protected TextEdit copy0(TextEditCopier copier) {
        return new EncapsulateWriteAccess();
    }

    private static int getOffset(Assignment assignment) {
        Expression lhs;
        Expression result = lhs = assignment.getLeftHandSide();
        if (lhs instanceof FieldAccess) {
            ThisExpression thisExpression;
            FieldAccess fieldAccess = (FieldAccess)lhs;
            result = fieldAccess.getName();
            if (fieldAccess.getExpression() instanceof ThisExpression && (thisExpression = (ThisExpression)fieldAccess.getExpression()).getQualifier() == null) {
                result = fieldAccess;
            }
        } else if (lhs instanceof QualifiedName) {
            result = ((QualifiedName)lhs).getName();
        }
        return result.getStartPosition();
    }

    private static int getLength(Assignment assignment, int offset) {
        return assignment.getRightHandSide().getStartPosition() - offset;
    }

    private static int getBracketOffset(Assignment assignment) {
        Expression expression = assignment.getRightHandSide();
        return expression.getStartPosition() + expression.getLength();
    }

    private static String getGetter(String getter, Assignment assignment) {
        Expression lhs = assignment.getLeftHandSide();
        if (lhs instanceof QualifiedName) {
            return String.valueOf(ASTNodes.asString((ASTNode)((QualifiedName)lhs).getQualifier())) + "." + getter;
        }
        return getter;
    }

    private static String getOperator(Assignment assignment) {
        String operator = assignment.getOperator().toString();
        return operator.substring(0, operator.length() - 1);
    }
}

