/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.BindingIdentifier;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaSourceContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.sef.EncapsulatePostfixAccess;
import org.eclipse.jdt.internal.corext.refactoring.sef.EncapsulatePrefixAccess;
import org.eclipse.jdt.internal.corext.refactoring.sef.EncapsulateReadAccess;
import org.eclipse.jdt.internal.corext.refactoring.sef.EncapsulateWriteAccess;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;

class AccessAnalyzer
extends ASTVisitor {
    private ICompilationUnit fCUnit;
    private BindingIdentifier fFieldIdentifier;
    private BindingIdentifier fDeclaringClassIdentifier;
    private String fGetter;
    private String fSetter;
    private TextChange fChange;
    private RefactoringStatus fStatus;
    private boolean fSetterMustReturnValue;
    private boolean fEncapsulateDeclaringClass;
    private boolean fIsFieldFinal;
    private static final String READ_ACCESS = RefactoringCoreMessages.getString("SelfEncapsulateField.AccessAnalyzer.encapsulate_read_access");
    private static final String WRITE_ACCESS = RefactoringCoreMessages.getString("SelfEncapsulateField.AccessAnalyzer.encapsulate_write_access");
    private static final String PREFIX_ACCESS = RefactoringCoreMessages.getString("SelfEncapsulateField.AccessAnalyzer.encapsulate_prefix_access");
    private static final String POSTFIX_ACCESS = RefactoringCoreMessages.getString("SelfEncapsulateField.AccessAnalyzer.encapsulate_postfix_access");
    static /* synthetic */ Class class$0;

    public AccessAnalyzer(SelfEncapsulateFieldRefactoring refactoring, ICompilationUnit unit, BindingIdentifier field, BindingIdentifier declaringClass, TextChange change) {
        Assert.isNotNull(refactoring);
        Assert.isNotNull(unit);
        Assert.isNotNull(field);
        Assert.isNotNull(declaringClass);
        Assert.isNotNull(change);
        this.fCUnit = unit;
        this.fFieldIdentifier = field;
        this.fDeclaringClassIdentifier = declaringClass;
        this.fChange = change;
        this.fGetter = refactoring.getGetterName();
        this.fSetter = refactoring.getSetterName();
        this.fEncapsulateDeclaringClass = refactoring.getEncapsulateDeclaringClass();
        try {
            this.fIsFieldFinal = Flags.isFinal((int)refactoring.getField().getFlags());
        }
        catch (JavaModelException javaModelException) {}
        this.fStatus = new RefactoringStatus();
    }

    public boolean getSetterMustReturnValue() {
        return this.fSetterMustReturnValue;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        if (!this.considerBinding(this.resolveBinding(lhs), (ASTNode)lhs)) {
            return true;
        }
        this.checkParent((ASTNode)node);
        if (!this.fIsFieldFinal) {
            this.fChange.addTextEdit(WRITE_ACCESS, new EncapsulateWriteAccess(this.fGetter, this.fSetter, node));
        }
        node.getRightHandSide().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SimpleName node) {
        if (!node.isDeclaration() && this.considerBinding(node.resolveBinding(), (ASTNode)node)) {
            this.fChange.addTextEdit(READ_ACCESS, new EncapsulateReadAccess(this.fGetter, node));
        }
        return true;
    }

    public boolean visit(PrefixExpression node) {
        Expression operand = node.getOperand();
        if (!this.considerBinding(this.resolveBinding(operand), (ASTNode)operand)) {
            return true;
        }
        PrefixExpression.Operator operator = node.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return true;
        }
        this.checkParent((ASTNode)node);
        this.fChange.addTextEdit(PREFIX_ACCESS, new EncapsulatePrefixAccess(this.fGetter, this.fSetter, node));
        return false;
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        if (!this.considerBinding(this.resolveBinding(operand), (ASTNode)operand)) {
            return true;
        }
        ASTNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement)) {
            this.fStatus.addError(RefactoringCoreMessages.getString("SelfEncapsulateField.AccessAnalyzer.cannot_convert_postfix_expression"), JavaSourceContext.create(this.fCUnit, new SourceRange((ASTNode)node)));
            return false;
        }
        this.fChange.addTextEdit(POSTFIX_ACCESS, new EncapsulatePostfixAccess(this.fGetter, this.fSetter, node));
        return false;
    }

    private boolean considerBinding(IBinding binding, ASTNode node) {
        boolean result = this.fFieldIdentifier.matches(binding);
        if (!result || this.fEncapsulateDeclaringClass) {
            return result;
        }
        if (binding instanceof IVariableBinding) {
            TypeDeclaration type;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((type = (TypeDeclaration)ASTNodes.getParent(node, clazz)) != null) {
                ITypeBinding declaringType = type.resolveBinding();
                return !this.fDeclaringClassIdentifier.matches((IBinding)declaringType);
            }
        }
        return true;
    }

    private void checkParent(ASTNode node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement)) {
            this.fSetterMustReturnValue = true;
        }
    }

    private IBinding resolveBinding(Expression expression) {
        if (expression instanceof SimpleName) {
            return ((SimpleName)expression).resolveBinding();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).resolveBinding();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName().resolveBinding();
        }
        return null;
    }
}

