/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;

public class SourceReferenceUtil {
    private SourceReferenceUtil() {
    }

    public static IFile getFile(ISourceReference ref) throws JavaModelException {
        ICompilationUnit unit = SourceReferenceUtil.getCompilationUnit(ref);
        if (!unit.isWorkingCopy()) {
            return (IFile)unit.getResource();
        }
        return (IFile)unit.getOriginalElement().getResource();
    }

    public static ICompilationUnit getCompilationUnit(ISourceReference o) {
        Assert.isTrue(!(o instanceof IClassFile));
        if (o instanceof IMember) {
            return ((IMember)o).getCompilationUnit();
        }
        if (o instanceof IImportDeclaration) {
            IImportDeclaration im = (IImportDeclaration)o;
            return (ICompilationUnit)im.getParent().getParent();
        }
        if (o instanceof ICompilationUnit) {
            return (ICompilationUnit)o;
        }
        return (ICompilationUnit)((IJavaElement)o).getParent();
    }

    private static boolean hasParentInSet(IJavaElement elem, Set set) {
        IJavaElement parent = elem.getParent();
        while (parent != null) {
            if (set.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static ISourceReference[] removeAllWithParentsSelected(ISourceReference[] elems) {
        HashSet<ISourceReference> set = new HashSet<ISourceReference>(Arrays.asList(elems));
        ArrayList<ISourceReference> result = new ArrayList<ISourceReference>(elems.length);
        int i = 0;
        while (i < elems.length) {
            ISourceReference elem = elems[i];
            if (!(elem instanceof IJavaElement)) {
                result.add(elem);
            } else if (!SourceReferenceUtil.hasParentInSet((IJavaElement)elem, set)) {
                result.add(elem);
            }
            ++i;
        }
        return result.toArray(new ISourceReference[result.size()]);
    }

    public static Map groupByFile(ISourceReference[] elems) throws JavaModelException {
        HashMap map = new HashMap();
        int i = 0;
        while (i < elems.length) {
            ISourceReference elem = elems[i];
            IFile file = SourceReferenceUtil.getFile(elem);
            if (!map.containsKey(file)) {
                map.put(file, new ArrayList());
            }
            ((List)map.get(file)).add(elem);
            ++i;
        }
        return map;
    }

    public static ISourceReference[] sortByOffset(ISourceReference[] methods) {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((ISourceReference)o2).getSourceRange().getOffset() - ((ISourceReference)o1).getSourceRange().getOffset();
                }
                catch (JavaModelException javaModelException) {
                    return o2.hashCode() - o1.hashCode();
                }
            }
        };
        Arrays.sort(methods, comparator);
        return methods;
    }
}

