/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class ReorgUtils {
    private ReorgUtils() {
    }

    static Object getJavaParent(Object element) {
        if (element instanceof IResource) {
            IResource res = (IResource)element;
            IContainer parent = res.getParent();
            IJavaElement javaParent = JavaCore.create((IResource)parent);
            if (javaParent != null) {
                return javaParent;
            }
            return parent;
        }
        if (element instanceof IJavaElement) {
            IJavaElement jElement = (IJavaElement)element;
            return jElement.getParent();
        }
        return null;
    }

    public static String getName(Object element) {
        if (element instanceof IResource) {
            IResource res = (IResource)element;
            return res.getName();
        }
        if (element instanceof IJavaElement) {
            IJavaElement res = (IJavaElement)element;
            return res.getElementName();
        }
        return element.toString();
    }

    private static boolean shouldConfirmReadOnly(IResource res) {
        if (res.isReadOnly()) {
            return true;
        }
        if (res instanceof IContainer) {
            IContainer container = (IContainer)res;
            try {
                IResource[] children = container.members();
                int i = 0;
                while (i < children.length) {
                    if (ReorgUtils.shouldConfirmReadOnly(children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean shouldConfirmReadOnly(Object element) {
        if (element instanceof IJavaElement) {
            try {
                if (element instanceof IPackageFragmentRoot && ReorgUtils.isClasspathDelete((IPackageFragmentRoot)element)) {
                    return false;
                }
                element = ((IJavaElement)element).getResource();
            }
            catch (JavaModelException javaModelException) {}
        }
        if (element instanceof IResource) {
            return ReorgUtils.shouldConfirmReadOnly((IResource)element);
        }
        return false;
    }

    static boolean isClasspathDelete(IPackageFragmentRoot pkgRoot) throws JavaModelException {
        IProject occurringProject;
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        return !definingProject.equals((Object)(occurringProject = pkgRoot.getJavaProject().getProject()));
    }

    public static boolean isParent(IPackageFragment pack, IPackageFragmentRoot root) {
        if (pack == null) {
            return false;
        }
        IJavaElement packParent = pack.getParent();
        if (packParent == null) {
            return false;
        }
        if (packParent.equals(root)) {
            return true;
        }
        IResource packageResource = ResourceUtil.getResource(pack);
        IResource packageRootResource = ResourceUtil.getResource(root);
        return ReorgUtils.isParent(packageResource, packageRootResource);
    }

    public static boolean isParent(ICompilationUnit cu, IPackageFragment dest) {
        if (cu == null) {
            return false;
        }
        IJavaElement cuParent = cu.getParent();
        if (cuParent == null) {
            return false;
        }
        if (cuParent.equals(dest)) {
            return true;
        }
        IResource cuResource = ResourceUtil.getResource(cu);
        IResource packageResource = ResourceUtil.getResource(dest);
        return ReorgUtils.isParent(cuResource, packageResource);
    }

    public static boolean isParent(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.equalInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }

    public static boolean equalInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        IPath r1Location = r1.getLocation();
        IPath r2Location = r2.getLocation();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals((Object)r2Location);
    }
}

