/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;

public abstract class ReorgRefactoring
extends Refactoring {
    private final List fElements;
    private Object fDestination;
    private Set fExcludedElements;
    private static final String DEFAULT_PACKAGE = "";
    private IFile[] fUnsavedFiles = new IFile[0];
    static /* synthetic */ Class class$0;

    ReorgRefactoring(List elements) {
        Assert.isNotNull(elements);
        this.fElements = ReorgRefactoring.convertToInputElements(elements);
        this.fExcludedElements = new HashSet(0);
    }

    public IFile[] getUnsavedFiles() {
        return this.fUnsavedFiles;
    }

    public void setUnsavedFiles(IFile[] unsavedFiles) {
        Assert.isNotNull(unsavedFiles);
        this.fUnsavedFiles = unsavedFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block14: {
            RefactoringStatus refactoringStatus2;
            block13: {
                RefactoringStatus refactoringStatus3;
                block12: {
                    RefactoringStatus refactoringStatus4;
                    block11: {
                        RefactoringStatus refactoringStatus5;
                        block10: {
                            RefactoringStatus refactoringStatus6;
                            block9: {
                                RefactoringStatus refactoringStatus7;
                                block8: {
                                    pm.beginTask(DEFAULT_PACKAGE, 1);
                                    try {
                                        if (this.getElements().isEmpty()) {
                                            refactoringStatus7 = RefactoringStatus.createFatalErrorStatus(DEFAULT_PACKAGE);
                                            Object var2_9 = null;
                                            break block8;
                                        }
                                        if (ReorgRefactoring.hasParentCollision(this.getElements())) {
                                            refactoringStatus6 = RefactoringStatus.createFatalErrorStatus(DEFAULT_PACKAGE);
                                            break block9;
                                        }
                                        if (this.hasNonCusOrFiles() && (this.hasCus() || this.hasFiles())) {
                                            refactoringStatus5 = RefactoringStatus.createFatalErrorStatus(DEFAULT_PACKAGE);
                                            break block10;
                                        }
                                        if (this.hasPackages() && this.hasNonPackages()) {
                                            refactoringStatus4 = RefactoringStatus.createFatalErrorStatus(DEFAULT_PACKAGE);
                                            break block11;
                                        }
                                        if (this.hasSourceFolders() && this.hasNonSourceFolders()) {
                                            refactoringStatus3 = RefactoringStatus.createFatalErrorStatus(DEFAULT_PACKAGE);
                                            break block12;
                                        }
                                        if (!this.canReorgAll()) {
                                            refactoringStatus2 = RefactoringStatus.createFatalErrorStatus(DEFAULT_PACKAGE);
                                            break block13;
                                        }
                                        refactoringStatus = new RefactoringStatus();
                                        break block14;
                                    }
                                    catch (Throwable throwable) {
                                        Object var2_16 = null;
                                        pm.done();
                                        throw throwable;
                                    }
                                }
                                pm.done();
                                return refactoringStatus7;
                            }
                            Object var2_10 = null;
                            pm.done();
                            return refactoringStatus6;
                        }
                        Object var2_11 = null;
                        pm.done();
                        return refactoringStatus5;
                    }
                    Object var2_12 = null;
                    pm.done();
                    return refactoringStatus4;
                }
                Object var2_13 = null;
                pm.done();
                return refactoringStatus3;
            }
            Object var2_14 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var2_15 = null;
        pm.done();
        return refactoringStatus;
    }

    public List getElementsToReorg() {
        return Collections.unmodifiableList(this.fElements);
    }

    public void setExcludedElements(Set excluded) {
        Assert.isNotNull(excluded);
        Assert.isTrue(this.fElements.containsAll(excluded));
        this.fExcludedElements = excluded;
    }

    public Set getExcludedElements() {
        return this.fExcludedElements;
    }

    public void setDestination(Object destination) throws JavaModelException {
        IJavaProject p;
        if (destination instanceof IJavaProject && ReorgRefactoring.isPackageFragmentRoot(p = (IJavaProject)destination)) {
            this.fDestination = ReorgRefactoring.getPackageFragmentRoot(p);
        }
        this.fDestination = destination;
    }

    public boolean canBeAncestor(Object ancestor) {
        if (ancestor instanceof IJavaModel) {
            return true;
        }
        if (ancestor instanceof IJavaProject) {
            return true;
        }
        if (ancestor instanceof IPackageFragmentRoot) {
            return !((IPackageFragmentRoot)ancestor).isReadOnly();
        }
        if (this.hasPackages()) {
            return false;
        }
        if (ancestor instanceof IPackageFragment) {
            return !((IPackageFragment)ancestor).isReadOnly();
        }
        return ancestor instanceof IContainer;
    }

    public Map getElementsThatExistInTarget() throws JavaModelException {
        HashMap result = new HashMap();
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            Object conflicting = this.getConflictingElementFromDestination(each);
            if (conflicting == null) continue;
            result.put(each, conflicting);
        }
        return result;
    }

    abstract boolean isValidDestinationForCusAndFiles(Object var1) throws JavaModelException;

    public final boolean isValidDestination(Object dest) throws JavaModelException {
        if (dest instanceof IProject && !((IProject)dest).isAccessible()) {
            return false;
        }
        if (this.hasLinkedResources()) {
            if (dest instanceof IPackageFragmentRoot) {
                if (!ReorgRefactoring.isProjectPackageFragmentRoot((IPackageFragmentRoot)dest)) {
                    return false;
                }
            } else {
                if (!(dest instanceof IJavaProject) && !(dest instanceof IProject)) {
                    return false;
                }
                IResource destResource = ResourceUtil.getResource(dest);
                Iterator iter = this.getLinkedResources().iterator();
                while (iter.hasNext()) {
                    IResource linkedResource = (IResource)iter.next();
                    if (!ReorgUtils.isParent(linkedResource, destResource)) continue;
                    return false;
                }
            }
        }
        if (dest instanceof IJavaProject) {
            IJavaProject jp = (IJavaProject)dest;
            IPackageFragmentRoot root = ReorgRefactoring.getPackageFragmentRoot(jp);
            if (root != null) {
                return this.isValidDestination(root);
            }
            return this.isValidDestination(jp.getProject());
        }
        if (this.hasSourceFolders()) {
            return this.canCopySourceFolders(dest);
        }
        if (this.hasPackages()) {
            return this.canCopyPackages(dest);
        }
        if (this.hasResources() && !this.hasNonResources()) {
            return this.canCopyResources(dest);
        }
        return this.isValidDestinationForCusAndFiles(dest);
    }

    public Object getDestination() {
        return this.fDestination;
    }

    List getElements() {
        return this.fElements;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        Assert.isNotNull(this.fDestination, "destination not specified");
        pm.beginTask(DEFAULT_PACKAGE, this.fElements.size());
        try {
            CompositeChange composite = new CompositeChange(RefactoringCoreMessages.getString("ReorgRefactoring.reorganize_elements"), this.fElements.size());
            Iterator iter = this.fElements.iterator();
            while (iter.hasNext()) {
                composite.add(this.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1), iter.next()));
            }
            compositeChange = composite;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IChange createChange(IProgressMonitor pm, Object o) throws JavaModelException {
        block12: {
            IChange iChange;
            block11: {
                IChange iChange2;
                block10: {
                    IChange iChange3;
                    block9: {
                        IChange iChange4;
                        block8: {
                            block7: {
                                try {
                                    if (this.fExcludedElements.contains(o)) {
                                        Object var3_3 = null;
                                        break block7;
                                    }
                                    if (o instanceof IPackageFragmentRoot) {
                                        iChange4 = this.createChange(pm, (IPackageFragmentRoot)o);
                                        break block8;
                                    }
                                    if (o instanceof IPackageFragment) {
                                        iChange3 = this.createChange(pm, (IPackageFragment)o);
                                        break block9;
                                    }
                                    if (o instanceof ICompilationUnit) {
                                        iChange2 = this.createChange(pm, (ICompilationUnit)o);
                                        break block10;
                                    }
                                    if (o instanceof IResource) {
                                        iChange = this.createChange(pm, (IResource)o);
                                        break block11;
                                    }
                                    Assert.isTrue(false);
                                    break block12;
                                }
                                catch (Throwable throwable) {
                                    Object var3_9 = null;
                                    pm.done();
                                    throw throwable;
                                }
                            }
                            pm.done();
                            return null;
                        }
                        Object var3_4 = null;
                        pm.done();
                        return iChange4;
                    }
                    Object var3_5 = null;
                    pm.done();
                    return iChange3;
                }
                Object var3_6 = null;
                pm.done();
                return iChange2;
            }
            Object var3_7 = null;
            pm.done();
            return iChange;
        }
        Object var3_8 = null;
        pm.done();
        return null;
    }

    abstract IChange createChange(IProgressMonitor var1, IPackageFragmentRoot var2) throws JavaModelException;

    abstract IChange createChange(IProgressMonitor var1, IPackageFragment var2) throws JavaModelException;

    abstract IChange createChange(IProgressMonitor var1, ICompilationUnit var2) throws JavaModelException;

    abstract IChange createChange(IProgressMonitor var1, IResource var2) throws JavaModelException;

    static Object getDestinationForCusAndFiles(Object dest) throws JavaModelException {
        IPackageFragment result = ReorgRefactoring.getDestinationAsPackageFragment(dest);
        if (result != null) {
            if (result.isReadOnly()) {
                return null;
            }
            return result;
        }
        return ReorgRefactoring.getDestinationForResources(dest);
    }

    static IPackageFragmentRoot getDestinationForPackages(Object dest) throws JavaModelException {
        IPackageFragmentRoot result = null;
        if (dest instanceof IPackageFragmentRoot) {
            result = (IPackageFragmentRoot)dest;
        } else if (dest instanceof IJavaProject) {
            result = ReorgRefactoring.getDestinationAsPackageFragmentRoot((IJavaProject)dest);
        }
        if (result == null || result.isReadOnly()) {
            return null;
        }
        return result;
    }

    static IProject getDestinationForSourceFolders(Object dest) throws JavaModelException {
        if (dest instanceof IJavaProject) {
            return ((IJavaProject)dest).getProject();
        }
        if (dest instanceof IProject) {
            return (IProject)dest;
        }
        return null;
    }

    static IContainer getDestinationForResources(Object dest) throws JavaModelException {
        if (dest instanceof IJavaElement) {
            return ReorgRefactoring.getDestinationForResources(((IJavaElement)dest).getResource());
        }
        if (dest instanceof IResource) {
            return ReorgRefactoring.getDestinationForResources((IResource)dest);
        }
        return null;
    }

    static IContainer getDestinationForResources(IResource dest) {
        if (dest instanceof IContainer) {
            return (IContainer)dest;
        }
        if (dest instanceof IFile) {
            return ((IFile)dest).getParent();
        }
        return null;
    }

    boolean hasCus() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof ICompilationUnit)) continue;
            return true;
        }
        return false;
    }

    boolean hasFiles() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IFile)) continue;
            return true;
        }
        return false;
    }

    boolean hasPackages() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IPackageFragment)) continue;
            return true;
        }
        return false;
    }

    boolean hasSourceFolders() throws JavaModelException {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IPackageFragmentRoot) || !ReorgRefactoring.isSourceFolder((IPackageFragmentRoot)each)) continue;
            return true;
        }
        return false;
    }

    boolean hasNonPackages() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (each instanceof IPackageFragment) continue;
            return true;
        }
        return false;
    }

    boolean hasNonSourceFolders() throws JavaModelException {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IPackageFragmentRoot)) {
                return true;
            }
            if (ReorgRefactoring.isSourceFolder((IPackageFragmentRoot)each)) continue;
            return true;
        }
        return false;
    }

    boolean hasResources() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IResource)) continue;
            return true;
        }
        return false;
    }

    boolean hasNonResources() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (each instanceof IResource) continue;
            return true;
        }
        return false;
    }

    boolean hasNonCusOrFiles() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (each instanceof ICompilationUnit || each instanceof IFile) continue;
            return true;
        }
        return false;
    }

    private boolean hasLinkedResources() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            IResource resource = ResourceUtil.getResource(each);
            if (resource == null || !resource.isLinked()) continue;
            return true;
        }
        return false;
    }

    private List getLinkedResources() {
        ArrayList<IResource> result = new ArrayList<IResource>(3);
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            IResource resource = ResourceUtil.getResource(each);
            if (resource == null || !resource.isLinked()) continue;
            result.add(resource);
        }
        return result;
    }

    boolean canCopyCusAndFiles(Object dest) throws JavaModelException {
        Object destination = ReorgRefactoring.getDestinationForCusAndFiles(dest);
        if (destination instanceof IPackageFragment && ReorgRefactoring.destinationIsParent(this.getElements(), (IJavaElement)((IPackageFragment)destination))) {
            return false;
        }
        return destination != null;
    }

    boolean canCopyResources(Object dest) throws JavaModelException {
        return ReorgRefactoring.getDestinationForResources(dest) != null;
    }

    boolean canCopyPackages(Object dest) throws JavaModelException {
        return ReorgRefactoring.getDestinationForPackages(dest) != null;
    }

    boolean canCopySourceFolders(Object dest) throws JavaModelException {
        return ReorgRefactoring.getDestinationForSourceFolders(dest) != null;
    }

    static boolean destinationIsParent(List elements, IJavaElement dest) throws JavaModelException {
        if (dest.getElementType() == 3) {
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IPackageFragment)) {
                    return ReorgRefactoring.destinationIsParent(elements, dest.getResource());
                }
                IPackageFragment pack = (IPackageFragment)element;
                if (!ReorgUtils.isParent(pack, (IPackageFragmentRoot)dest)) continue;
                return true;
            }
            return false;
        }
        if (dest.getElementType() == 2) {
            IPackageFragmentRoot root = ReorgRefactoring.getPackageFragmentRoot((IJavaProject)dest);
            if (root == null) {
                return ReorgRefactoring.destinationIsParent(elements, dest.getResource());
            }
            return ReorgRefactoring.destinationIsParent(elements, (IJavaElement)root);
        }
        return ReorgRefactoring.destinationIsParent(elements, dest.getResource());
    }

    private static boolean destinationIsParent(List elements, IResource parent) {
        if (parent == null) {
            return false;
        }
        Iterator iter = elements.iterator();
        if (iter.hasNext()) {
            IResource resource = ReorgRefactoring.convertToResource(iter.next());
            return ReorgUtils.isParent(resource, parent);
        }
        return false;
    }

    private static IResource convertToResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    private Object getConflictingElementFromDestination(Object o) throws JavaModelException {
        String newName = ReorgUtils.getName(o);
        if (o instanceof ICompilationUnit) {
            Object dest = ReorgRefactoring.getDestinationForCusAndFiles(this.getDestination());
            ICompilationUnit cu = (ICompilationUnit)o;
            if (dest instanceof IPackageFragment) {
                if (ReorgUtils.isParent(cu, (IPackageFragment)dest)) {
                    return null;
                }
                return this.getConflictingElementFromDestination((IPackageFragment)dest, newName);
            }
            if (dest instanceof IContainer) {
                if (ReorgUtils.isParent(ResourceUtil.getResource(cu), (IResource)((IContainer)dest))) {
                    return null;
                }
                return this.getConflictingElementFromDestination((IContainer)dest, newName);
            }
            return null;
        }
        if (o instanceof IPackageFragmentRoot) {
            IProject dest = ReorgRefactoring.getDestinationForSourceFolders(this.getDestination());
            if (((IPackageFragmentRoot)o).getJavaProject().getProject().equals((Object)dest)) {
                return null;
            }
            return this.getConflictingElementFromDestination((IContainer)dest, newName);
        }
        if (o instanceof IPackageFragment) {
            IPackageFragmentRoot dest = ReorgRefactoring.getDestinationForPackages(this.getDestination());
            if (ReorgUtils.isParent((IPackageFragment)o, dest)) {
                return null;
            }
            return this.getConflictingElementFromDestination(dest, newName);
        }
        if (o instanceof IResource) {
            IContainer dest = ReorgRefactoring.getDestinationForResources(this.getDestination());
            if (ReorgUtils.isParent((IResource)o, (IResource)dest)) {
                return null;
            }
            return this.getConflictingElementFromDestination(dest, newName);
        }
        Assert.isTrue(false, RefactoringCoreMessages.getString("ReorgRefactoring.assert.whyhere"));
        return null;
    }

    private Object getConflictingElementFromDestination(IContainer c, String name) {
        if (c == null) {
            return null;
        }
        IResource foundMember = c.findMember(name);
        if (foundMember != null) {
            return foundMember;
        }
        return null;
    }

    private Object getConflictingElementFromDestination(IPackageFragmentRoot root, String name) throws JavaModelException {
        if (root == null) {
            return null;
        }
        IPackageFragment pkg = root.getPackageFragment(name);
        if (pkg.exists() && pkg.hasChildren()) {
            return pkg;
        }
        return null;
    }

    private Object getConflictingElementFromDestination(IPackageFragment pkg, String name) throws JavaModelException {
        if (pkg == null) {
            return null;
        }
        IStatus status = JavaConventions.validateCompilationUnitName((String)name);
        if (!status.isOK()) {
            return null;
        }
        if (pkg.getCompilationUnit(name).exists() || ReorgRefactoring.getResource(pkg, name) != null) {
            return pkg.getCompilationUnit(name);
        }
        return null;
    }

    private boolean canReorgAll() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            if (ReorgRefactoring.canReorg(iter.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean canReorg(Object o) {
        if (o instanceof IPackageFragment) {
            return ReorgRefactoring.canReorg((IPackageFragment)o);
        }
        if (o instanceof IResource) {
            return ReorgRefactoring.canReorg((IResource)o);
        }
        if (o instanceof ICompilationUnit) {
            return ReorgRefactoring.canReorg((ICompilationUnit)o);
        }
        if (o instanceof IPackageFragmentRoot) {
            return ReorgRefactoring.canReorg((IPackageFragmentRoot)o);
        }
        return false;
    }

    private static boolean canReorg(IPackageFragmentRoot root) {
        if (!root.exists()) {
            return false;
        }
        try {
            return ReorgRefactoring.isSourceFolder(root);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static boolean canReorg(IPackageFragment pkg) {
        if (!pkg.exists()) {
            return false;
        }
        if (pkg.isDefaultPackage()) {
            return false;
        }
        try {
            IResource res = pkg.getUnderlyingResource();
            return res != null && res.equals((Object)pkg.getCorrespondingResource());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static boolean canReorg(IResource element) {
        if (element instanceof IFolder) {
            return true;
        }
        if (!(element instanceof IFile)) {
            return false;
        }
        Object parent = ReorgUtils.getJavaParent(element);
        if (parent == null) {
            return false;
        }
        if (parent instanceof IJavaElement) {
            return !((IJavaElement)parent).isReadOnly();
        }
        return true;
    }

    private static boolean canReorg(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return false;
        }
        IResource res = cu.getResource();
        return res != null && res.exists();
    }

    private static boolean isSourceFolder(IPackageFragmentRoot root) throws JavaModelException {
        return root.getKind() == 1;
    }

    public static IPackageFragment getDestinationAsPackageFragment(Object dest) throws JavaModelException {
        if (dest instanceof IPackageFragment) {
            return (IPackageFragment)dest;
        }
        if (dest instanceof IJavaProject) {
            return ReorgRefactoring.getDestinationAsPackageFragment(ReorgRefactoring.getDestinationAsPackageFragmentRoot((IJavaProject)dest));
        }
        if (dest instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)dest).getPackageFragment(DEFAULT_PACKAGE);
        }
        if (dest instanceof ICompilationUnit && ((ICompilationUnit)dest).getParent() instanceof IPackageFragment) {
            return (IPackageFragment)((ICompilationUnit)dest).getParent();
        }
        if (dest instanceof IFile) {
            return ReorgRefactoring.getDestinationAsPackageFragment(ReorgUtils.getJavaParent(dest));
        }
        return null;
    }

    private static IPackageFragmentRoot getDestinationAsPackageFragmentRoot(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (!roots[i].isArchive()) {
                if (ReorgRefactoring.isProjectPackageFragmentRoot(roots[i])) {
                    return roots[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    static final IPackageFragmentRoot getPackageFragmentRoot(IJavaProject p) throws JavaModelException {
        IPackageFragmentRoot[] roots = p.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (ReorgRefactoring.isProjectPackageFragmentRoot(roots[i])) {
                return roots[i];
            }
            ++i;
        }
        return null;
    }

    private static final boolean isProjectPackageFragmentRoot(IPackageFragmentRoot root) throws JavaModelException {
        return root.getResource() instanceof IProject;
    }

    private static final boolean isPackageFragmentRoot(IJavaProject p) throws JavaModelException {
        return ReorgRefactoring.getPackageFragmentRoot(p) != null;
    }

    private static boolean hasParentCollision(List elements) {
        int size = elements.size();
        if (size < 2) {
            return false;
        }
        ArrayList<IPath> paths = new ArrayList<IPath>(size);
        int i = 0;
        while (i < size) {
            paths.add(ReorgRefactoring.getPath(elements.get(i)));
            ++i;
        }
        i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                IPath right;
                IPath left;
                if (i != j && (left = (IPath)paths.get(i)).isPrefixOf(right = (IPath)paths.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static IPath getPath(Object element) {
        String name = ReorgUtils.getName(element);
        if (name == null) {
            return new Path(DEFAULT_PACKAGE);
        }
        Object parent = ReorgUtils.getJavaParent(element);
        if (parent == null) {
            return new Path(name);
        }
        return ReorgRefactoring.getPath(parent).append(name);
    }

    static Object getResource(IPackageFragment fragment, String name) throws JavaModelException {
        Object[] children = fragment.getNonJavaResources();
        int i = 0;
        while (i < children.length) {
            IResource child;
            if (children[i] instanceof IResource ? (child = (IResource)children[i]).getName().equals(name) : children[i] instanceof IStorage && (child = (IStorage)children[i]).getName().equals(name)) {
                return children[i];
            }
            ++i;
        }
        return null;
    }

    private static List convertToInputElements(List elements) {
        ArrayList<Object> converted = new ArrayList<Object>(elements.size());
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object convertedObject = ReorgRefactoring.convertToInputElement(iter.next());
            if (convertedObject == null) continue;
            converted.add(convertedObject);
        }
        return converted;
    }

    private static Object convertToInputElement(Object element) {
        if (!(element instanceof IType)) {
            return element;
        }
        IType type = (IType)element;
        try {
            if (JavaElementUtil.isMainType(type)) {
                return WorkingCopyUtil.getOriginal(type.getCompilationUnit());
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    ICompilationUnit[] collectCus() {
        ArrayList cus = new ArrayList();
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof ICompilationUnit)) continue;
            cus.add(each);
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }
}

