/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MovePackageFragmentRootChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MoveCuUpdateCreator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.structure.ReferenceFinderUtil;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdatingRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class MoveRefactoring
extends ReorgRefactoring
implements IQualifiedNameUpdatingRefactoring {
    private boolean fUpdateReferences;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private final CodeGenerationSettings fSettings;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    public MoveRefactoring(List elements, CodeGenerationSettings settings, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        super(elements);
        Assert.isNotNull(settings);
        this.fSettings = settings;
        this.fUpdateReferences = true;
        this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    public boolean canEnableQualifiedNameUpdating() {
        Object destination = this.getDestination();
        if (!(destination instanceof IPackageFragment)) {
            return false;
        }
        if (((IPackageFragment)destination).isDefaultPackage()) {
            return false;
        }
        return this.canUpdateQualifiedNames();
    }

    public boolean canUpdateQualifiedNames() {
        List elements = this.getElementsToReorg();
        Class<?> last = null;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (last == null) {
                IJavaElement parent = null;
                if (element instanceof ICompilationUnit) {
                    parent = ((IJavaElement)element).getParent();
                    last = element.getClass();
                } else if (element instanceof IType) {
                    parent = ((IJavaElement)element).getParent();
                    last = element.getClass();
                } else {
                    return false;
                }
                if (!(parent instanceof IPackageFragment) || !((IPackageFragment)parent).isDefaultPackage()) continue;
                return false;
            }
            if (last.equals(element.getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("MoveRefactoring.move_elements");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask(RefactoringCoreMessages.getString("MoveRefactoring.searching"), 3);
        try {
            try {
                RefactoringStatus result = new RefactoringStatus();
                result.merge(this.checkReferencesToNotPublicTypes((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                result.merge(this.checkPackageVisibileClassReferences((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                result.merge(this.validateModifiesFiles());
                refactoringStatus = result;
                Object var3_6 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus checkReferencesToNotPublicTypes(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block7: {
            block6: {
                pm.beginTask("", 1);
                try {
                    if (!(this.getDestination() instanceof IPackageFragment)) {
                        Object var10_2 = null;
                        break block6;
                    }
                    ICompilationUnit[] movedCus = this.collectCus();
                    List<ICompilationUnit> movedCuList = Arrays.asList(movedCus);
                    IType[] types = ReferenceFinderUtil.getTypesReferencedIn((IJavaElement[])movedCus, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    RefactoringStatus result = new RefactoringStatus();
                    int i = 0;
                    while (true) {
                        if (i >= types.length) {
                            refactoringStatus = result;
                            break block7;
                        }
                        IType type = types[i];
                        if (!(JdtFlags.isPublic((IMember)type) || movedCuList.contains(type.getCompilationUnit()) || this.getDestination().equals(type.getPackageFragment()))) {
                            String[] keys = new String[]{JavaElementUtil.createSignature((IMember)type)};
                            String message = RefactoringCoreMessages.getFormattedString("MoveRefactoring.warning.typeWillNotBeAccessible", keys);
                            result.addWarning(message);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return null;
        }
        Object var10_3 = null;
        pm.done();
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus checkPackageVisibileClassReferences(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block9: {
            block8: {
                block7: {
                    pm.beginTask("", 1);
                    try {
                        if (!(this.getDestination() instanceof IPackageFragment)) {
                            Object var14_2 = null;
                            break block7;
                        }
                        ICompilationUnit[] movedCus = this.collectCus();
                        List<ICompilationUnit> movedCuList = Arrays.asList(movedCus);
                        IType[] movedPackageVisibleTypes = MoveRefactoring.getMovedPackageVisibleTypes(movedCus);
                        if (movedPackageVisibleTypes.length == 0) {
                            break block8;
                        }
                        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
                        ISearchPattern pattern = MoveRefactoring.createSearchPattern(movedPackageVisibleTypes);
                        SearchResultGroup[] groups = RefactoringSearchEngine.search((IProgressMonitor)new SubProgressMonitor(pm, 1), scope, pattern);
                        RefactoringStatus result = new RefactoringStatus();
                        int i = 0;
                        while (true) {
                            if (i >= groups.length) {
                                refactoringStatus = result;
                                break block9;
                            }
                            SearchResultGroup group = groups[i];
                            ICompilationUnit cu = group.getCompilationUnit();
                            if (cu != null && !cu.getParent().equals(this.getDestination()) && !movedCuList.contains(cu)) {
                                String[] keys = new String[]{cu.getElementName()};
                                String message = RefactoringCoreMessages.getFormattedString("MoveRefactoring.warning.containsReferencesToTypeThatWillNotBeVisible", keys);
                                result.addWarning(message);
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_5 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return null;
            }
            Object var14_3 = null;
            pm.done();
            return null;
        }
        Object var14_4 = null;
        pm.done();
        return refactoringStatus;
    }

    private static ISearchPattern createSearchPattern(IType[] movedPackageVisibleTypes) {
        return RefactoringSearchEngine.createSearchPattern((IJavaElement[])movedPackageVisibleTypes, 2);
    }

    private static IType[] getMovedPackageVisibleTypes(ICompilationUnit[] movedCus) throws JavaModelException {
        ArrayList result = new ArrayList(movedCus.length);
        int i = 0;
        while (i < movedCus.length) {
            ICompilationUnit cu = movedCus[i];
            result.addAll(MoveRefactoring.getPackageVisibleTypes(cu));
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static Collection getPackageVisibleTypes(ICompilationUnit cu) throws JavaModelException {
        IType[] types = cu.getTypes();
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            if (JdtFlags.isPackageVisible((IMember)type)) {
                result.add(type);
            }
            result.addAll(MoveRefactoring.getPackageVisibleTypes(type));
            ++i;
        }
        return result;
    }

    private static Collection getPackageVisibleTypes(IType type) throws JavaModelException {
        IType[] types = type.getTypes();
        ArrayList<IType> result = new ArrayList<IType>();
        int i = 0;
        while (i < types.length) {
            IType innerType = types[i];
            if (!JdtFlags.isPrivate((IMember)innerType)) {
                if (!JdtFlags.isPublic((IMember)innerType)) {
                    result.add(innerType);
                }
                result.addAll(MoveRefactoring.getPackageVisibleTypes(innerType));
            }
            ++i;
        }
        return result;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        if (this.getDestination() instanceof IPackageFragment) {
            result.addAll(Arrays.asList(ResourceUtil.getFiles(this.collectCus())));
        }
        return result.toArray(new IFile[result.size()]);
    }

    private RefactoringStatus validateModifiesFiles() throws CoreException {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    boolean isValidDestinationForCusAndFiles(Object dest) throws JavaModelException {
        Object destination = ReorgRefactoring.getDestinationForCusAndFiles(dest);
        if (destination instanceof IPackageFragment) {
            return this.canCopyCusAndFiles(dest);
        }
        return this.canCopyResources(dest);
    }

    boolean canCopySourceFolders(Object dest) throws JavaModelException {
        if (!super.canCopySourceFolders(dest)) {
            return false;
        }
        IJavaProject javaProject = JavaCore.create((IProject)ReorgRefactoring.getDestinationForSourceFolders(dest));
        if (javaProject == null) {
            return false;
        }
        if (!javaProject.exists()) {
            return true;
        }
        return !ReorgRefactoring.destinationIsParent(this.getElements(), (IJavaElement)javaProject);
    }

    boolean canCopyPackages(Object dest) throws JavaModelException {
        return super.canCopyPackages(dest) && !ReorgRefactoring.destinationIsParent(this.getElements(), (IJavaElement)ReorgRefactoring.getDestinationForPackages(dest));
    }

    boolean canCopyResources(Object dest) throws JavaModelException {
        IContainer destination = ReorgRefactoring.getDestinationForResources(dest);
        return super.canCopyResources(dest) && !this.destinationIsOneOfResources(destination) && !this.destinationIsParentForResources(destination);
    }

    private boolean destinationIsParentForResources(IContainer dest) {
        if (dest == null) {
            return false;
        }
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            IResource resource;
            Object each = iter.next();
            if (!(each instanceof IResource) || !ReorgUtils.isParent(resource = (IResource)each, (IResource)dest)) continue;
            return true;
        }
        return false;
    }

    private boolean destinationIsOneOfResources(IContainer dest) {
        if (dest == null) {
            return false;
        }
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!dest.equals(each)) continue;
            return true;
        }
        return false;
    }

    public boolean canUpdateReferences() throws JavaModelException {
        if (this.getDestination() == null) {
            return false;
        }
        if (this.hasPackages()) {
            return false;
        }
        if (this.hasSourceFolders()) {
            return false;
        }
        if (!this.hasCus()) {
            return false;
        }
        Object dest = ReorgRefactoring.getDestinationForCusAndFiles(this.getDestination());
        if (!(dest instanceof IPackageFragment)) {
            return false;
        }
        if (((IPackageFragment)dest).isDefaultPackage()) {
            return false;
        }
        if (this.isAnyCUFromDefaultPackage()) {
            return false;
        }
        if (!this.allExist()) {
            return false;
        }
        if (this.isAnyUnsaved()) {
            return false;
        }
        return !this.anyHasSyntaxErrors();
    }

    private boolean allExist() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof IJavaElement) || ((IJavaElement)each).exists()) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyCUFromDefaultPackage() {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof ICompilationUnit) || !JavaElementUtil.isDefaultPackage(((ICompilationUnit)each).getParent())) continue;
            return true;
        }
        return false;
    }

    private boolean anyHasSyntaxErrors() throws JavaModelException {
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object each = iter.next();
            if (!(each instanceof ICompilationUnit) || !MoveRefactoring.hasSyntaxErrors((ICompilationUnit)JavaCore.create((IResource)ResourceUtil.getResource((ICompilationUnit)each)))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSyntaxErrors(ICompilationUnit cu) throws JavaModelException {
        Assert.isTrue(!cu.isWorkingCopy());
        return !cu.isStructureKnown();
    }

    private boolean isAnyUnsaved() {
        List elements = this.getElements();
        IFile[] unsaved = this.getUnsavedFiles();
        int i = 0;
        while (i < unsaved.length) {
            if (elements.contains(unsaved[i])) {
                return true;
            }
            if (elements.contains(JavaCore.create((IFile)unsaved[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        if (!this.fUpdateReferences) {
            if (!this.fUpdateQualifiedNames) {
                return super.createChange(pm);
            }
            pm.beginTask("", 2);
            IChange change = super.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1));
            CompositeChange result = new CompositeChange(RefactoringCoreMessages.getString("MoveRefactoring.reorganize_elements"), 2){

                public boolean isUndoable() {
                    return false;
                }
            };
            if (change instanceof ICompositeChange) {
                MoveRefactoring.addAllChildren(result, (ICompositeChange)change);
            } else {
                result.add(change);
            }
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.addAll(this.fQualifiedNameSearchResult.getAllChanges());
            return result;
        }
        pm.beginTask("", 2 + (this.fUpdateQualifiedNames ? 1 : 0));
        try {
            IChange fileMove;
            CompositeChange composite = new CompositeChange(RefactoringCoreMessages.getString("MoveRefactoring.reorganize_elements"), 2){

                public boolean isUndoable() {
                    return false;
                }
            };
            if (this.fChangeManager == null) {
                this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                try {
                    RefactoringStatus status = this.validateModifiesFiles();
                    if (status.hasFatalError()) {
                        this.fChangeManager = new TextChangeManager();
                    }
                }
                catch (JavaModelException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
            }
            MoveRefactoring.addAllChildren(composite, new CompositeChange(RefactoringCoreMessages.getString("MoveRefactoring.reorganize_elements"), this.fChangeManager.getAllChanges()));
            if (this.fUpdateQualifiedNames) {
                this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 1));
                composite.addAll(this.fQualifiedNameSearchResult.getAllChanges());
            }
            if ((fileMove = super.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1))) instanceof ICompositeChange) {
                MoveRefactoring.addAllChildren(composite, (ICompositeChange)fileMove);
            } else {
                composite.add(fileMove);
            }
            compositeChange = composite;
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextChangeManager createChangeManager(IProgressMonitor pm) throws JavaModelException {
        TextChangeManager textChangeManager;
        block6: {
            TextChangeManager textChangeManager2;
            block5: {
                TextChangeManager textChangeManager3;
                block4: {
                    pm.beginTask("", 1);
                    try {
                        if (!this.fUpdateReferences) {
                            textChangeManager3 = new TextChangeManager();
                            Object var4_5 = null;
                            break block4;
                        }
                        Object dest = ReorgRefactoring.getDestinationForCusAndFiles(this.getDestination());
                        if (dest instanceof IPackageFragment) {
                            MoveCuUpdateCreator creator = new MoveCuUpdateCreator(this.collectCus(), (IPackageFragment)dest, this.fSettings);
                            textChangeManager2 = creator.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1));
                            break block5;
                        }
                        textChangeManager = new TextChangeManager();
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return textChangeManager3;
            }
            Object var4_6 = null;
            pm.done();
            return textChangeManager2;
        }
        Object var4_7 = null;
        pm.done();
        return textChangeManager;
    }

    private static void addAllChildren(CompositeChange collector, ICompositeChange composite) {
        collector.addAll(composite.getChildren());
    }

    IChange createChange(IProgressMonitor pm, ICompilationUnit cu) throws JavaModelException {
        Object dest = ReorgRefactoring.getDestinationForCusAndFiles(this.getDestination());
        if (dest instanceof IPackageFragment) {
            return this.moveCuToPackage(cu, (IPackageFragment)dest);
        }
        return this.moveFileToContainer(cu, (IContainer)dest);
    }

    private IChange moveFileToContainer(ICompilationUnit cu, IContainer dest) {
        return new MoveResourceChange(ResourceUtil.getResource(cu), dest);
    }

    private IChange moveCuToPackage(ICompilationUnit cu, IPackageFragment dest) {
        IResource resource = ResourceUtil.getResource(cu);
        if (resource != null && resource.isLinked() && ResourceUtil.getResource(dest) instanceof IContainer) {
            return this.moveFileToContainer(cu, (IContainer)ResourceUtil.getResource(dest));
        }
        return new MoveCompilationUnitChange(cu, dest);
    }

    IChange createChange(IProgressMonitor pm, IPackageFragmentRoot root) throws JavaModelException {
        IProject destinationProject = ReorgRefactoring.getDestinationForSourceFolders(this.getDestination());
        return new MovePackageFragmentRootChange(root, destinationProject, this.fUpdateClasspathQuery);
    }

    IChange createChange(IProgressMonitor pm, IPackageFragment pack) throws JavaModelException {
        return new MovePackageChange(pack, ReorgRefactoring.getDestinationForPackages(this.getDestination()));
    }

    IChange createChange(IProgressMonitor pm, IResource res) throws JavaModelException {
        return new MoveResourceChange(res, ReorgRefactoring.getDestinationForResources(this.getDestination()));
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws JavaModelException {
        if (!this.fUpdateQualifiedNames) {
            return;
        }
        IPackageFragment destination = (IPackageFragment)this.getDestination();
        List elements = this.getElements();
        pm.beginTask("", elements.size());
        pm.subTask(RefactoringCoreMessages.getString("MoveRefactoring.scanning_qualified_names"));
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ICompilationUnit) {
                IType[] types = ((ICompilationUnit)element).getTypes();
                SubProgressMonitor typesMonitor = new SubProgressMonitor(pm, 1);
                typesMonitor.beginTask("", types.length);
                int i = 0;
                while (i < types.length) {
                    this.handleType(types[i], destination, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)typesMonitor, 1));
                    ++i;
                }
                typesMonitor.done();
                continue;
            }
            if (!(element instanceof IType)) continue;
            this.handleType((IType)element, destination, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
    }

    private void handleType(IType type, IPackageFragment destination, IProgressMonitor pm) throws JavaModelException {
        this.fQualifiedNameSearchResult = QualifiedNameFinder.process(type.getFullyQualifiedName(), String.valueOf(destination.getElementName()) + "." + type.getTypeQualifiedName(), this.fFilePatterns, type.getJavaProject().getProject(), pm);
    }
}

